/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.editor.processor.model;

import java.beans.Introspector;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.gwtproject.editor.processor.model.EditorTypes;

public enum BeanMethod {
    GET{

        @Override
        public String inferName(ExecutableElement method) {
            if (this.isBooleanProperty(method) && method.getSimpleName().toString().startsWith(BeanMethod.IS_PREFIX)) {
                return Introspector.decapitalize(method.getSimpleName().toString().substring(2));
            }
            return super.inferName(method);
        }

        @Override
        public boolean matches(EditorTypes types, ExecutableElement method) {
            if (method.getParameters().size() > 0) {
                return false;
            }
            if (this.isBooleanProperty(method)) {
                return true;
            }
            String name = method.getSimpleName().toString();
            return name.startsWith(BeanMethod.GET_PREFIX) && name.length() > 3;
        }

        private boolean isBooleanProperty(ExecutableElement method) {
            TypeMirror returnType = method.getReturnType();
            if (returnType.getKind() == TypeKind.BOOLEAN || returnType.toString().equals(Boolean.class.getName())) {
                String name = method.getSimpleName().toString();
                if (name.startsWith(BeanMethod.IS_PREFIX) && name.length() > 2) {
                    return true;
                }
                return name.startsWith(BeanMethod.HAS_PREFIX) && name.length() > 3;
            }
            return false;
        }
    }
    ,
    SET{

        @Override
        public boolean matches(EditorTypes types, ExecutableElement method) {
            if (method.getReturnType().getKind() != TypeKind.VOID) {
                return false;
            }
            if (method.getParameters().size() != 1) {
                return false;
            }
            String name = method.getSimpleName().toString();
            return name.startsWith(BeanMethod.SET_PREFIX) && name.length() > 3;
        }
    }
    ,
    SET_BUILDER{

        @Override
        public boolean matches(EditorTypes types, ExecutableElement method) {
            if (!BeanMethod.isReturnTypeEnclosingElement(types, method)) {
                return false;
            }
            if (method.getParameters().size() != 1) {
                return false;
            }
            String name = method.getSimpleName().toString();
            return name.startsWith(BeanMethod.SET_PREFIX) && name.length() > 3;
        }
    }
    ,
    CALL{

        @Override
        public boolean matches(EditorTypes types, ExecutableElement method) {
            return true;
        }
    };

    private static final String GET_PREFIX = "get";
    private static final String HAS_PREFIX = "has";
    private static final String IS_PREFIX = "is";
    private static final String SET_PREFIX = "set";

    public static BeanMethod which(EditorTypes types, ExecutableElement method) {
        for (BeanMethod action : BeanMethod.values()) {
            if (!action.matches(types, method)) continue;
            return action;
        }
        throw new RuntimeException("CALL should have matched");
    }

    public String inferName(ExecutableElement method) {
        if (this == CALL) {
            throw new UnsupportedOperationException("Cannot infer a property name for a CALL-type method");
        }
        return Introspector.decapitalize(method.getSimpleName().toString().substring(3));
    }

    private static boolean isReturnTypeEnclosingElement(EditorTypes types, ExecutableElement method) {
        TypeMirror returnTypeMirror = method.getReturnType();
        if (returnTypeMirror == null || returnTypeMirror.toString().equals("void")) {
            return false;
        }
        TypeMirror matchingReturnTM = null;
        if (types.getTypes().erasure(returnTypeMirror).equals(types.getTypes().erasure(method.getEnclosingElement().asType()))) {
            matchingReturnTM = method.getEnclosingElement().asType();
        } else {
            List<? extends TypeMirror> directSupertypes = types.getTypes().directSupertypes(method.getEnclosingElement().asType());
            for (TypeMirror typeMirror : directSupertypes) {
                if (!types.getTypes().erasure(returnTypeMirror).equals(types.getTypes().erasure(typeMirror))) continue;
                matchingReturnTM = typeMirror;
                break;
            }
        }
        if (matchingReturnTM == null) {
            return false;
        }
        return BeanMethod.deepCompare(types, returnTypeMirror, matchingReturnTM);
    }

    private static boolean deepCompare(EditorTypes types, TypeMirror source, TypeMirror target) {
        if (!types.getTypes().erasure(source).equals(types.getTypes().erasure(target))) {
            return false;
        }
        List<? extends TypeMirror> sourceTypeArguments = ((DeclaredType)source).getTypeArguments();
        List<? extends TypeMirror> targetTypeArguments = ((DeclaredType)target).getTypeArguments();
        if (sourceTypeArguments.size() != targetTypeArguments.size()) {
            return false;
        }
        for (int i = 0; i < sourceTypeArguments.size(); ++i) {
            if (!(TypeKind.DECLARED == sourceTypeArguments.get(i).getKind() && TypeKind.DECLARED == targetTypeArguments.get(i).getKind() ? !BeanMethod.deepCompare(types, sourceTypeArguments.get(i), targetTypeArguments.get(i)) : !types.getTypes().erasure(sourceTypeArguments.get(i)).equals(types.getTypes().erasure(targetTypeArguments.get(i))))) continue;
            return false;
        }
        return true;
    }

    public abstract boolean matches(EditorTypes var1, ExecutableElement var2);
}

