/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.editor.processor.model;

import com.google.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.gwtproject.editor.client.Editor;
import org.gwtproject.editor.processor.ModelUtils;
import org.gwtproject.editor.processor.model.EditorProperty;
import org.gwtproject.editor.processor.model.EditorTypes;

public class EditorModel {
    private final Messager messager;
    private final EditorTypes editorTypes;
    private final TypeMirror dataType;
    private final TypeMirror editorType;
    private final EditorModel parentModel;
    private final EditorProperty editorSoFar;
    private final List<EditorProperty> childrenModels;
    private final Map<TypeMirror, List<EditorProperty>> typeData;

    public EditorModel(Messager messager, EditorTypes editorTypes, TypeMirror intfType, TypeMirror driverType) {
        this.messager = messager;
        this.editorTypes = editorTypes;
        List<? extends TypeMirror> params = ModelUtils.findParameterizationOf(editorTypes.getTypes(), driverType, intfType);
        assert (params != null) : "Can't parameterize " + intfType + " as a driver";
        this.dataType = params.get(0);
        this.editorType = params.get(1);
        this.parentModel = null;
        this.editorSoFar = null;
        this.typeData = new HashMap<TypeMirror, List<EditorProperty>>();
        this.childrenModels = this.calculateEditorData();
    }

    public EditorModel(Messager messager, EditorTypes editorTypes, EditorModel parent, TypeMirror editorType, EditorProperty subEditor, TypeMirror proxyType) {
        this.messager = messager;
        this.editorTypes = editorTypes;
        this.dataType = proxyType;
        this.editorType = editorType;
        this.editorSoFar = subEditor;
        this.parentModel = parent;
        this.typeData = parent.typeData;
        this.childrenModels = this.calculateEditorData();
    }

    private List<EditorProperty> calculateEditorData() {
        ArrayList<EditorProperty> flatData = new ArrayList<EditorProperty>();
        ArrayList<EditorProperty> toReturn = new ArrayList<EditorProperty>();
        if (!this.editorTypes.getTypes().isAssignable(this.editorType, this.editorTypes.getLeafValueEditorInterface())) {
            List<EditorProperty> data;
            LinkedHashSet members = ModelUtils.getFlattenedSupertypeHierarchy(this.editorTypes.getTypes(), this.editorType).stream().map(MoreTypes::asElement).map(Element::getEnclosedElements).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
            for (VariableElement field : ElementFilter.fieldsIn(members)) {
                TypeMirror fieldClassType;
                if (field.getModifiers().contains((Object)Modifier.PRIVATE) || field.getModifiers().contains((Object)Modifier.STATIC) || field.getAnnotation(Editor.Ignore.class) != null || !this.shouldExamine(fieldClassType = field.asType())) continue;
                data = new EditorProperty.Builder(this.editorTypes, this.dataType).access(field).build(Optional.ofNullable(this.editorSoFar));
                this.accumulateEditorData(data, flatData, toReturn);
            }
            for (ExecutableElement method : ElementFilter.methodsIn(members)) {
                TypeMirror methodReturnType;
                if (method.getModifiers().contains((Object)Modifier.PRIVATE) || method.getModifiers().contains((Object)Modifier.STATIC) || method.getAnnotation(Editor.Ignore.class) != null || !this.shouldExamine(methodReturnType = ((ExecutableType)this.editorTypes.getTypes().asMemberOf((DeclaredType)this.editorType, method)).getReturnType()) || method.getParameters().size() != 0 || method.getSimpleName().toString().equals("asEditor") && this.editorTypes.getTypes().isAssignable(this.editorType, this.editorTypes.getIsEditorInterface()) || method.getSimpleName().toString().equals("createEditorForTraversal") && this.editorTypes.getTypes().isAssignable(this.editorType, this.editorTypes.getCompositeEditorInterface())) continue;
                data = new EditorProperty.Builder(this.editorTypes, this.dataType).access(method).build(Optional.ofNullable(this.editorSoFar));
                this.accumulateEditorData(data, flatData, toReturn);
            }
        }
        if (this.editorTypes.getTypes().isAssignable(this.editorType, this.editorTypes.getCompositeEditorInterface())) {
            TypeMirror subEditorType = ModelUtils.findParameterizationOf(this.editorTypes.getTypes(), this.editorTypes.getCompositeEditorInterface(), this.editorType).get(2);
            EditorProperty subEditor = new EditorProperty.Builder(this.editorTypes, this.dataType).root(subEditorType).build(Optional.ofNullable(this.editorSoFar)).get(0);
            ArrayList<EditorProperty> accumulator = new ArrayList<EditorProperty>();
            this.descendIntoSubEditor(accumulator, subEditor);
            EditorModel editorModel = new EditorModel(this.messager, this.editorTypes, this, subEditor.getEditorType(), subEditor, subEditor.getEditedType());
        }
        if (!this.typeData.containsKey(this.editorType)) {
            this.typeData.put(this.editorType, flatData);
        }
        return toReturn;
    }

    private List<EditorProperty> makeProperties(Supplier<EditorProperty.Builder> builder, TypeMirror editorType) {
        ArrayList result = new ArrayList();
        return null;
    }

    private boolean shouldExamine(TypeMirror fieldClassType) {
        return this.editorTypes.getTypes().isAssignable(fieldClassType, this.editorTypes.getEditorInterface()) || this.editorTypes.getTypes().isAssignable(fieldClassType, this.editorTypes.getIsEditorInterface());
    }

    private void accumulateEditorData(List<EditorProperty> data, List<EditorProperty> flatData, List<EditorProperty> allData) {
        assert (!data.isEmpty());
        flatData.addAll(data);
        allData.addAll(data);
        for (EditorProperty d : data) {
            this.descendIntoSubEditor(allData, d);
        }
    }

    private void descendIntoSubEditor(List<EditorProperty> accumulator, EditorProperty data) {
        EditorModel superModel = this.parentModel;
        while (superModel != null) {
            if (this.editorTypes.getTypes().isAssignable(data.getEditorType(), superModel.editorType) || this.editorTypes.getTypes().isAssignable(superModel.editorType, data.getEditorType())) {
                return;
            }
            superModel = superModel.parentModel;
        }
        if (data.isDelegateRequired()) {
            EditorModel subModel = new EditorModel(this.messager, this.editorTypes, this, data.getEditorType(), data, ModelUtils.findParameterizationOf(this.editorTypes.getTypes(), this.editorTypes.getEditorInterface(), data.getEditorType()).get(0));
            accumulator.addAll(accumulator.indexOf(data) + 1, new ArrayList<EditorProperty>(subModel.getEditorData()));
        }
    }

    public TypeMirror getEditorType() {
        return this.editorType;
    }

    public TypeMirror getProxyType() {
        return this.dataType;
    }

    public List<EditorProperty> getEditorData() {
        return this.childrenModels;
    }

    public List<EditorProperty> getEditorData(TypeMirror editor) {
        List<EditorProperty> toReturn = this.typeData.get(editor);
        if (toReturn == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(toReturn);
    }

    public EditorProperty getRootData() {
        return new EditorProperty.Builder(this.editorTypes, this.dataType).root(this.getEditorType()).build(Optional.empty()).get(0);
    }
}

