/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.editor.processor.model;

import com.google.auto.common.MoreElements;
import com.google.common.collect.UnmodifiableIterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.gwtproject.editor.client.Editor;
import org.gwtproject.editor.processor.ModelUtils;
import org.gwtproject.editor.processor.model.BeanMethod;
import org.gwtproject.editor.processor.model.EditorTypes;

public class EditorProperty {
    private String beanOwnerExpression = "";
    private String beanOwnerGuard = "true";
    private EditorProperty composedData;
    private String declaredPath;
    private TypeMirror editedType;
    private TypeMirror editorType;
    private String editorExpression;
    private String getterExpression;
    private boolean isLeaf;
    private boolean isCompositeEditor;
    private boolean isDelegateRequired;
    private boolean isValueAware;
    private String path;
    private TypeMirror propertyOwnerType;
    private String setterName;
    private String simpleExpression;

    public String getExpression() {
        return this.editorExpression;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isCompositeEditor() {
        return this.isCompositeEditor;
    }

    public EditorProperty getComposedData() {
        return this.composedData;
    }

    public TypeMirror getEditedType() {
        return this.editedType;
    }

    public TypeMirror getEditorType() {
        return this.editorType;
    }

    public boolean isDelegateRequired() {
        return this.isDelegateRequired;
    }

    public boolean isLeafValueEditor() {
        return this.isLeaf;
    }

    public boolean isValueAwareEditor() {
        return this.isValueAware;
    }

    public boolean isDeclaredPathNested() {
        return this.declaredPath.contains(".");
    }

    public String getBeanOwnerExpression() {
        return this.beanOwnerExpression;
    }

    public String getBeanOwnerGuard(String ownerExpression) {
        return String.format(this.beanOwnerGuard, ownerExpression);
    }

    public String getGetterExpression() {
        return this.getterExpression;
    }

    public String getSetterName() {
        return this.setterName;
    }

    public String getPropertyName() {
        return this.getPath().substring(this.getPath().lastIndexOf(46) + 1);
    }

    public TypeMirror getPropertyOwnerType() {
        return this.propertyOwnerType;
    }

    public String getSimpleExpression() {
        return this.simpleExpression;
    }

    public String getDeclaredPath() {
        return this.declaredPath;
    }

    public static class Builder {
        private static final String EDITOR_SUFFIX = "Editor";
        private final EditorTypes types;
        private final TypeMirror dataType;
        private Stream.Builder<EditorProperty> builder = Stream.builder();
        private Stream<EditorProperty> stream;

        public Builder(EditorTypes types, TypeMirror dataType) {
            this.types = types;
            this.dataType = dataType;
        }

        public Builder root(TypeMirror type) {
            return this.access("", "", type);
        }

        public Builder access(VariableElement field) {
            String path = this.getPath(field.getSimpleName().toString(), field.getAnnotation(Editor.Path.class));
            return this.access(path, field.getSimpleName().toString(), field.asType());
        }

        public Builder access(ExecutableElement method) {
            assert (method.getParameters().isEmpty());
            String path = this.getPath(method.getSimpleName().toString(), method.getAnnotation(Editor.Path.class));
            return this.access(path, method.getSimpleName().toString() + "()", method.getReturnType());
        }

        private String getPath(String memberName, Editor.Path pathAnnotation) {
            if (pathAnnotation != null) {
                return pathAnnotation.value();
            }
            if (memberName.endsWith(EDITOR_SUFFIX)) {
                return memberName.substring(0, memberName.length() - EDITOR_SUFFIX.length());
            }
            return memberName;
        }

        private Builder access(String path, String editorExpression, TypeMirror editorType) {
            EditorProperty property2;
            TypeMirror editedType = null;
            if (this.types.getTypes().isAssignable(editorType, this.types.getIsEditorInterface())) {
                property2 = new EditorProperty();
                property2.editorType = ModelUtils.findParameterizationOf(this.types.getTypes(), this.types.getIsEditorInterface(), editorType).get(0);
                editedType = ModelUtils.findParameterizationOf(this.types.getTypes(), this.types.getEditorInterface(), property2.editorType).get(0);
                property2.editedType = editedType;
                property2.simpleExpression = editorExpression + ".asEditor()";
                this.builder.accept(property2);
            }
            if (this.types.getTypes().isAssignable(editorType, this.types.getEditorInterface())) {
                property2 = new EditorProperty();
                property2.editorType = editorType;
                editedType = ModelUtils.findParameterizationOf(this.types.getTypes(), this.types.getEditorInterface(), editorType).get(0);
                property2.editedType = editedType;
                property2.simpleExpression = editorExpression;
                this.builder.accept(property2);
            }
            this.stream = this.builder.build().peek((? super T property) -> {
                assert (((EditorProperty)property).declaredPath == null);
                ((EditorProperty)property).declaredPath = path;
                ((EditorProperty)property).isLeaf = this.types.getTypes().isAssignable(((EditorProperty)property).editorType, this.types.getLeafValueEditorInterface());
                ((EditorProperty)property).isCompositeEditor = this.types.getTypes().isAssignable(((EditorProperty)property).editorType, this.types.getCompositeEditorInterface());
                ((EditorProperty)property).isDelegateRequired = this.types.getTypes().isAssignable(((EditorProperty)property).editorType, this.types.getHasEditorDelegateInterface()) || this.types.getTypes().isAssignable(((EditorProperty)property).editorType, this.types.getHasEditorErrorsInterface()) || !ModelUtils.isValueType(((EditorProperty)property).editedType);
                ((EditorProperty)property).isValueAware = this.types.getTypes().isAssignable(((EditorProperty)property).editorType, this.types.getValueAwareEditorInterface());
            });
            this.builder = null;
            if (editedType != null) {
                this.findBeanPropertyMethods(path, editedType);
            }
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void findBeanPropertyMethods(String path, TypeMirror propertyType) {
            StringBuilder interstitialGetters = new StringBuilder();
            StringBuilder interstitialGuard = new StringBuilder("true");
            String[] parts = path.split(Pattern.quote("."));
            String setterName = null;
            TypeMirror lookingAt = this.dataType;
            int i = 0;
            int j = parts.length;
            while (true) {
                block12: {
                    UnmodifiableIterator unmodifiableIterator;
                    TypeMirror owner;
                    boolean foundGetterForPart;
                    boolean lastPart;
                    block14: {
                        block13: {
                            if (i >= j) break block13;
                            if (parts[i].length() == 0) break block12;
                            lastPart = i == j - 1;
                            foundGetterForPart = false;
                            owner = lookingAt;
                            unmodifiableIterator = MoreElements.getLocalAndInheritedMethods((TypeElement)((TypeElement)this.types.getTypes().asElement(lookingAt)), (Types)this.types.getTypes(), (Elements)this.types.getElements()).iterator();
                            break block14;
                        }
                        int idx = interstitialGetters.lastIndexOf(".");
                        this.beanOwnerExpression(idx <= 0 ? "" : interstitialGetters.substring(0, idx));
                        if (parts.length > 1) {
                            interstitialGuard.delete(interstitialGuard.lastIndexOf(" &&"), interstitialGuard.length());
                            this.beanOwnerGuard(interstitialGuard.substring(8));
                        }
                        if (interstitialGetters.length() > 0) {
                            this.getterExpression("." + interstitialGetters.substring(idx + 1, interstitialGetters.length() - 2) + "()");
                        } else {
                            this.getterExpression("");
                        }
                        this.setterName(setterName);
                        return;
                    }
                    while (unmodifiableIterator.hasNext()) {
                        ExecutableElement maybeSetter = (ExecutableElement)unmodifiableIterator.next();
                        BeanMethod which = BeanMethod.which(this.types, maybeSetter);
                        if (BeanMethod.CALL.equals((Object)which) || !which.inferName(maybeSetter).equals(parts[i])) continue;
                        switch (which) {
                            case GET: {
                                lookingAt = ((ExecutableType)this.types.getTypes().asMemberOf((DeclaredType)owner, maybeSetter)).getReturnType();
                                if (!lastPart && lookingAt.getKind().isPrimitive()) {
                                    throw new IllegalStateException("!lastPart && lookingAt.getKind().isPrimitive()");
                                }
                                interstitialGetters.append(".").append(maybeSetter.getSimpleName().toString()).append("()");
                                interstitialGuard.append(" && %1$s").append((CharSequence)interstitialGetters).append(" != null");
                                this.propertyOwnerType(maybeSetter.getEnclosingElement().asType());
                                foundGetterForPart = true;
                                if (lastPart) break;
                                break block12;
                            }
                            case SET: 
                            case SET_BUILDER: {
                                boolean matches;
                                if (!lastPart || setterName != null) break;
                                TypeMirror setterParamType = ((ExecutableType)this.types.getTypes().asMemberOf((DeclaredType)owner, maybeSetter)).getParameterTypes().get(0);
                                if (setterParamType.getKind().isPrimitive()) {
                                    setterParamType = this.types.getTypes().boxedClass((PrimitiveType)setterParamType).asType();
                                }
                                if (!(matches = this.types.getTypes().isAssignable(propertyType, setterParamType))) break;
                                setterName = maybeSetter.getSimpleName().toString();
                            }
                        }
                    }
                    if (!foundGetterForPart) {
                        throw new IllegalStateException("generation aborted! No getter exists for >>" + path + "<<");
                    }
                }
                ++i;
            }
        }

        private Builder peek(Consumer<EditorProperty> consumer) {
            this.stream = this.stream.peek(consumer);
            return this;
        }

        public Builder getterExpression(String value) {
            return this.peek(property -> ((EditorProperty)property).getterExpression = value);
        }

        public Builder propertyOwnerType(TypeMirror ownerType) {
            return this.peek(property -> ((EditorProperty)property).propertyOwnerType = ownerType);
        }

        public Builder setterName(String value) {
            return this.peek(property -> ((EditorProperty)property).setterName = value);
        }

        public Builder beanOwnerExpression(String value) {
            return this.peek(property -> ((EditorProperty)property).beanOwnerExpression = value);
        }

        public Builder beanOwnerGuard(String value) {
            return this.peek(property -> ((EditorProperty)property).beanOwnerGuard = value);
        }

        public List<EditorProperty> build(Optional<EditorProperty> parent) {
            if (this.stream == null) {
                throw new IllegalStateException();
            }
            try {
                this.stream = this.stream.peek((? super T property) -> {
                    ((EditorProperty)property).editorExpression = parent.map(p -> p.getExpression() + ".").orElse("") + ((EditorProperty)property).simpleExpression;
                    ((EditorProperty)property).path = parent.map(p -> p.getPath() + ".").orElse("") + ((EditorProperty)property).declaredPath;
                    if (((EditorProperty)property).isCompositeEditor) {
                        assert (this.types.getTypes().isAssignable(((EditorProperty)property).editorType, this.types.getCompositeEditorInterface()));
                        TypeMirror subEditorType = ModelUtils.findParameterizationOf(this.types.getTypes(), this.types.getCompositeEditorInterface(), ((EditorProperty)property).editorType).get(2);
                        ((EditorProperty)property).composedData = new Builder(this.types, this.dataType).root(subEditorType).build(Optional.of(property)).get(0);
                    }
                });
                List<EditorProperty> list = this.stream.collect(Collectors.toList());
                return list;
            }
            finally {
                this.stream = null;
            }
        }
    }
}

