/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "dua" locale.
 */
public class DateTimeFormatInfoImpl_dua extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "idiɓa",
        "ebyámu"
    };
  }

  @Override
  public String dateFormatFull() {
    return "EEEE d MMMM y";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM y";
  }

  @Override
  public String dateFormatShort() {
    return "d/M/y";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "ɓoso ɓwá yáɓe lá",
        "mbúsa kwédi a Yés"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "ɓ.Ys",
        "mb.Ys"
    };
  }

  @Override
  public String formatMinuteSecond() {
    return "m:ss";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d MMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE d MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "d/M";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d MMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d MMMM y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d/M/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE d MMM y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "dimɔ́di",
        "ŋgɔndɛ",
        "sɔŋɛ",
        "diɓáɓá",
        "emiasele",
        "esɔpɛsɔpɛ",
        "madiɓɛ́díɓɛ́",
        "diŋgindi",
        "nyɛtɛki",
        "mayésɛ́",
        "tiníní",
        "eláŋgɛ́"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "d",
        "ŋ",
        "s",
        "d",
        "e",
        "e",
        "m",
        "d",
        "n",
        "m",
        "t",
        "e"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "di",
        "ŋgɔn",
        "sɔŋ",
        "diɓ",
        "emi",
        "esɔ",
        "mad",
        "diŋ",
        "nyɛt",
        "may",
        "tin",
        "elá"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "ndúmbū nyá ɓosó",
        "ndúmbū ní lóndɛ́ íɓaá",
        "ndúmbū ní lóndɛ́ ílálo",
        "ndúmbū ní lóndɛ́ ínɛ́y"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "ndu1",
        "ndu2",
        "ndu3",
        "ndu4"
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "éti",
        "mɔ́sú",
        "kwasú",
        "mukɔ́sú",
        "ŋgisú",
        "ɗónɛsú",
        "esaɓasú"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "e",
        "m",
        "k",
        "m",
        "ŋ",
        "ɗ",
        "e"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "ét",
        "mɔ́s",
        "kwa",
        "muk",
        "ŋgi",
        "ɗón",
        "esa"
    };
  }
}
