/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "ky" locale.
 */
public class DateTimeFormatInfoImpl_ky extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "тң",
        "тк"
    };
  }

  @Override
  public String dateFormatFull() {
    return "y-'ж'., d-MMMM, EEEE";
  }

  @Override
  public String dateFormatLong() {
    return "y-'ж'., d-MMMM";
  }

  @Override
  public String dateFormatMedium() {
    return "y-'ж'., d-MMM";
  }

  @Override
  public String dateFormatShort() {
    return "d/M/yy";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "биздин заманга чейин",
        "биздин заман"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "б.з.ч.",
        "б.з."
    };
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d-MMM";
  }

  @Override
  public String formatMonthFullDay() {
    return "d-MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "d-MMMM, EEEE";
  }

  @Override
  public String formatMonthNumDay() {
    return "dd-MM";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "y-'ж'. MMM";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "y-'ж'. d-MMM";
  }

  @Override
  public String formatYearMonthFull() {
    return "y-'ж'., MMMM";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "y-'ж'., d-MMMM";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "y-dd-MM";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "y-'ж'. d-MMM, EEE";
  }

  @Override
  public String formatYearQuarterFull() {
    return "y-'ж'., QQQQ";
  }

  @Override
  public String formatYearQuarterShort() {
    return "y-'ж'., Q";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "январь",
        "февраль",
        "март",
        "апрель",
        "май",
        "июнь",
        "июль",
        "август",
        "сентябрь",
        "октябрь",
        "ноябрь",
        "декабрь"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "Январь",
        "Февраль",
        "Март",
        "Апрель",
        "Май",
        "Июнь",
        "Июль",
        "Август",
        "Сентябрь",
        "Октябрь",
        "Ноябрь",
        "Декабрь"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "Я",
        "Ф",
        "М",
        "А",
        "М",
        "И",
        "И",
        "А",
        "С",
        "О",
        "Н",
        "Д"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "янв.",
        "фев.",
        "мар.",
        "апр.",
        "май",
        "июн.",
        "июл.",
        "авг.",
        "сен.",
        "окт.",
        "ноя.",
        "дек."
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return new String[] {
        "Янв",
        "Фев",
        "Мар",
        "Апр",
        "Май",
        "Июн",
        "Июл",
        "Авг",
        "Сен",
        "Окт",
        "Ноя",
        "Дек"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1-чейрек",
        "2-чейрек",
        "3-чейрек",
        "4-чейрек"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "1-чей.",
        "2-чей.",
        "3-чей.",
        "4-чей."
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "жекшемби",
        "дүйшөмбү",
        "шейшемби",
        "шаршемби",
        "бейшемби",
        "жума",
        "ишемби"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "Ж",
        "Д",
        "Ш",
        "Ш",
        "Б",
        "Ж",
        "И"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "жек.",
        "дүй.",
        "шейш.",
        "шарш.",
        "бейш.",
        "жума",
        "ишм."
    };
  }
}
