/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "te" locale.
 */
public class DateTimeFormatInfoImpl_te extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatFull() {
    return "d, MMMM y, EEEE";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM, y";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM, y";
  }

  @Override
  public String dateFormatShort() {
    return "dd-MM-yy";
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return datePattern + " " + timePattern + "కి";
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return datePattern + " " + timePattern + "కి";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "క్రీస్తు పూర్వం",
        "క్రీస్తు శకం"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "క్రీపూ",
        "క్రీశ"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 0;
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d MMM";
  }

  @Override
  public String formatMonthFullDay() {
    return "d MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "d MMMM, EEEE";
  }

  @Override
  public String formatMonthNumDay() {
    return "d/M";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d, MMM y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d MMMM, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d/M/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "d MMM, y, EEE";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "జనవరి",
        "ఫిబ్రవరి",
        "మార్చి",
        "ఏప్రిల్",
        "మే",
        "జూన్",
        "జులై",
        "ఆగస్టు",
        "సెప్టెంబర్",
        "అక్టోబర్",
        "నవంబర్",
        "డిసెంబర్"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "జ",
        "ఫి",
        "మా",
        "ఏ",
        "మే",
        "జూ",
        "జు",
        "ఆ",
        "సె",
        "అ",
        "న",
        "డి"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "జన",
        "ఫిబ్ర",
        "మార్చి",
        "ఏప్రి",
        "మే",
        "జూన్",
        "జులై",
        "ఆగ",
        "సెప్టెం",
        "అక్టో",
        "నవం",
        "డిసెం"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1వ త్రైమాసికం",
        "2వ త్రైమాసికం",
        "3వ త్రైమాసికం",
        "4వ త్రైమాసికం"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "త్రై1",
        "త్రై2",
        "త్రై3",
        "త్రై4"
    };
  }

  @Override
  public String timeFormatFull() {
    return "h:mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "h:mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "h:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "h:mm a";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "ఆదివారం",
        "సోమవారం",
        "మంగళవారం",
        "బుధవారం",
        "గురువారం",
        "శుక్రవారం",
        "శనివారం"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "ఆ",
        "సో",
        "మ",
        "బు",
        "గు",
        "శు",
        "శ"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "ఆది",
        "సోమ",
        "మంగళ",
        "బుధ",
        "గురు",
        "శుక్ర",
        "శని"
    };
  }

  @Override
  public int weekendStart() {
    return 0;
  }
}
