/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.i18n.client;

import java.util.HashMap;
import java.util.Map;
import org.gwtproject.i18n.client.LocalizedNames;

public abstract class DefaultLocalizedNamesBase
implements LocalizedNames {
    protected String[] likelyRegionCodes = null;
    protected String[] sortedRegionCodes = null;
    protected Map<String, String> namesMap = null;

    @Override
    public final String[] getLikelyRegionCodes() {
        if (this.likelyRegionCodes == null) {
            this.likelyRegionCodes = this.loadLikelyRegionCodes();
        }
        return this.likelyRegionCodes;
    }

    @Override
    public final String getRegionName(String regionCode) {
        if (this.needsNameMap()) {
            this.loadNameMap();
        }
        return this.getRegionNameImpl(regionCode);
    }

    @Override
    public final String[] getSortedRegionCodes() {
        if (this.sortedRegionCodes == null) {
            this.sortedRegionCodes = this.loadSortedRegionCodes();
        }
        return this.sortedRegionCodes;
    }

    protected String getRegionNameImpl(String regionCode) {
        return this.namesMap.get(regionCode);
    }

    protected String[] loadLikelyRegionCodes() {
        return new String[0];
    }

    protected void loadNameMap() {
        this.namesMap = new HashMap<String, String>();
    }

    protected abstract String[] loadSortedRegionCodes();

    protected boolean needsNameMap() {
        return this.namesMap == null;
    }
}

