/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.client.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "eo" locale.
 */
public class DateTimeFormatInfoImpl_eo extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "atm",
        "ptm"
    };
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, d-'a' 'de' MMMM y";
  }

  @Override
  public String dateFormatLong() {
    return "y-MMMM-dd";
  }

  @Override
  public String dateFormatMedium() {
    return "y-MMM-dd";
  }

  @Override
  public String dateFormatShort() {
    return "yy-MM-dd";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "aK",
        "pK"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "aK",
        "pK"
    };
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "y-MMM-d";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "y-MMMM-d";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "januaro",
        "februaro",
        "marto",
        "aprilo",
        "majo",
        "junio",
        "julio",
        "aŭgusto",
        "septembro",
        "oktobro",
        "novembro",
        "decembro"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "jan",
        "feb",
        "mar",
        "apr",
        "maj",
        "jun",
        "jul",
        "aŭg",
        "sep",
        "okt",
        "nov",
        "dec"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1-a kvaronjaro",
        "2-a kvaronjaro",
        "3-a kvaronjaro",
        "4-a kvaronjaro"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "K1",
        "K2",
        "K3",
        "K4"
    };
  }

  @Override
  public String timeFormatFull() {
    return "H-'a' 'horo' 'kaj' m:ss zzzz";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "dimanĉo",
        "lundo",
        "mardo",
        "merkredo",
        "ĵaŭdo",
        "vendredo",
        "sabato"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "D",
        "L",
        "M",
        "M",
        "Ĵ",
        "V",
        "S"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "di",
        "lu",
        "ma",
        "me",
        "ĵa",
        "ve",
        "sa"
    };
  }
}
