/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.client.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "ku" locale.
 */
public class DateTimeFormatInfoImpl_ku extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "BN",
        "PN"
    };
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "berî zayînê",
        "piştî zayînê"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "BZ",
        "PZ"
    };
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, MMMM d";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "MMM d, y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "MMMM d, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "M/d/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, MMM d, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "rêbendanê",
        "reşemiyê",
        "adarê",
        "avrêlê",
        "gulanê",
        "pûşperê",
        "tîrmehê",
        "gelawêjê",
        "rezberê",
        "kewçêrê",
        "sermawezê",
        "berfanbarê"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "rêbendan",
        "reşemî",
        "adar",
        "avrêl",
        "gulan",
        "pûşper",
        "tîrmeh",
        "gelawêj",
        "rezber",
        "kewçêr",
        "sermawez",
        "berfanbar"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "R",
        "R",
        "A",
        "A",
        "G",
        "P",
        "T",
        "G",
        "R",
        "K",
        "S",
        "B"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "rêb",
        "reş",
        "ada",
        "avr",
        "gul",
        "pûş",
        "tîr",
        "gel",
        "rez",
        "kew",
        "ser",
        "ber"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "Ç1",
        "Ç2",
        "Ç3",
        "Ç4"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "Ç1",
        "Ç2",
        "Ç3",
        "Ç4"
    };
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "yekşem",
        "duşem",
        "sêşem",
        "çarşem",
        "pêncşem",
        "în",
        "şemî"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "Y",
        "D",
        "S",
        "Ç",
        "P",
        "Î",
        "Ş"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "yş",
        "dş",
        "sş",
        "çş",
        "pş",
        "în",
        "ş"
    };
  }
}
