/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.client.impl.cldr;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "ks" locale.
 */
public class DateTimeFormatInfoImpl_ks extends DateTimeFormatInfoImpl {

  @Override
  public String dateFormatFull() {
    return "EEEE, MMMM d, y";
  }

  @Override
  public String dateFormatLong() {
    return "MMMM d, y";
  }

  @Override
  public String dateFormatMedium() {
    return "MMM d, y";
  }

  @Override
  public String dateFormatShort() {
    return "M/d/yy";
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "قبٕل مسیٖح",
        "عیٖسوی سنہٕ"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "بی سی",
        "اے ڈی"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 0;
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d-MMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, MMMM d";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "MMM d, y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "MMMM d, y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "M/d/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, MMM d, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "جنؤری",
        "فرؤری",
        "مارٕچ",
        "اپریل",
        "میٔ",
        "جوٗن",
        "جوٗلایی",
        "اگست",
        "ستمبر",
        "اکتوٗبر",
        "نومبر",
        "دسمبر"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "ج",
        "ف",
        "م",
        "ا",
        "م",
        "ج",
        "ج",
        "ا",
        "س",
        "س",
        "ا",
        "ن"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "جنؤری",
        "فرؤری",
        "مارٕچ",
        "اپریل",
        "میٔ",
        "جوٗن",
        "جوٗلایی",
        "اگست",
        "ستمبر",
        "اکتوٗبر",
        "نومبر",
        "دسمبر"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "گۄڑنیُک ژۄباگ",
        "دوٚیِم ژۄباگ",
        "ترٛیِم ژۄباگ",
        "ژوٗرِم ژۄباگ"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "ژۄباگ",
        "دوٚیِم ژۄباگ",
        "ترٛیِم ژۄباگ",
        "ژوٗرِم ژۄباگ"
    };
  }

  @Override
  public String timeFormatFull() {
    return "h:mm:ss a zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "h:mm:ss a z";
  }

  @Override
  public String timeFormatMedium() {
    return "h:mm:ss a";
  }

  @Override
  public String timeFormatShort() {
    return "h:mm a";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "اَتھوار",
        "ژٔنٛدرٕروار",
        "بوٚموار",
        "بودوار",
        "برٛٮ۪سوار",
        "جُمہ",
        "بٹوار"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "ا",
        "ژ",
        "ب",
        "ب",
        "ب",
        "ج",
        "ب"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "آتھوار",
        "ژٔنٛدٕروار",
        "بوٚموار",
        "بودوار",
        "برٛٮ۪سوار",
        "جُمہ",
        "بٹوار"
    };
  }

  @Override
  public int weekendStart() {
    return 0;
  }
}
