package org.gwtproject.i18n.shared.cldr.impl;

import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import javax.annotation.Generated;
import org.gwtproject.i18n.shared.cldr.CurrencyData;
import org.gwtproject.i18n.shared.cldr.CurrencyDataImpl;

@Generated("gwt-cldr-importer : org.gwtproject.tools.cldr.CurrencyListProcessor, CLDR version : release-34")
public class CurrencyList_da extends CurrencyList_ {
  public CurrencyData getDefault() {
    return new CurrencyDataImpl("DKK","kr.",2,"kr.","kr.");
  }

  protected HashMap<String, CurrencyData> loadCurrencyMap() {
    HashMap<String,CurrencyData> result = super.loadCurrencyMap();
    // Andorransk peseta
    result.put("ADP", new CurrencyDataImpl("ADP","ADP",128,"ADP","ADP"));
    // dirham fra de Forenede Arabiske Emirater
    result.put("AED", new CurrencyDataImpl("AED","AED",2,"AED","AED"));
    // Afghansk afghani (1927–2002)
    result.put("AFA", new CurrencyDataImpl("AFA","AFA",130,"AFA","AFA"));
    // afghansk afghani
    result.put("AFN", new CurrencyDataImpl("AFN","AFN",0,"AFN","AFN"));
    // albansk lek (1946–1965)
    result.put("ALK", new CurrencyDataImpl("ALK","ALK",130,"ALK","ALK"));
    // albansk lek
    result.put("ALL", new CurrencyDataImpl("ALL","ALL",0,"ALL","ALL"));
    // armensk dram
    result.put("AMD", new CurrencyDataImpl("AMD","AMD",2,"AMD","AMD"));
    // Nederlandske Antiller-gylden
    result.put("ANG", new CurrencyDataImpl("ANG","ANG",2,"ANG","ANG"));
    // angolansk kwanza
    result.put("AOA", new CurrencyDataImpl("AOA","AOA",2,"AOA","AOA"));
    // Angolansk kwanza (1977–1990)
    result.put("AOK", new CurrencyDataImpl("AOK","AOK",130,"AOK","AOK"));
    // Angolansk nye kwanza (1990–2000)
    result.put("AON", new CurrencyDataImpl("AON","AON",130,"AON","AON"));
    // Angolansk kwanza (1995–1999)
    result.put("AOR", new CurrencyDataImpl("AOR","AOR",130,"AOR","AOR"));
    // Argentinsk austral
    result.put("ARA", new CurrencyDataImpl("ARA","ARA",130,"ARA","ARA"));
    // argentinsk peso ley (1970–1983)
    result.put("ARL", new CurrencyDataImpl("ARL","ARL",130,"ARL","ARL"));
    // argentinsk peso (1881–1970)
    result.put("ARM", new CurrencyDataImpl("ARM","ARM",130,"ARM","ARM"));
    // Argentinsk peso (1983–1985)
    result.put("ARP", new CurrencyDataImpl("ARP","ARP",130,"ARP","ARP"));
    // argentinsk peso
    result.put("ARS", new CurrencyDataImpl("ARS","ARS",2,"ARS","ARS"));
    // Østrigsk schilling
    result.put("ATS", new CurrencyDataImpl("ATS","ATS",130,"ATS","ATS"));
    // australsk dollar
    result.put("AUD", new CurrencyDataImpl("AUD","AU$",2,"AU$","AU$"));
    // arubansk florin
    result.put("AWG", new CurrencyDataImpl("AWG","AWG",2,"AWG","AWG"));
    // Aserbajdsjansk manat (1993–2006)
    result.put("AZM", new CurrencyDataImpl("AZM","AZM",130,"AZM","AZM"));
    // aserbajdsjansk manat
    result.put("AZN", new CurrencyDataImpl("AZN","AZN",2,"AZN","AZN"));
    // Bosnien-Hercegovinsk dinar
    result.put("BAD", new CurrencyDataImpl("BAD","BAD",130,"BAD","BAD"));
    // bosnien-hercegovinsk konvertibel mark
    result.put("BAM", new CurrencyDataImpl("BAM","BAM",2,"BAM","BAM"));
    // ny bosnien-hercegovinsk dinar (1994–1997)
    result.put("BAN", new CurrencyDataImpl("BAN","BAN",130,"BAN","BAN"));
    // barbadisk dollar
    result.put("BBD", new CurrencyDataImpl("BBD","BBD",2,"BBD","BBD"));
    // bangladeshisk taka
    result.put("BDT", new CurrencyDataImpl("BDT","BDT",2,"BDT","BDT"));
    // Belgisk franc (konvertibel)
    result.put("BEC", new CurrencyDataImpl("BEC","BEC",130,"BEC","BEC"));
    // Belgisk franc
    result.put("BEF", new CurrencyDataImpl("BEF","BEF",130,"BEF","BEF"));
    // Belgisk franc (financial)
    result.put("BEL", new CurrencyDataImpl("BEL","BEL",130,"BEL","BEL"));
    // Bulgarsk hard lev
    result.put("BGL", new CurrencyDataImpl("BGL","BGL",130,"BGL","BGL"));
    // bulgarsk socialistisk lev
    result.put("BGM", new CurrencyDataImpl("BGM","BGM",130,"BGM","BGM"));
    // bulgarsk lev
    result.put("BGN", new CurrencyDataImpl("BGN","BGN",2,"BGN","BGN"));
    // bulgarsk lev (1879–1952)
    result.put("BGO", new CurrencyDataImpl("BGO","BGO",130,"BGO","BGO"));
    // bahrainsk dinar
    result.put("BHD", new CurrencyDataImpl("BHD","BHD",3,"BHD","BHD"));
    // burundisk franc
    result.put("BIF", new CurrencyDataImpl("BIF","BIF",0,"BIF","BIF"));
    // bermudansk dollar
    result.put("BMD", new CurrencyDataImpl("BMD","BMD",2,"BMD","BMD"));
    // bruneisk dollar
    result.put("BND", new CurrencyDataImpl("BND","BND",2,"BND","BND"));
    // boliviansk boliviano
    result.put("BOB", new CurrencyDataImpl("BOB","BOB",2,"BOB","BOB"));
    // boliviansk boliviano (1863–1963)
    result.put("BOL", new CurrencyDataImpl("BOL","BOL",130,"BOL","BOL"));
    // Boliviansk peso
    result.put("BOP", new CurrencyDataImpl("BOP","BOP",130,"BOP","BOP"));
    // Boliviansk mvdol
    result.put("BOV", new CurrencyDataImpl("BOV","BOV",130,"BOV","BOV"));
    // Brasiliansk cruzeiro novo (1967–1986)
    result.put("BRB", new CurrencyDataImpl("BRB","BRB",130,"BRB","BRB"));
    // Brasiliansk cruzado (1986–1989)
    result.put("BRC", new CurrencyDataImpl("BRC","BRC",130,"BRC","BRC"));
    // Brasiliansk cruzeiro (1990–1993)
    result.put("BRE", new CurrencyDataImpl("BRE","BRE",130,"BRE","BRE"));
    // brasiliansk real
    result.put("BRL", new CurrencyDataImpl("BRL","R$",2,"R$","R$"));
    // Brasiliansk cruzado novo (1989–1990)
    result.put("BRN", new CurrencyDataImpl("BRN","BRN",130,"BRN","BRN"));
    // Brasiliansk cruzeiro (1993–1994)
    result.put("BRR", new CurrencyDataImpl("BRR","BRR",130,"BRR","BRR"));
    // brasiliansk cruzeiro (1942–1967)
    result.put("BRZ", new CurrencyDataImpl("BRZ","BRZ",130,"BRZ","BRZ"));
    // bahamansk dollar
    result.put("BSD", new CurrencyDataImpl("BSD","BSD",2,"BSD","BSD"));
    // bhutansk ngultrum
    result.put("BTN", new CurrencyDataImpl("BTN","BTN",2,"BTN","BTN"));
    // Burmesisk kyat
    result.put("BUK", new CurrencyDataImpl("BUK","BUK",130,"BUK","BUK"));
    // botswansk pula
    result.put("BWP", new CurrencyDataImpl("BWP","BWP",2,"BWP","BWP"));
    // Hviderussisk rubel (1994–1999)
    result.put("BYB", new CurrencyDataImpl("BYB","BYB",130,"BYB","BYB"));
    // hviderussisk rubel
    result.put("BYN", new CurrencyDataImpl("BYN","BYN",2,"BYN","BYN"));
    // hviderussisk rubel (2000–2016)
    result.put("BYR", new CurrencyDataImpl("BYR","BYR",128,"BYR","BYR"));
    // belizisk dollar
    result.put("BZD", new CurrencyDataImpl("BZD","BZD",2,"BZD","BZD"));
    // canadisk dollar
    result.put("CAD", new CurrencyDataImpl("CAD","CA$",2,"CA$","CA$"));
    // congolesisk franc
    result.put("CDF", new CurrencyDataImpl("CDF","CDF",2,"CDF","CDF"));
    // WIR euro
    result.put("CHE", new CurrencyDataImpl("CHE","CHE",130,"CHE","CHE"));
    // schweizerfranc
    result.put("CHF", new CurrencyDataImpl("CHF","CHF",2,"CHF","CHF"));
    // WIR franc
    result.put("CHW", new CurrencyDataImpl("CHW","CHW",130,"CHW","CHW"));
    // chilensk escudo
    result.put("CLE", new CurrencyDataImpl("CLE","CLE",130,"CLE","CLE"));
    // CLF
    result.put("CLF", new CurrencyDataImpl("CLF","CLF",132,"CLF","CLF"));
    // chilensk peso
    result.put("CLP", new CurrencyDataImpl("CLP","CLP",0,"CLP","CLP"));
    // kinesisk yuan (offshore)
    result.put("CNH", new CurrencyDataImpl("CNH","CNH",130,"CNH","CNH"));
    // CNX
    result.put("CNX", new CurrencyDataImpl("CNX","CNX",130,"CNX","CNX"));
    // kinesisk yuan
    result.put("CNY", new CurrencyDataImpl("CNY","CN¥",2,"CN¥","CN¥"));
    // colombiansk peso
    result.put("COP", new CurrencyDataImpl("COP","COP",2,"COP","COP"));
    // COU
    result.put("COU", new CurrencyDataImpl("COU","COU",130,"COU","COU"));
    // costaricansk colón
    result.put("CRC", new CurrencyDataImpl("CRC","CRC",2,"CRC","CRC"));
    // Serbisk dinar (2002–2006)
    result.put("CSD", new CurrencyDataImpl("CSD","CSD",130,"CSD","CSD"));
    // Tjekkoslovakisk hard koruna
    result.put("CSK", new CurrencyDataImpl("CSK","CSK",130,"CSK","CSK"));
    // cubansk konvertibel peso
    result.put("CUC", new CurrencyDataImpl("CUC","CUC",2,"CUC","CUC"));
    // cubansk peso
    result.put("CUP", new CurrencyDataImpl("CUP","CUP",2,"CUP","CUP"));
    // kapverdisk escudo
    result.put("CVE", new CurrencyDataImpl("CVE","CVE",2,"CVE","CVE"));
    // Cypriotisk pund
    result.put("CYP", new CurrencyDataImpl("CYP","CYP",130,"CYP","CYP"));
    // tjekkisk koruna
    result.put("CZK", new CurrencyDataImpl("CZK","CZK",2,"CZK","CZK"));
    // Østtysk mark
    result.put("DDM", new CurrencyDataImpl("DDM","DDM",130,"DDM","DDM"));
    // Tysk mark
    result.put("DEM", new CurrencyDataImpl("DEM","DEM",130,"DEM","DEM"));
    // djiboutisk franc
    result.put("DJF", new CurrencyDataImpl("DJF","DJF",0,"DJF","DJF"));
    // dansk krone
    result.put("DKK", new CurrencyDataImpl("DKK","kr.",2,"kr.","kr."));
    // dominikansk peso
    result.put("DOP", new CurrencyDataImpl("DOP","DOP",2,"DOP","DOP"));
    // algerisk dinar
    result.put("DZD", new CurrencyDataImpl("DZD","DZD",2,"DZD","DZD"));
    // Ecuadoriansk sucre
    result.put("ECS", new CurrencyDataImpl("ECS","ECS",130,"ECS","ECS"));
    // ECV
    result.put("ECV", new CurrencyDataImpl("ECV","ECV",130,"ECV","ECV"));
    // Estisk kroon
    result.put("EEK", new CurrencyDataImpl("EEK","EEK",130,"EEK","EEK"));
    // egyptisk pund
    result.put("EGP", new CurrencyDataImpl("EGP","EGP",2,"EGP","EGP"));
    // eritreisk nakfa
    result.put("ERN", new CurrencyDataImpl("ERN","ERN",2,"ERN","ERN"));
    // Spansk peseta (A–konto)
    result.put("ESA", new CurrencyDataImpl("ESA","ESA",130,"ESA","ESA"));
    // Spansk peseta (konvertibel konto)
    result.put("ESB", new CurrencyDataImpl("ESB","ESB",130,"ESB","ESB"));
    // Spansk peseta
    result.put("ESP", new CurrencyDataImpl("ESP","ESP",128,"ESP","ESP"));
    // etiopisk birr
    result.put("ETB", new CurrencyDataImpl("ETB","ETB",2,"ETB","ETB"));
    // euro
    result.put("EUR", new CurrencyDataImpl("EUR","€",2,"€","€"));
    // Finsk mark
    result.put("FIM", new CurrencyDataImpl("FIM","FIM",130,"FIM","FIM"));
    // fijiansk dollar
    result.put("FJD", new CurrencyDataImpl("FJD","FJD",2,"FJD","FJD"));
    // pund fra Falklandsøerne
    result.put("FKP", new CurrencyDataImpl("FKP","FKP",2,"FKP","FKP"));
    // Fransk franc
    result.put("FRF", new CurrencyDataImpl("FRF","FRF",130,"FRF","FRF"));
    // britisk pund
    result.put("GBP", new CurrencyDataImpl("GBP","£",2,"£","£"));
    // Georgisk kupon larit
    result.put("GEK", new CurrencyDataImpl("GEK","GEK",130,"GEK","GEK"));
    // georgisk lari
    result.put("GEL", new CurrencyDataImpl("GEL","₾",2,"₾","₾"));
    // Ghanesisk cedi (1979–2007)
    result.put("GHC", new CurrencyDataImpl("GHC","GHC",130,"GHC","GHC"));
    // ghanesisk cedi
    result.put("GHS", new CurrencyDataImpl("GHS","GHS",2,"GHS","GHS"));
    // gibraltarisk pund
    result.put("GIP", new CurrencyDataImpl("GIP","GIP",2,"GIP","GIP"));
    // gambisk dalasi
    result.put("GMD", new CurrencyDataImpl("GMD","GMD",2,"GMD","GMD"));
    // guineansk franc
    result.put("GNF", new CurrencyDataImpl("GNF","GNF",0,"GNF","GNF"));
    // Guineansk syli
    result.put("GNS", new CurrencyDataImpl("GNS","GNS",130,"GNS","GNS"));
    // Ækvatorialguineask ekwele
    result.put("GQE", new CurrencyDataImpl("GQE","GQE",130,"GQE","GQE"));
    // Græsk drakme
    result.put("GRD", new CurrencyDataImpl("GRD","GRD",130,"GRD","GRD"));
    // guatemalansk quetzal
    result.put("GTQ", new CurrencyDataImpl("GTQ","GTQ",2,"GTQ","GTQ"));
    // Portugisisk guinea escudo
    result.put("GWE", new CurrencyDataImpl("GWE","GWE",130,"GWE","GWE"));
    // Guineansk peso
    result.put("GWP", new CurrencyDataImpl("GWP","GWP",130,"GWP","GWP"));
    // guyansk dollar
    result.put("GYD", new CurrencyDataImpl("GYD","GYD",2,"GYD","GYD"));
    // Hongkong dollar
    result.put("HKD", new CurrencyDataImpl("HKD","HK$",2,"HK$","HK$"));
    // honduransk lempira
    result.put("HNL", new CurrencyDataImpl("HNL","HNL",2,"HNL","HNL"));
    // Kroatisk dinar
    result.put("HRD", new CurrencyDataImpl("HRD","HRD",130,"HRD","HRD"));
    // kroatisk kuna
    result.put("HRK", new CurrencyDataImpl("HRK","HRK",2,"HRK","HRK"));
    // haitisk gourde
    result.put("HTG", new CurrencyDataImpl("HTG","HTG",2,"HTG","HTG"));
    // ungarsk forint
    result.put("HUF", new CurrencyDataImpl("HUF","HUF",2,"HUF","HUF"));
    // indonesisk rupiah
    result.put("IDR", new CurrencyDataImpl("IDR","IDR",2,"IDR","IDR"));
    // Irsk pund
    result.put("IEP", new CurrencyDataImpl("IEP","IEP",130,"IEP","IEP"));
    // Israelsk pund
    result.put("ILP", new CurrencyDataImpl("ILP","ILP",130,"ILP","ILP"));
    // israelsk shekel (1980–1985)
    result.put("ILR", new CurrencyDataImpl("ILR","ILR",130,"ILR","ILR"));
    // ny israelsk shekel
    result.put("ILS", new CurrencyDataImpl("ILS","₪",2,"₪","₪"));
    // indisk rupee
    result.put("INR", new CurrencyDataImpl("INR","₹",2,"₹","₹"));
    // irakisk dinar
    result.put("IQD", new CurrencyDataImpl("IQD","IQD",0,"IQD","IQD"));
    // iransk rial
    result.put("IRR", new CurrencyDataImpl("IRR","IRR",0,"IRR","IRR"));
    // islandsk krone (1918–1981)
    result.put("ISJ", new CurrencyDataImpl("ISJ","ISJ",130,"ISJ","ISJ"));
    // islandsk krone
    result.put("ISK", new CurrencyDataImpl("ISK","ISK",0,"ISK","ISK"));
    // Italiensk lire
    result.put("ITL", new CurrencyDataImpl("ITL","ITL",128,"ITL","ITL"));
    // jamaicansk dollar
    result.put("JMD", new CurrencyDataImpl("JMD","JMD",2,"JMD","JMD"));
    // jordansk dinar
    result.put("JOD", new CurrencyDataImpl("JOD","JOD",3,"JOD","JOD"));
    // japansk yen
    result.put("JPY", new CurrencyDataImpl("JPY","JP¥",0,"JP¥","JP¥"));
    // kenyansk shilling
    result.put("KES", new CurrencyDataImpl("KES","KES",2,"KES","KES"));
    // kirgisisk som
    result.put("KGS", new CurrencyDataImpl("KGS","KGS",2,"KGS","KGS"));
    // cambodjansk riel
    result.put("KHR", new CurrencyDataImpl("KHR","KHR",2,"KHR","KHR"));
    // comorisk franc
    result.put("KMF", new CurrencyDataImpl("KMF","KMF",0,"KMF","KMF"));
    // nordkoreansk won
    result.put("KPW", new CurrencyDataImpl("KPW","KPW",0,"KPW","KPW"));
    // sydkoreansk hwan (1953–1962)
    result.put("KRH", new CurrencyDataImpl("KRH","KRH",130,"KRH","KRH"));
    // sydkoreansk won (1945–1953)
    result.put("KRO", new CurrencyDataImpl("KRO","KRO",130,"KRO","KRO"));
    // sydkoreansk won
    result.put("KRW", new CurrencyDataImpl("KRW","₩",0,"₩","₩"));
    // kuwaitisk dinar
    result.put("KWD", new CurrencyDataImpl("KWD","KWD",3,"KWD","KWD"));
    // caymansk dollar
    result.put("KYD", new CurrencyDataImpl("KYD","KYD",2,"KYD","KYD"));
    // kasakhisk tenge
    result.put("KZT", new CurrencyDataImpl("KZT","KZT",2,"KZT","KZT"));
    // laotisk kip
    result.put("LAK", new CurrencyDataImpl("LAK","LAK",0,"LAK","LAK"));
    // libanesisk pund
    result.put("LBP", new CurrencyDataImpl("LBP","LBP",0,"LBP","LBP"));
    // srilankansk rupee
    result.put("LKR", new CurrencyDataImpl("LKR","LKR",2,"LKR","LKR"));
    // liberisk dollar
    result.put("LRD", new CurrencyDataImpl("LRD","LRD",2,"LRD","LRD"));
    // Lesothisk loti
    result.put("LSL", new CurrencyDataImpl("LSL","LSL",2,"LSL","LSL"));
    // Litauisk litas
    result.put("LTL", new CurrencyDataImpl("LTL","LTL",130,"LTL","LTL"));
    // Litauisk talonas
    result.put("LTT", new CurrencyDataImpl("LTT","LTT",130,"LTT","LTT"));
    // Luxembourgsk konvertibel franc
    result.put("LUC", new CurrencyDataImpl("LUC","LUC",130,"LUC","LUC"));
    // Luxembourgsk franc
    result.put("LUF", new CurrencyDataImpl("LUF","LUF",128,"LUF","LUF"));
    // Luxembourgsk finansiel franc
    result.put("LUL", new CurrencyDataImpl("LUL","LUL",130,"LUL","LUL"));
    // Lettisk lat
    result.put("LVL", new CurrencyDataImpl("LVL","LVL",130,"LVL","LVL"));
    // Lettisk rubel
    result.put("LVR", new CurrencyDataImpl("LVR","LVR",130,"LVR","LVR"));
    // libysk dinar
    result.put("LYD", new CurrencyDataImpl("LYD","LYD",3,"LYD","LYD"));
    // marokkansk dirham
    result.put("MAD", new CurrencyDataImpl("MAD","MAD",2,"MAD","MAD"));
    // Marokkansk franc
    result.put("MAF", new CurrencyDataImpl("MAF","MAF",130,"MAF","MAF"));
    // monegaskisk franc
    result.put("MCF", new CurrencyDataImpl("MCF","MCF",130,"MCF","MCF"));
    // moldovisk cupon
    result.put("MDC", new CurrencyDataImpl("MDC","MDC",130,"MDC","MDC"));
    // moldovisk leu
    result.put("MDL", new CurrencyDataImpl("MDL","MDL",2,"MDL","MDL"));
    // madagaskisk ariary
    result.put("MGA", new CurrencyDataImpl("MGA","MGA",0,"MGA","MGA"));
    // Madagaskisk franc
    result.put("MGF", new CurrencyDataImpl("MGF","MGF",128,"MGF","MGF"));
    // makedonsk denar
    result.put("MKD", new CurrencyDataImpl("MKD","MKD",2,"MKD","MKD"));
    // makedonsk denar (1992–1993)
    result.put("MKN", new CurrencyDataImpl("MKN","MKN",130,"MKN","MKN"));
    // Malisk franc
    result.put("MLF", new CurrencyDataImpl("MLF","MLF",130,"MLF","MLF"));
    // myanmarsk kyat
    result.put("MMK", new CurrencyDataImpl("MMK","MMK",0,"MMK","MMK"));
    // mongolsk tugrik
    result.put("MNT", new CurrencyDataImpl("MNT","MNT",2,"MNT","MNT"));
    // macaosk pataca
    result.put("MOP", new CurrencyDataImpl("MOP","MOP",2,"MOP","MOP"));
    // mauritansk ouguiya (1973–2017)
    result.put("MRO", new CurrencyDataImpl("MRO","MRO",128,"MRO","MRO"));
    // mauritansk ouguiya
    result.put("MRU", new CurrencyDataImpl("MRU","MRU",2,"MRU","MRU"));
    // Maltesisk lira
    result.put("MTL", new CurrencyDataImpl("MTL","MTL",130,"MTL","MTL"));
    // Maltesisk pund
    result.put("MTP", new CurrencyDataImpl("MTP","MTP",130,"MTP","MTP"));
    // mauritisk rupee
    result.put("MUR", new CurrencyDataImpl("MUR","MUR",2,"MUR","MUR"));
    // maldivisk rupi (1947–1981)
    result.put("MVP", new CurrencyDataImpl("MVP","MVP",130,"MVP","MVP"));
    // maldivisk rufiyaa
    result.put("MVR", new CurrencyDataImpl("MVR","MVR",2,"MVR","MVR"));
    // malawisk kwacha
    result.put("MWK", new CurrencyDataImpl("MWK","MWK",2,"MWK","MWK"));
    // mexicansk peso
    result.put("MXN", new CurrencyDataImpl("MXN","MX$",2,"MX$","MX$"));
    // Mexicansk silver peso (1861–1992)
    result.put("MXP", new CurrencyDataImpl("MXP","MXP",130,"MXP","MXP"));
    // MXV
    result.put("MXV", new CurrencyDataImpl("MXV","MXV",130,"MXV","MXV"));
    // malaysisk ringgit
    result.put("MYR", new CurrencyDataImpl("MYR","MYR",2,"MYR","MYR"));
    // Mozambiquisk escudo
    result.put("MZE", new CurrencyDataImpl("MZE","MZE",130,"MZE","MZE"));
    // Mozambiquisk metical (1980–2006)
    result.put("MZM", new CurrencyDataImpl("MZM","MZM",130,"MZM","MZM"));
    // mozambiquisk metical
    result.put("MZN", new CurrencyDataImpl("MZN","MZN",2,"MZN","MZN"));
    // namibisk dollar
    result.put("NAD", new CurrencyDataImpl("NAD","NAD",2,"NAD","NAD"));
    // nigeriansk naira
    result.put("NGN", new CurrencyDataImpl("NGN","NGN",2,"NGN","NGN"));
    // Nicaraguansk cordoba (1988–1991)
    result.put("NIC", new CurrencyDataImpl("NIC","NIC",130,"NIC","NIC"));
    // nicaraguansk cordoba
    result.put("NIO", new CurrencyDataImpl("NIO","NIO",2,"NIO","NIO"));
    // Hollandsk guilder
    result.put("NLG", new CurrencyDataImpl("NLG","NLG",130,"NLG","NLG"));
    // norsk krone
    result.put("NOK", new CurrencyDataImpl("NOK","NOK",2,"NOK","NOK"));
    // nepalesisk rupee
    result.put("NPR", new CurrencyDataImpl("NPR","NPR",2,"NPR","NPR"));
    // newzealandsk dollar
    result.put("NZD", new CurrencyDataImpl("NZD","NZ$",2,"NZ$","NZ$"));
    // omansk rial
    result.put("OMR", new CurrencyDataImpl("OMR","OMR",3,"OMR","OMR"));
    // panamansk balboa
    result.put("PAB", new CurrencyDataImpl("PAB","PAB",2,"PAB","PAB"));
    // peruviansk inti
    result.put("PEI", new CurrencyDataImpl("PEI","PEI",130,"PEI","PEI"));
    // peruansk sol
    result.put("PEN", new CurrencyDataImpl("PEN","PEN",2,"PEN","PEN"));
    // peruviansk sol (1863–1965)
    result.put("PES", new CurrencyDataImpl("PES","PES",130,"PES","PES"));
    // papuansk kina
    result.put("PGK", new CurrencyDataImpl("PGK","PGK",2,"PGK","PGK"));
    // filippinsk peso
    result.put("PHP", new CurrencyDataImpl("PHP","PHP",2,"PHP","PHP"));
    // pakistansk rupee
    result.put("PKR", new CurrencyDataImpl("PKR","PKR",2,"PKR","PKR"));
    // polsk zloty
    result.put("PLN", new CurrencyDataImpl("PLN","PLN",2,"PLN","PLN"));
    // Polsk zloty (1950–1995)
    result.put("PLZ", new CurrencyDataImpl("PLZ","PLZ",130,"PLZ","PLZ"));
    // Portugisisk escudo
    result.put("PTE", new CurrencyDataImpl("PTE","PTE",130,"PTE","PTE"));
    // paraguaysk guarani
    result.put("PYG", new CurrencyDataImpl("PYG","PYG",0,"PYG","PYG"));
    // qatarsk rial
    result.put("QAR", new CurrencyDataImpl("QAR","QAR",2,"QAR","QAR"));
    // rhodesisk dollar
    result.put("RHD", new CurrencyDataImpl("RHD","RHD",130,"RHD","RHD"));
    // Rumænsk leu (1952–2006)
    result.put("ROL", new CurrencyDataImpl("ROL","ROL",130,"ROL","ROL"));
    // rumænsk leu
    result.put("RON", new CurrencyDataImpl("RON","RON",2,"RON","RON"));
    // serbisk dinar
    result.put("RSD", new CurrencyDataImpl("RSD","RSD",0,"RSD","RSD"));
    // russisk rubel
    result.put("RUB", new CurrencyDataImpl("RUB","RUB",2,"RUB","RUB"));
    // Russisk rubel (1991–1998)
    result.put("RUR", new CurrencyDataImpl("RUR","RUR",130,"RUR","RUR"));
    // rwandisk franc
    result.put("RWF", new CurrencyDataImpl("RWF","RWF",0,"RWF","RWF"));
    // saudiarabisk riyal
    result.put("SAR", new CurrencyDataImpl("SAR","SAR",2,"SAR","SAR"));
    // salomonsk dollar
    result.put("SBD", new CurrencyDataImpl("SBD","SBD",2,"SBD","SBD"));
    // seychellisk rupee
    result.put("SCR", new CurrencyDataImpl("SCR","SCR",2,"SCR","SCR"));
    // Sudansk dinar (1992–2007)
    result.put("SDD", new CurrencyDataImpl("SDD","SDD",130,"SDD","SDD"));
    // sudansk pund
    result.put("SDG", new CurrencyDataImpl("SDG","SDG",2,"SDG","SDG"));
    // Sudansk pund (1957–1998)
    result.put("SDP", new CurrencyDataImpl("SDP","SDP",130,"SDP","SDP"));
    // svensk krone
    result.put("SEK", new CurrencyDataImpl("SEK","SEK",2,"SEK","SEK"));
    // singaporeansk dollar
    result.put("SGD", new CurrencyDataImpl("SGD","SGD",2,"SGD","SGD"));
    // pund fra Saint Helena
    result.put("SHP", new CurrencyDataImpl("SHP","SHP",2,"SHP","SHP"));
    // Slovensk tolar
    result.put("SIT", new CurrencyDataImpl("SIT","SIT",130,"SIT","SIT"));
    // Slovakisk koruna
    result.put("SKK", new CurrencyDataImpl("SKK","SKK",130,"SKK","SKK"));
    // sierraleonsk leone
    result.put("SLL", new CurrencyDataImpl("SLL","SLL",0,"SLL","SLL"));
    // somalisk shilling
    result.put("SOS", new CurrencyDataImpl("SOS","SOS",0,"SOS","SOS"));
    // surinamsk dollar
    result.put("SRD", new CurrencyDataImpl("SRD","SRD",2,"SRD","SRD"));
    // Surinamsk guilder
    result.put("SRG", new CurrencyDataImpl("SRG","SRG",130,"SRG","SRG"));
    // sydsudansk pund
    result.put("SSP", new CurrencyDataImpl("SSP","SSP",2,"SSP","SSP"));
    // dobra fra Sao Tome og Principe (1977–2017)
    result.put("STD", new CurrencyDataImpl("STD","STD",128,"STD","STD"));
    // dobra fra Sao Tome og Principe
    result.put("STN", new CurrencyDataImpl("STN","STN",2,"STN","STN"));
    // Sovjetisk rubel
    result.put("SUR", new CurrencyDataImpl("SUR","SUR",130,"SUR","SUR"));
    // Salvadoransk colon
    result.put("SVC", new CurrencyDataImpl("SVC","SVC",130,"SVC","SVC"));
    // syrisk pund
    result.put("SYP", new CurrencyDataImpl("SYP","SYP",0,"SYP","SYP"));
    // swazilandsk lilangeni
    result.put("SZL", new CurrencyDataImpl("SZL","SZL",2,"SZL","SZL"));
    // thailandsk baht
    result.put("THB", new CurrencyDataImpl("THB","฿",2,"฿","฿"));
    // Tadsjikisk rubel
    result.put("TJR", new CurrencyDataImpl("TJR","TJR",130,"TJR","TJR"));
    // tadsjikisk somoni
    result.put("TJS", new CurrencyDataImpl("TJS","TJS",2,"TJS","TJS"));
    // Turkmensk manat (1993–2009)
    result.put("TMM", new CurrencyDataImpl("TMM","TMM",128,"TMM","TMM"));
    // turkmensk manat
    result.put("TMT", new CurrencyDataImpl("TMT","TMT",2,"TMT","TMT"));
    // tunesisk dinar
    result.put("TND", new CurrencyDataImpl("TND","TND",3,"TND","TND"));
    // tongansk paʻanga
    result.put("TOP", new CurrencyDataImpl("TOP","TOP",2,"TOP","TOP"));
    // Escudo fra Timor
    result.put("TPE", new CurrencyDataImpl("TPE","TPE",130,"TPE","TPE"));
    // Tyrkisk lire (1922–2005)
    result.put("TRL", new CurrencyDataImpl("TRL","TRL",128,"TRL","TRL"));
    // tyrkisk lira
    result.put("TRY", new CurrencyDataImpl("TRY","TL",2,"TL","TL"));
    // dollar fra Trinidad og Tobago
    result.put("TTD", new CurrencyDataImpl("TTD","TTD",2,"TTD","TTD"));
    // ny taiwansk dollar
    result.put("TWD", new CurrencyDataImpl("TWD","NT$",2,"NT$","NT$"));
    // tanzanisk shilling
    result.put("TZS", new CurrencyDataImpl("TZS","TZS",2,"TZS","TZS"));
    // ukrainsk grynia
    result.put("UAH", new CurrencyDataImpl("UAH","UAH",2,"UAH","UAH"));
    // Ukrainsk karbovanetz
    result.put("UAK", new CurrencyDataImpl("UAK","UAK",130,"UAK","UAK"));
    // Ugandisk shilling (1966–1987)
    result.put("UGS", new CurrencyDataImpl("UGS","UGS",130,"UGS","UGS"));
    // ugandisk shilling
    result.put("UGX", new CurrencyDataImpl("UGX","UGX",0,"UGX","UGX"));
    // amerikansk dollar
    result.put("USD", new CurrencyDataImpl("USD","$",2,"$","$"));
    // Amerikansk dollar (næste dag)
    result.put("USN", new CurrencyDataImpl("USN","USN",130,"USN","USN"));
    // Amerikansk dollar (samme dag)
    result.put("USS", new CurrencyDataImpl("USS","USS",130,"USS","USS"));
    // UYI
    result.put("UYI", new CurrencyDataImpl("UYI","UYI",128,"UYI","UYI"));
    // Uruguayansk peso (1975–1993)
    result.put("UYP", new CurrencyDataImpl("UYP","UYP",130,"UYP","UYP"));
    // uruguayansk peso
    result.put("UYU", new CurrencyDataImpl("UYU","UYU",2,"UYU","UYU"));
    // UYW
    result.put("UYW", new CurrencyDataImpl("UYW","UYW",132,"UYW","UYW"));
    // usbekisk sum
    result.put("UZS", new CurrencyDataImpl("UZS","UZS",2,"UZS","UZS"));
    // Venezuelansk bolivar (1871–2008)
    result.put("VEB", new CurrencyDataImpl("VEB","VEB",130,"VEB","VEB"));
    // venezuelansk bolivar (2008–2018)
    result.put("VEF", new CurrencyDataImpl("VEF","VEF",130,"VEF","VEF"));
    // venezuelansk bolivar
    result.put("VES", new CurrencyDataImpl("VES","VES",2,"VES","VES"));
    // vietnamesisk dong
    result.put("VND", new CurrencyDataImpl("VND","₫",0,"₫","₫"));
    // vietnamesisk dong (1978–1985)
    result.put("VNN", new CurrencyDataImpl("VNN","VNN",130,"VNN","VNN"));
    // vanuaisk vatu
    result.put("VUV", new CurrencyDataImpl("VUV","VUV",0,"VUV","VUV"));
    // samoansk tala
    result.put("WST", new CurrencyDataImpl("WST","WST",2,"WST","WST"));
    // CFA-franc (BEAC)
    result.put("XAF", new CurrencyDataImpl("XAF","FCFA",0,"FCFA","FCFA"));
    // Sølv
    result.put("XAG", new CurrencyDataImpl("XAG","XAG",130,"XAG","XAG"));
    // Guld
    result.put("XAU", new CurrencyDataImpl("XAU","XAU",130,"XAU","XAU"));
    // EURCO
    result.put("XBA", new CurrencyDataImpl("XBA","XBA",130,"XBA","XBA"));
    // EMU
    result.put("XBB", new CurrencyDataImpl("XBB","XBB",130,"XBB","XBB"));
    // XBC
    result.put("XBC", new CurrencyDataImpl("XBC","XBC",130,"XBC","XBC"));
    // XBD
    result.put("XBD", new CurrencyDataImpl("XBD","XBD",130,"XBD","XBD"));
    // østkaribisk dollar
    result.put("XCD", new CurrencyDataImpl("XCD","EC$",2,"EC$","EC$"));
    // SDR
    result.put("XDR", new CurrencyDataImpl("XDR","XDR",130,"XDR","XDR"));
    // ECU
    result.put("XEU", new CurrencyDataImpl("XEU","XEU",130,"XEU","XEU"));
    // Fransk guldfranc
    result.put("XFO", new CurrencyDataImpl("XFO","XFO",130,"XFO","XFO"));
    // Fransk UIC-franc
    result.put("XFU", new CurrencyDataImpl("XFU","XFU",130,"XFU","XFU"));
    // CFA-franc BCEAO
    result.put("XOF", new CurrencyDataImpl("XOF","CFA",0,"CFA","CFA"));
    // Palladium
    result.put("XPD", new CurrencyDataImpl("XPD","XPD",130,"XPD","XPD"));
    // CFP-franc
    result.put("XPF", new CurrencyDataImpl("XPF","CFPF",0,"CFPF","CFPF"));
    // Platin
    result.put("XPT", new CurrencyDataImpl("XPT","XPT",130,"XPT","XPT"));
    // RINET-fond
    result.put("XRE", new CurrencyDataImpl("XRE","XRE",130,"XRE","XRE"));
    // XSU
    result.put("XSU", new CurrencyDataImpl("XSU","XSU",130,"XSU","XSU"));
    // testvalutakode
    result.put("XTS", new CurrencyDataImpl("XTS","XTS",130,"XTS","XTS"));
    // XUA
    result.put("XUA", new CurrencyDataImpl("XUA","XUA",130,"XUA","XUA"));
    // ukendt valuta
    result.put("XXX", new CurrencyDataImpl("XXX","¤",130,"¤","¤"));
    // Yemenitisk dinar
    result.put("YDD", new CurrencyDataImpl("YDD","YDD",130,"YDD","YDD"));
    // yemenitisk rial
    result.put("YER", new CurrencyDataImpl("YER","YER",0,"YER","YER"));
    // Jugoslavisk hard dinar (1966–1990)
    result.put("YUD", new CurrencyDataImpl("YUD","YUD",130,"YUD","YUD"));
    // Jugoslavisk noviy dinar (1994–2002)
    result.put("YUM", new CurrencyDataImpl("YUM","YUM",130,"YUM","YUM"));
    // Jugoslavisk konvertibel dinar (1990–1992)
    result.put("YUN", new CurrencyDataImpl("YUN","YUN",130,"YUN","YUN"));
    // jugoslavisk reformeret dinar (1992–1993)
    result.put("YUR", new CurrencyDataImpl("YUR","YUR",130,"YUR","YUR"));
    // Sydafrikansk rand (financial)
    result.put("ZAL", new CurrencyDataImpl("ZAL","ZAL",130,"ZAL","ZAL"));
    // sydafrikansk rand
    result.put("ZAR", new CurrencyDataImpl("ZAR","ZAR",2,"ZAR","ZAR"));
    // Zambisk kwacha (1968–2012)
    result.put("ZMK", new CurrencyDataImpl("ZMK","ZMK",128,"ZMK","ZMK"));
    // zambisk kwacha
    result.put("ZMW", new CurrencyDataImpl("ZMW","ZMW",2,"ZMW","ZMW"));
    // Ny zairisk zaire (1993–1998)
    result.put("ZRN", new CurrencyDataImpl("ZRN","ZRN",130,"ZRN","ZRN"));
    // Zairisk zaire (1971–1993)
    result.put("ZRZ", new CurrencyDataImpl("ZRZ","ZRZ",130,"ZRZ","ZRZ"));
    // Zimbabwisk dollar (1980–2008)
    result.put("ZWD", new CurrencyDataImpl("ZWD","ZWD",128,"ZWD","ZWD"));
    // Zimbabwisk dollar (2009)
    result.put("ZWL", new CurrencyDataImpl("ZWL","ZWL",130,"ZWL","ZWL"));
    // Zimbabwisk dollar (2008)
    result.put("ZWR", new CurrencyDataImpl("ZWR","ZWR",130,"ZWR","ZWR"));
    return result;
  }

  @Override
  protected HashMap<String, String> loadNamesMap() {
    HashMap<String,String> result = super.loadNamesMap();
    result.put("ADP","Andorransk peseta");
    result.put("AED","dirham fra de Forenede Arabiske Emirater");
    result.put("AFA","Afghansk afghani (1927–2002)");
    result.put("AFN","afghansk afghani");
    result.put("ALK","albansk lek (1946–1965)");
    result.put("ALL","albansk lek");
    result.put("AMD","armensk dram");
    result.put("ANG","Nederlandske Antiller-gylden");
    result.put("AOA","angolansk kwanza");
    result.put("AOK","Angolansk kwanza (1977–1990)");
    result.put("AON","Angolansk nye kwanza (1990–2000)");
    result.put("AOR","Angolansk kwanza (1995–1999)");
    result.put("ARA","Argentinsk austral");
    result.put("ARL","argentinsk peso ley (1970–1983)");
    result.put("ARM","argentinsk peso (1881–1970)");
    result.put("ARP","Argentinsk peso (1983–1985)");
    result.put("ARS","argentinsk peso");
    result.put("ATS","Østrigsk schilling");
    result.put("AUD","australsk dollar");
    result.put("AWG","arubansk florin");
    result.put("AZM","Aserbajdsjansk manat (1993–2006)");
    result.put("AZN","aserbajdsjansk manat");
    result.put("BAD","Bosnien-Hercegovinsk dinar");
    result.put("BAM","bosnien-hercegovinsk konvertibel mark");
    result.put("BAN","ny bosnien-hercegovinsk dinar (1994–1997)");
    result.put("BBD","barbadisk dollar");
    result.put("BDT","bangladeshisk taka");
    result.put("BEC","Belgisk franc (konvertibel)");
    result.put("BEF","Belgisk franc");
    result.put("BEL","Belgisk franc (financial)");
    result.put("BGL","Bulgarsk hard lev");
    result.put("BGM","bulgarsk socialistisk lev");
    result.put("BGN","bulgarsk lev");
    result.put("BGO","bulgarsk lev (1879–1952)");
    result.put("BHD","bahrainsk dinar");
    result.put("BIF","burundisk franc");
    result.put("BMD","bermudansk dollar");
    result.put("BND","bruneisk dollar");
    result.put("BOB","boliviansk boliviano");
    result.put("BOL","boliviansk boliviano (1863–1963)");
    result.put("BOP","Boliviansk peso");
    result.put("BOV","Boliviansk mvdol");
    result.put("BRB","Brasiliansk cruzeiro novo (1967–1986)");
    result.put("BRC","Brasiliansk cruzado (1986–1989)");
    result.put("BRE","Brasiliansk cruzeiro (1990–1993)");
    result.put("BRL","brasiliansk real");
    result.put("BRN","Brasiliansk cruzado novo (1989–1990)");
    result.put("BRR","Brasiliansk cruzeiro (1993–1994)");
    result.put("BRZ","brasiliansk cruzeiro (1942–1967)");
    result.put("BSD","bahamansk dollar");
    result.put("BTN","bhutansk ngultrum");
    result.put("BUK","Burmesisk kyat");
    result.put("BWP","botswansk pula");
    result.put("BYB","Hviderussisk rubel (1994–1999)");
    result.put("BYN","hviderussisk rubel");
    result.put("BYR","hviderussisk rubel (2000–2016)");
    result.put("BZD","belizisk dollar");
    result.put("CAD","canadisk dollar");
    result.put("CDF","congolesisk franc");
    result.put("CHE","WIR euro");
    result.put("CHF","schweizerfranc");
    result.put("CHW","WIR franc");
    result.put("CLE","chilensk escudo");
    result.put("CLP","chilensk peso");
    result.put("CNH","kinesisk yuan (offshore)");
    result.put("CNY","kinesisk yuan");
    result.put("COP","colombiansk peso");
    result.put("CRC","costaricansk colón");
    result.put("CSD","Serbisk dinar (2002–2006)");
    result.put("CSK","Tjekkoslovakisk hard koruna");
    result.put("CUC","cubansk konvertibel peso");
    result.put("CUP","cubansk peso");
    result.put("CVE","kapverdisk escudo");
    result.put("CYP","Cypriotisk pund");
    result.put("CZK","tjekkisk koruna");
    result.put("DDM","Østtysk mark");
    result.put("DEM","Tysk mark");
    result.put("DJF","djiboutisk franc");
    result.put("DKK","dansk krone");
    result.put("DOP","dominikansk peso");
    result.put("DZD","algerisk dinar");
    result.put("ECS","Ecuadoriansk sucre");
    result.put("EEK","Estisk kroon");
    result.put("EGP","egyptisk pund");
    result.put("ERN","eritreisk nakfa");
    result.put("ESA","Spansk peseta (A–konto)");
    result.put("ESB","Spansk peseta (konvertibel konto)");
    result.put("ESP","Spansk peseta");
    result.put("ETB","etiopisk birr");
    result.put("EUR","euro");
    result.put("FIM","Finsk mark");
    result.put("FJD","fijiansk dollar");
    result.put("FKP","pund fra Falklandsøerne");
    result.put("FRF","Fransk franc");
    result.put("GBP","britisk pund");
    result.put("GEK","Georgisk kupon larit");
    result.put("GEL","georgisk lari");
    result.put("GHC","Ghanesisk cedi (1979–2007)");
    result.put("GHS","ghanesisk cedi");
    result.put("GIP","gibraltarisk pund");
    result.put("GMD","gambisk dalasi");
    result.put("GNF","guineansk franc");
    result.put("GNS","Guineansk syli");
    result.put("GQE","Ækvatorialguineask ekwele");
    result.put("GRD","Græsk drakme");
    result.put("GTQ","guatemalansk quetzal");
    result.put("GWE","Portugisisk guinea escudo");
    result.put("GWP","Guineansk peso");
    result.put("GYD","guyansk dollar");
    result.put("HKD","Hongkong dollar");
    result.put("HNL","honduransk lempira");
    result.put("HRD","Kroatisk dinar");
    result.put("HRK","kroatisk kuna");
    result.put("HTG","haitisk gourde");
    result.put("HUF","ungarsk forint");
    result.put("IDR","indonesisk rupiah");
    result.put("IEP","Irsk pund");
    result.put("ILP","Israelsk pund");
    result.put("ILR","israelsk shekel (1980–1985)");
    result.put("ILS","ny israelsk shekel");
    result.put("INR","indisk rupee");
    result.put("IQD","irakisk dinar");
    result.put("IRR","iransk rial");
    result.put("ISJ","islandsk krone (1918–1981)");
    result.put("ISK","islandsk krone");
    result.put("ITL","Italiensk lire");
    result.put("JMD","jamaicansk dollar");
    result.put("JOD","jordansk dinar");
    result.put("JPY","japansk yen");
    result.put("KES","kenyansk shilling");
    result.put("KGS","kirgisisk som");
    result.put("KHR","cambodjansk riel");
    result.put("KMF","comorisk franc");
    result.put("KPW","nordkoreansk won");
    result.put("KRH","sydkoreansk hwan (1953–1962)");
    result.put("KRO","sydkoreansk won (1945–1953)");
    result.put("KRW","sydkoreansk won");
    result.put("KWD","kuwaitisk dinar");
    result.put("KYD","caymansk dollar");
    result.put("KZT","kasakhisk tenge");
    result.put("LAK","laotisk kip");
    result.put("LBP","libanesisk pund");
    result.put("LKR","srilankansk rupee");
    result.put("LRD","liberisk dollar");
    result.put("LSL","Lesothisk loti");
    result.put("LTL","Litauisk litas");
    result.put("LTT","Litauisk talonas");
    result.put("LUC","Luxembourgsk konvertibel franc");
    result.put("LUF","Luxembourgsk franc");
    result.put("LUL","Luxembourgsk finansiel franc");
    result.put("LVL","Lettisk lat");
    result.put("LVR","Lettisk rubel");
    result.put("LYD","libysk dinar");
    result.put("MAD","marokkansk dirham");
    result.put("MAF","Marokkansk franc");
    result.put("MCF","monegaskisk franc");
    result.put("MDC","moldovisk cupon");
    result.put("MDL","moldovisk leu");
    result.put("MGA","madagaskisk ariary");
    result.put("MGF","Madagaskisk franc");
    result.put("MKD","makedonsk denar");
    result.put("MKN","makedonsk denar (1992–1993)");
    result.put("MLF","Malisk franc");
    result.put("MMK","myanmarsk kyat");
    result.put("MNT","mongolsk tugrik");
    result.put("MOP","macaosk pataca");
    result.put("MRO","mauritansk ouguiya (1973–2017)");
    result.put("MRU","mauritansk ouguiya");
    result.put("MTL","Maltesisk lira");
    result.put("MTP","Maltesisk pund");
    result.put("MUR","mauritisk rupee");
    result.put("MVP","maldivisk rupi (1947–1981)");
    result.put("MVR","maldivisk rufiyaa");
    result.put("MWK","malawisk kwacha");
    result.put("MXN","mexicansk peso");
    result.put("MXP","Mexicansk silver peso (1861–1992)");
    result.put("MYR","malaysisk ringgit");
    result.put("MZE","Mozambiquisk escudo");
    result.put("MZM","Mozambiquisk metical (1980–2006)");
    result.put("MZN","mozambiquisk metical");
    result.put("NAD","namibisk dollar");
    result.put("NGN","nigeriansk naira");
    result.put("NIC","Nicaraguansk cordoba (1988–1991)");
    result.put("NIO","nicaraguansk cordoba");
    result.put("NLG","Hollandsk guilder");
    result.put("NOK","norsk krone");
    result.put("NPR","nepalesisk rupee");
    result.put("NZD","newzealandsk dollar");
    result.put("OMR","omansk rial");
    result.put("PAB","panamansk balboa");
    result.put("PEI","peruviansk inti");
    result.put("PEN","peruansk sol");
    result.put("PES","peruviansk sol (1863–1965)");
    result.put("PGK","papuansk kina");
    result.put("PHP","filippinsk peso");
    result.put("PKR","pakistansk rupee");
    result.put("PLN","polsk zloty");
    result.put("PLZ","Polsk zloty (1950–1995)");
    result.put("PTE","Portugisisk escudo");
    result.put("PYG","paraguaysk guarani");
    result.put("QAR","qatarsk rial");
    result.put("RHD","rhodesisk dollar");
    result.put("ROL","Rumænsk leu (1952–2006)");
    result.put("RON","rumænsk leu");
    result.put("RSD","serbisk dinar");
    result.put("RUB","russisk rubel");
    result.put("RUR","Russisk rubel (1991–1998)");
    result.put("RWF","rwandisk franc");
    result.put("SAR","saudiarabisk riyal");
    result.put("SBD","salomonsk dollar");
    result.put("SCR","seychellisk rupee");
    result.put("SDD","Sudansk dinar (1992–2007)");
    result.put("SDG","sudansk pund");
    result.put("SDP","Sudansk pund (1957–1998)");
    result.put("SEK","svensk krone");
    result.put("SGD","singaporeansk dollar");
    result.put("SHP","pund fra Saint Helena");
    result.put("SIT","Slovensk tolar");
    result.put("SKK","Slovakisk koruna");
    result.put("SLL","sierraleonsk leone");
    result.put("SOS","somalisk shilling");
    result.put("SRD","surinamsk dollar");
    result.put("SRG","Surinamsk guilder");
    result.put("SSP","sydsudansk pund");
    result.put("STD","dobra fra Sao Tome og Principe (1977–2017)");
    result.put("STN","dobra fra Sao Tome og Principe");
    result.put("SUR","Sovjetisk rubel");
    result.put("SVC","Salvadoransk colon");
    result.put("SYP","syrisk pund");
    result.put("SZL","swazilandsk lilangeni");
    result.put("THB","thailandsk baht");
    result.put("TJR","Tadsjikisk rubel");
    result.put("TJS","tadsjikisk somoni");
    result.put("TMM","Turkmensk manat (1993–2009)");
    result.put("TMT","turkmensk manat");
    result.put("TND","tunesisk dinar");
    result.put("TOP","tongansk paʻanga");
    result.put("TPE","Escudo fra Timor");
    result.put("TRL","Tyrkisk lire (1922–2005)");
    result.put("TRY","tyrkisk lira");
    result.put("TTD","dollar fra Trinidad og Tobago");
    result.put("TWD","ny taiwansk dollar");
    result.put("TZS","tanzanisk shilling");
    result.put("UAH","ukrainsk grynia");
    result.put("UAK","Ukrainsk karbovanetz");
    result.put("UGS","Ugandisk shilling (1966–1987)");
    result.put("UGX","ugandisk shilling");
    result.put("USD","amerikansk dollar");
    result.put("USN","Amerikansk dollar (næste dag)");
    result.put("USS","Amerikansk dollar (samme dag)");
    result.put("UYP","Uruguayansk peso (1975–1993)");
    result.put("UYU","uruguayansk peso");
    result.put("UZS","usbekisk sum");
    result.put("VEB","Venezuelansk bolivar (1871–2008)");
    result.put("VEF","venezuelansk bolivar (2008–2018)");
    result.put("VES","venezuelansk bolivar");
    result.put("VND","vietnamesisk dong");
    result.put("VNN","vietnamesisk dong (1978–1985)");
    result.put("VUV","vanuaisk vatu");
    result.put("WST","samoansk tala");
    result.put("XAF","CFA-franc (BEAC)");
    result.put("XAG","Sølv");
    result.put("XAU","Guld");
    result.put("XBA","EURCO");
    result.put("XBB","EMU");
    result.put("XCD","østkaribisk dollar");
    result.put("XDR","SDR");
    result.put("XEU","ECU");
    result.put("XFO","Fransk guldfranc");
    result.put("XFU","Fransk UIC-franc");
    result.put("XOF","CFA-franc BCEAO");
    result.put("XPD","Palladium");
    result.put("XPF","CFP-franc");
    result.put("XPT","Platin");
    result.put("XRE","RINET-fond");
    result.put("XTS","testvalutakode");
    result.put("XXX","ukendt valuta");
    result.put("YDD","Yemenitisk dinar");
    result.put("YER","yemenitisk rial");
    result.put("YUD","Jugoslavisk hard dinar (1966–1990)");
    result.put("YUM","Jugoslavisk noviy dinar (1994–2002)");
    result.put("YUN","Jugoslavisk konvertibel dinar (1990–1992)");
    result.put("YUR","jugoslavisk reformeret dinar (1992–1993)");
    result.put("ZAL","Sydafrikansk rand (financial)");
    result.put("ZAR","sydafrikansk rand");
    result.put("ZMK","Zambisk kwacha (1968–2012)");
    result.put("ZMW","zambisk kwacha");
    result.put("ZRN","Ny zairisk zaire (1993–1998)");
    result.put("ZRZ","Zairisk zaire (1971–1993)");
    result.put("ZWD","Zimbabwisk dollar (1980–2008)");
    result.put("ZWL","Zimbabwisk dollar (2009)");
    result.put("ZWR","Zimbabwisk dollar (2008)");
    return result;
  }
}
