/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.i18n.processor;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.WeakHashMap;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import org.gwtproject.ext.ConfigurationProperty;
import org.gwtproject.ext.PropertyOracle;
import org.gwtproject.ext.SelectionProperty;
import org.gwtproject.ext.UnableToCompleteException;
import org.gwtproject.i18n.processor.GwtLocaleFactoryImpl;
import org.gwtproject.i18n.processor.LocaleInfoContext;
import org.gwtproject.i18n.processor.ProcessorContext;
import org.gwtproject.i18n.shared.GwtLocale;
import org.gwtproject.i18n.shared.GwtLocaleFactory;

public class LocaleUtils {
    private static final GwtLocaleFactoryImpl factory = new GwtLocaleFactoryImpl();
    static final String PROP_LOCALE = "locale";
    static final String PROP_LOCALE_QUERY_PARAM = "locale.queryparam";
    static final String PROP_LOCALE_COOKIE = "locale.cookie";
    static final String PROP_RUNTIME_LOCALES = "runtime.locales.new";
    private static final WeakHashMap<ProcessorContext, LocaleInfoContext> localeInfoCtxHolder = new WeakHashMap();
    private final Set<GwtLocale> allCompileLocales;
    private final Set<GwtLocale> allLocales;
    private final GwtLocale compileLocale;
    private final Set<GwtLocale> runtimeLocales;
    private final String queryParam;
    private final String cookie;

    public static LocaleUtils getInstance(Messager logger, PropertyOracle propertyOracle, ProcessorContext context) {
        try {
            SelectionProperty localeProp = propertyOracle.getSelectionProperty(logger, PROP_LOCALE);
            ConfigurationProperty runtimeLocaleProp = propertyOracle.getConfigurationProperty(PROP_RUNTIME_LOCALES);
            ConfigurationProperty queryParamProp = propertyOracle.getConfigurationProperty(PROP_LOCALE_QUERY_PARAM);
            ConfigurationProperty cookieProp = propertyOracle.getConfigurationProperty(PROP_LOCALE_COOKIE);
            LocaleInfoContext localeInfoCtx = new LocaleInfoContext();
            LocaleUtils localeUtils = localeInfoCtx.getLocaleUtils(localeProp, runtimeLocaleProp, queryParamProp, cookieProp);
            if (localeUtils == null) {
                localeUtils = LocaleUtils.createInstance(localeProp, runtimeLocaleProp, queryParamProp, cookieProp);
                localeInfoCtx.putLocaleUtils(localeProp, runtimeLocaleProp, queryParamProp, cookieProp, localeUtils);
            }
            return localeUtils;
        }
        catch (UnableToCompleteException e) {
            logger.printMessage(Diagnostic.Kind.WARNING, "Unable to get locale properties, using defaults" + e.getMessage());
            GwtLocale defaultLocale = factory.fromString("default");
            HashSet<GwtLocale> allLocales = new HashSet<GwtLocale>();
            allLocales.add(defaultLocale);
            return new LocaleUtils(defaultLocale, allLocales, allLocales, Collections.emptySet(), null, null);
        }
    }

    public static GwtLocaleFactory getLocaleFactory() {
        return factory;
    }

    private static LocaleUtils createInstance(SelectionProperty localeProp, ConfigurationProperty prop, ConfigurationProperty queryParamProp, ConfigurationProperty cookieProp) {
        GwtLocale newCompileLocale;
        String cookie;
        GwtLocale compileLocale = null;
        HashSet<GwtLocale> allLocales = new HashSet<GwtLocale>();
        HashSet<GwtLocale> allCompileLocales = new HashSet<GwtLocale>();
        HashSet<GwtLocale> runtimeLocales = new HashSet<GwtLocale>();
        String localeName = localeProp.getCurrentValue();
        String queryParam = queryParamProp.getValues().get(0);
        if (queryParam.length() == 0) {
            queryParam = null;
        }
        if ((cookie = cookieProp.getValues().get(0)).length() == 0) {
            cookie = null;
        }
        SortedSet<String> localeValues = localeProp.getPossibleValues();
        GwtLocaleFactory factoryInstance = LocaleUtils.getLocaleFactory();
        compileLocale = newCompileLocale = factoryInstance.fromString(localeName);
        for (String localeValue : localeValues) {
            allCompileLocales.add(factoryInstance.fromString(localeValue));
        }
        allLocales.addAll(allCompileLocales);
        List<String> rtLocaleNames = prop.getValues();
        if (rtLocaleNames != null) {
            block1: for (String rtLocaleName : rtLocaleNames) {
                GwtLocale rtLocale = factoryInstance.fromString(rtLocaleName);
                if (rtLocale.isDefault()) continue;
                for (GwtLocale search : rtLocale.getCompleteSearchList()) {
                    if (search.equals(compileLocale) && rtLocale.usesSameScript(compileLocale)) {
                        runtimeLocales.add(rtLocale);
                        allLocales.add(rtLocale);
                        continue block1;
                    }
                    if (!allCompileLocales.contains(search) || !rtLocale.usesSameScript(search)) continue;
                    allLocales.add(rtLocale);
                    continue block1;
                }
            }
        }
        return new LocaleUtils(compileLocale, allLocales, allCompileLocales, runtimeLocales, queryParam, cookie);
    }

    private static synchronized LocaleInfoContext getLocaleInfoCtx(ProcessorContext context) {
        LocaleInfoContext localeInfoCtx = localeInfoCtxHolder.get(context);
        if (localeInfoCtx == null) {
            localeInfoCtx = new LocaleInfoContext();
            localeInfoCtxHolder.put(context, localeInfoCtx);
        }
        return localeInfoCtx;
    }

    private LocaleUtils(GwtLocale compileLocale, Set<GwtLocale> allLocales, Set<GwtLocale> allCompileLocales, Set<GwtLocale> runtimeLocales, String queryParam, String cookie) {
        this.compileLocale = compileLocale;
        this.allLocales = Collections.unmodifiableSet(allLocales);
        this.allCompileLocales = Collections.unmodifiableSet(allCompileLocales);
        this.runtimeLocales = Collections.unmodifiableSet(runtimeLocales);
        this.queryParam = queryParam;
        this.cookie = cookie;
    }

    public Set<GwtLocale> getAllCompileLocales() {
        return this.allCompileLocales;
    }

    public Set<GwtLocale> getAllLocales() {
        return this.allLocales;
    }

    public GwtLocale getCompileLocale() {
        return this.compileLocale;
    }

    public String getCookie() {
        return this.cookie;
    }

    public String getQueryParam() {
        return this.queryParam;
    }

    public Set<GwtLocale> getRuntimeLocales() {
        return this.runtimeLocales;
    }
}

