/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gwtproject.ext.BadPropertyValueException;
import org.gwtproject.ext.ConfigurationProperty;
import org.gwtproject.ext.DefaultConfigurationProperty;

public final class ConfigurationProperties {
    private final Map<String, ConfigurationProperty> holder = new HashMap<String, ConfigurationProperty>();

    public ConfigurationProperties() {
        this.setDefaultProperties();
    }

    private void setDefaultProperties() {
        this.lookupAndSet("locale", Arrays.asList("default"), false);
    }

    private void lookupAndSet(String propertyName, List<String> defaulValues, boolean override) {
        ArrayList<String> list = new ArrayList<String>(defaulValues);
        this.holder.put(propertyName, this.lookup(new DefaultConfigurationProperty(propertyName, list), override));
    }

    private ConfigurationProperty lookup(ConfigurationProperty holder, boolean override) {
        String values = System.getProperty(holder.getName());
        if (values != null) {
            if (override) {
                holder.getValues().clear();
            }
            Arrays.stream(values.split("\\s+")).forEach(e -> holder.getValues().add((String)e));
        }
        return holder;
    }

    public ConfigurationProperty getConfigurationProperty(String key) throws BadPropertyValueException {
        if (this.holder.containsKey(key)) {
            return this.holder.get(key);
        }
        throw new BadPropertyValueException(key);
    }
}

