/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.ext;

import java.util.List;
import org.gwtproject.ext.ConfigurationProperty;
import org.gwtproject.ext.UnableToCompleteException;

public class DefaultConfigurationProperty
implements ConfigurationProperty {
    private final String name;
    private final List<String> values;

    public DefaultConfigurationProperty(String name, List<String> values) {
        assert (name != null);
        assert (values != null);
        this.name = name;
        this.values = values;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultConfigurationProperty other = (DefaultConfigurationProperty)obj;
        return this.name.equals(other.name) && this.values.equals(other.values);
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public String asSingleValue() throws UnableToCompleteException {
        if (this.values.size() > 1) {
            throw new UnableToCompleteException("The configuration property " + this.getName() + " cannot be a multi-valued property");
        }
        return this.values.get(0);
    }

    @Override
    public Boolean asSingleBooleanValue() throws UnableToCompleteException {
        return Boolean.valueOf(this.asSingleValue());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    public String toString() {
        return "ConfigProp " + this.name + ": " + this.values.toString();
    }
}

