/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.ext;

import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import org.gwtproject.ext.BadPropertyValueException;
import org.gwtproject.ext.ConfigurationProperties;
import org.gwtproject.ext.ConfigurationProperty;
import org.gwtproject.ext.PropertyOracle;
import org.gwtproject.ext.SelectionProperty;
import org.gwtproject.ext.StandardSelectionProperty;
import org.gwtproject.ext.UnableToCompleteException;

public class PropertyOracleImpl
implements PropertyOracle {
    public final ConfigurationProperties configurationProperties = new ConfigurationProperties();

    @Override
    public ConfigurationProperty getConfigurationProperty(String propertyName) throws UnableToCompleteException {
        ConfigurationProperty configurationProperty;
        try {
            configurationProperty = this.configurationProperties.getConfigurationProperty(propertyName);
        }
        catch (BadPropertyValueException e) {
            throw new UnableToCompleteException();
        }
        return configurationProperty;
    }

    @Override
    public SelectionProperty getSelectionProperty(Messager logger, String propertyName) throws UnableToCompleteException {
        String value = System.getProperty(propertyName);
        if (value != null) {
            return new StandardSelectionProperty(propertyName, value);
        }
        try {
            ConfigurationProperty configurationProperty = this.configurationProperties.getConfigurationProperty(propertyName);
            return new StandardSelectionProperty(propertyName, configurationProperty.asSingleValue());
        }
        catch (BadPropertyValueException e) {
            logger.printMessage(Diagnostic.Kind.ERROR, "Unable to get selection property : " + propertyName);
            throw new UnableToCompleteException();
        }
    }
}

