/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.safehtml.apt;

import com.google.common.base.Preconditions;
import com.google.streamhtmlparser.HtmlParser;
import com.google.streamhtmlparser.HtmlParserFactory;
import com.google.streamhtmlparser.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gwtproject.safehtml.apt.ParsedHtmlTemplate;
import org.gwtproject.safehtml.apt.UnableToCompleteException;

final class HtmlTemplateParser {
    private static final Logger LOGGER = Logger.getLogger(HtmlTemplateParser.class.getName());
    private static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile("\\{(\\d+)\\}");
    private final ParsedHtmlTemplate parsedTemplate = new ParsedHtmlTemplate();
    private final HtmlParser streamHtmlParser = HtmlParserFactory.createParser();
    private String template;
    private int parsePosition;
    private char lookBehind;
    private char lookAhead;

    public ParsedHtmlTemplate getParsedTemplate() {
        return this.parsedTemplate;
    }

    void parseTemplate(String template) throws UnableToCompleteException {
        this.template = template;
        this.parsePosition = 0;
        this.lookBehind = '\u0000';
        this.lookAhead = '\u0000';
        Matcher match = TEMPLATE_PARAM_PATTERN.matcher(template);
        int endOfPreviousMatch = 0;
        while (match.find()) {
            if (match.start() > endOfPreviousMatch) {
                this.parseAndAppendTemplateSegment(template.substring(endOfPreviousMatch, match.start()));
                this.parsePosition = match.start();
                this.lookBehind = template.charAt(this.parsePosition - 1);
            }
            int paramIndex = Integer.parseInt(match.group(1));
            this.parsePosition = match.end();
            this.lookAhead = this.parsePosition < template.length() ? template.charAt(this.parsePosition) : (char)'\u0000';
            this.parsedTemplate.addParameter(new ParsedHtmlTemplate.ParameterChunk(this.getHtmlContextFromParseState(), paramIndex));
            endOfPreviousMatch = match.end();
        }
        if (endOfPreviousMatch < template.length()) {
            this.parseAndAppendTemplateSegment(template.substring(endOfPreviousMatch));
        }
        if (!this.streamHtmlParser.getState().equals(HtmlParser.STATE_TEXT)) {
            LOGGER.log(Level.SEVERE, "Template does not end in inner-HTML context: " + template);
            throw new UnableToCompleteException();
        }
    }

    private ParsedHtmlTemplate.HtmlContext getHtmlContextFromParseState() throws UnableToCompleteException {
        if (this.streamHtmlParser.getState().equals(HtmlParser.STATE_ERROR)) {
            LOGGER.log(Level.SEVERE, "Parsing template resulted in parse error: " + this.getTemplateParsedSoFar());
            throw new UnableToCompleteException();
        }
        if (this.streamHtmlParser.inJavascript()) {
            LOGGER.log(Level.SEVERE, "Template variables in javascript context are not supported: " + this.getTemplateParsedSoFar());
            throw new UnableToCompleteException();
        }
        if (this.streamHtmlParser.getState().equals(HtmlParser.STATE_COMMENT)) {
            LOGGER.log(Level.SEVERE, "Template variables inside HTML comments are not supported: " + this.getTemplateParsedSoFar());
            throw new UnableToCompleteException();
        }
        if (this.streamHtmlParser.getState().equals(HtmlParser.STATE_TEXT) && !this.streamHtmlParser.inCss()) {
            return new ParsedHtmlTemplate.HtmlContext(ParsedHtmlTemplate.HtmlContext.Type.TEXT);
        }
        if (this.streamHtmlParser.getState().equals(HtmlParser.STATE_VALUE)) {
            String tag = this.streamHtmlParser.getTag();
            String attribute = this.streamHtmlParser.getAttribute();
            Preconditions.checkState((!tag.equals("") ? 1 : 0) != 0, (String)"streamHtmlParser.getTag() should not be empty  while in attribute value context; at %s", (Object)this.getTemplateParsedSoFar());
            Preconditions.checkState((!attribute.equals("") ? 1 : 0) != 0, (String)"streamHtmlParser.getAttribute() should not be empty while in attribute value context; at %s", (Object)this.getTemplateParsedSoFar());
            if (!this.streamHtmlParser.isAttributeQuoted()) {
                LOGGER.log(Level.SEVERE, "Template variable in unquoted attribute value: " + this.getTemplateParsedSoFar());
                throw new UnableToCompleteException();
            }
            if ("meta".equals(tag) && "content".equals(attribute)) {
                LOGGER.log(Level.SEVERE, "Template variables in content attribute of meta tag are not supported: " + this.getTemplateParsedSoFar());
                throw new UnableToCompleteException();
            }
            if (this.streamHtmlParser.isUrlStart()) {
                Preconditions.checkState((this.lookBehind == '\"' || this.lookBehind == '\'' ? 1 : 0) != 0, (String)"At the start of a quoted attribute, lookBehind should be a quote character; at %s", (Object)this.getTemplateParsedSoFar());
                if (this.lookAhead == this.lookBehind) {
                    return new ParsedHtmlTemplate.HtmlContext(ParsedHtmlTemplate.HtmlContext.Type.URL_ATTRIBUTE_ENTIRE, tag, attribute);
                }
                return new ParsedHtmlTemplate.HtmlContext(ParsedHtmlTemplate.HtmlContext.Type.URL_ATTRIBUTE_START, tag, attribute);
            }
            if (this.streamHtmlParser.inCss()) {
                if (this.streamHtmlParser.getValueIndex() == 0) {
                    return new ParsedHtmlTemplate.HtmlContext(ParsedHtmlTemplate.HtmlContext.Type.CSS_ATTRIBUTE_START, tag, attribute);
                }
                return new ParsedHtmlTemplate.HtmlContext(ParsedHtmlTemplate.HtmlContext.Type.CSS_ATTRIBUTE, tag, attribute);
            }
            return new ParsedHtmlTemplate.HtmlContext(ParsedHtmlTemplate.HtmlContext.Type.ATTRIBUTE_VALUE, tag, attribute);
        }
        if (this.streamHtmlParser.inCss()) {
            return new ParsedHtmlTemplate.HtmlContext(ParsedHtmlTemplate.HtmlContext.Type.CSS);
        }
        if (this.streamHtmlParser.getState().equals(HtmlParser.STATE_TAG) || this.streamHtmlParser.inAttribute()) {
            LOGGER.log(Level.SEVERE, "Template variables in tags or in attribute names are not supported: " + this.getTemplateParsedSoFar());
            throw new UnableToCompleteException();
        }
        LOGGER.log(Level.SEVERE, "unhandeled/illegal parse state" + this.streamHtmlParser.getState());
        throw new UnableToCompleteException();
    }

    private String getTemplateParsedSoFar() {
        return this.template.substring(0, this.parsePosition);
    }

    private void parseAndAppendTemplateSegment(String segment) throws UnableToCompleteException {
        try {
            this.streamHtmlParser.parse(segment);
        }
        catch (ParseException cause) {
            LOGGER.log(Level.SEVERE, "Parse exception when parsing segment '" + segment + "' of template '" + this.template + "'", cause);
            throw new UnableToCompleteException();
        }
        this.parsedTemplate.addLiteral(segment);
    }
}

