/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.safehtml.apt;

import com.google.common.primitives.Primitives;
import com.google.gwt.codegen.server.SourceWriter;
import com.google.gwt.safecss.shared.SafeStyles;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import org.gwtproject.safehtml.apt.HtmlTemplateParser;
import org.gwtproject.safehtml.apt.ParsedHtmlTemplate;
import org.gwtproject.safehtml.apt.UnableToCompleteException;
import org.gwtproject.safehtml.shared.OnlyToBeUsedInGeneratedCodeStringBlessedAsSafeHtml;
import org.gwtproject.safehtml.shared.SafeHtml;
import org.gwtproject.safehtml.shared.SafeHtmlUtils;
import org.gwtproject.safehtml.shared.SafeUri;
import org.gwtproject.safehtml.shared.UriUtils;

public class SafeHtmlTemplatesImplMethodCreator {
    private static final String JAVA_LANG_STRING_FQCN = String.class.getName();
    private static final String SAFE_URI_CN = SafeUri.class.getSimpleName();
    private static final String SAFE_URI_FQCN = SafeUri.class.getName();
    private static final String SAFE_STYLES_CN = SafeStyles.class.getSimpleName();
    private static final String SAFE_STYLES_FQCN = SafeStyles.class.getName();
    private static final String SAFE_HTML_CN = SafeHtml.class.getSimpleName();
    private static final String SAFE_HTML_FQCN = SafeHtml.class.getName();
    private static final String BLESSED_STRING_FQCN = OnlyToBeUsedInGeneratedCodeStringBlessedAsSafeHtml.class.getName();
    private static final String SAFE_HTML_UTILS_FQCN = SafeHtmlUtils.class.getName();
    private static final String URI_UTILS_FQCN = UriUtils.class.getName();
    private final SourceWriter writer;
    private final Messager messager;

    public SafeHtmlTemplatesImplMethodCreator(SourceWriter writer, Messager messager) {
        this.writer = writer;
        this.messager = messager;
    }

    public SourceWriter getWriter() {
        return this.writer;
    }

    public void createMethodFor(String templateString, String[] params) throws UnableToCompleteException {
        this.emitMethodBodyFromTemplate(templateString, params);
    }

    private void emitAttributeContextParameterExpression(ParsedHtmlTemplate.HtmlContext htmlContext, String formalParameterName, String parameterType) {
        String expression = formalParameterName;
        if (this.isSafeUri(parameterType) || this.isSafeStyles(parameterType)) {
            expression = expression + ".asString()";
        } else {
            if (!JAVA_LANG_STRING_FQCN.equals(parameterType)) {
                expression = "String.valueOf(" + expression + ")";
            }
            if (htmlContext.getType() == ParsedHtmlTemplate.HtmlContext.Type.URL_ATTRIBUTE_START || htmlContext.getType() == ParsedHtmlTemplate.HtmlContext.Type.URL_ATTRIBUTE_ENTIRE) {
                expression = URI_UTILS_FQCN + ".sanitizeUri(" + expression + ")";
            }
        }
        expression = SAFE_HTML_UTILS_FQCN + ".htmlEscape(" + expression + ")";
        this.print(expression);
    }

    private void emitMethodBodyFromTemplate(String template, String[] params) throws UnableToCompleteException {
        this.println("StringBuilder sb = new java.lang.StringBuilder();");
        HtmlTemplateParser parser = new HtmlTemplateParser();
        parser.parseTemplate(template);
        for (ParsedHtmlTemplate.TemplateChunk chunk : parser.getParsedTemplate().getChunks()) {
            if (chunk.getKind() == ParsedHtmlTemplate.TemplateChunk.Kind.LITERAL) {
                this.emitStringLiteral(((ParsedHtmlTemplate.LiteralChunk)chunk).getLiteral());
                continue;
            }
            if (chunk.getKind() == ParsedHtmlTemplate.TemplateChunk.Kind.PARAMETER) {
                ParsedHtmlTemplate.ParameterChunk parameterChunk = (ParsedHtmlTemplate.ParameterChunk)chunk;
                int formalParameterIndex = parameterChunk.getParameterIndex();
                if (formalParameterIndex < 0 || formalParameterIndex >= params.length) {
                    throw this.error("Argument " + formalParameterIndex + " beyond range of arguments: " + template);
                }
                String formalParameterName = "arg" + formalParameterIndex;
                String paramType = params[formalParameterIndex];
                this.emitParameterExpression(parameterChunk.getContext(), formalParameterName, paramType);
                continue;
            }
            throw this.error("Unexpected chunk kind in parsed template " + template);
        }
        this.outdent();
        this.outdent();
        this.println("return new " + BLESSED_STRING_FQCN + "(sb.toString());");
    }

    private void emitParameterExpression(ParsedHtmlTemplate.HtmlContext htmlContext, String formalParameterName, String parameterType) throws UnableToCompleteException {
        ParsedHtmlTemplate.HtmlContext.Type contextType = htmlContext.getType();
        if (this.isSafeHtml(parameterType) && ParsedHtmlTemplate.HtmlContext.Type.TEXT != contextType) {
            throw this.error(SAFE_HTML_CN + " used in a non-text context. Did you mean to use " + JAVA_LANG_STRING_FQCN + " or " + SAFE_STYLES_CN + " instead?");
        }
        if (this.isSafeStyles(parameterType) && ParsedHtmlTemplate.HtmlContext.Type.CSS_ATTRIBUTE_START != contextType) {
            if (ParsedHtmlTemplate.HtmlContext.Type.CSS_ATTRIBUTE == contextType) {
                throw this.error(SAFE_STYLES_CN + " cannot be used in the middle of a CSS attribute. It must be used at the start a CSS attribute.");
            }
            throw this.error(SAFE_STYLES_CN + " used in a non-CSS attribute context. Did you mean to use " + JAVA_LANG_STRING_FQCN + " or " + SAFE_HTML_CN + " instead?");
        }
        if (this.isSafeUri(parameterType) && ParsedHtmlTemplate.HtmlContext.Type.URL_ATTRIBUTE_ENTIRE != contextType) {
            if (ParsedHtmlTemplate.HtmlContext.Type.URL_ATTRIBUTE_START == contextType) {
                throw this.error(SAFE_URI_CN + " cannot be used in a URL attribute if it isn't the entire attribute value.");
            }
            throw this.error(SAFE_URI_CN + " can only be used as the entire value of a URL attribute. Did you mean to use " + JAVA_LANG_STRING_FQCN + " or " + SAFE_HTML_CN + " instead?");
        }
        this.print("sb.append(");
        switch (contextType) {
            case CSS: {
                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Template with variable in CSS context: The template code generator cannot guarantee HTML-safety of the template -- please inspect manually");
                this.emitTextContextParameterExpression(formalParameterName, parameterType);
                break;
            }
            case TEXT: {
                this.emitTextContextParameterExpression(formalParameterName, parameterType);
                break;
            }
            case CSS_ATTRIBUTE: 
            case CSS_ATTRIBUTE_START: {
                if (!this.isSafeStyles(parameterType)) {
                    this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Template with variable in CSS attribute context: The template code generator cannot guarantee HTML-safety of the template -- please inspect manually or use " + SAFE_STYLES_CN + " to specify arguments in a CSS attribute context");
                }
                this.emitAttributeContextParameterExpression(htmlContext, formalParameterName, parameterType);
                break;
            }
            case URL_ATTRIBUTE_START: 
            case URL_ATTRIBUTE_ENTIRE: {
                if (!this.isSafeUri(parameterType)) {
                    this.messager.printMessage(Diagnostic.Kind.WARNING, "Template with variable in URL attribute context: The template code generator will sanitize the URL.  Use " + SAFE_URI_CN + " to specify arguments in a URL attribute context that should not be sanitized.");
                }
                this.emitAttributeContextParameterExpression(htmlContext, formalParameterName, parameterType);
                break;
            }
            case ATTRIBUTE_VALUE: {
                this.emitAttributeContextParameterExpression(htmlContext, formalParameterName, parameterType);
                break;
            }
            default: {
                throw this.error("unknown HTML context for formal template parameter " + formalParameterName + ": " + htmlContext);
            }
        }
        this.println(");");
    }

    private void emitStringLiteral(String str) {
        this.print("sb.append(");
        this.print(SafeHtmlTemplatesImplMethodCreator.wrap(str));
        this.println(");");
    }

    private void emitTextContextParameterExpression(String formalParameterName, String parameterType) {
        boolean parameterIsNotStringTyped;
        boolean parameterIsPrimitiveType = this.isPrimitive(parameterType);
        boolean bl = parameterIsNotStringTyped = !JAVA_LANG_STRING_FQCN.equals(parameterType);
        if (this.isSafeHtml(parameterType)) {
            this.print(formalParameterName + ".asString()");
        } else if (parameterIsPrimitiveType) {
            this.print(formalParameterName);
        } else {
            String expression = formalParameterName;
            if (parameterIsNotStringTyped) {
                expression = "String.valueOf(" + expression + ")";
            }
            this.print(SAFE_HTML_UTILS_FQCN + ".htmlEscape(" + expression + ")");
        }
    }

    private boolean isPrimitive(String parameterType) {
        try {
            return Primitives.isWrapperType(Class.forName(parameterType));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isSafeHtml(String parameterType) {
        return parameterType.equals(SAFE_HTML_FQCN);
    }

    private boolean isSafeStyles(String parameterType) {
        return parameterType.equals(SAFE_STYLES_FQCN);
    }

    private boolean isSafeUri(String parameterType) {
        return parameterType.equals(SAFE_URI_FQCN);
    }

    protected static String wrap(String wrapMe) {
        return "\"" + SafeHtmlTemplatesImplMethodCreator.escape(wrapMe) + "\"";
    }

    public static String escape(String unescaped) {
        int extra = 0;
        int n = unescaped.length();
        for (int in = 0; in < n; ++in) {
            switch (unescaped.charAt(in)) {
                case '\u0000': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': {
                    ++extra;
                }
            }
        }
        if (extra == 0) {
            return unescaped;
        }
        char[] oldChars = unescaped.toCharArray();
        char[] newChars = new char[oldChars.length + extra];
        int in = 0;
        int out = 0;
        int n2 = oldChars.length;
        while (in < n2) {
            int c = oldChars[in];
            switch (c) {
                case 0: {
                    newChars[out++] = 92;
                    c = 48;
                    break;
                }
                case 10: {
                    newChars[out++] = 92;
                    c = 110;
                    break;
                }
                case 13: {
                    newChars[out++] = 92;
                    c = 114;
                    break;
                }
                case 34: {
                    newChars[out++] = 92;
                    c = 34;
                    break;
                }
                case 92: {
                    newChars[out++] = 92;
                    c = 92;
                }
            }
            newChars[out] = c;
            ++in;
            ++out;
        }
        return String.valueOf(newChars);
    }

    protected UnableToCompleteException error(String msg) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg);
        return new UnableToCompleteException();
    }

    protected UnableToCompleteException error(String msg, Throwable cause) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg + ": " + cause.getMessage());
        return new UnableToCompleteException();
    }

    protected UnableToCompleteException error(Throwable e) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage() + ": " + e.getMessage());
        return new UnableToCompleteException();
    }

    public void println(Object printMe) {
        this.getWriter().println(printMe.toString());
    }

    protected void indent() {
        this.getWriter().indent();
    }

    protected void outdent() {
        this.getWriter().outdent();
    }

    protected void print(String printMe) {
        this.getWriter().print(printMe);
    }
}

