/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.safehtml.apt;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

final class ParsedHtmlTemplate {
    private final LinkedList<TemplateChunk> chunks = new LinkedList();

    public void addLiteral(String literal) {
        if (this.chunks.isEmpty() || this.chunks.getLast().getKind() != TemplateChunk.Kind.LITERAL) {
            this.chunks.add(new LiteralChunk(literal));
        } else {
            ((LiteralChunk)this.chunks.getLast()).append(literal);
        }
    }

    public void addParameter(ParameterChunk chunk) {
        this.chunks.add(chunk);
    }

    public List<TemplateChunk> getChunks() {
        return Collections.unmodifiableList(this.chunks);
    }

    public String toString() {
        return this.chunks.toString();
    }

    static interface TemplateChunk {
        public Kind getKind();

        public static enum Kind {
            LITERAL,
            PARAMETER;

        }
    }

    static final class ParameterChunk
    implements TemplateChunk {
        private final HtmlContext context;
        private final int parameterIndex;

        public ParameterChunk(HtmlContext context, int parameterIndex) {
            this.context = context;
            this.parameterIndex = parameterIndex;
        }

        public HtmlContext getContext() {
            return this.context;
        }

        @Override
        public TemplateChunk.Kind getKind() {
            return TemplateChunk.Kind.PARAMETER;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public String toString() {
            return String.format("P(%s,%d)", this.getContext(), this.getParameterIndex());
        }
    }

    static final class LiteralChunk
    implements TemplateChunk {
        private final StringBuilder chunk;

        public LiteralChunk() {
            this.chunk = new StringBuilder();
        }

        public LiteralChunk(String literal) {
            this.chunk = new StringBuilder(literal);
        }

        @Override
        public TemplateChunk.Kind getKind() {
            return TemplateChunk.Kind.LITERAL;
        }

        public String getLiteral() {
            return this.chunk.toString();
        }

        public String toString() {
            return String.format("L(%s)", this.getLiteral());
        }

        void append(String s) {
            this.chunk.append(s);
        }
    }

    static final class HtmlContext {
        private final Type type;
        private final String tag;
        private final String attribute;

        public HtmlContext(Type type) {
            this(type, null, null);
        }

        public HtmlContext(Type type, String tag, String attribute) {
            Preconditions.checkArgument((type != Type.TEXT || tag == null && attribute == null ? 1 : 0) != 0, (Object)"tag and attribute must be null for context \"TEXT\"");
            this.type = type;
            this.tag = tag;
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public String getTag() {
            return this.tag;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return "(" + (Object)((Object)this.getType()) + "," + this.getTag() + "," + this.getAttribute() + ")";
        }

        static enum Type {
            TEXT,
            ATTRIBUTE_VALUE,
            URL_ATTRIBUTE_START,
            URL_ATTRIBUTE_ENTIRE,
            CSS,
            CSS_ATTRIBUTE,
            CSS_ATTRIBUTE_START;

        }
    }
}

