/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.safehtml.apt;

import com.squareup.javapoet.ClassName;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.gwtproject.safehtml.apt.SafeApiPackage;
import org.gwtproject.safehtml.apt.SafeHtmlTemplatesImplMethodCreator;
import org.gwtproject.safehtml.apt.UnableToCompleteException;
import org.gwtproject.safehtml.apt.source.AbortablePrintWriter;
import org.gwtproject.safehtml.apt.source.JavaSourceWriterBuilder;
import org.gwtproject.safehtml.apt.source.SourceWriter;

@SupportedAnnotationTypes(value={"org.gwtproject.safehtml.client.SafeHtmlTemplates.Template", "com.google.gwt.safehtml.client.SafeHtmlTemplates.Template"})
public class SafeHtmlProcessor
extends AbstractProcessor {
    public static final String TEMPLATE_ANNOTATION_NAME = "org.gwtproject.safehtml.client.SafeHtmlTemplates.Template";
    public static final String OLD_TEMPLATE_ANNOTATION_NAME = "com.google.gwt.safehtml.client.SafeHtmlTemplates.Template";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager messager = this.processingEnv.getMessager();
        T types = new T();
        HashSet templateTypes = new HashSet();
        templateTypes.addAll(roundEnv.getElementsAnnotatedWith(this.processingEnv.getElementUtils().getTypeElement(TEMPLATE_ANNOTATION_NAME)).stream().map(Element::getEnclosingElement).map(TypeElement.class::cast).collect(Collectors.toSet()));
        TypeElement oldTemplateAnnotationName = this.processingEnv.getElementUtils().getTypeElement(OLD_TEMPLATE_ANNOTATION_NAME);
        if (oldTemplateAnnotationName != null) {
            templateTypes.addAll(roundEnv.getElementsAnnotatedWith(oldTemplateAnnotationName).stream().map(Element::getEnclosingElement).map(TypeElement.class::cast).collect(Collectors.toSet()));
        }
        for (TypeElement templateType : templateTypes) {
            try {
                String packageName = this.processingEnv.getElementUtils().getPackageOf(templateType).getQualifiedName().toString();
                String className = templateType.getQualifiedName().toString().substring(packageName.length() + 1).replace('.', '_') + "Impl";
                JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(packageName + "." + className, new Element[0]);
                AbortablePrintWriter writer = new AbortablePrintWriter(new PrintWriter(jfo.openWriter()));
                JavaSourceWriterBuilder writerBuilder = new JavaSourceWriterBuilder(writer, packageName, className);
                writerBuilder.setJavaDocCommentForClass("This class is generated from " + templateType.getQualifiedName().toString() + ", do not edit manually");
                writerBuilder.addImplementedInterface(templateType.getQualifiedName().toString());
                SourceWriter sourceWriter = writerBuilder.createSourceWriter();
                for (Element element : templateType.getEnclosedElements()) {
                    SafeApiPackage api;
                    String templateString;
                    ExecutableElement method;
                    if (!(element instanceof ExecutableElement) || (method = (ExecutableElement)element).isDefault() || types.isSameType(method.getEnclosingElement().asType(), types.jlObject)) continue;
                    AnnotationMirror template = this.getAnnotationWithName(method, TEMPLATE_ANNOTATION_NAME);
                    AnnotationMirror templateOld = this.getAnnotationWithName(method, OLD_TEMPLATE_ANNOTATION_NAME);
                    if (template == null && templateOld == null) {
                        messager.printMessage(Diagnostic.Kind.ERROR, "SafeHtmlTemplates method is missing @Template annotation", method);
                        continue;
                    }
                    if (template != null && templateOld != null) {
                        messager.printMessage(Diagnostic.Kind.ERROR, "Cannot use both old and new template", method);
                        continue;
                    }
                    if (templateOld != null) {
                        messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Using old @Template, please update to new", method);
                        templateString = templateOld.getElementValues().values().iterator().next().getValue().toString();
                        api = SafeApiPackage.COM_GOOGLE_GWT_SAFEHTML;
                    } else {
                        templateString = template.getElementValues().values().iterator().next().getValue().toString();
                        api = SafeApiPackage.ORG_GWTPROJECT_SAFEHTML;
                    }
                    if (!types.isSameType(method.getReturnType(), this.processingEnv.getElementUtils().getTypeElement(api.getSafeHtmlInterfaceFQN()).asType())) {
                        messager.printMessage(Diagnostic.Kind.ERROR, "SafeHtmlTemplates method must return SafeHtml", method);
                        continue;
                    }
                    sourceWriter.beginJavaDocComment();
                    sourceWriter.print("@Template(");
                    sourceWriter.print("\"" + SafeHtmlProcessor.escape(templateString) + "\"");
                    sourceWriter.print(")");
                    sourceWriter.endJavaDocComment();
                    this.printMethodDecl(sourceWriter, method);
                    sourceWriter.println(" {");
                    sourceWriter.indent();
                    SafeHtmlTemplatesImplMethodCreator methodCreator = new SafeHtmlTemplatesImplMethodCreator(sourceWriter, messager, api);
                    methodCreator.createMethodFor(templateString, method);
                    sourceWriter.outdent();
                    sourceWriter.println("}");
                    sourceWriter.println();
                }
                sourceWriter.close();
            }
            catch (IOException | UnableToCompleteException e) {
                messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage(), templateType);
                e.printStackTrace();
            }
        }
        return true;
    }

    private AnnotationMirror getAnnotationWithName(ExecutableElement elt, String name) {
        return elt.getAnnotationMirrors().stream().filter(a -> name.equals(ClassName.get((TypeMirror)a.getAnnotationType()).toString())).findAny().orElse(null);
    }

    private void printMethodDecl(SourceWriter sourceWriter, ExecutableElement method) {
        sourceWriter.println("public " + method.getReturnType().toString() + " " + method.getSimpleName() + "(");
        sourceWriter.indent();
        sourceWriter.indent();
        sourceWriter.indent();
        boolean first = true;
        List<? extends VariableElement> parameters = method.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement variableElement = parameters.get(i);
            if (first) {
                first = false;
            } else {
                sourceWriter.println(", ");
            }
            sourceWriter.print(variableElement.asType().toString() + " arg" + i);
        }
        sourceWriter.outdent();
        sourceWriter.outdent();
        sourceWriter.outdent();
        sourceWriter.print(")");
    }

    public static String escape(String string) {
        return SafeHtmlTemplatesImplMethodCreator.escape(string);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private class T {
        DeclaredType jlObject;

        private T() {
            this.jlObject = (DeclaredType)SafeHtmlProcessor.this.processingEnv.getElementUtils().getTypeElement(Object.class.getCanonicalName()).asType();
        }

        boolean isSameType(TypeMirror t1, TypeMirror t2) {
            return SafeHtmlProcessor.this.processingEnv.getTypeUtils().isSameType(t1, t2);
        }
    }
}

