/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.safehtml.apt.source;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gwtproject.safehtml.apt.source.AbortablePrintWriter;
import org.gwtproject.safehtml.apt.source.SourceWriterBase;

public class JavaSourceWriter
extends SourceWriterBase {
    private static final Pattern PKG_REGEX_BOTH = Pattern.compile("(com\\.google|javax?)\\..*");
    private static final Pattern PKG_REGEX_GOOGLE = Pattern.compile("com\\.google\\..*");
    private static final Pattern PKG_REGEX_JAVA = Pattern.compile("javax?\\..*");
    private final AbortablePrintWriter printWriter;

    public JavaSourceWriter(AbortablePrintWriter printWriter, String targetPackageName, Iterable<String> imports, boolean isClass, String classJavaDocComment, Iterable<String> annotationDeclarations, String targetClassShortName, String superClassName, Iterable<String> interfaceNames) {
        this.printWriter = printWriter;
        if (targetPackageName == null) {
            throw new IllegalArgumentException("Cannot supply a null package name to" + targetClassShortName);
        }
        if (targetPackageName.length() > 0) {
            this.println("package " + targetPackageName + ";");
        }
        this.writeImportGroup(imports, PKG_REGEX_GOOGLE, true);
        this.writeImportGroup(imports, PKG_REGEX_BOTH, false);
        this.writeImportGroup(imports, PKG_REGEX_JAVA, true);
        if (classJavaDocComment != null) {
            this.beginJavaDocComment();
            this.print(classJavaDocComment);
            this.endJavaDocComment();
        } else {
            this.println();
        }
        for (String annotation : annotationDeclarations) {
            this.println('@' + annotation);
        }
        if (isClass) {
            this.emitClassDecl(targetClassShortName, superClassName, interfaceNames);
        } else {
            this.emitInterfaceDecl(targetClassShortName, superClassName, interfaceNames);
        }
        this.println(" {");
        this.indent();
    }

    @Override
    public void abort() {
        this.printWriter.abort();
    }

    @Override
    public void close() {
        super.close();
        this.printWriter.close();
    }

    @Override
    protected void writeString(String s) {
        this.printWriter.print(s);
    }

    private void emitClassDecl(String targetClassShortName, String superClassName, Iterable<String> interfaceNames) {
        this.print("public class " + targetClassShortName);
        if (superClassName != null) {
            this.print(" extends " + superClassName);
        }
        boolean first = true;
        for (String interfaceName : interfaceNames) {
            if (first) {
                this.print(" implements ");
                first = false;
            } else {
                this.print(", ");
            }
            this.print(interfaceName);
        }
    }

    private void emitInterfaceDecl(String targetClassShortName, String superClassName, Iterable<String> interfaceNames) {
        if (superClassName != null) {
            throw new IllegalArgumentException("Cannot set superclass name " + superClassName + " on a interface.");
        }
        this.print("public interface " + targetClassShortName);
        boolean first = true;
        for (String interfaceName : interfaceNames) {
            if (first) {
                this.print(" extends ");
                first = false;
            } else {
                this.print(", ");
            }
            this.print(interfaceName);
        }
    }

    private void writeImportGroup(Iterable<String> imports, Pattern regex, boolean includeMatches) {
        boolean firstOfGroup = true;
        for (String importEntry : imports) {
            Matcher matcher = regex.matcher(importEntry);
            if (matcher.matches() != includeMatches) continue;
            if (firstOfGroup) {
                this.println();
                firstOfGroup = false;
            }
            this.println("import " + importEntry + ";");
        }
    }
}

