/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.safehtml.apt;

import com.google.common.primitives.Primitives;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.gwtproject.safehtml.apt.HtmlTemplateParser;
import org.gwtproject.safehtml.apt.ParsedHtmlTemplate;
import org.gwtproject.safehtml.apt.SafeApiPackage;
import org.gwtproject.safehtml.apt.UnableToCompleteException;
import org.gwtproject.safehtml.apt.source.SourceWriter;

public class SafeHtmlTemplatesImplMethodCreator {
    private static final String JAVA_LANG_STRING_FQCN = String.class.getName();
    private final SourceWriter writer;
    private final Messager messager;
    private final SafeApiPackage api;

    public SafeHtmlTemplatesImplMethodCreator(SourceWriter writer, Messager messager, SafeApiPackage api) {
        this.writer = writer;
        this.messager = messager;
        this.api = api;
    }

    public SourceWriter getWriter() {
        return this.writer;
    }

    public void createMethodFor(String templateString, ExecutableElement method) throws UnableToCompleteException {
        this.emitMethodBodyFromTemplate(templateString, this.getParamTypes(method), method);
    }

    private String[] getParamTypes(ExecutableElement method) {
        String[] params = new String[method.getParameters().size()];
        int i = 0;
        for (VariableElement variableElement : method.getParameters()) {
            params[i++] = variableElement.asType().toString();
        }
        return params;
    }

    private void emitAttributeContextParameterExpression(ParsedHtmlTemplate.HtmlContext htmlContext, String formalParameterName, String parameterType) {
        String expression = formalParameterName;
        if (this.isSafeUri(parameterType) || this.isSafeStyles(parameterType)) {
            expression = expression + ".asString()";
        } else {
            if (!JAVA_LANG_STRING_FQCN.equals(parameterType)) {
                expression = "String.valueOf(" + expression + ")";
            }
            if (htmlContext.getType() == ParsedHtmlTemplate.HtmlContext.Type.URL_ATTRIBUTE_START || htmlContext.getType() == ParsedHtmlTemplate.HtmlContext.Type.URL_ATTRIBUTE_ENTIRE) {
                expression = this.api.getUriUtilsFqn() + ".sanitizeUri(" + expression + ")";
            }
        }
        expression = this.api.getSafeHtmlUtilsFQN() + ".htmlEscape(" + expression + ")";
        this.print(expression);
    }

    private void emitMethodBodyFromTemplate(String template, String[] params, ExecutableElement method) throws UnableToCompleteException {
        this.println("StringBuilder sb = new java.lang.StringBuilder();");
        HtmlTemplateParser parser = new HtmlTemplateParser();
        parser.parseTemplate(template);
        for (ParsedHtmlTemplate.TemplateChunk chunk : parser.getParsedTemplate().getChunks()) {
            if (chunk.getKind() == ParsedHtmlTemplate.TemplateChunk.Kind.LITERAL) {
                this.emitStringLiteral(((ParsedHtmlTemplate.LiteralChunk)chunk).getLiteral());
                continue;
            }
            if (chunk.getKind() == ParsedHtmlTemplate.TemplateChunk.Kind.PARAMETER) {
                ParsedHtmlTemplate.ParameterChunk parameterChunk = (ParsedHtmlTemplate.ParameterChunk)chunk;
                int formalParameterIndex = parameterChunk.getParameterIndex();
                if (formalParameterIndex < 0 || formalParameterIndex >= params.length) {
                    throw this.error("Argument " + formalParameterIndex + " beyond range of arguments: " + template, (Element)method);
                }
                String formalParameterName = "arg" + formalParameterIndex;
                String paramType = params[formalParameterIndex];
                this.emitParameterExpression(parameterChunk.getContext(), formalParameterName, paramType, method);
                continue;
            }
            throw this.error("Unexpected chunk kind in parsed template " + template, (Element)method);
        }
        this.outdent();
        this.outdent();
        this.println("return new " + this.api.getBlessedStringFQN() + "(sb.toString());");
    }

    private void emitParameterExpression(ParsedHtmlTemplate.HtmlContext htmlContext, String formalParameterName, String parameterType, ExecutableElement method) throws UnableToCompleteException {
        ParsedHtmlTemplate.HtmlContext.Type contextType = htmlContext.getType();
        if (this.isSafeHtml(parameterType) && ParsedHtmlTemplate.HtmlContext.Type.TEXT != contextType) {
            throw this.error(this.api.getSafeHtmlInterfaceFQN() + " used in a non-text context. Did you mean to use " + JAVA_LANG_STRING_FQCN + " or " + this.api.getSafeStylesInterfaceFQN() + " instead?", (Element)method);
        }
        if (this.isSafeStyles(parameterType) && ParsedHtmlTemplate.HtmlContext.Type.CSS_ATTRIBUTE_START != contextType) {
            if (ParsedHtmlTemplate.HtmlContext.Type.CSS_ATTRIBUTE == contextType) {
                throw this.error(this.api.getSafeStylesInterfaceFQN() + " cannot be used in the middle of a CSS attribute. It must be used at the start a CSS attribute.", (Element)method);
            }
            throw this.error(this.api.getSafeStylesInterfaceFQN() + " used in a non-CSS attribute context. Did you mean to use " + JAVA_LANG_STRING_FQCN + " or " + this.api.getSafeHtmlInterfaceFQN() + " instead?", (Element)method);
        }
        if (this.isSafeUri(parameterType) && ParsedHtmlTemplate.HtmlContext.Type.URL_ATTRIBUTE_ENTIRE != contextType) {
            if (ParsedHtmlTemplate.HtmlContext.Type.URL_ATTRIBUTE_START == contextType) {
                throw this.error(this.api.getSafeUriInterfaceFQN() + " cannot be used in a URL attribute if it isn't the entire attribute value.", (Element)method);
            }
            throw this.error(this.api.getSafeUriInterfaceFQN() + " can only be used as the entire value of a URL attribute. Did you mean to use " + JAVA_LANG_STRING_FQCN + " or " + this.api.getSafeHtmlInterfaceFQN() + " instead?", (Element)method);
        }
        this.print("sb.append(");
        switch (contextType) {
            case CSS: {
                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Template with variable in CSS context: The template code generator cannot guarantee HTML-safety of the template -- please inspect manually", method);
                this.emitTextContextParameterExpression(formalParameterName, parameterType);
                break;
            }
            case TEXT: {
                this.emitTextContextParameterExpression(formalParameterName, parameterType);
                break;
            }
            case CSS_ATTRIBUTE: 
            case CSS_ATTRIBUTE_START: {
                if (!this.isSafeStyles(parameterType)) {
                    this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Template with variable in CSS attribute context: The template code generator cannot guarantee HTML-safety of the template -- please inspect manually or use " + this.api.getSafeStylesInterfaceFQN() + " to specify arguments in a CSS attribute context", method);
                }
                this.emitAttributeContextParameterExpression(htmlContext, formalParameterName, parameterType);
                break;
            }
            case URL_ATTRIBUTE_START: 
            case URL_ATTRIBUTE_ENTIRE: {
                if (!this.isSafeUri(parameterType)) {
                    this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Template with variable in URL attribute context: The template code generator will sanitize the URL.  Use " + this.api.getSafeUriInterfaceFQN() + " to specify arguments in a URL attribute context that should not be sanitized.", method);
                }
                this.emitAttributeContextParameterExpression(htmlContext, formalParameterName, parameterType);
                break;
            }
            case ATTRIBUTE_VALUE: {
                this.emitAttributeContextParameterExpression(htmlContext, formalParameterName, parameterType);
                break;
            }
            default: {
                throw this.error("unknown HTML context for formal template parameter " + formalParameterName + ": " + htmlContext, (Element)method);
            }
        }
        this.println(");");
    }

    private void emitStringLiteral(String str) {
        this.print("sb.append(");
        this.print(SafeHtmlTemplatesImplMethodCreator.wrap(str));
        this.println(");");
    }

    private void emitTextContextParameterExpression(String formalParameterName, String parameterType) {
        boolean parameterIsNotStringTyped;
        boolean parameterIsPrimitiveType = this.isPrimitive(parameterType);
        boolean bl = parameterIsNotStringTyped = !JAVA_LANG_STRING_FQCN.equals(parameterType);
        if (this.isSafeHtml(parameterType)) {
            this.print(formalParameterName + ".asString()");
        } else if (parameterIsPrimitiveType) {
            this.print(formalParameterName);
        } else {
            String expression = formalParameterName;
            if (parameterIsNotStringTyped) {
                expression = "String.valueOf(" + expression + ")";
            }
            this.print(this.api.getSafeHtmlUtilsFQN() + ".htmlEscape(" + expression + ")");
        }
    }

    private boolean isPrimitive(String parameterType) {
        try {
            return Primitives.isWrapperType(Class.forName(parameterType));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isSafeHtml(String parameterType) {
        return parameterType.equals(this.api.getSafeHtmlInterfaceFQN());
    }

    private boolean isSafeStyles(String parameterType) {
        return parameterType.equals(this.api.getSafeStylesInterfaceFQN());
    }

    private boolean isSafeUri(String parameterType) {
        return parameterType.equals(this.api.getSafeUriInterfaceFQN());
    }

    protected static String wrap(String wrapMe) {
        return "\"" + SafeHtmlTemplatesImplMethodCreator.escape(wrapMe) + "\"";
    }

    public static String escape(String unescaped) {
        int extra = 0;
        int n = unescaped.length();
        for (int in = 0; in < n; ++in) {
            switch (unescaped.charAt(in)) {
                case '\u0000': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': {
                    ++extra;
                }
            }
        }
        if (extra == 0) {
            return unescaped;
        }
        char[] oldChars = unescaped.toCharArray();
        char[] newChars = new char[oldChars.length + extra];
        int in = 0;
        int out = 0;
        int n2 = oldChars.length;
        while (in < n2) {
            int c = oldChars[in];
            switch (c) {
                case 0: {
                    newChars[out++] = 92;
                    c = 48;
                    break;
                }
                case 10: {
                    newChars[out++] = 92;
                    c = 110;
                    break;
                }
                case 13: {
                    newChars[out++] = 92;
                    c = 114;
                    break;
                }
                case 34: {
                    newChars[out++] = 92;
                    c = 34;
                    break;
                }
                case 92: {
                    newChars[out++] = 92;
                    c = 92;
                }
            }
            newChars[out] = c;
            ++in;
            ++out;
        }
        return String.valueOf(newChars);
    }

    protected UnableToCompleteException error(String msg, Element elt) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg, elt);
        return new UnableToCompleteException();
    }

    protected UnableToCompleteException error(String msg, Throwable cause, Element elt) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg + ": " + cause.getMessage(), elt);
        return new UnableToCompleteException();
    }

    protected UnableToCompleteException error(Throwable e, Element elt) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage() + ": " + e.getMessage(), elt);
        return new UnableToCompleteException();
    }

    public void println(Object printMe) {
        this.getWriter().println(printMe.toString());
    }

    protected void indent() {
        this.getWriter().indent();
    }

    protected void outdent() {
        this.getWriter().outdent();
    }

    protected void print(String printMe) {
        this.getWriter().print(printMe);
    }
}

