/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.ical.iter;

import java.util.BitSet;

final class IntSet {
    BitSet ints = new BitSet();

    IntSet() {
    }

    void add(int n) {
        this.ints.set(this.encode(n));
    }

    int encode(int n) {
        return n < 0 ? (-n << 1) + 1 : n << 1;
    }

    int decode(int i) {
        return (i >>> 1) * (-(i & 1) | 1);
    }

    boolean contains(int n) {
        return this.ints.get(this.encode(n));
    }

    int size() {
        return this.ints.cardinality();
    }

    int[] toIntArray() {
        int[] out = new int[this.ints.cardinality()];
        int a = 0;
        int b = out.length;
        int i = -1;
        while ((i = this.ints.nextSetBit(i + 1)) >= 0) {
            int n = this.decode(i);
            if (n < 0) {
                out[a++] = n;
                continue;
            }
            out[--b] = n;
        }
        IntSet.reverse(out, 0, a);
        IntSet.reverse(out, a, out.length);
        return out;
    }

    private static void reverse(int[] arr, int s, int e) {
        int j = e;
        for (int i = s; i < --j; ++i) {
            int t = arr[i];
            arr[i] = arr[j];
            arr[j] = t;
        }
    }
}

