/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.ical.values;

import org.jresearch.ical.util.TimeUtils;
import org.jresearch.ical.values.DateValue;

public enum Weekday {
    SU(0),
    MO(1),
    TU(2),
    WE(3),
    TH(4),
    FR(5),
    SA(6);

    public final int jsDayNum;
    public final int javaDayNum;
    private static Weekday[] VALUES;

    private Weekday(int wDayNum) {
        this.jsDayNum = wDayNum;
        this.javaDayNum = 1 + wDayNum;
    }

    public static Weekday valueOf(DateValue dv) {
        int dayIndex = TimeUtils.fixedFromGregorian(dv.year(), dv.month(), dv.day()) % 7;
        if (dayIndex < 0) {
            dayIndex += 7;
        }
        return VALUES[dayIndex];
    }

    public static Weekday firstDayOfWeekInMonth(int year, int month) {
        int result = TimeUtils.fixedFromGregorian(year, month, 1) % 7;
        return VALUES[result >= 0 ? result : result + 7];
    }

    public Weekday successor() {
        return VALUES[(this.ordinal() + 1) % 7];
    }

    public Weekday predecessor() {
        return VALUES[(this.ordinal() - 1 + 7) % 7];
    }

    static {
        VALUES = new Weekday[7];
        System.arraycopy(Weekday.values(), 0, VALUES, 0, 7);
    }
}

