/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.ical.compat.jodatime;

import java.text.ParseException;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.jresearch.ical.compat.jodatime.LocalDateIterable;
import org.jresearch.ical.compat.jodatime.LocalDateIterator;
import org.jresearch.ical.compat.jodatime.TimeZoneConverter;
import org.jresearch.ical.iter.RecurrenceIterable;
import org.jresearch.ical.iter.RecurrenceIterator;
import org.jresearch.ical.iter.RecurrenceIteratorFactory;
import org.jresearch.ical.values.DateValue;
import org.jresearch.ical.values.DateValueImpl;

public class LocalDateIteratorFactory {
    public static LocalDateIterator createLocalDateIterator(String rdata, LocalDate start, DateTimeZone tzid, boolean strict) throws ParseException {
        return new RecurrenceIteratorWrapper(RecurrenceIteratorFactory.createRecurrenceIterator(rdata, LocalDateIteratorFactory.localDateToDateValue(start), TimeZoneConverter.toTimeZone(tzid), strict));
    }

    public static LocalDateIterator createLocalDateIterator(String rdata, LocalDate start, boolean strict) throws ParseException {
        return LocalDateIteratorFactory.createLocalDateIterator(rdata, start, DateTimeZone.UTC, strict);
    }

    public static LocalDateIterable createLocalDateIterable(String rdata, LocalDate start, DateTimeZone tzid, boolean strict) throws ParseException {
        return new RecurrenceIterableWrapper(RecurrenceIteratorFactory.createRecurrenceIterable(rdata, LocalDateIteratorFactory.localDateToDateValue(start), TimeZoneConverter.toTimeZone(tzid), strict));
    }

    public static LocalDateIterable createLocalDateIterable(String rdata, LocalDate start, boolean strict) throws ParseException {
        return LocalDateIteratorFactory.createLocalDateIterable(rdata, start, DateTimeZone.UTC, strict);
    }

    public static LocalDateIterator createLocalDateIterator(RecurrenceIterator rit) {
        return new RecurrenceIteratorWrapper(rit);
    }

    static LocalDate dateValueToLocalDate(DateValue dvUtc) {
        return new LocalDate(dvUtc.year(), dvUtc.month(), dvUtc.day());
    }

    static DateValue localDateToDateValue(LocalDate date) {
        return new DateValueImpl(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth());
    }

    private LocalDateIteratorFactory() {
    }

    private static final class RecurrenceIteratorWrapper
    implements LocalDateIterator {
        private final RecurrenceIterator it;

        RecurrenceIteratorWrapper(RecurrenceIterator it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public LocalDate next() {
            return LocalDateIteratorFactory.dateValueToLocalDate(this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void advanceTo(LocalDate d) {
            this.it.advanceTo(LocalDateIteratorFactory.localDateToDateValue(d));
        }
    }

    private static final class RecurrenceIterableWrapper
    implements LocalDateIterable {
        private final RecurrenceIterable it;

        public RecurrenceIterableWrapper(RecurrenceIterable it) {
            this.it = it;
        }

        @Override
        public LocalDateIterator iterator() {
            return new RecurrenceIteratorWrapper(this.it.iterator());
        }
    }
}

