/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.ical.iter;

import java.util.Comparator;
import org.jresearch.ical.iter.DateValueComparison;
import org.jresearch.ical.iter.RecurrenceIterator;
import org.jresearch.ical.values.DateValue;

final class HeapElement {
    final boolean inclusion;
    private long comparable;
    private DateValue head;
    private RecurrenceIterator it;
    static Comparator<HeapElement> CMP = new Comparator<HeapElement>(){

        @Override
        public int compare(HeapElement a, HeapElement b) {
            long bc;
            long ac = a.comparable();
            return ac < (bc = b.comparable()) ? -1 : (ac == bc ? 0 : 1);
        }
    };

    HeapElement(boolean inclusion, RecurrenceIterator it) {
        this.inclusion = inclusion;
        this.it = it;
    }

    DateValue head() {
        return this.head;
    }

    long comparable() {
        return this.comparable;
    }

    boolean shift() {
        if (!this.it.hasNext()) {
            return false;
        }
        this.head = this.it.next();
        this.comparable = DateValueComparison.comparable(this.head);
        return true;
    }

    void advanceTo(DateValue dvUtc) {
        this.it.advanceTo(dvUtc);
    }

    public String toString() {
        return "[" + this.head.toString() + (this.inclusion ? ", inclusion]" : ", exclusion]");
    }
}

