/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.ical.values;

import org.jresearch.ical.util.TimeUtils;
import org.jresearch.ical.values.DateValue;
import org.jresearch.ical.values.PeriodValue;
import org.jresearch.ical.values.TimeValue;

public class PeriodValueImpl
implements PeriodValue {
    private DateValue start;
    private DateValue end;

    public static PeriodValue create(DateValue start, DateValue end) {
        return new PeriodValueImpl(start, end);
    }

    public static PeriodValue createFromDuration(DateValue start, DateValue dur) {
        DateValue end = TimeUtils.add(start, dur);
        if (end instanceof TimeValue && !(start instanceof TimeValue)) {
            start = TimeUtils.dayStart(start);
        }
        return new PeriodValueImpl(start, end);
    }

    protected PeriodValueImpl(DateValue start, DateValue end) {
        if (start.compareTo(end) > 0) {
            throw new IllegalArgumentException("Start (" + start + ") must precede end (" + end + ")");
        }
        if (start instanceof TimeValue ^ end instanceof TimeValue) {
            throw new IllegalArgumentException("Start (" + start + ") and end (" + end + ") must both have times or neither have times.");
        }
        this.start = start;
        this.end = end;
    }

    @Override
    public DateValue start() {
        return this.start;
    }

    @Override
    public DateValue end() {
        return this.end;
    }

    @Override
    public boolean intersects(PeriodValue pv) {
        DateValue sa = this.start;
        DateValue ea = this.end;
        DateValue sb = pv.start();
        DateValue eb = pv.end();
        return sa.compareTo(eb) < 0 && sb.compareTo(ea) < 0;
    }

    @Override
    public boolean contains(PeriodValue pv) {
        DateValue sa = this.start;
        DateValue ea = this.end;
        DateValue sb = pv.start();
        DateValue eb = pv.end();
        return sb.compareTo(sa) >= 0 && ea.compareTo(eb) >= 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PeriodValue)) {
            return false;
        }
        PeriodValue that = (PeriodValue)o;
        return this.start().equals(that.start()) && this.end().equals(that.end());
    }

    public int hashCode() {
        return this.start.hashCode() ^ 31 * this.end.hashCode();
    }

    public String toString() {
        return this.start().toString() + "/" + this.end().toString();
    }
}

