/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.ical.iter;

import org.jresearch.ical.iter.IntSet;
import org.jresearch.ical.util.DTBuilder;
import org.jresearch.ical.values.DateValue;
import org.jresearch.ical.values.Weekday;
import org.jresearch.ical.values.WeekdayNum;

class Util {
    static void rollToNextWeekStart(DTBuilder builder, Weekday wkst) {
        DateValue bd = builder.toDate();
        builder.day += (7 - (7 + (Weekday.valueOf((DateValue)bd).javaDayNum - wkst.javaDayNum)) % 7) % 7;
        builder.normalize();
    }

    static DateValue nextWeekStart(DateValue d, Weekday wkst) {
        DTBuilder builder = new DTBuilder(d);
        builder.day += (7 - (7 + (Weekday.valueOf((DateValue)d).javaDayNum - wkst.javaDayNum)) % 7) % 7;
        return builder.toDate();
    }

    static int[] uniquify(int[] ints) {
        return Util.uniquify(ints, 0, ints.length);
    }

    static int[] uniquify(int[] ints, int start, int end) {
        IntSet iset = new IntSet();
        int i = end;
        while (--i >= start) {
            iset.add(ints[i]);
        }
        return iset.toIntArray();
    }

    static int dayNumToDate(Weekday dow0, int nDays, int weekNum, Weekday dow, int d0, int nDaysInMonth) {
        int date;
        int firstDateOfGivenDow = 1 + (7 + dow.javaDayNum - dow0.javaDayNum) % 7;
        if (weekNum > 0) {
            date = (weekNum - 1) * 7 + firstDateOfGivenDow - d0;
        } else {
            int lastDateOfGivenDow = firstDateOfGivenDow + 378;
            lastDateOfGivenDow -= 7 * ((lastDateOfGivenDow - nDays + 6) / 7);
            date = lastDateOfGivenDow + 7 * (weekNum + 1) - d0;
        }
        if (date <= 0 || date > nDaysInMonth) {
            return 0;
        }
        return date;
    }

    static int invertWeekdayNum(WeekdayNum weekdayNum, Weekday dow0, int nDays) {
        assert (weekdayNum.num < 0);
        return Util.countInPeriod(weekdayNum.wday, dow0, nDays) + weekdayNum.num + 1;
    }

    static int countInPeriod(Weekday dow, Weekday dow0, int nDays) {
        if (dow.javaDayNum >= dow0.javaDayNum) {
            return 1 + (nDays - (dow.javaDayNum - dow0.javaDayNum) - 1) / 7;
        }
        return 1 + (nDays - (7 - (dow0.javaDayNum - dow.javaDayNum)) - 1) / 7;
    }

    private Util() {
    }
}

