/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.ical.compat.javautil;

import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.jresearch.ical.compat.javautil.DateIterable;
import org.jresearch.ical.compat.javautil.DateIterator;
import org.jresearch.ical.iter.RecurrenceIterable;
import org.jresearch.ical.iter.RecurrenceIterator;
import org.jresearch.ical.iter.RecurrenceIteratorFactory;
import org.jresearch.ical.util.TimeUtils;
import org.jresearch.ical.values.DateTimeValueImpl;
import org.jresearch.ical.values.DateValue;
import org.jresearch.ical.values.DateValueImpl;
import org.jresearch.ical.values.TimeValue;

public class DateIteratorFactory {
    public static DateIterator createDateIterator(String rdata, Date start, TimeZone tzid, boolean strict) throws ParseException {
        return new RecurrenceIteratorWrapper(RecurrenceIteratorFactory.createRecurrenceIterator(rdata, DateIteratorFactory.dateToDateValue(start, true), tzid, strict));
    }

    public static DateIterable createDateIterable(String rdata, Date start, TimeZone tzid, boolean strict) throws ParseException {
        return new RecurrenceIterableWrapper(RecurrenceIteratorFactory.createRecurrenceIterable(rdata, DateIteratorFactory.dateToDateValue(start, true), tzid, strict));
    }

    public static DateIterator createDateIterator(RecurrenceIterator rit) {
        return new RecurrenceIteratorWrapper(rit);
    }

    static Date dateValueToDate(DateValue dvUtc) {
        GregorianCalendar c = new GregorianCalendar(TimeUtils.utcTimezone());
        c.clear();
        if (dvUtc instanceof TimeValue) {
            TimeValue tvUtc = (TimeValue)((Object)dvUtc);
            c.set(dvUtc.year(), dvUtc.month() - 1, dvUtc.day(), tvUtc.hour(), tvUtc.minute(), tvUtc.second());
        } else {
            c.set(dvUtc.year(), dvUtc.month() - 1, dvUtc.day(), 0, 0, 0);
        }
        return c.getTime();
    }

    static DateValue dateToDateValue(Date date, boolean midnightAsDate) {
        GregorianCalendar c = new GregorianCalendar(TimeUtils.utcTimezone());
        c.setTime(date);
        int h = c.get(11);
        int m = c.get(12);
        int s = c.get(13);
        if (midnightAsDate && 0 == (h | m | s)) {
            return new DateValueImpl(c.get(1), c.get(2) + 1, c.get(5));
        }
        return new DateTimeValueImpl(c.get(1), c.get(2) + 1, c.get(5), h, m, s);
    }

    private DateIteratorFactory() {
    }

    private static final class RecurrenceIteratorWrapper
    implements DateIterator {
        private final RecurrenceIterator it;

        RecurrenceIteratorWrapper(RecurrenceIterator it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Date next() {
            return DateIteratorFactory.dateValueToDate(this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void advanceTo(Date d) {
            this.it.advanceTo(DateIteratorFactory.dateToDateValue(d, true));
        }
    }

    private static final class RecurrenceIterableWrapper
    implements DateIterable {
        private final RecurrenceIterable it;

        public RecurrenceIterableWrapper(RecurrenceIterable it) {
            this.it = it;
        }

        @Override
        public DateIterator iterator() {
            return new RecurrenceIteratorWrapper(this.it.iterator());
        }
    }
}

