/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.ical.iter;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.jresearch.ical.iter.DateValueComparison;
import org.jresearch.ical.iter.HeapElement;
import org.jresearch.ical.iter.RecurrenceIterator;
import org.jresearch.ical.values.DateValue;

final class CompoundIteratorImpl
implements RecurrenceIterator {
    private PriorityQueue<HeapElement> queue;
    private HeapElement pending;
    private int nInclusionsRemaining;

    CompoundIteratorImpl(Collection<RecurrenceIterator> inclusions, Collection<RecurrenceIterator> exclusions) {
        HeapElement el;
        this.queue = new PriorityQueue<HeapElement>(inclusions.size() + exclusions.size(), HeapElement.CMP);
        for (RecurrenceIterator it : inclusions) {
            el = new HeapElement(true, it);
            if (!el.shift()) continue;
            this.queue.add(el);
            ++this.nInclusionsRemaining;
        }
        for (RecurrenceIterator it : exclusions) {
            el = new HeapElement(false, it);
            if (!el.shift()) continue;
            this.queue.add(el);
        }
    }

    @Override
    public boolean hasNext() {
        this.requirePending();
        return null != this.pending;
    }

    @Override
    public DateValue next() {
        this.requirePending();
        if (null == this.pending) {
            throw new NoSuchElementException();
        }
        DateValue head = this.pending.head();
        this.reattach(this.pending);
        this.pending = null;
        return head;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void advanceTo(DateValue newStart) {
        long newStartCmp = DateValueComparison.comparable(newStart);
        if (null != this.pending) {
            if (this.pending.comparable() >= newStartCmp) {
                return;
            }
            this.pending.advanceTo(newStart);
            this.reattach(this.pending);
            this.pending = null;
        }
        while (0 != this.nInclusionsRemaining && !this.queue.isEmpty() && this.queue.peek().comparable() < newStartCmp) {
            HeapElement el = this.queue.poll();
            el.advanceTo(newStart);
            this.reattach(el);
        }
    }

    private void reattach(HeapElement el) {
        if (el.shift()) {
            this.queue.add(el);
        } else if (el.inclusion && 0 == --this.nInclusionsRemaining) {
            this.queue.clear();
        }
    }

    private void requirePending() {
        if (null != this.pending) {
            return;
        }
        long exclusionComparable = Long.MIN_VALUE;
        while (0 != this.nInclusionsRemaining && !this.queue.isEmpty()) {
            boolean excluded;
            HeapElement inclusion = null;
            do {
                HeapElement candidate = this.queue.poll();
                if (candidate.inclusion) {
                    if (exclusionComparable != candidate.comparable()) {
                        inclusion = candidate;
                        break;
                    }
                } else {
                    exclusionComparable = candidate.comparable();
                }
                this.reattach(candidate);
                if (0 != this.nInclusionsRemaining) continue;
                return;
            } while (!this.queue.isEmpty());
            if (inclusion == null) {
                return;
            }
            long inclusionComparable = inclusion.comparable();
            boolean bl = excluded = exclusionComparable == inclusionComparable;
            while (!this.queue.isEmpty() && this.queue.peek().comparable() == inclusionComparable) {
                HeapElement match = this.queue.poll();
                excluded |= !match.inclusion;
                this.reattach(match);
                if (0 != this.nInclusionsRemaining) continue;
                return;
            }
            if (!excluded) {
                this.pending = inclusion;
                return;
            }
            this.reattach(inclusion);
        }
    }
}

