package org.jresearch.gwt.time.apt.data.client;

import static org.jresearch.gwt.time.apt.base.Chrono.*;
import static org.jresearch.gwt.time.apt.data.client.ImmutablePatternCoordinates.*;

import java.lang.String;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PatternInfo {
	public static final Map<String, PatternCoordinates[]> DATE_FULL_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> DATE_LONG_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> DATE_MEDIUM_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> DATE_SHORT_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> DATE_TIME_FULL_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> DATE_TIME_LONG_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> DATE_TIME_MEDIUM_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> DATE_TIME_SHORT_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> TIME_FULL_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> TIME_LONG_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> TIME_MEDIUM_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> TIME_SHORT_PATTERNS = new HashMap<>();

	static {
		DATE_FULL_PATTERNS.put("EEEE d MMMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("br")),
				of(JAPANESE, Locale.forLanguageTag("br")),
				of(MINGUO, Locale.forLanguageTag("br")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fr")),
				of(JAPANESE, Locale.forLanguageTag("fr")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fy")),
				of(JAPANESE, Locale.forLanguageTag("fy")),
				of(MINGUO, Locale.forLanguageTag("fy")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ga")),
				of(JAPANESE, Locale.forLanguageTag("it")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("nl")),
				of(JAPANESE, Locale.forLanguageTag("nl")),
				of(MINGUO, Locale.forLanguageTag("nl")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("sv")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d 'ta'’ MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("mt")),
				});
		DATE_FULL_PATTERNS.put("EEEE d MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af-NA")),
				of(ISO, Locale.forLanguageTag("agq")),
				of(ISO, Locale.forLanguageTag("bas")),
				of(ISO, Locale.forLanguageTag("bm")),
				of(ISO, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("dje")),
				of(ISO, Locale.forLanguageTag("dua")),
				of(ISO, Locale.forLanguageTag("dyo")),
				of(ISO, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("en-IE")),
				of(ISO, Locale.forLanguageTag("en-MV")),
				of(ISO, Locale.forLanguageTag("ewo")),
				of(ISO, Locale.forLanguageTag("fa")),
				of(ISO, Locale.forLanguageTag("ff")),
				of(ISO, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("fr-CA")),
				of(ISO, Locale.forLanguageTag("fy")),
				of(ISO, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("it")),
				of(ISO, Locale.forLanguageTag("kab")),
				of(ISO, Locale.forLanguageTag("khq")),
				of(ISO, Locale.forLanguageTag("km")),
				of(ISO, Locale.forLanguageTag("kok")),
				of(ISO, Locale.forLanguageTag("ksf")),
				of(ISO, Locale.forLanguageTag("kw")),
				of(ISO, Locale.forLanguageTag("ln")),
				of(ISO, Locale.forLanguageTag("lu")),
				of(ISO, Locale.forLanguageTag("mfe")),
				of(ISO, Locale.forLanguageTag("mg")),
				of(ISO, Locale.forLanguageTag("mua")),
				of(ISO, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("nmg")),
				of(ISO, Locale.forLanguageTag("nus")),
				of(ISO, Locale.forLanguageTag("rn")),
				of(ISO, Locale.forLanguageTag("se-FI")),
				of(ISO, Locale.forLanguageTag("ses")),
				of(ISO, Locale.forLanguageTag("sg")),
				of(ISO, Locale.forLanguageTag("shi")),
				of(ISO, Locale.forLanguageTag("shi-Latn")),
				of(ISO, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("to")),
				of(ISO, Locale.forLanguageTag("twq")),
				of(ISO, Locale.forLanguageTag("yav")),
				of(ISO, Locale.forLanguageTag("zgh")),
				});
		DATE_FULL_PATTERNS.put("y MMMMའི་ཚེས་d, EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bo")),
				});
		DATE_FULL_PATTERNS.put("dd MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ms-BN")),
				});
		DATE_FULL_PATTERNS.put("Gy年M月d日 EEEE", new PatternCoordinates[] {
				of(MINGUO, Locale.forLanguageTag("yue")),
				of(MINGUO, Locale.forLanguageTag("zh-Hant")),
				});
		DATE_FULL_PATTERNS.put("EEEE, སྤྱི་ལོ་y MMMM ཚེས་dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("dz")),
				});
		DATE_FULL_PATTERNS.put("y 'ж'. d MMMM, EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("kk")),
				});
		DATE_FULL_PATTERNS.put("d MMMM y, EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("az")),
				of(ISO, Locale.forLanguageTag("az-Cyrl")),
				of(ISO, Locale.forLanguageTag("brx")),
				});
		DATE_FULL_PATTERNS.put("d MMMM y EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("tk")),
				of(ISO, Locale.forLanguageTag("tr")),
				});
		DATE_FULL_PATTERNS.put("EEEE, dd MMMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("ca")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("id")),
				of(JAPANESE, Locale.forLanguageTag("id")),
				of(MINGUO, Locale.forLanguageTag("id")),
				});
		DATE_FULL_PATTERNS.put("y年M月d日EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ja")),
				of(ISO, Locale.forLanguageTag("yue-Hans")),
				of(ISO, Locale.forLanguageTag("zh")),
				of(ISO, Locale.forLanguageTag("zh-Hant-HK")),
				});
		DATE_FULL_PATTERNS.put("EEEEที่ d MMMM ปีGที่ y", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("th")),
				of(MINGUO, Locale.forLanguageTag("th")),
				});
		DATE_FULL_PATTERNS.put("y 'оны' MMMM'ын' d, EEEE 'гараг'", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("mn")),
				});
		DATE_FULL_PATTERNS.put("EEEE d MMMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ha")),
				});
		DATE_FULL_PATTERNS.put("EEEE, dd MMMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ka")),
				of(ISO, Locale.forLanguageTag("uz-Cyrl")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d'mh' MMMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("gd")),
				of(JAPANESE, Locale.forLanguageTag("gd")),
				of(MINGUO, Locale.forLanguageTag("gd")),
				});
		DATE_FULL_PATTERNS.put("EEEE d MMMM 'de' y G", new PatternCoordinates[] {
				of(MINGUO, Locale.forLanguageTag("ca")),
				});
		DATE_FULL_PATTERNS.put("EEEE d MMMM⹁ y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ff-Adlm")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d MMMM y 'р'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("uk")),
				});
		DATE_FULL_PATTERNS.put("EEEE، d MMMM، y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ur")),
				});
		DATE_FULL_PATTERNS.put("y թ. MMMM d, EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("hy")),
				});
		DATE_FULL_PATTERNS.put("y 'сыл' MMMM d 'күнэ', EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("sah")),
				});
		DATE_FULL_PATTERNS.put("Gy年M月d日EEEE", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ja")),
				of(MINGUO, Locale.forLanguageTag("ja")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("yue")),
				of(JAPANESE, Locale.forLanguageTag("yue")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("yue-Hans")),
				of(JAPANESE, Locale.forLanguageTag("yue-Hans")),
				of(MINGUO, Locale.forLanguageTag("yue-Hans")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh")),
				of(JAPANESE, Locale.forLanguageTag("zh")),
				of(MINGUO, Locale.forLanguageTag("zh")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh-Hant")),
				of(JAPANESE, Locale.forLanguageTag("zh-Hant")),
				});
		DATE_FULL_PATTERNS.put("y年M月d日 EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yue")),
				of(ISO, Locale.forLanguageTag("zh-Hant")),
				});
		DATE_FULL_PATTERNS.put("cccc, MMMM d. y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("smn")),
				});
		DATE_FULL_PATTERNS.put("EEEE d. MMMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("cs")),
				of(MINGUO, Locale.forLanguageTag("cs")),
				of(JAPANESE, Locale.forLanguageTag("da")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("gsw")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("no")),
				of(JAPANESE, Locale.forLanguageTag("no")),
				of(MINGUO, Locale.forLanguageTag("no")),
				});
		DATE_FULL_PATTERNS.put("EEEE d MMMM⹁ y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ff-Adlm")),
				});
		DATE_FULL_PATTERNS.put("EEEE, dd MMMM y 'г'. G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("mk")),
				});
		DATE_FULL_PATTERNS.put("EEEE, dd. MMMM y.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bs-Cyrl")),
				});
		DATE_FULL_PATTERNS.put("EEEE, MMMM dd 'lia', G y", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ee")),
				of(MINGUO, Locale.forLanguageTag("ee")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d. MMMM y.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bs")),
				of(ISO, Locale.forLanguageTag("hr")),
				of(ISO, Locale.forLanguageTag("sr")),
				of(ISO, Locale.forLanguageTag("sr-Latn")),
				});
		DATE_FULL_PATTERNS.put("y, MMMM d, EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ml")),
				});
		DATE_FULL_PATTERNS.put("EEEE፣ d MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ti")),
				});
		DATE_FULL_PATTERNS.put("cccc d. MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fi")),
				});
		DATE_FULL_PATTERNS.put("EEEE 'le' d 'de' MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ia")),
				});
		DATE_FULL_PATTERNS.put("G y. MMMM d., EEEE", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("hu")),
				});
		DATE_FULL_PATTERNS.put("EEEE dd MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af")),
				of(ISO, Locale.forLanguageTag("gv")),
				of(ISO, Locale.forLanguageTag("kkj")),
				of(ISO, Locale.forLanguageTag("kl")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d. MMMM y. G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("hr")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d MMMM y 'ҫ'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("cv")),
				});
		DATE_FULL_PATTERNS.put("y MMMM d, EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("ckb")),
				of(ISO, Locale.forLanguageTag("ii")),
				of(ISO, Locale.forLanguageTag("lrc")),
				of(ISO, Locale.forLanguageTag("ne")),
				of(ISO, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("rw")),
				of(ISO, Locale.forLanguageTag("se")),
				of(ISO, Locale.forLanguageTag("si")),
				of(ISO, Locale.forLanguageTag("sn")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d MMMM, y 'аз'", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("os")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d-MMMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("uz")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d-'a' 'de' MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("eo")),
				});
		DATE_FULL_PATTERNS.put("EEEE د y د MMMM d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ps")),
				});
		DATE_FULL_PATTERNS.put("EEEE, MMMM d 'lia' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ee")),
				});
		DATE_FULL_PATTERNS.put("EEEE, dd MMMM 'de' y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("ast")),
				of(MINGUO, Locale.forLanguageTag("ast")),
				});
		DATE_FULL_PATTERNS.put("EEEE، d MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ar")),
				});
		DATE_FULL_PATTERNS.put("y('e')'ko' MMMM'ren' d('a'), EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("eu")),
				});
		DATE_FULL_PATTERNS.put("d, MMMM y, EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("te")),
				});
		DATE_FULL_PATTERNS.put("G y MMMM d, EEEE", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("")),
				of(HIJRAH_UMALQURA, Locale.forLanguageTag("")),
				of(JAPANESE, Locale.forLanguageTag("")),
				of(MINGUO, Locale.forLanguageTag("")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d 'de' MMMM 'de' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("es")),
				of(ISO, Locale.forLanguageTag("es-419")),
				of(ISO, Locale.forLanguageTag("es-MX")),
				of(ISO, Locale.forLanguageTag("es-US")),
				of(ISO, Locale.forLanguageTag("gl")),
				of(ISO, Locale.forLanguageTag("oc-ES")),
				of(ISO, Locale.forLanguageTag("pt")),
				of(ISO, Locale.forLanguageTag("pt-PT")),
				of(ISO, Locale.forLanguageTag("seh")),
				});
		DATE_FULL_PATTERNS.put("EEEE, 'dä' d. MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ksh")),
				});
		DATE_FULL_PATTERNS.put("EEEE, dטן MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yi")),
				});
		DATE_FULL_PATTERNS.put("EEEE, y. 'gada' d. MMMM", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("lv")),
				});
		DATE_FULL_PATTERNS.put("y d-MMMM، EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ug")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d MMMM, y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("el")),
				});
		DATE_FULL_PATTERNS.put("y-'ж'., d-MMMM, EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ky")),
				});
		DATE_FULL_PATTERNS.put("EEEE , 'lyɛ'̌ʼ d 'na' MMMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nnh")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d 'di' MMMM 'di' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("kea")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d MMMM 'de' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("ca")),
				});
		DATE_FULL_PATTERNS.put("EEEE, y MMMM dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ak")),
				of(ISO, Locale.forLanguageTag("jgo")),
				of(ISO, Locale.forLanguageTag("mgo")),
				});
		DATE_FULL_PATTERNS.put("EEEE, 'ngày' dd MMMM 'năm' y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("vi")),
				of(JAPANESE, Locale.forLanguageTag("vi")),
				of(MINGUO, Locale.forLanguageTag("vi")),
				});
		DATE_FULL_PATTERNS.put("cccc d. MMMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("fi")),
				of(JAPANESE, Locale.forLanguageTag("fi")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d MMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yo")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d. MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("de")),
				of(ISO, Locale.forLanguageTag("dsb")),
				of(ISO, Locale.forLanguageTag("et")),
				of(ISO, Locale.forLanguageTag("fo")),
				of(ISO, Locale.forLanguageTag("frr")),
				of(ISO, Locale.forLanguageTag("gsw")),
				of(ISO, Locale.forLanguageTag("hsb")),
				of(ISO, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("lb")),
				of(ISO, Locale.forLanguageTag("sl")),
				of(ISO, Locale.forLanguageTag("wae")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d, MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("doi")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d 'ne' MMMM, y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("kgp")),
				});
		DATE_FULL_PATTERNS.put("EEEE ທີ d MMMM G y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("lo")),
				});
		DATE_FULL_PATTERNS.put("EEEE, MMMM d، y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ug")),
				});
		DATE_FULL_PATTERNS.put("EEEE d 'de' MMMM 'de' 'su' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("sc")),
				});
		DATE_FULL_PATTERNS.put("y년 M월 d일 EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ko")),
				});
		DATE_FULL_PATTERNS.put("EEEE, 'de' d. MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nds")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d'mh' MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("gd")),
				});
		DATE_FULL_PATTERNS.put("y 'm'. MMMM d 'd'., EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("lt")),
				});
		DATE_FULL_PATTERNS.put("EEEE d. MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("nn")),
				of(ISO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("sk")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("asa")),
				of(ISO, Locale.forLanguageTag("bem")),
				of(ISO, Locale.forLanguageTag("bez")),
				of(ISO, Locale.forLanguageTag("cgg")),
				of(ISO, Locale.forLanguageTag("cy")),
				of(ISO, Locale.forLanguageTag("dav")),
				of(ISO, Locale.forLanguageTag("ebu")),
				of(ISO, Locale.forLanguageTag("en-001")),
				of(ISO, Locale.forLanguageTag("en-AE")),
				of(ISO, Locale.forLanguageTag("en-AU")),
				of(ISO, Locale.forLanguageTag("en-GB")),
				of(ISO, Locale.forLanguageTag("fr-CH")),
				of(ISO, Locale.forLanguageTag("guz")),
				of(ISO, Locale.forLanguageTag("haw")),
				of(ISO, Locale.forLanguageTag("hi")),
				of(ISO, Locale.forLanguageTag("ig")),
				of(ISO, Locale.forLanguageTag("it-CH")),
				of(ISO, Locale.forLanguageTag("jmc")),
				of(ISO, Locale.forLanguageTag("jv")),
				of(ISO, Locale.forLanguageTag("kam")),
				of(ISO, Locale.forLanguageTag("kde")),
				of(ISO, Locale.forLanguageTag("ki")),
				of(ISO, Locale.forLanguageTag("kln")),
				of(ISO, Locale.forLanguageTag("ks-Deva")),
				of(ISO, Locale.forLanguageTag("ksb")),
				of(ISO, Locale.forLanguageTag("lag")),
				of(ISO, Locale.forLanguageTag("lg")),
				of(ISO, Locale.forLanguageTag("luo")),
				of(ISO, Locale.forLanguageTag("luy")),
				of(ISO, Locale.forLanguageTag("mai")),
				of(ISO, Locale.forLanguageTag("mas")),
				of(ISO, Locale.forLanguageTag("mer")),
				of(ISO, Locale.forLanguageTag("mgh")),
				of(ISO, Locale.forLanguageTag("mi")),
				of(ISO, Locale.forLanguageTag("mk")),
				of(ISO, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("naq")),
				of(ISO, Locale.forLanguageTag("nd")),
				of(ISO, Locale.forLanguageTag("nyn")),
				of(ISO, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pcm")),
				of(ISO, Locale.forLanguageTag("pl")),
				of(ISO, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("rof")),
				of(ISO, Locale.forLanguageTag("rwk")),
				of(ISO, Locale.forLanguageTag("sa")),
				of(ISO, Locale.forLanguageTag("saq")),
				of(ISO, Locale.forLanguageTag("sat")),
				of(ISO, Locale.forLanguageTag("sbp")),
				of(ISO, Locale.forLanguageTag("sq")),
				of(ISO, Locale.forLanguageTag("su")),
				of(ISO, Locale.forLanguageTag("sw")),
				of(ISO, Locale.forLanguageTag("sw-KE")),
				of(ISO, Locale.forLanguageTag("teo")),
				of(ISO, Locale.forLanguageTag("tzm")),
				of(ISO, Locale.forLanguageTag("vai")),
				of(ISO, Locale.forLanguageTag("vai-Latn")),
				of(ISO, Locale.forLanguageTag("vun")),
				of(ISO, Locale.forLanguageTag("xog")),
				of(ISO, Locale.forLanguageTag("yrl")),
				of(ISO, Locale.forLanguageTag("yrl-CO")),
				of(ISO, Locale.forLanguageTag("yrl-VE")),
				});
		DATE_FULL_PATTERNS.put("GGGGy年M月d日EEEE", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("ja")),
				});
		DATE_FULL_PATTERNS.put("EEEE dd 'de' MMMM 'de' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("es-HN")),
				});
		DATE_FULL_PATTERNS.put("EEEE, MMMM d, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ceb")),
				of(ISO, Locale.forLanguageTag("chr")),
				of(ISO, Locale.forLanguageTag("en")),
				of(ISO, Locale.forLanguageTag("en-CA")),
				of(ISO, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("kn")),
				of(ISO, Locale.forLanguageTag("ks")),
				of(ISO, Locale.forLanguageTag("lkt")),
				of(ISO, Locale.forLanguageTag("om")),
				of(ISO, Locale.forLanguageTag("or")),
				of(ISO, Locale.forLanguageTag("sd")),
				of(ISO, Locale.forLanguageTag("sd-Deva")),
				of(ISO, Locale.forLanguageTag("so")),
				of(ISO, Locale.forLanguageTag("xh")),
				of(ISO, Locale.forLanguageTag("zu")),
				});
		DATE_FULL_PATTERNS.put("y၊ MMMM d၊ EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("my")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d 'ne' MMMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("kgp")),
				});
		DATE_FULL_PATTERNS.put("EEEEที่ d MMMM G y", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("th")),
				of(ISO, Locale.forLanguageTag("th")),
				});
		DATE_FULL_PATTERNS.put("d MMMM y G EEEE", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("tr")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d MMMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("as")),
				of(ISO, Locale.forLanguageTag("bn")),
				of(ISO, Locale.forLanguageTag("ccp")),
				of(ISO, Locale.forLanguageTag("en-IN")),
				of(ISO, Locale.forLanguageTag("gu")),
				of(ISO, Locale.forLanguageTag("hi-Latn")),
				of(ISO, Locale.forLanguageTag("mr")),
				of(ISO, Locale.forLanguageTag("qu")),
				of(ISO, Locale.forLanguageTag("ta")),
				of(ISO, Locale.forLanguageTag("vi")),
				});
		DATE_FULL_PATTERNS.put("d MMMM, y 'ел', EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("tt")),
				});
		DATE_FULL_PATTERNS.put("EEEE, 'ils' d MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("rm")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d בMMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("he")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d MMMM y 'г'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("be-TARASK")),
				of(ISO, Locale.forLanguageTag("bg")),
				of(ISO, Locale.forLanguageTag("ru")),
				});
		DATE_FULL_PATTERNS.put("EEEE, dd MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("en-BW")),
				of(ISO, Locale.forLanguageTag("en-BZ")),
				of(ISO, Locale.forLanguageTag("en-ZA")),
				of(ISO, Locale.forLanguageTag("en-ZW")),
				of(ISO, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("ms-ID")),
				of(ISO, Locale.forLanguageTag("pa-Arab")),
				of(ISO, Locale.forLanguageTag("tg")),
				});
		DATE_FULL_PATTERNS.put("EEEE፣ d MMMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("am")),
				});
		DATE_FULL_PATTERNS.put("EEEE d 'di' MMMM 'dal' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fur")),
				});
		DATE_FULL_PATTERNS.put("EEEE, MMMM d, y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("bs-Cyrl")),
				of(JAPANESE, Locale.forLanguageTag("en")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fil")),
				of(MINGUO, Locale.forLanguageTag("fil")),
				of(JAPANESE, Locale.forLanguageTag("sr")),
				of(JAPANESE, Locale.forLanguageTag("sr-Latn")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d. MMMM y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("cs")),
				of(JAPANESE, Locale.forLanguageTag("de")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("is")),
				of(JAPANESE, Locale.forLanguageTag("is")),
				of(MINGUO, Locale.forLanguageTag("is")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ksh")),
				of(JAPANESE, Locale.forLanguageTag("lb")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d MMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("wo")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d MMMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("be")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("el")),
				of(JAPANESE, Locale.forLanguageTag("ms")),
				of(JAPANESE, Locale.forLanguageTag("pl")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ro")),
				of(JAPANESE, Locale.forLanguageTag("yrl")),
				});
		DATE_FULL_PATTERNS.put("y نچی ییل d نچی MMMM EEEE کونی", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("uz-Arab")),
				});
		DATE_FULL_PATTERNS.put("EEEE 'den' d. MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("da")),
				});
		DATE_FULL_PATTERNS.put("MMMM d, y, EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("mni")),
				});
		DATE_FULL_PATTERNS.put("EEEE, d 'de' MMMM 'de' y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("es")),
				of(JAPANESE, Locale.forLanguageTag("pt")),
				});
		DATE_FULL_PATTERNS.put("y. MMMM d., EEEE", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("hu")),
				});
		DATE_FULL_PATTERNS.put("EEEE d MMMM 'de' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("oc")),
				});
		DATE_LONG_PATTERNS.put("'Ngày' dd 'tháng' M 'năm' y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("vi")),
				});
		DATE_LONG_PATTERNS.put("d نچی MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("uz-Arab")),
				});
		DATE_LONG_PATTERNS.put("d MMMM, y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("el")),
				});
		DATE_LONG_PATTERNS.put("y. 'gada' d. MMMM", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("lv")),
				});
		DATE_LONG_PATTERNS.put("d MMMM, y 'ел'", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("tt")),
				});
		DATE_LONG_PATTERNS.put("dd MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af")),
				of(ISO, Locale.forLanguageTag("en-BW")),
				of(ISO, Locale.forLanguageTag("en-BZ")),
				of(ISO, Locale.forLanguageTag("en-MT")),
				of(ISO, Locale.forLanguageTag("en-ZA")),
				of(ISO, Locale.forLanguageTag("en-ZW")),
				of(ISO, Locale.forLanguageTag("gv")),
				of(ISO, Locale.forLanguageTag("kl")),
				of(ISO, Locale.forLanguageTag("om")),
				of(ISO, Locale.forLanguageTag("tg")),
				});
		DATE_LONG_PATTERNS.put("d-MMMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("uz")),
				});
		DATE_LONG_PATTERNS.put("d, MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("doi")),
				});
		DATE_LONG_PATTERNS.put("d. MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("da")),
				of(ISO, Locale.forLanguageTag("de")),
				of(ISO, Locale.forLanguageTag("dsb")),
				of(ISO, Locale.forLanguageTag("et")),
				of(ISO, Locale.forLanguageTag("fi")),
				of(ISO, Locale.forLanguageTag("fo")),
				of(ISO, Locale.forLanguageTag("frr")),
				of(ISO, Locale.forLanguageTag("gsw")),
				of(ISO, Locale.forLanguageTag("hsb")),
				of(ISO, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("ksh")),
				of(ISO, Locale.forLanguageTag("lb")),
				of(ISO, Locale.forLanguageTag("nds")),
				of(ISO, Locale.forLanguageTag("nn")),
				of(ISO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("sk")),
				of(ISO, Locale.forLanguageTag("sl")),
				of(ISO, Locale.forLanguageTag("wae")),
				});
		DATE_LONG_PATTERNS.put("y年M月d日", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ja")),
				of(ISO, Locale.forLanguageTag("yue")),
				of(ISO, Locale.forLanguageTag("yue-Hans")),
				of(ISO, Locale.forLanguageTag("zh")),
				of(ISO, Locale.forLanguageTag("zh-Hant")),
				of(ISO, Locale.forLanguageTag("zh-Hant-HK")),
				});
		DATE_LONG_PATTERNS.put("d 'ta'’ MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("mt")),
				});
		DATE_LONG_PATTERNS.put("d 'de' MMMM 'de' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("es")),
				of(ISO, Locale.forLanguageTag("es-419")),
				of(ISO, Locale.forLanguageTag("es-MX")),
				of(ISO, Locale.forLanguageTag("es-US")),
				of(ISO, Locale.forLanguageTag("gl")),
				of(ISO, Locale.forLanguageTag("oc-ES")),
				of(ISO, Locale.forLanguageTag("pt")),
				of(ISO, Locale.forLanguageTag("pt-PT")),
				of(ISO, Locale.forLanguageTag("seh")),
				});
		DATE_LONG_PATTERNS.put("d MMMM، y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ur")),
				});
		DATE_LONG_PATTERNS.put("d 'de' MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ia")),
				});
		DATE_LONG_PATTERNS.put("dd MMMM, y թ.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("hy")),
				});
		DATE_LONG_PATTERNS.put("d MMMM 'de' y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("ast")),
				of(MINGUO, Locale.forLanguageTag("ast")),
				of(MINGUO, Locale.forLanguageTag("ca")),
				});
		DATE_LONG_PATTERNS.put("d 'de' MMMM 'de' y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("es")),
				of(JAPANESE, Locale.forLanguageTag("pt")),
				});
		DATE_LONG_PATTERNS.put("د y د MMMM d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ps")),
				});
		DATE_LONG_PATTERNS.put("y-MMMM-dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("eo")),
				});
		DATE_LONG_PATTERNS.put("d בMMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("he")),
				});
		DATE_LONG_PATTERNS.put("MMMM d، y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ug")),
				});
		DATE_LONG_PATTERNS.put("G y MMMM d", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("")),
				of(HIJRAH_UMALQURA, Locale.forLanguageTag("")),
				of(JAPANESE, Locale.forLanguageTag("")),
				of(MINGUO, Locale.forLanguageTag("")),
				});
		DATE_LONG_PATTERNS.put("d MMMM y 'г'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("be-TARASK")),
				of(ISO, Locale.forLanguageTag("bg")),
				of(ISO, Locale.forLanguageTag("ru")),
				});
		DATE_LONG_PATTERNS.put("སྤྱི་ལོ་y MMMMའི་ཚེས་d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bo")),
				});
		DATE_LONG_PATTERNS.put("y 'ж'. d MMMM", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("kk")),
				});
		DATE_LONG_PATTERNS.put("d MMMM, y 'аз'", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("os")),
				});
		DATE_LONG_PATTERNS.put("d MMMM y 'ҫ'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("cv")),
				});
		DATE_LONG_PATTERNS.put("dی MMMMی y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ckb")),
				});
		DATE_LONG_PATTERNS.put("GGGGy年M月d日", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("ja")),
				});
		DATE_LONG_PATTERNS.put("dd. MMMM y.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bs-Cyrl")),
				});
		DATE_LONG_PATTERNS.put("MMMM d 'lia' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ee")),
				});
		DATE_LONG_PATTERNS.put("d 'ne' MMMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("kgp")),
				});
		DATE_LONG_PATTERNS.put("Gy年M月d日", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ja")),
				of(MINGUO, Locale.forLanguageTag("ja")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("yue")),
				of(JAPANESE, Locale.forLanguageTag("yue")),
				of(MINGUO, Locale.forLanguageTag("yue")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("yue-Hans")),
				of(JAPANESE, Locale.forLanguageTag("yue-Hans")),
				of(MINGUO, Locale.forLanguageTag("yue-Hans")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh")),
				of(JAPANESE, Locale.forLanguageTag("zh")),
				of(MINGUO, Locale.forLanguageTag("zh")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh-Hant")),
				of(JAPANESE, Locale.forLanguageTag("zh-Hant")),
				of(MINGUO, Locale.forLanguageTag("zh-Hant")),
				});
		DATE_LONG_PATTERNS.put("སྤྱི་ལོ་y MMMM ཚེས་ dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("dz")),
				});
		DATE_LONG_PATTERNS.put("dטן MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yi")),
				});
		DATE_LONG_PATTERNS.put("y 'm'. MMMM d 'd'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("lt")),
				});
		DATE_LONG_PATTERNS.put("dd MMMM y 'г'. G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("mk")),
				});
		DATE_LONG_PATTERNS.put("y-'ж'., d-MMMM", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ky")),
				});
		DATE_LONG_PATTERNS.put("MMMM d 'lia', G y", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ee")),
				of(MINGUO, Locale.forLanguageTag("ee")),
				});
		DATE_LONG_PATTERNS.put("y 'оны' MMMM'ын' d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("mn")),
				});
		DATE_LONG_PATTERNS.put("d MMMM⹁ y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ff-Adlm")),
				});
		DATE_LONG_PATTERNS.put("G y. MMMM d.", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("hu")),
				});
		DATE_LONG_PATTERNS.put("d-MMMM، y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ug")),
				});
		DATE_LONG_PATTERNS.put("d 'de' MMMM 'de' 'su' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("sc")),
				});
		DATE_LONG_PATTERNS.put("d MMMM⹁ y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ff-Adlm")),
				});
		DATE_LONG_PATTERNS.put("d. MMMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("cs")),
				of(JAPANESE, Locale.forLanguageTag("cs")),
				of(MINGUO, Locale.forLanguageTag("cs")),
				of(JAPANESE, Locale.forLanguageTag("da")),
				of(JAPANESE, Locale.forLanguageTag("de")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fi")),
				of(JAPANESE, Locale.forLanguageTag("fi")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("gsw")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("is")),
				of(JAPANESE, Locale.forLanguageTag("is")),
				of(MINGUO, Locale.forLanguageTag("is")),
				of(JAPANESE, Locale.forLanguageTag("lb")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("no")),
				of(JAPANESE, Locale.forLanguageTag("no")),
				of(MINGUO, Locale.forLanguageTag("no")),
				});
		DATE_LONG_PATTERNS.put("d MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af-NA")),
				of(ISO, Locale.forLanguageTag("agq")),
				of(ISO, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("ar")),
				of(ISO, Locale.forLanguageTag("asa")),
				of(ISO, Locale.forLanguageTag("az")),
				of(ISO, Locale.forLanguageTag("az-Cyrl")),
				of(ISO, Locale.forLanguageTag("bas")),
				of(ISO, Locale.forLanguageTag("bem")),
				of(ISO, Locale.forLanguageTag("bez")),
				of(ISO, Locale.forLanguageTag("bm")),
				of(ISO, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("cgg")),
				of(ISO, Locale.forLanguageTag("cy")),
				of(ISO, Locale.forLanguageTag("dav")),
				of(ISO, Locale.forLanguageTag("dje")),
				of(ISO, Locale.forLanguageTag("dua")),
				of(ISO, Locale.forLanguageTag("dyo")),
				of(ISO, Locale.forLanguageTag("ebu")),
				of(ISO, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("en-001")),
				of(ISO, Locale.forLanguageTag("en-AE")),
				of(ISO, Locale.forLanguageTag("en-AU")),
				of(ISO, Locale.forLanguageTag("en-GB")),
				of(ISO, Locale.forLanguageTag("en-IN")),
				of(ISO, Locale.forLanguageTag("en-MV")),
				of(ISO, Locale.forLanguageTag("ewo")),
				of(ISO, Locale.forLanguageTag("fa")),
				of(ISO, Locale.forLanguageTag("ff")),
				of(ISO, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("fr-CA")),
				of(ISO, Locale.forLanguageTag("fy")),
				of(ISO, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("guz")),
				of(ISO, Locale.forLanguageTag("haw")),
				of(ISO, Locale.forLanguageTag("hi")),
				of(ISO, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("ig")),
				of(ISO, Locale.forLanguageTag("it")),
				of(ISO, Locale.forLanguageTag("jmc")),
				of(ISO, Locale.forLanguageTag("jv")),
				of(ISO, Locale.forLanguageTag("kab")),
				of(ISO, Locale.forLanguageTag("kam")),
				of(ISO, Locale.forLanguageTag("kde")),
				of(ISO, Locale.forLanguageTag("khq")),
				of(ISO, Locale.forLanguageTag("ki")),
				of(ISO, Locale.forLanguageTag("kkj")),
				of(ISO, Locale.forLanguageTag("kln")),
				of(ISO, Locale.forLanguageTag("km")),
				of(ISO, Locale.forLanguageTag("kok")),
				of(ISO, Locale.forLanguageTag("ks-Deva")),
				of(ISO, Locale.forLanguageTag("ksb")),
				of(ISO, Locale.forLanguageTag("ksf")),
				of(ISO, Locale.forLanguageTag("kw")),
				of(ISO, Locale.forLanguageTag("lag")),
				of(ISO, Locale.forLanguageTag("lg")),
				of(ISO, Locale.forLanguageTag("ln")),
				of(ISO, Locale.forLanguageTag("lo")),
				of(ISO, Locale.forLanguageTag("lu")),
				of(ISO, Locale.forLanguageTag("luo")),
				of(ISO, Locale.forLanguageTag("luy")),
				of(ISO, Locale.forLanguageTag("mai")),
				of(ISO, Locale.forLanguageTag("mas")),
				of(ISO, Locale.forLanguageTag("mer")),
				of(ISO, Locale.forLanguageTag("mfe")),
				of(ISO, Locale.forLanguageTag("mg")),
				of(ISO, Locale.forLanguageTag("mgh")),
				of(ISO, Locale.forLanguageTag("mi")),
				of(ISO, Locale.forLanguageTag("mk")),
				of(ISO, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("mua")),
				of(ISO, Locale.forLanguageTag("naq")),
				of(ISO, Locale.forLanguageTag("nd")),
				of(ISO, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("nmg")),
				of(ISO, Locale.forLanguageTag("nus")),
				of(ISO, Locale.forLanguageTag("nyn")),
				of(ISO, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pa-Arab")),
				of(ISO, Locale.forLanguageTag("pcm")),
				of(ISO, Locale.forLanguageTag("pl")),
				of(ISO, Locale.forLanguageTag("qu")),
				of(ISO, Locale.forLanguageTag("rm")),
				of(ISO, Locale.forLanguageTag("rn")),
				of(ISO, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("rof")),
				of(ISO, Locale.forLanguageTag("rwk")),
				of(ISO, Locale.forLanguageTag("sa")),
				of(ISO, Locale.forLanguageTag("saq")),
				of(ISO, Locale.forLanguageTag("sat")),
				of(ISO, Locale.forLanguageTag("sbp")),
				of(ISO, Locale.forLanguageTag("se-FI")),
				of(ISO, Locale.forLanguageTag("ses")),
				of(ISO, Locale.forLanguageTag("sg")),
				of(ISO, Locale.forLanguageTag("shi")),
				of(ISO, Locale.forLanguageTag("shi-Latn")),
				of(ISO, Locale.forLanguageTag("sq")),
				of(ISO, Locale.forLanguageTag("su")),
				of(ISO, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sw")),
				of(ISO, Locale.forLanguageTag("sw-KE")),
				of(ISO, Locale.forLanguageTag("teo")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("th")),
				of(ISO, Locale.forLanguageTag("ti")),
				of(ISO, Locale.forLanguageTag("tk")),
				of(ISO, Locale.forLanguageTag("to")),
				of(ISO, Locale.forLanguageTag("tr")),
				of(ISO, Locale.forLanguageTag("twq")),
				of(ISO, Locale.forLanguageTag("tzm")),
				of(ISO, Locale.forLanguageTag("vai")),
				of(ISO, Locale.forLanguageTag("vai-Latn")),
				of(ISO, Locale.forLanguageTag("vun")),
				of(ISO, Locale.forLanguageTag("xog")),
				of(ISO, Locale.forLanguageTag("yav")),
				of(ISO, Locale.forLanguageTag("yrl")),
				of(ISO, Locale.forLanguageTag("yrl-CO")),
				of(ISO, Locale.forLanguageTag("yrl-VE")),
				of(ISO, Locale.forLanguageTag("zgh")),
				});
		DATE_LONG_PATTERNS.put("d MMMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("am")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("be")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("br")),
				of(JAPANESE, Locale.forLanguageTag("br")),
				of(MINGUO, Locale.forLanguageTag("br")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ca")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("el")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fr")),
				of(JAPANESE, Locale.forLanguageTag("fr")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fy")),
				of(JAPANESE, Locale.forLanguageTag("fy")),
				of(MINGUO, Locale.forLanguageTag("fy")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ga")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("id")),
				of(JAPANESE, Locale.forLanguageTag("id")),
				of(MINGUO, Locale.forLanguageTag("id")),
				of(JAPANESE, Locale.forLanguageTag("ms")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("nl")),
				of(JAPANESE, Locale.forLanguageTag("nl")),
				of(MINGUO, Locale.forLanguageTag("nl")),
				of(JAPANESE, Locale.forLanguageTag("pl")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ro")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("sv")),
				of(JAPANESE, Locale.forLanguageTag("tr")),
				of(JAPANESE, Locale.forLanguageTag("yrl")),
				});
		DATE_LONG_PATTERNS.put("d MMMM G y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("th")),
				});
		DATE_LONG_PATTERNS.put("y၊ MMMM d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("my")),
				});
		DATE_LONG_PATTERNS.put("d 'ne' MMMM, y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("kgp")),
				});
		DATE_LONG_PATTERNS.put("d. MMMM y. G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("hr")),
				});
		DATE_LONG_PATTERNS.put("dd MMMM y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("it")),
				});
		DATE_LONG_PATTERNS.put("d MMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yo")),
				});
		DATE_LONG_PATTERNS.put("dd 'de' MMMM 'de' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("es-HN")),
				});
		DATE_LONG_PATTERNS.put("MMMM d, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ceb")),
				of(ISO, Locale.forLanguageTag("chr")),
				of(ISO, Locale.forLanguageTag("en")),
				of(ISO, Locale.forLanguageTag("en-CA")),
				of(ISO, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("kn")),
				of(ISO, Locale.forLanguageTag("ks")),
				of(ISO, Locale.forLanguageTag("lkt")),
				of(ISO, Locale.forLanguageTag("mni")),
				of(ISO, Locale.forLanguageTag("or")),
				of(ISO, Locale.forLanguageTag("sd-Deva")),
				of(ISO, Locale.forLanguageTag("so")),
				of(ISO, Locale.forLanguageTag("xh")),
				of(ISO, Locale.forLanguageTag("zu")),
				});
		DATE_LONG_PATTERNS.put("y('e')'ko' MMMM'ren' d('a')", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("eu")),
				});
		DATE_LONG_PATTERNS.put("MMMM d. y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("smn")),
				});
		DATE_LONG_PATTERNS.put("d MMMM y 'р'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("uk")),
				});
		DATE_LONG_PATTERNS.put("y, MMMM d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ml")),
				of(ISO, Locale.forLanguageTag("sah")),
				});
		DATE_LONG_PATTERNS.put("d MMMM 'de' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("oc")),
				});
		DATE_LONG_PATTERNS.put("'lyɛ'̌ʼ d 'na' MMMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nnh")),
				});
		DATE_LONG_PATTERNS.put("d MMMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("as")),
				of(ISO, Locale.forLanguageTag("bn")),
				of(ISO, Locale.forLanguageTag("brx")),
				of(ISO, Locale.forLanguageTag("ccp")),
				of(ISO, Locale.forLanguageTag("gu")),
				of(ISO, Locale.forLanguageTag("ha")),
				of(ISO, Locale.forLanguageTag("hi-Latn")),
				of(ISO, Locale.forLanguageTag("ka")),
				of(ISO, Locale.forLanguageTag("mr")),
				of(ISO, Locale.forLanguageTag("ta")),
				of(ISO, Locale.forLanguageTag("te")),
				of(ISO, Locale.forLanguageTag("uz-Cyrl")),
				of(ISO, Locale.forLanguageTag("vi")),
				of(ISO, Locale.forLanguageTag("wo")),
				});
		DATE_LONG_PATTERNS.put("y MMMM d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ak")),
				of(ISO, Locale.forLanguageTag("ii")),
				of(ISO, Locale.forLanguageTag("jgo")),
				of(ISO, Locale.forLanguageTag("lrc")),
				of(ISO, Locale.forLanguageTag("mgo")),
				of(ISO, Locale.forLanguageTag("ne")),
				of(ISO, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("rw")),
				of(ISO, Locale.forLanguageTag("sd")),
				of(ISO, Locale.forLanguageTag("se")),
				of(ISO, Locale.forLanguageTag("si")),
				of(ISO, Locale.forLanguageTag("sn")),
				});
		DATE_LONG_PATTERNS.put("MMMM d, y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("bs-Cyrl")),
				of(JAPANESE, Locale.forLanguageTag("en")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fil")),
				of(MINGUO, Locale.forLanguageTag("fil")),
				of(JAPANESE, Locale.forLanguageTag("sr")),
				of(JAPANESE, Locale.forLanguageTag("sr-Latn")),
				});
		DATE_LONG_PATTERNS.put("y. MMMM d.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("hu")),
				});
		DATE_LONG_PATTERNS.put("d 'di' MMMM 'di' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("kea")),
				});
		DATE_LONG_PATTERNS.put("y년 M월 d일", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ko")),
				});
		DATE_LONG_PATTERNS.put("d. MMMM y.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bs")),
				of(ISO, Locale.forLanguageTag("hr")),
				of(ISO, Locale.forLanguageTag("sr")),
				of(ISO, Locale.forLanguageTag("sr-Latn")),
				});
		DATE_LONG_PATTERNS.put("d 'di' MMMM 'dal' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fur")),
				});
		DATE_LONG_PATTERNS.put("d'mh' MMMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("gd")),
				of(JAPANESE, Locale.forLanguageTag("gd")),
				of(MINGUO, Locale.forLanguageTag("gd")),
				});
		DATE_LONG_PATTERNS.put("d'mh' MMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("gd")),
				});
		DATE_LONG_PATTERNS.put("d MMMM ปีG y", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("th")),
				of(MINGUO, Locale.forLanguageTag("th")),
				});
		DATE_MEDIUM_PATTERNS.put("d. MMM y.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bs")),
				of(ISO, Locale.forLanguageTag("hr")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM, y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("el")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM 'de' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("es-BO")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM, y 'ел'", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("tt")),
				});
		DATE_MEDIUM_PATTERNS.put("d. MMM y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("da")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("gsw")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("no")),
				of(JAPANESE, Locale.forLanguageTag("no")),
				of(MINGUO, Locale.forLanguageTag("no")),
				});
		DATE_MEDIUM_PATTERNS.put("y MMM d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ak")),
				of(ISO, Locale.forLanguageTag("ckb")),
				of(ISO, Locale.forLanguageTag("ii")),
				of(ISO, Locale.forLanguageTag("jgo")),
				of(ISO, Locale.forLanguageTag("lrc")),
				of(ISO, Locale.forLanguageTag("mg")),
				of(ISO, Locale.forLanguageTag("mgo")),
				of(ISO, Locale.forLanguageTag("ne")),
				of(ISO, Locale.forLanguageTag("ps")),
				of(ISO, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("rw")),
				of(ISO, Locale.forLanguageTag("sd")),
				of(ISO, Locale.forLanguageTag("se")),
				of(ISO, Locale.forLanguageTag("si")),
				of(ISO, Locale.forLanguageTag("sn")),
				});
		DATE_MEDIUM_PATTERNS.put("y. M. d.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ko")),
				});
		DATE_MEDIUM_PATTERNS.put("y-MM-dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("lt")),
				});
		DATE_MEDIUM_PATTERNS.put("dd.MM.y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("de")),
				of(JAPANESE, Locale.forLanguageTag("lb")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ro")),
				});
		DATE_MEDIUM_PATTERNS.put("MMM dd, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("gv")),
				});
		DATE_MEDIUM_PATTERNS.put("dd-MM-y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("as")),
				of(ISO, Locale.forLanguageTag("en-MV")),
				of(ISO, Locale.forLanguageTag("es-CL")),
				of(ISO, Locale.forLanguageTag("rm")),
				});
		DATE_MEDIUM_PATTERNS.put("d 'ne' MMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("kgp")),
				});
		DATE_MEDIUM_PATTERNS.put("y. MMM d.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("hu")),
				});
		DATE_MEDIUM_PATTERNS.put("y年M月d日", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yue")),
				of(ISO, Locale.forLanguageTag("yue-Hans")),
				of(ISO, Locale.forLanguageTag("zh")),
				of(ISO, Locale.forLanguageTag("zh-Hant")),
				of(ISO, Locale.forLanguageTag("zh-Hant-HK")),
				});
		DATE_MEDIUM_PATTERNS.put("MMM d, y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("bs-Cyrl")),
				of(JAPANESE, Locale.forLanguageTag("en")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fil")),
				of(MINGUO, Locale.forLanguageTag("fil")),
				of(JAPANESE, Locale.forLanguageTag("sr")),
				of(JAPANESE, Locale.forLanguageTag("sr-Latn")),
				});
		DATE_MEDIUM_PATTERNS.put("dd.MM.y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("de")),
				of(ISO, Locale.forLanguageTag("fo")),
				of(ISO, Locale.forLanguageTag("gsw")),
				});
		DATE_MEDIUM_PATTERNS.put("d.M.y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("dsb")),
				of(ISO, Locale.forLanguageTag("fi")),
				of(ISO, Locale.forLanguageTag("hsb")),
				of(ISO, Locale.forLanguageTag("mk")),
				});
		DATE_MEDIUM_PATTERNS.put("d 'de' MMM 'de' y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("gl")),
				of(ISO, Locale.forLanguageTag("pt")),
				of(ISO, Locale.forLanguageTag("seh")),
				});
		DATE_MEDIUM_PATTERNS.put("dטן MMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yi")),
				});
		DATE_MEDIUM_PATTERNS.put("G y MMM d", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("")),
				of(HIJRAH_UMALQURA, Locale.forLanguageTag("")),
				of(JAPANESE, Locale.forLanguageTag("")),
				of(MINGUO, Locale.forLanguageTag("")),
				});
		DATE_MEDIUM_PATTERNS.put("d. MMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("da")),
				of(ISO, Locale.forLanguageTag("et")),
				of(ISO, Locale.forLanguageTag("frr")),
				of(ISO, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("lb")),
				of(ISO, Locale.forLanguageTag("nds")),
				of(ISO, Locale.forLanguageTag("nn")),
				of(ISO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("sl")),
				of(ISO, Locale.forLanguageTag("wae")),
				});
		DATE_MEDIUM_PATTERNS.put("d. M. y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("cs")),
				of(JAPANESE, Locale.forLanguageTag("cs")),
				of(MINGUO, Locale.forLanguageTag("cs")),
				});
		DATE_MEDIUM_PATTERNS.put("MMM d، y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ug")),
				});
		DATE_MEDIUM_PATTERNS.put("d.MM.y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("be-TARASK")),
				});
		DATE_MEDIUM_PATTERNS.put("dd MMM, y թ.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("hy")),
				});
		DATE_MEDIUM_PATTERNS.put("dd/MM/y GGGGG", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("es")),
				});
		DATE_MEDIUM_PATTERNS.put("d-MMM-y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("kok")),
				});
		DATE_MEDIUM_PATTERNS.put("d 'de' MMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("sc")),
				});
		DATE_MEDIUM_PATTERNS.put("MMM d 'lia', G y", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ee")),
				of(MINGUO, Locale.forLanguageTag("ee")),
				});
		DATE_MEDIUM_PATTERNS.put("d בMMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("he")),
				});
		DATE_MEDIUM_PATTERNS.put("dd.MM.y.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bs-Cyrl")),
				});
		DATE_MEDIUM_PATTERNS.put("dd/MM/y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fur")),
				of(ISO, Locale.forLanguageTag("pt-PT")),
				});
		DATE_MEDIUM_PATTERNS.put("dd MMM y 'аз'", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("os")),
				});
		DATE_MEDIUM_PATTERNS.put("d MM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yo")),
				});
		DATE_MEDIUM_PATTERNS.put("d. M. y.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("sr")),
				of(ISO, Locale.forLanguageTag("sr-Latn")),
				});
		DATE_MEDIUM_PATTERNS.put("Gy年M月d日", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ja")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("yue")),
				of(JAPANESE, Locale.forLanguageTag("yue")),
				of(MINGUO, Locale.forLanguageTag("yue")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("yue-Hans")),
				of(JAPANESE, Locale.forLanguageTag("yue-Hans")),
				of(MINGUO, Locale.forLanguageTag("yue-Hans")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh")),
				of(JAPANESE, Locale.forLanguageTag("zh")),
				of(MINGUO, Locale.forLanguageTag("zh")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh-Hant")),
				of(JAPANESE, Locale.forLanguageTag("zh-Hant")),
				of(MINGUO, Locale.forLanguageTag("zh-Hant")),
				});
		DATE_MEDIUM_PATTERNS.put("dd-MM-y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("vi")),
				});
		DATE_MEDIUM_PATTERNS.put("dd-MMM-y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("en-BZ")),
				of(ISO, Locale.forLanguageTag("en-IN")),
				of(ISO, Locale.forLanguageTag("en-PK")),
				of(ISO, Locale.forLanguageTag("om")),
				of(ISO, Locale.forLanguageTag("so")),
				});
		DATE_MEDIUM_PATTERNS.put("dd MMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af")),
				of(ISO, Locale.forLanguageTag("en-BE")),
				of(ISO, Locale.forLanguageTag("en-BW")),
				of(ISO, Locale.forLanguageTag("en-MT")),
				of(ISO, Locale.forLanguageTag("en-ZA")),
				of(ISO, Locale.forLanguageTag("kl")),
				of(ISO, Locale.forLanguageTag("mt")),
				of(ISO, Locale.forLanguageTag("tg")),
				});
		DATE_MEDIUM_PATTERNS.put("Gy/MM/dd", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("ja")),
				of(MINGUO, Locale.forLanguageTag("ja")),
				});
		DATE_MEDIUM_PATTERNS.put("d/MM/y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("en-NZ")),
				of(ISO, Locale.forLanguageTag("es-CO")),
				of(ISO, Locale.forLanguageTag("es-GT")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM⹁ y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ff-Adlm")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM، y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ur")),
				});
		DATE_MEDIUM_PATTERNS.put("y('e')'ko' MMM d('a')", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("eu")),
				});
		DATE_MEDIUM_PATTERNS.put("dd MMM y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("it")),
				});
		DATE_MEDIUM_PATTERNS.put("y-'ж'., d-MMM", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ky")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM y 'р'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("uk")),
				});
		DATE_MEDIUM_PATTERNS.put("dd/MM/y G", new PatternCoordinates[] {
				of(MINGUO, Locale.forLanguageTag("ca")),
				of(JAPANESE, Locale.forLanguageTag("kgp")),
				of(JAPANESE, Locale.forLanguageTag("ms")),
				of(JAPANESE, Locale.forLanguageTag("pt")),
				of(JAPANESE, Locale.forLanguageTag("yrl")),
				});
		DATE_MEDIUM_PATTERNS.put("MM/dd/y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("es-PA")),
				of(ISO, Locale.forLanguageTag("es-PR")),
				});
		DATE_MEDIUM_PATTERNS.put("y-MMM-dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("eo")),
				});
		DATE_MEDIUM_PATTERNS.put("y, MMM d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ml")),
				of(ISO, Locale.forLanguageTag("sah")),
				});
		DATE_MEDIUM_PATTERNS.put("y ལོའི་MMMཚེས་d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bo")),
				});
		DATE_MEDIUM_PATTERNS.put("G y.MM.dd.", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("hu")),
				});
		DATE_MEDIUM_PATTERNS.put("y/MM/dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ja")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af-NA")),
				of(ISO, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("asa")),
				of(ISO, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("az")),
				of(ISO, Locale.forLanguageTag("az-Cyrl")),
				of(ISO, Locale.forLanguageTag("bem")),
				of(ISO, Locale.forLanguageTag("bez")),
				of(ISO, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("cgg")),
				of(ISO, Locale.forLanguageTag("cy")),
				of(ISO, Locale.forLanguageTag("dav")),
				of(ISO, Locale.forLanguageTag("dua")),
				of(ISO, Locale.forLanguageTag("dyo")),
				of(ISO, Locale.forLanguageTag("ebu")),
				of(ISO, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("en-001")),
				of(ISO, Locale.forLanguageTag("en-AE")),
				of(ISO, Locale.forLanguageTag("en-AU")),
				of(ISO, Locale.forLanguageTag("en-GB")),
				of(ISO, Locale.forLanguageTag("es")),
				of(ISO, Locale.forLanguageTag("es-419")),
				of(ISO, Locale.forLanguageTag("es-MX")),
				of(ISO, Locale.forLanguageTag("es-US")),
				of(ISO, Locale.forLanguageTag("ewo")),
				of(ISO, Locale.forLanguageTag("fa")),
				of(ISO, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("fr-CA")),
				of(ISO, Locale.forLanguageTag("fy")),
				of(ISO, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("gd")),
				of(ISO, Locale.forLanguageTag("guz")),
				of(ISO, Locale.forLanguageTag("haw")),
				of(ISO, Locale.forLanguageTag("hi")),
				of(ISO, Locale.forLanguageTag("ia")),
				of(ISO, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("ig")),
				of(ISO, Locale.forLanguageTag("it")),
				of(ISO, Locale.forLanguageTag("jmc")),
				of(ISO, Locale.forLanguageTag("jv")),
				of(ISO, Locale.forLanguageTag("kam")),
				of(ISO, Locale.forLanguageTag("kde")),
				of(ISO, Locale.forLanguageTag("kea")),
				of(ISO, Locale.forLanguageTag("ki")),
				of(ISO, Locale.forLanguageTag("kkj")),
				of(ISO, Locale.forLanguageTag("kln")),
				of(ISO, Locale.forLanguageTag("km")),
				of(ISO, Locale.forLanguageTag("ks-Deva")),
				of(ISO, Locale.forLanguageTag("ksb")),
				of(ISO, Locale.forLanguageTag("ksf")),
				of(ISO, Locale.forLanguageTag("kw")),
				of(ISO, Locale.forLanguageTag("lag")),
				of(ISO, Locale.forLanguageTag("lg")),
				of(ISO, Locale.forLanguageTag("ln")),
				of(ISO, Locale.forLanguageTag("lo")),
				of(ISO, Locale.forLanguageTag("lu")),
				of(ISO, Locale.forLanguageTag("luo")),
				of(ISO, Locale.forLanguageTag("luy")),
				of(ISO, Locale.forLanguageTag("mai")),
				of(ISO, Locale.forLanguageTag("mas")),
				of(ISO, Locale.forLanguageTag("mer")),
				of(ISO, Locale.forLanguageTag("mgh")),
				of(ISO, Locale.forLanguageTag("mi")),
				of(ISO, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("mua")),
				of(ISO, Locale.forLanguageTag("naq")),
				of(ISO, Locale.forLanguageTag("nd")),
				of(ISO, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("nmg")),
				of(ISO, Locale.forLanguageTag("nus")),
				of(ISO, Locale.forLanguageTag("nyn")),
				of(ISO, Locale.forLanguageTag("oc")),
				of(ISO, Locale.forLanguageTag("oc-ES")),
				of(ISO, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pa-Arab")),
				of(ISO, Locale.forLanguageTag("pcm")),
				of(ISO, Locale.forLanguageTag("pl")),
				of(ISO, Locale.forLanguageTag("qu")),
				of(ISO, Locale.forLanguageTag("rn")),
				of(ISO, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("rof")),
				of(ISO, Locale.forLanguageTag("rwk")),
				of(ISO, Locale.forLanguageTag("sa")),
				of(ISO, Locale.forLanguageTag("saq")),
				of(ISO, Locale.forLanguageTag("sat")),
				of(ISO, Locale.forLanguageTag("sbp")),
				of(ISO, Locale.forLanguageTag("se-FI")),
				of(ISO, Locale.forLanguageTag("sq")),
				of(ISO, Locale.forLanguageTag("su")),
				of(ISO, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sw")),
				of(ISO, Locale.forLanguageTag("sw-KE")),
				of(ISO, Locale.forLanguageTag("teo")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("th")),
				of(ISO, Locale.forLanguageTag("th")),
				of(ISO, Locale.forLanguageTag("ti")),
				of(ISO, Locale.forLanguageTag("tk")),
				of(ISO, Locale.forLanguageTag("to")),
				of(ISO, Locale.forLanguageTag("tr")),
				of(ISO, Locale.forLanguageTag("twq")),
				of(ISO, Locale.forLanguageTag("tzm")),
				of(ISO, Locale.forLanguageTag("uz-Arab")),
				of(ISO, Locale.forLanguageTag("vai")),
				of(ISO, Locale.forLanguageTag("vai-Latn")),
				of(ISO, Locale.forLanguageTag("vun")),
				of(ISO, Locale.forLanguageTag("xog")),
				of(ISO, Locale.forLanguageTag("yav")),
				of(ISO, Locale.forLanguageTag("yrl")),
				of(ISO, Locale.forLanguageTag("yrl-CO")),
				of(ISO, Locale.forLanguageTag("yrl-VE")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("am")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ast")),
				of(MINGUO, Locale.forLanguageTag("ast")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("be")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("br")),
				of(JAPANESE, Locale.forLanguageTag("br")),
				of(MINGUO, Locale.forLanguageTag("br")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ca")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("el")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fr")),
				of(JAPANESE, Locale.forLanguageTag("fr")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fy")),
				of(JAPANESE, Locale.forLanguageTag("fy")),
				of(MINGUO, Locale.forLanguageTag("fy")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ga")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("id")),
				of(JAPANESE, Locale.forLanguageTag("id")),
				of(MINGUO, Locale.forLanguageTag("id")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("nl")),
				of(JAPANESE, Locale.forLanguageTag("nl")),
				of(MINGUO, Locale.forLanguageTag("nl")),
				of(JAPANESE, Locale.forLanguageTag("pl")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("sv")),
				of(JAPANESE, Locale.forLanguageTag("tr")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM G y", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("th")),
				of(MINGUO, Locale.forLanguageTag("th")),
				});
		DATE_MEDIUM_PATTERNS.put("MMM d, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ceb")),
				of(ISO, Locale.forLanguageTag("chr")),
				of(ISO, Locale.forLanguageTag("en")),
				of(ISO, Locale.forLanguageTag("en-CA")),
				of(ISO, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("kn")),
				of(ISO, Locale.forLanguageTag("ks")),
				of(ISO, Locale.forLanguageTag("lkt")),
				of(ISO, Locale.forLanguageTag("mni")),
				of(ISO, Locale.forLanguageTag("or")),
				of(ISO, Locale.forLanguageTag("sd-Deva")),
				of(ISO, Locale.forLanguageTag("xh")),
				of(ISO, Locale.forLanguageTag("zu")),
				});
		DATE_MEDIUM_PATTERNS.put("d. M. y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("sk")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM⹁ y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ff-Adlm")),
				});
		DATE_MEDIUM_PATTERNS.put("dd MMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("hi-Latn")),
				});
		DATE_MEDIUM_PATTERNS.put("dd.M.y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("mk")),
				});
		DATE_MEDIUM_PATTERNS.put("MMM d. y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("smn")),
				});
		DATE_MEDIUM_PATTERNS.put("སྤྱི་ལོ་y ཟླ་MMM ཚེས་dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("dz")),
				});
		DATE_MEDIUM_PATTERNS.put("d-MMM، y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ug")),
				});
		DATE_MEDIUM_PATTERNS.put("y၊ MMM d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("my")),
				});
		DATE_MEDIUM_PATTERNS.put("d, MMM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("doi")),
				});
		DATE_MEDIUM_PATTERNS.put("MMM d 'lia', y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ee")),
				});
		DATE_MEDIUM_PATTERNS.put("d. MMM. y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ksh")),
				});
		DATE_MEDIUM_PATTERNS.put("y 'ж'. dd MMM", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("kk")),
				});
		DATE_MEDIUM_PATTERNS.put("y 'оны' MMM'ын' d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("mn")),
				});
		DATE_MEDIUM_PATTERNS.put("d-MMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("uz")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM y 'г'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("ru")),
				});
		DATE_MEDIUM_PATTERNS.put("d.MM.y 'г'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bg")),
				});
		DATE_MEDIUM_PATTERNS.put("d.M.y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("fi")),
				of(JAPANESE, Locale.forLanguageTag("fi")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("is")),
				of(JAPANESE, Locale.forLanguageTag("is")),
				of(MINGUO, Locale.forLanguageTag("is")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM. y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ka")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM, y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("agq")),
				of(ISO, Locale.forLanguageTag("bas")),
				of(ISO, Locale.forLanguageTag("bm")),
				of(ISO, Locale.forLanguageTag("bn")),
				of(ISO, Locale.forLanguageTag("brx")),
				of(ISO, Locale.forLanguageTag("ccp")),
				of(ISO, Locale.forLanguageTag("dje")),
				of(ISO, Locale.forLanguageTag("ff")),
				of(ISO, Locale.forLanguageTag("gu")),
				of(ISO, Locale.forLanguageTag("ha")),
				of(ISO, Locale.forLanguageTag("kab")),
				of(ISO, Locale.forLanguageTag("khq")),
				of(ISO, Locale.forLanguageTag("mfe")),
				of(ISO, Locale.forLanguageTag("mr")),
				of(ISO, Locale.forLanguageTag("nnh")),
				of(ISO, Locale.forLanguageTag("ses")),
				of(ISO, Locale.forLanguageTag("sg")),
				of(ISO, Locale.forLanguageTag("shi")),
				of(ISO, Locale.forLanguageTag("shi-Latn")),
				of(ISO, Locale.forLanguageTag("ta")),
				of(ISO, Locale.forLanguageTag("te")),
				of(ISO, Locale.forLanguageTag("uz-Cyrl")),
				of(ISO, Locale.forLanguageTag("vi")),
				of(ISO, Locale.forLanguageTag("wo")),
				of(ISO, Locale.forLanguageTag("zgh")),
				});
		DATE_MEDIUM_PATTERNS.put("dd MMM,y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("en-ZW")),
				});
		DATE_MEDIUM_PATTERNS.put("dd‏/MM‏/y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ar")),
				});
		DATE_MEDIUM_PATTERNS.put("y. 'gada' d. MMM", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("lv")),
				});
		DATE_MEDIUM_PATTERNS.put("d MMM y 'ҫ'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("cv")),
				});
		DATE_MEDIUM_PATTERNS.put("d. M. y. G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("hr")),
				});
		DATE_SHORT_PATTERNS.put("dd.MM.yy", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("az")),
				of(ISO, Locale.forLanguageTag("az-Cyrl")),
				of(ISO, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("de")),
				of(ISO, Locale.forLanguageTag("et")),
				of(ISO, Locale.forLanguageTag("fo")),
				of(ISO, Locale.forLanguageTag("fr-CH")),
				of(ISO, Locale.forLanguageTag("gsw")),
				of(ISO, Locale.forLanguageTag("hy")),
				of(ISO, Locale.forLanguageTag("it-CH")),
				of(ISO, Locale.forLanguageTag("ka")),
				of(ISO, Locale.forLanguageTag("kk")),
				of(ISO, Locale.forLanguageTag("lb")),
				of(ISO, Locale.forLanguageTag("lv")),
				of(ISO, Locale.forLanguageTag("os")),
				of(ISO, Locale.forLanguageTag("uk")),
				});
		DATE_SHORT_PATTERNS.put("M/d/yy", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ceb")),
				of(ISO, Locale.forLanguageTag("chr")),
				of(ISO, Locale.forLanguageTag("ee")),
				of(ISO, Locale.forLanguageTag("en")),
				of(ISO, Locale.forLanguageTag("en-CA")),
				of(ISO, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("ks")),
				of(ISO, Locale.forLanguageTag("lkt")),
				of(ISO, Locale.forLanguageTag("or")),
				of(ISO, Locale.forLanguageTag("sd-Deva")),
				of(ISO, Locale.forLanguageTag("xh")),
				of(ISO, Locale.forLanguageTag("zu")),
				});
		DATE_SHORT_PATTERNS.put("y-MM-dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af")),
				of(ISO, Locale.forLanguageTag("bo")),
				of(ISO, Locale.forLanguageTag("ckb")),
				of(ISO, Locale.forLanguageTag("dz")),
				of(ISO, Locale.forLanguageTag("en-SE")),
				of(ISO, Locale.forLanguageTag("fr-CA")),
				of(ISO, Locale.forLanguageTag("ii")),
				of(ISO, Locale.forLanguageTag("jgo")),
				of(ISO, Locale.forLanguageTag("kl")),
				of(ISO, Locale.forLanguageTag("lrc")),
				of(ISO, Locale.forLanguageTag("lt")),
				of(ISO, Locale.forLanguageTag("mg")),
				of(ISO, Locale.forLanguageTag("mgo")),
				of(ISO, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("rw")),
				of(ISO, Locale.forLanguageTag("sd")),
				of(ISO, Locale.forLanguageTag("se")),
				of(ISO, Locale.forLanguageTag("si")),
				of(ISO, Locale.forLanguageTag("sn")),
				of(ISO, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("ug")),
				});
		DATE_SHORT_PATTERNS.put("d-M-y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("as")),
				of(ISO, Locale.forLanguageTag("ff-Adlm")),
				});
		DATE_SHORT_PATTERNS.put("d/MM/yy", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("en-NZ")),
				of(ISO, Locale.forLanguageTag("es-CO")),
				of(ISO, Locale.forLanguageTag("es-GT")),
				of(ISO, Locale.forLanguageTag("es-PE")),
				of(ISO, Locale.forLanguageTag("fr-BE")),
				of(ISO, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("oc")),
				of(ISO, Locale.forLanguageTag("oc-ES")),
				});
		DATE_SHORT_PATTERNS.put("dd.MM.y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("pl")),
				});
		DATE_SHORT_PATTERNS.put("yy/M/d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("eu")),
				of(ISO, Locale.forLanguageTag("ne")),
				of(ISO, Locale.forLanguageTag("sah")),
				});
		DATE_SHORT_PATTERNS.put("dd-MM-y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("brx")),
				of(ISO, Locale.forLanguageTag("ia")),
				of(ISO, Locale.forLanguageTag("jv")),
				of(ISO, Locale.forLanguageTag("mi")),
				of(ISO, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("wo")),
				});
		DATE_SHORT_PATTERNS.put("yy-MM-dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("eo")),
				});
		DATE_SHORT_PATTERNS.put("M.d.y GGGGG", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("en-CH")),
				});
		DATE_SHORT_PATTERNS.put("GGGGG y.MM.dd.", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("hu")),
				});
		DATE_SHORT_PATTERNS.put("dd.MM.y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("cv")),
				of(ISO, Locale.forLanguageTag("da")),
				of(ISO, Locale.forLanguageTag("en-CH")),
				of(ISO, Locale.forLanguageTag("nn")),
				of(ISO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("ru")),
				of(ISO, Locale.forLanguageTag("se-FI")),
				of(ISO, Locale.forLanguageTag("tk")),
				of(ISO, Locale.forLanguageTag("tt")),
				});
		DATE_SHORT_PATTERNS.put("d.M.y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fi")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("gsw")),
				of(ISO, Locale.forLanguageTag("he")),
				of(ISO, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("smn")),
				});
		DATE_SHORT_PATTERNS.put("d/M/y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("agq")),
				of(ISO, Locale.forLanguageTag("bas")),
				of(ISO, Locale.forLanguageTag("bm")),
				of(JAPANESE, Locale.forLanguageTag("da")),
				of(ISO, Locale.forLanguageTag("dje")),
				of(ISO, Locale.forLanguageTag("dua")),
				of(ISO, Locale.forLanguageTag("dyo")),
				of(ISO, Locale.forLanguageTag("en-HK")),
				of(ISO, Locale.forLanguageTag("en-ZW")),
				of(ISO, Locale.forLanguageTag("es-US")),
				of(ISO, Locale.forLanguageTag("ewo")),
				of(ISO, Locale.forLanguageTag("ff")),
				of(ISO, Locale.forLanguageTag("kab")),
				of(ISO, Locale.forLanguageTag("khq")),
				of(ISO, Locale.forLanguageTag("ksf")),
				of(ISO, Locale.forLanguageTag("ln")),
				of(ISO, Locale.forLanguageTag("lo")),
				of(ISO, Locale.forLanguageTag("lu")),
				of(ISO, Locale.forLanguageTag("mfe")),
				of(ISO, Locale.forLanguageTag("mua")),
				of(ISO, Locale.forLanguageTag("nmg")),
				of(ISO, Locale.forLanguageTag("rn")),
				of(ISO, Locale.forLanguageTag("seh")),
				of(ISO, Locale.forLanguageTag("ses")),
				of(ISO, Locale.forLanguageTag("sg")),
				of(ISO, Locale.forLanguageTag("shi")),
				of(ISO, Locale.forLanguageTag("shi-Latn")),
				of(ISO, Locale.forLanguageTag("twq")),
				of(ISO, Locale.forLanguageTag("yav")),
				of(ISO, Locale.forLanguageTag("yo")),
				of(ISO, Locale.forLanguageTag("zgh")),
				of(ISO, Locale.forLanguageTag("zh-Hant-HK")),
				});
		DATE_SHORT_PATTERNS.put("dd-MM-yy GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("fy")),
				of(JAPANESE, Locale.forLanguageTag("fy")),
				of(MINGUO, Locale.forLanguageTag("fy")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("nl")),
				of(JAPANESE, Locale.forLanguageTag("nl")),
				of(MINGUO, Locale.forLanguageTag("nl")),
				});
		DATE_SHORT_PATTERNS.put("d.M.yy.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bs-Cyrl")),
				of(ISO, Locale.forLanguageTag("sr")),
				of(ISO, Locale.forLanguageTag("sr-Latn")),
				});
		DATE_SHORT_PATTERNS.put("Gy-MM-dd", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("zh")),
				});
		DATE_SHORT_PATTERNS.put("yy. M. d.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ko")),
				});
		DATE_SHORT_PATTERNS.put("d.MM.y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("pl")),
				of(ISO, Locale.forLanguageTag("tr")),
				});
		DATE_SHORT_PATTERNS.put("d-M-y GGGGG", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ff-Adlm")),
				});
		DATE_SHORT_PATTERNS.put("dd/MM/y GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("am")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ca")),
				of(MINGUO, Locale.forLanguageTag("ca")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fr")),
				of(JAPANESE, Locale.forLanguageTag("fr")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ga")),
				});
		DATE_SHORT_PATTERNS.put("d-M-yy", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("en-MV")),
				of(ISO, Locale.forLanguageTag("kok")),
				});
		DATE_SHORT_PATTERNS.put("dd/MM/y GGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("br")),
				of(JAPANESE, Locale.forLanguageTag("br")),
				of(MINGUO, Locale.forLanguageTag("br")),
				});
		DATE_SHORT_PATTERNS.put("Gyy/M/d", new PatternCoordinates[] {
				of(MINGUO, Locale.forLanguageTag("yue-Hans")),
				});
		DATE_SHORT_PATTERNS.put("d/M/yy", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("bn")),
				of(ISO, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("ccp")),
				of(ISO, Locale.forLanguageTag("doi")),
				of(ISO, Locale.forLanguageTag("el")),
				of(JAPANESE, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("en-AU")),
				of(ISO, Locale.forLanguageTag("en-JM")),
				of(ISO, Locale.forLanguageTag("en-SG")),
				of(ISO, Locale.forLanguageTag("es")),
				of(ISO, Locale.forLanguageTag("es-419")),
				of(ISO, Locale.forLanguageTag("gu")),
				of(ISO, Locale.forLanguageTag("ha")),
				of(ISO, Locale.forLanguageTag("haw")),
				of(ISO, Locale.forLanguageTag("hi")),
				of(ISO, Locale.forLanguageTag("ig")),
				of(ISO, Locale.forLanguageTag("km")),
				of(ISO, Locale.forLanguageTag("kn")),
				of(ISO, Locale.forLanguageTag("ks-Deva")),
				of(ISO, Locale.forLanguageTag("ky")),
				of(ISO, Locale.forLanguageTag("mai")),
				of(ISO, Locale.forLanguageTag("ml")),
				of(ISO, Locale.forLanguageTag("mni")),
				of(ISO, Locale.forLanguageTag("mr")),
				of(ISO, Locale.forLanguageTag("my")),
				of(ISO, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("sa")),
				of(ISO, Locale.forLanguageTag("sat")),
				of(ISO, Locale.forLanguageTag("su")),
				of(ISO, Locale.forLanguageTag("ta")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("th")),
				of(ISO, Locale.forLanguageTag("th")),
				of(ISO, Locale.forLanguageTag("to")),
				of(ISO, Locale.forLanguageTag("ur")),
				of(ISO, Locale.forLanguageTag("zh-Hans-HK")),
				of(ISO, Locale.forLanguageTag("zh-Hans-MO")),
				});
		DATE_SHORT_PATTERNS.put("y/M/d", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fa")),
				of(ISO, Locale.forLanguageTag("ps")),
				of(ISO, Locale.forLanguageTag("uz-Arab")),
				of(ISO, Locale.forLanguageTag("yue")),
				of(ISO, Locale.forLanguageTag("yue-Hans")),
				of(ISO, Locale.forLanguageTag("zh")),
				of(ISO, Locale.forLanguageTag("zh-Hant")),
				});
		DATE_SHORT_PATTERNS.put("y. MM. dd.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("hu")),
				});
		DATE_SHORT_PATTERNS.put("dd/MM/y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("asa")),
				of(ISO, Locale.forLanguageTag("bem")),
				of(ISO, Locale.forLanguageTag("bez")),
				of(ISO, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("cgg")),
				of(ISO, Locale.forLanguageTag("dav")),
				of(ISO, Locale.forLanguageTag("ebu")),
				of(ISO, Locale.forLanguageTag("en-001")),
				of(ISO, Locale.forLanguageTag("en-AE")),
				of(ISO, Locale.forLanguageTag("en-GB")),
				of(ISO, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("gd")),
				of(ISO, Locale.forLanguageTag("guz")),
				of(ISO, Locale.forLanguageTag("hi-Latn")),
				of(ISO, Locale.forLanguageTag("jmc")),
				of(ISO, Locale.forLanguageTag("kam")),
				of(ISO, Locale.forLanguageTag("kde")),
				of(ISO, Locale.forLanguageTag("kea")),
				of(ISO, Locale.forLanguageTag("kgp")),
				of(ISO, Locale.forLanguageTag("ki")),
				of(ISO, Locale.forLanguageTag("kln")),
				of(ISO, Locale.forLanguageTag("ksb")),
				of(ISO, Locale.forLanguageTag("kw")),
				of(ISO, Locale.forLanguageTag("lag")),
				of(ISO, Locale.forLanguageTag("lg")),
				of(ISO, Locale.forLanguageTag("luo")),
				of(ISO, Locale.forLanguageTag("luy")),
				of(ISO, Locale.forLanguageTag("mas")),
				of(ISO, Locale.forLanguageTag("mer")),
				of(ISO, Locale.forLanguageTag("mgh")),
				of(ISO, Locale.forLanguageTag("mt")),
				of(ISO, Locale.forLanguageTag("naq")),
				of(ISO, Locale.forLanguageTag("nd")),
				of(ISO, Locale.forLanguageTag("nyn")),
				of(ISO, Locale.forLanguageTag("pa-Arab")),
				of(ISO, Locale.forLanguageTag("pcm")),
				of(ISO, Locale.forLanguageTag("pt")),
				of(ISO, Locale.forLanguageTag("qu")),
				of(ISO, Locale.forLanguageTag("rof")),
				of(ISO, Locale.forLanguageTag("rwk")),
				of(ISO, Locale.forLanguageTag("saq")),
				of(ISO, Locale.forLanguageTag("sbp")),
				of(ISO, Locale.forLanguageTag("sc")),
				of(ISO, Locale.forLanguageTag("sw")),
				of(ISO, Locale.forLanguageTag("sw-KE")),
				of(ISO, Locale.forLanguageTag("teo")),
				of(ISO, Locale.forLanguageTag("tzm")),
				of(ISO, Locale.forLanguageTag("vai")),
				of(ISO, Locale.forLanguageTag("vai-Latn")),
				of(ISO, Locale.forLanguageTag("vi")),
				of(ISO, Locale.forLanguageTag("vun")),
				of(ISO, Locale.forLanguageTag("xog")),
				of(ISO, Locale.forLanguageTag("yrl")),
				of(ISO, Locale.forLanguageTag("yrl-CO")),
				of(ISO, Locale.forLanguageTag("yrl-VE")),
				});
		DATE_SHORT_PATTERNS.put("d.M y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("no")),
				});
		DATE_SHORT_PATTERNS.put("d. MM. yy", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("sl")),
				});
		DATE_SHORT_PATTERNS.put("dd. MM. y.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("hr")),
				});
		DATE_SHORT_PATTERNS.put("d/M/yy G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("th")),
				});
		DATE_SHORT_PATTERNS.put("d. M. y. GGGGG", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("hr")),
				});
		DATE_SHORT_PATTERNS.put("d‏/M‏/y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ar")),
				});
		DATE_SHORT_PATTERNS.put("MM/dd/yy", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("es-PA")),
				of(ISO, Locale.forLanguageTag("es-PR")),
				});
		DATE_SHORT_PATTERNS.put("d. M. y.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bs")),
				});
		DATE_SHORT_PATTERNS.put("Gy/M/d", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("yue")),
				of(JAPANESE, Locale.forLanguageTag("yue")),
				of(MINGUO, Locale.forLanguageTag("yue")),
				of(MINGUO, Locale.forLanguageTag("zh")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh-Hant")),
				of(JAPANESE, Locale.forLanguageTag("zh-Hant")),
				of(MINGUO, Locale.forLanguageTag("zh-Hant")),
				});
		DATE_SHORT_PATTERNS.put("Gyy-MM-dd", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("yue-Hans")),
				});
		DATE_SHORT_PATTERNS.put("dd/MM/yy GGGGG", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("es")),
				of(JAPANESE, Locale.forLanguageTag("it")),
				of(JAPANESE, Locale.forLanguageTag("kgp")),
				of(JAPANESE, Locale.forLanguageTag("pt")),
				of(JAPANESE, Locale.forLanguageTag("yrl")),
				});
		DATE_SHORT_PATTERNS.put("dd.MM.y GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("en-CH")),
				of(MINGUO, Locale.forLanguageTag("en-CH")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ro")),
				});
		DATE_SHORT_PATTERNS.put("d/M/y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("pt-PT")),
				of(JAPANESE, Locale.forLanguageTag("pt-PT")),
				of(MINGUO, Locale.forLanguageTag("pt-PT")),
				of(MINGUO, Locale.forLanguageTag("th")),
				});
		DATE_SHORT_PATTERNS.put("d/M/y GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("el")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("id")),
				of(JAPANESE, Locale.forLanguageTag("id")),
				of(MINGUO, Locale.forLanguageTag("id")),
				});
		DATE_SHORT_PATTERNS.put("Gy/MM/dd", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("ja")),
				of(MINGUO, Locale.forLanguageTag("ja")),
				});
		DATE_SHORT_PATTERNS.put("d/MM/y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nl-BE")),
				of(ISO, Locale.forLanguageTag("nus")),
				});
		DATE_SHORT_PATTERNS.put("d.MM.yy 'г'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bg")),
				});
		DATE_SHORT_PATTERNS.put("Gd/M/yy", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh-Hans-HK")),
				of(JAPANESE, Locale.forLanguageTag("zh-Hans-HK")),
				of(MINGUO, Locale.forLanguageTag("zh-Hans-HK")),
				of(MINGUO, Locale.forLanguageTag("zh-Hans-MO")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh-Hans-SG")),
				of(JAPANESE, Locale.forLanguageTag("zh-Hans-SG")),
				of(MINGUO, Locale.forLanguageTag("zh-Hans-SG")),
				});
		DATE_SHORT_PATTERNS.put("dd/MM/y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("vi")),
				});
		DATE_SHORT_PATTERNS.put("Gy-M-d", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("yue-Hans")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh")),
				});
		DATE_SHORT_PATTERNS.put("d.MM.y G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("tr")),
				});
		DATE_SHORT_PATTERNS.put("dd/MM/yy", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("cy")),
				of(ISO, Locale.forLanguageTag("en-BE")),
				of(ISO, Locale.forLanguageTag("en-BW")),
				of(ISO, Locale.forLanguageTag("en-BZ")),
				of(ISO, Locale.forLanguageTag("en-IN")),
				of(ISO, Locale.forLanguageTag("es-MX")),
				of(ISO, Locale.forLanguageTag("frr")),
				of(ISO, Locale.forLanguageTag("fur")),
				of(ISO, Locale.forLanguageTag("gl")),
				of(ISO, Locale.forLanguageTag("gv")),
				of(ISO, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("it")),
				of(ISO, Locale.forLanguageTag("ms-ID")),
				of(ISO, Locale.forLanguageTag("nnh")),
				of(ISO, Locale.forLanguageTag("om")),
				of(ISO, Locale.forLanguageTag("pt-PT")),
				of(ISO, Locale.forLanguageTag("so")),
				of(ISO, Locale.forLanguageTag("tg")),
				of(ISO, Locale.forLanguageTag("ti")),
				of(ISO, Locale.forLanguageTag("uz")),
				of(ISO, Locale.forLanguageTag("uz-Cyrl")),
				of(ISO, Locale.forLanguageTag("yi")),
				of(ISO, Locale.forLanguageTag("zh-Hans-SG")),
				});
		DATE_SHORT_PATTERNS.put("y-MM-dd G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("sv")),
				});
		DATE_SHORT_PATTERNS.put("y/MM/dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("en-ZA")),
				of(ISO, Locale.forLanguageTag("ja")),
				});
		DATE_SHORT_PATTERNS.put("d/MM/y GGGGG", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ms")),
				});
		DATE_SHORT_PATTERNS.put("d. M. y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ksh")),
				of(ISO, Locale.forLanguageTag("sk")),
				});
		DATE_SHORT_PATTERNS.put("GGGGG y-MM-dd", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("")),
				of(HIJRAH_UMALQURA, Locale.forLanguageTag("")),
				of(JAPANESE, Locale.forLanguageTag("")),
				of(MINGUO, Locale.forLanguageTag("")),
				});
		DATE_SHORT_PATTERNS.put("dd/MM y", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("kkj")),
				});
		DATE_SHORT_PATTERNS.put("M/d/yy G", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("bs-Cyrl")),
				of(JAPANESE, Locale.forLanguageTag("sr")),
				of(JAPANESE, Locale.forLanguageTag("sr-Latn")),
				});
		DATE_SHORT_PATTERNS.put("y.MM.dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("mn")),
				});
		DATE_SHORT_PATTERNS.put("dd.MM.yy GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("cs")),
				of(JAPANESE, Locale.forLanguageTag("cs")),
				of(MINGUO, Locale.forLanguageTag("cs")),
				of(JAPANESE, Locale.forLanguageTag("de")),
				of(JAPANESE, Locale.forLanguageTag("lb")),
				});
		DATE_SHORT_PATTERNS.put("d.MM.yy", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("be-TARASK")),
				of(ISO, Locale.forLanguageTag("nds")),
				});
		DATE_SHORT_PATTERNS.put("dd-MM-GGGGG yy", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ee")),
				});
		DATE_SHORT_PATTERNS.put("GGGGGy/M/d", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ja")),
				});
		DATE_SHORT_PATTERNS.put("dd-MM-yy", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("es-CL")),
				of(ISO, Locale.forLanguageTag("fy")),
				of(ISO, Locale.forLanguageTag("rm")),
				of(ISO, Locale.forLanguageTag("te")),
				});
		DATE_SHORT_PATTERNS.put("d. M. yy.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("hr-BA")),
				});
		DATE_SHORT_PATTERNS.put("yy/MM/dd", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ak")),
				});
		DATE_SHORT_PATTERNS.put("dd-MM-GGGGG y", new PatternCoordinates[] {
				of(MINGUO, Locale.forLanguageTag("ee")),
				});
		DATE_SHORT_PATTERNS.put("d.M.y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("no")),
				of(MINGUO, Locale.forLanguageTag("no")),
				});
		DATE_SHORT_PATTERNS.put("d/M/yy GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("ast")),
				of(MINGUO, Locale.forLanguageTag("ast")),
				});
		DATE_SHORT_PATTERNS.put("d.M.yy", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("dsb")),
				of(ISO, Locale.forLanguageTag("hsb")),
				of(ISO, Locale.forLanguageTag("mk")),
				of(ISO, Locale.forLanguageTag("sq")),
				});
		DATE_SHORT_PATTERNS.put("M/d/y GGGGG", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("en")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fil")),
				of(MINGUO, Locale.forLanguageTag("fil")),
				of(JAPANESE, Locale.forLanguageTag("ug")),
				});
		DATE_SHORT_PATTERNS.put("dd.M.y GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("mk")),
				});
		DATE_SHORT_PATTERNS.put("d.M.y GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("fi")),
				of(JAPANESE, Locale.forLanguageTag("fi")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("is")),
				of(JAPANESE, Locale.forLanguageTag("is")),
				of(MINGUO, Locale.forLanguageTag("is")),
				});
		DATE_TIME_FULL_PATTERNS.put("{1}, {0}", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("ast")),
				of(JAPANESE, Locale.forLanguageTag("ast")),
				of(MINGUO, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("be-TARASK")),
				of(ISO, Locale.forLanguageTag("bg")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("br")),
				of(JAPANESE, Locale.forLanguageTag("br")),
				of(MINGUO, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("brx")),
				of(ISO, Locale.forLanguageTag("bs")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("ceb")),
				of(ISO, Locale.forLanguageTag("chr")),
				of(ISO, Locale.forLanguageTag("cv")),
				of(ISO, Locale.forLanguageTag("cy")),
				of(ISO, Locale.forLanguageTag("de")),
				of(ISO, Locale.forLanguageTag("doi")),
				of(ISO, Locale.forLanguageTag("en")),
				of(ISO, Locale.forLanguageTag("en-AU")),
				of(ISO, Locale.forLanguageTag("en-CA")),
				of(ISO, Locale.forLanguageTag("en-GB")),
				of(ISO, Locale.forLanguageTag("en-IN")),
				of(ISO, Locale.forLanguageTag("es")),
				of(ISO, Locale.forLanguageTag("es-419")),
				of(ISO, Locale.forLanguageTag("es-MX")),
				of(ISO, Locale.forLanguageTag("es-US")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("fil")),
				of(MINGUO, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("fo")),
				of(ISO, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("fr-CA")),
				of(ISO, Locale.forLanguageTag("frr")),
				of(ISO, Locale.forLanguageTag("gl")),
				of(ISO, Locale.forLanguageTag("he")),
				of(ISO, Locale.forLanguageTag("hi")),
				of(ISO, Locale.forLanguageTag("hi-Latn")),
				of(ISO, Locale.forLanguageTag("hy")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("ig")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("is")),
				of(JAPANESE, Locale.forLanguageTag("is")),
				of(MINGUO, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("ka")),
				of(ISO, Locale.forLanguageTag("kab")),
				of(ISO, Locale.forLanguageTag("kea")),
				of(ISO, Locale.forLanguageTag("kk")),
				of(ISO, Locale.forLanguageTag("km")),
				of(ISO, Locale.forLanguageTag("ks")),
				of(ISO, Locale.forLanguageTag("ks-Deva")),
				of(ISO, Locale.forLanguageTag("lo")),
				of(ISO, Locale.forLanguageTag("mai")),
				of(ISO, Locale.forLanguageTag("mk")),
				of(ISO, Locale.forLanguageTag("mni")),
				of(ISO, Locale.forLanguageTag("mr")),
				of(ISO, Locale.forLanguageTag("nds")),
				of(ISO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("oc-ES")),
				of(ISO, Locale.forLanguageTag("or")),
				of(ISO, Locale.forLanguageTag("os")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pcm")),
				of(ISO, Locale.forLanguageTag("pt-PT")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("ru")),
				of(ISO, Locale.forLanguageTag("sa")),
				of(ISO, Locale.forLanguageTag("sc")),
				of(ISO, Locale.forLanguageTag("sd-Deva")),
				of(ISO, Locale.forLanguageTag("sk")),
				of(ISO, Locale.forLanguageTag("sq")),
				of(ISO, Locale.forLanguageTag("su")),
				of(ISO, Locale.forLanguageTag("ta")),
				of(ISO, Locale.forLanguageTag("to")),
				of(ISO, Locale.forLanguageTag("tt")),
				of(ISO, Locale.forLanguageTag("uk")),
				of(ISO, Locale.forLanguageTag("uz")),
				});
		DATE_TIME_FULL_PATTERNS.put("{1} {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("as")),
				of(ISO, Locale.forLanguageTag("az")),
				of(ISO, Locale.forLanguageTag("bn")),
				of(ISO, Locale.forLanguageTag("bs-Cyrl")),
				of(ISO, Locale.forLanguageTag("ccp")),
				of(ISO, Locale.forLanguageTag("ckb")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("cs")),
				of(JAPANESE, Locale.forLanguageTag("cs")),
				of(MINGUO, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("da")),
				of(ISO, Locale.forLanguageTag("dsb")),
				of(ISO, Locale.forLanguageTag("dz")),
				of(ISO, Locale.forLanguageTag("en-MV")),
				of(ISO, Locale.forLanguageTag("eo")),
				of(ISO, Locale.forLanguageTag("et")),
				of(ISO, Locale.forLanguageTag("eu")),
				of(ISO, Locale.forLanguageTag("ff-Adlm")),
				of(JAPANESE, Locale.forLanguageTag("ff-Adlm")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fi")),
				of(ISO, Locale.forLanguageTag("fi")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fr")),
				of(JAPANESE, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("fy")),
				of(JAPANESE, Locale.forLanguageTag("fy")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("gd")),
				of(JAPANESE, Locale.forLanguageTag("gd")),
				of(MINGUO, Locale.forLanguageTag("gd")),
				of(ISO, Locale.forLanguageTag("gu")),
				of(ISO, Locale.forLanguageTag("ha")),
				of(ISO, Locale.forLanguageTag("haw")),
				of(ISO, Locale.forLanguageTag("hr")),
				of(JAPANESE, Locale.forLanguageTag("hr")),
				of(ISO, Locale.forLanguageTag("hsb")),
				of(ISO, Locale.forLanguageTag("hu")),
				of(ISO, Locale.forLanguageTag("ia")),
				of(ISO, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("ii")),
				of(ISO, Locale.forLanguageTag("it")),
				of(ISO, Locale.forLanguageTag("ja")),
				of(JAPANESE, Locale.forLanguageTag("ja")),
				of(ISO, Locale.forLanguageTag("jgo")),
				of(ISO, Locale.forLanguageTag("jv")),
				of(ISO, Locale.forLanguageTag("kgp")),
				of(ISO, Locale.forLanguageTag("kkj")),
				of(ISO, Locale.forLanguageTag("kl")),
				of(ISO, Locale.forLanguageTag("kn")),
				of(ISO, Locale.forLanguageTag("ko")),
				of(ISO, Locale.forLanguageTag("kok")),
				of(ISO, Locale.forLanguageTag("ky")),
				of(ISO, Locale.forLanguageTag("lb")),
				of(ISO, Locale.forLanguageTag("lrc")),
				of(ISO, Locale.forLanguageTag("lt")),
				of(ISO, Locale.forLanguageTag("lv")),
				of(ISO, Locale.forLanguageTag("mg")),
				of(ISO, Locale.forLanguageTag("mgo")),
				of(ISO, Locale.forLanguageTag("mi")),
				of(ISO, Locale.forLanguageTag("ml")),
				of(ISO, Locale.forLanguageTag("mn")),
				of(ISO, Locale.forLanguageTag("ms")),
				of(JAPANESE, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("mt")),
				of(ISO, Locale.forLanguageTag("my")),
				of(ISO, Locale.forLanguageTag("ne")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("nl")),
				of(JAPANESE, Locale.forLanguageTag("nl")),
				of(MINGUO, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("nn")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("no")),
				of(JAPANESE, Locale.forLanguageTag("no")),
				of(MINGUO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("om")),
				of(ISO, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pl")),
				of(ISO, Locale.forLanguageTag("ps")),
				of(ISO, Locale.forLanguageTag("pt")),
				of(ISO, Locale.forLanguageTag("qu")),
				of(ISO, Locale.forLanguageTag("rm")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("")),
				of(HIJRAH_UMALQURA, Locale.forLanguageTag("")),
				of(JAPANESE, Locale.forLanguageTag("")),
				of(MINGUO, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("rw")),
				of(ISO, Locale.forLanguageTag("sah")),
				of(ISO, Locale.forLanguageTag("sat")),
				of(ISO, Locale.forLanguageTag("sd")),
				of(ISO, Locale.forLanguageTag("se")),
				of(ISO, Locale.forLanguageTag("si")),
				of(ISO, Locale.forLanguageTag("sl")),
				of(ISO, Locale.forLanguageTag("smn")),
				of(ISO, Locale.forLanguageTag("sn")),
				of(ISO, Locale.forLanguageTag("so")),
				of(ISO, Locale.forLanguageTag("sr")),
				of(ISO, Locale.forLanguageTag("sr-Latn")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sv")),
				of(JAPANESE, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sw")),
				of(ISO, Locale.forLanguageTag("sw-KE")),
				of(ISO, Locale.forLanguageTag("te")),
				of(ISO, Locale.forLanguageTag("tg")),
				of(ISO, Locale.forLanguageTag("th")),
				of(JAPANESE, Locale.forLanguageTag("th")),
				of(ISO, Locale.forLanguageTag("ti")),
				of(ISO, Locale.forLanguageTag("tk")),
				of(ISO, Locale.forLanguageTag("tr")),
				of(ISO, Locale.forLanguageTag("ug")),
				of(ISO, Locale.forLanguageTag("ur")),
				of(ISO, Locale.forLanguageTag("uz-Cyrl")),
				of(ISO, Locale.forLanguageTag("xh")),
				of(ISO, Locale.forLanguageTag("yi")),
				of(ISO, Locale.forLanguageTag("yo")),
				of(ISO, Locale.forLanguageTag("yrl")),
				of(ISO, Locale.forLanguageTag("yrl-CO")),
				of(ISO, Locale.forLanguageTag("yrl-VE")),
				of(ISO, Locale.forLanguageTag("yue")),
				of(JAPANESE, Locale.forLanguageTag("yue")),
				of(ISO, Locale.forLanguageTag("yue-Hans")),
				of(JAPANESE, Locale.forLanguageTag("yue-Hans")),
				of(ISO, Locale.forLanguageTag("zgh")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh")),
				of(ISO, Locale.forLanguageTag("zh")),
				of(JAPANESE, Locale.forLanguageTag("zh")),
				of(ISO, Locale.forLanguageTag("zh-Hant")),
				of(ISO, Locale.forLanguageTag("zh-Hant-HK")),
				of(ISO, Locale.forLanguageTag("zu")),
				});
		DATE_TIME_FULL_PATTERNS.put("{1}، ساعت {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fa")),
				});
		DATE_TIME_FULL_PATTERNS.put("{1},{0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nnh")),
				});
		DATE_TIME_FULL_PATTERNS.put("{1}{0}", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh-Hant")),
				of(MINGUO, Locale.forLanguageTag("zh-Hant")),
				});
		DATE_TIME_FULL_PATTERNS.put("{1} 'a' {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("oc")),
				});
		DATE_TIME_FULL_PATTERNS.put("{0} {1}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ee")),
				of(ISO, Locale.forLanguageTag("vi")),
				});
		DATE_TIME_FULL_PATTERNS.put("{1} - {0}", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("wo")),
				});
		DATE_TIME_FULL_PATTERNS.put("{1}، {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ar")),
				});
		DATE_TIME_LONG_PATTERNS.put("{1}, {0}", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("ast")),
				of(JAPANESE, Locale.forLanguageTag("ast")),
				of(MINGUO, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("be-TARASK")),
				of(ISO, Locale.forLanguageTag("bg")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("br")),
				of(JAPANESE, Locale.forLanguageTag("br")),
				of(MINGUO, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("brx")),
				of(ISO, Locale.forLanguageTag("bs")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("ceb")),
				of(ISO, Locale.forLanguageTag("chr")),
				of(ISO, Locale.forLanguageTag("cv")),
				of(ISO, Locale.forLanguageTag("cy")),
				of(ISO, Locale.forLanguageTag("de")),
				of(ISO, Locale.forLanguageTag("doi")),
				of(ISO, Locale.forLanguageTag("en")),
				of(ISO, Locale.forLanguageTag("en-AU")),
				of(ISO, Locale.forLanguageTag("en-CA")),
				of(ISO, Locale.forLanguageTag("en-GB")),
				of(ISO, Locale.forLanguageTag("en-IN")),
				of(ISO, Locale.forLanguageTag("es")),
				of(ISO, Locale.forLanguageTag("es-419")),
				of(ISO, Locale.forLanguageTag("es-MX")),
				of(ISO, Locale.forLanguageTag("es-US")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("fil")),
				of(MINGUO, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("fo")),
				of(ISO, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("fr-CA")),
				of(ISO, Locale.forLanguageTag("frr")),
				of(ISO, Locale.forLanguageTag("gl")),
				of(ISO, Locale.forLanguageTag("ha")),
				of(ISO, Locale.forLanguageTag("he")),
				of(ISO, Locale.forLanguageTag("hi")),
				of(ISO, Locale.forLanguageTag("hi-Latn")),
				of(ISO, Locale.forLanguageTag("hy")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("ig")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("is")),
				of(JAPANESE, Locale.forLanguageTag("is")),
				of(MINGUO, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("ka")),
				of(ISO, Locale.forLanguageTag("kab")),
				of(ISO, Locale.forLanguageTag("kea")),
				of(ISO, Locale.forLanguageTag("kk")),
				of(ISO, Locale.forLanguageTag("km")),
				of(ISO, Locale.forLanguageTag("ks")),
				of(ISO, Locale.forLanguageTag("ks-Deva")),
				of(ISO, Locale.forLanguageTag("lo")),
				of(ISO, Locale.forLanguageTag("mai")),
				of(ISO, Locale.forLanguageTag("mk")),
				of(ISO, Locale.forLanguageTag("mni")),
				of(ISO, Locale.forLanguageTag("mr")),
				of(ISO, Locale.forLanguageTag("nds")),
				of(ISO, Locale.forLanguageTag("nnh")),
				of(ISO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("oc-ES")),
				of(ISO, Locale.forLanguageTag("or")),
				of(ISO, Locale.forLanguageTag("os")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pcm")),
				of(ISO, Locale.forLanguageTag("pt-PT")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("ru")),
				of(ISO, Locale.forLanguageTag("sa")),
				of(ISO, Locale.forLanguageTag("sc")),
				of(ISO, Locale.forLanguageTag("sd-Deva")),
				of(ISO, Locale.forLanguageTag("sk")),
				of(ISO, Locale.forLanguageTag("sq")),
				of(ISO, Locale.forLanguageTag("su")),
				of(ISO, Locale.forLanguageTag("ta")),
				of(ISO, Locale.forLanguageTag("to")),
				of(ISO, Locale.forLanguageTag("tt")),
				of(ISO, Locale.forLanguageTag("uk")),
				of(ISO, Locale.forLanguageTag("uz")),
				});
		DATE_TIME_LONG_PATTERNS.put("{1} 'kl'. {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nn")),
				});
		DATE_TIME_LONG_PATTERNS.put("{1} {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("as")),
				of(ISO, Locale.forLanguageTag("az")),
				of(ISO, Locale.forLanguageTag("bn")),
				of(ISO, Locale.forLanguageTag("bs-Cyrl")),
				of(ISO, Locale.forLanguageTag("ccp")),
				of(ISO, Locale.forLanguageTag("ckb")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("cs")),
				of(JAPANESE, Locale.forLanguageTag("cs")),
				of(MINGUO, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("da")),
				of(ISO, Locale.forLanguageTag("dsb")),
				of(ISO, Locale.forLanguageTag("dz")),
				of(ISO, Locale.forLanguageTag("en-MV")),
				of(ISO, Locale.forLanguageTag("eo")),
				of(ISO, Locale.forLanguageTag("et")),
				of(ISO, Locale.forLanguageTag("eu")),
				of(ISO, Locale.forLanguageTag("ff-Adlm")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fi")),
				of(ISO, Locale.forLanguageTag("fi")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fr")),
				of(JAPANESE, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("fy")),
				of(JAPANESE, Locale.forLanguageTag("fy")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("gd")),
				of(JAPANESE, Locale.forLanguageTag("gd")),
				of(MINGUO, Locale.forLanguageTag("gd")),
				of(ISO, Locale.forLanguageTag("gu")),
				of(ISO, Locale.forLanguageTag("haw")),
				of(ISO, Locale.forLanguageTag("hr")),
				of(JAPANESE, Locale.forLanguageTag("hr")),
				of(ISO, Locale.forLanguageTag("hsb")),
				of(ISO, Locale.forLanguageTag("hu")),
				of(ISO, Locale.forLanguageTag("ia")),
				of(ISO, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("ii")),
				of(ISO, Locale.forLanguageTag("it")),
				of(ISO, Locale.forLanguageTag("ja")),
				of(JAPANESE, Locale.forLanguageTag("ja")),
				of(ISO, Locale.forLanguageTag("jgo")),
				of(ISO, Locale.forLanguageTag("jv")),
				of(ISO, Locale.forLanguageTag("kgp")),
				of(ISO, Locale.forLanguageTag("kkj")),
				of(ISO, Locale.forLanguageTag("kl")),
				of(ISO, Locale.forLanguageTag("kn")),
				of(ISO, Locale.forLanguageTag("ko")),
				of(ISO, Locale.forLanguageTag("kok")),
				of(ISO, Locale.forLanguageTag("ky")),
				of(ISO, Locale.forLanguageTag("lb")),
				of(ISO, Locale.forLanguageTag("lrc")),
				of(ISO, Locale.forLanguageTag("lt")),
				of(ISO, Locale.forLanguageTag("lv")),
				of(ISO, Locale.forLanguageTag("mg")),
				of(ISO, Locale.forLanguageTag("mgo")),
				of(ISO, Locale.forLanguageTag("mi")),
				of(ISO, Locale.forLanguageTag("ml")),
				of(ISO, Locale.forLanguageTag("mn")),
				of(ISO, Locale.forLanguageTag("ms")),
				of(JAPANESE, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("mt")),
				of(ISO, Locale.forLanguageTag("my")),
				of(ISO, Locale.forLanguageTag("ne")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("nl")),
				of(JAPANESE, Locale.forLanguageTag("nl")),
				of(MINGUO, Locale.forLanguageTag("nl")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("no")),
				of(JAPANESE, Locale.forLanguageTag("no")),
				of(MINGUO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("om")),
				of(ISO, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pl")),
				of(ISO, Locale.forLanguageTag("ps")),
				of(ISO, Locale.forLanguageTag("pt")),
				of(ISO, Locale.forLanguageTag("rm")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("")),
				of(HIJRAH_UMALQURA, Locale.forLanguageTag("")),
				of(JAPANESE, Locale.forLanguageTag("")),
				of(MINGUO, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("rw")),
				of(ISO, Locale.forLanguageTag("sah")),
				of(ISO, Locale.forLanguageTag("sat")),
				of(ISO, Locale.forLanguageTag("sd")),
				of(ISO, Locale.forLanguageTag("se")),
				of(ISO, Locale.forLanguageTag("si")),
				of(ISO, Locale.forLanguageTag("sl")),
				of(ISO, Locale.forLanguageTag("smn")),
				of(ISO, Locale.forLanguageTag("sn")),
				of(ISO, Locale.forLanguageTag("so")),
				of(ISO, Locale.forLanguageTag("sr")),
				of(ISO, Locale.forLanguageTag("sr-Latn")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sv")),
				of(JAPANESE, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sw")),
				of(ISO, Locale.forLanguageTag("sw-KE")),
				of(ISO, Locale.forLanguageTag("te")),
				of(ISO, Locale.forLanguageTag("tg")),
				of(ISO, Locale.forLanguageTag("th")),
				of(JAPANESE, Locale.forLanguageTag("th")),
				of(ISO, Locale.forLanguageTag("ti")),
				of(ISO, Locale.forLanguageTag("tk")),
				of(ISO, Locale.forLanguageTag("tr")),
				of(ISO, Locale.forLanguageTag("ug")),
				of(ISO, Locale.forLanguageTag("ur")),
				of(ISO, Locale.forLanguageTag("uz-Cyrl")),
				of(ISO, Locale.forLanguageTag("xh")),
				of(ISO, Locale.forLanguageTag("yi")),
				of(ISO, Locale.forLanguageTag("yo")),
				of(ISO, Locale.forLanguageTag("yrl")),
				of(ISO, Locale.forLanguageTag("yrl-CO")),
				of(ISO, Locale.forLanguageTag("yrl-VE")),
				of(ISO, Locale.forLanguageTag("yue")),
				of(JAPANESE, Locale.forLanguageTag("yue")),
				of(ISO, Locale.forLanguageTag("yue-Hans")),
				of(JAPANESE, Locale.forLanguageTag("yue-Hans")),
				of(ISO, Locale.forLanguageTag("zgh")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh")),
				of(ISO, Locale.forLanguageTag("zh")),
				of(JAPANESE, Locale.forLanguageTag("zh")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh-Hant")),
				of(ISO, Locale.forLanguageTag("zh-Hant")),
				of(JAPANESE, Locale.forLanguageTag("zh-Hant")),
				of(MINGUO, Locale.forLanguageTag("zh-Hant")),
				of(ISO, Locale.forLanguageTag("zh-Hant-HK")),
				of(ISO, Locale.forLanguageTag("zu")),
				});
		DATE_TIME_LONG_PATTERNS.put("{1}، ساعت {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fa")),
				});
		DATE_TIME_LONG_PATTERNS.put("{1}⹁ {0}", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ff-Adlm")),
				});
		DATE_TIME_LONG_PATTERNS.put("{1} 'a' {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("oc")),
				});
		DATE_TIME_LONG_PATTERNS.put("{0} {1}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ee")),
				of(ISO, Locale.forLanguageTag("qu")),
				of(ISO, Locale.forLanguageTag("vi")),
				});
		DATE_TIME_LONG_PATTERNS.put("{1} - {0}", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("wo")),
				});
		DATE_TIME_LONG_PATTERNS.put("{1}، {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ar")),
				});
		DATE_TIME_MEDIUM_PATTERNS.put("{1}, {0}", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("ast")),
				of(JAPANESE, Locale.forLanguageTag("ast")),
				of(MINGUO, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("be-TARASK")),
				of(ISO, Locale.forLanguageTag("bg")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("br")),
				of(JAPANESE, Locale.forLanguageTag("br")),
				of(MINGUO, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("brx")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("ceb")),
				of(ISO, Locale.forLanguageTag("chr")),
				of(ISO, Locale.forLanguageTag("cv")),
				of(ISO, Locale.forLanguageTag("de")),
				of(ISO, Locale.forLanguageTag("doi")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("en")),
				of(ISO, Locale.forLanguageTag("en-AU")),
				of(ISO, Locale.forLanguageTag("en-CA")),
				of(ISO, Locale.forLanguageTag("en-GB")),
				of(ISO, Locale.forLanguageTag("en-IN")),
				of(ISO, Locale.forLanguageTag("es")),
				of(ISO, Locale.forLanguageTag("es-CO")),
				of(ISO, Locale.forLanguageTag("es-US")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("fil")),
				of(MINGUO, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("fo")),
				of(ISO, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("fr-CA")),
				of(ISO, Locale.forLanguageTag("fr-ML")),
				of(ISO, Locale.forLanguageTag("frr")),
				of(ISO, Locale.forLanguageTag("gl")),
				of(ISO, Locale.forLanguageTag("ha")),
				of(ISO, Locale.forLanguageTag("he")),
				of(ISO, Locale.forLanguageTag("hi")),
				of(ISO, Locale.forLanguageTag("hy")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("ig")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("is")),
				of(JAPANESE, Locale.forLanguageTag("is")),
				of(MINGUO, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("it")),
				of(ISO, Locale.forLanguageTag("jv")),
				of(ISO, Locale.forLanguageTag("ka")),
				of(ISO, Locale.forLanguageTag("kab")),
				of(ISO, Locale.forLanguageTag("kea")),
				of(ISO, Locale.forLanguageTag("kk")),
				of(ISO, Locale.forLanguageTag("km")),
				of(ISO, Locale.forLanguageTag("ks")),
				of(ISO, Locale.forLanguageTag("ks-Deva")),
				of(ISO, Locale.forLanguageTag("lo")),
				of(ISO, Locale.forLanguageTag("mai")),
				of(ISO, Locale.forLanguageTag("mk")),
				of(ISO, Locale.forLanguageTag("mni")),
				of(ISO, Locale.forLanguageTag("mr")),
				of(ISO, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("nds")),
				of(ISO, Locale.forLanguageTag("ne")),
				of(ISO, Locale.forLanguageTag("nn")),
				of(ISO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("oc")),
				of(ISO, Locale.forLanguageTag("oc-ES")),
				of(ISO, Locale.forLanguageTag("or")),
				of(ISO, Locale.forLanguageTag("os")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pl")),
				of(ISO, Locale.forLanguageTag("pt-PT")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("ru")),
				of(ISO, Locale.forLanguageTag("sa")),
				of(ISO, Locale.forLanguageTag("sc")),
				of(ISO, Locale.forLanguageTag("sd-Deva")),
				of(ISO, Locale.forLanguageTag("sk")),
				of(ISO, Locale.forLanguageTag("sl")),
				of(ISO, Locale.forLanguageTag("sq")),
				of(ISO, Locale.forLanguageTag("su")),
				of(ISO, Locale.forLanguageTag("ta")),
				of(ISO, Locale.forLanguageTag("to")),
				of(ISO, Locale.forLanguageTag("tt")),
				of(ISO, Locale.forLanguageTag("uk")),
				of(ISO, Locale.forLanguageTag("uz")),
				of(ISO, Locale.forLanguageTag("yi")),
				});
		DATE_TIME_MEDIUM_PATTERNS.put("{1} {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("as")),
				of(ISO, Locale.forLanguageTag("az")),
				of(ISO, Locale.forLanguageTag("bn")),
				of(ISO, Locale.forLanguageTag("bs")),
				of(ISO, Locale.forLanguageTag("bs-Cyrl")),
				of(ISO, Locale.forLanguageTag("ccp")),
				of(ISO, Locale.forLanguageTag("ckb")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("cs")),
				of(JAPANESE, Locale.forLanguageTag("cs")),
				of(MINGUO, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("cy")),
				of(ISO, Locale.forLanguageTag("da")),
				of(ISO, Locale.forLanguageTag("dsb")),
				of(ISO, Locale.forLanguageTag("dz")),
				of(ISO, Locale.forLanguageTag("en-MV")),
				of(ISO, Locale.forLanguageTag("eo")),
				of(ISO, Locale.forLanguageTag("es-419")),
				of(ISO, Locale.forLanguageTag("es-MX")),
				of(ISO, Locale.forLanguageTag("et")),
				of(ISO, Locale.forLanguageTag("eu")),
				of(ISO, Locale.forLanguageTag("ff-Adlm")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fi")),
				of(ISO, Locale.forLanguageTag("fi")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fr")),
				of(JAPANESE, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("fy")),
				of(JAPANESE, Locale.forLanguageTag("fy")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("gd")),
				of(MINGUO, Locale.forLanguageTag("gd")),
				of(ISO, Locale.forLanguageTag("gu")),
				of(ISO, Locale.forLanguageTag("haw")),
				of(ISO, Locale.forLanguageTag("hi-Latn")),
				of(ISO, Locale.forLanguageTag("hr")),
				of(JAPANESE, Locale.forLanguageTag("hr")),
				of(ISO, Locale.forLanguageTag("hsb")),
				of(ISO, Locale.forLanguageTag("hu")),
				of(ISO, Locale.forLanguageTag("ia")),
				of(ISO, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("ii")),
				of(ISO, Locale.forLanguageTag("ja")),
				of(JAPANESE, Locale.forLanguageTag("ja")),
				of(ISO, Locale.forLanguageTag("jgo")),
				of(ISO, Locale.forLanguageTag("kgp")),
				of(ISO, Locale.forLanguageTag("kkj")),
				of(ISO, Locale.forLanguageTag("kl")),
				of(ISO, Locale.forLanguageTag("kn")),
				of(ISO, Locale.forLanguageTag("ko")),
				of(ISO, Locale.forLanguageTag("kok")),
				of(ISO, Locale.forLanguageTag("ky")),
				of(ISO, Locale.forLanguageTag("lb")),
				of(ISO, Locale.forLanguageTag("lrc")),
				of(ISO, Locale.forLanguageTag("lt")),
				of(ISO, Locale.forLanguageTag("lv")),
				of(ISO, Locale.forLanguageTag("mg")),
				of(ISO, Locale.forLanguageTag("mgo")),
				of(ISO, Locale.forLanguageTag("mi")),
				of(ISO, Locale.forLanguageTag("ml")),
				of(ISO, Locale.forLanguageTag("mn")),
				of(JAPANESE, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("mt")),
				of(ISO, Locale.forLanguageTag("my")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("nl")),
				of(JAPANESE, Locale.forLanguageTag("nl")),
				of(MINGUO, Locale.forLanguageTag("nl")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("no")),
				of(JAPANESE, Locale.forLanguageTag("no")),
				of(MINGUO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("om")),
				of(ISO, Locale.forLanguageTag("pcm")),
				of(ISO, Locale.forLanguageTag("ps")),
				of(ISO, Locale.forLanguageTag("pt")),
				of(ISO, Locale.forLanguageTag("qu")),
				of(ISO, Locale.forLanguageTag("rm")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("")),
				of(HIJRAH_UMALQURA, Locale.forLanguageTag("")),
				of(JAPANESE, Locale.forLanguageTag("")),
				of(MINGUO, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("rw")),
				of(ISO, Locale.forLanguageTag("sah")),
				of(ISO, Locale.forLanguageTag("sat")),
				of(ISO, Locale.forLanguageTag("sd")),
				of(ISO, Locale.forLanguageTag("se")),
				of(ISO, Locale.forLanguageTag("si")),
				of(ISO, Locale.forLanguageTag("smn")),
				of(ISO, Locale.forLanguageTag("sn")),
				of(ISO, Locale.forLanguageTag("so")),
				of(ISO, Locale.forLanguageTag("sr")),
				of(ISO, Locale.forLanguageTag("sr-Latn")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sv")),
				of(JAPANESE, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sw")),
				of(ISO, Locale.forLanguageTag("sw-KE")),
				of(ISO, Locale.forLanguageTag("te")),
				of(ISO, Locale.forLanguageTag("tg")),
				of(ISO, Locale.forLanguageTag("th")),
				of(JAPANESE, Locale.forLanguageTag("th")),
				of(ISO, Locale.forLanguageTag("ti")),
				of(ISO, Locale.forLanguageTag("tk")),
				of(ISO, Locale.forLanguageTag("tr")),
				of(ISO, Locale.forLanguageTag("ur")),
				of(ISO, Locale.forLanguageTag("uz-Cyrl")),
				of(ISO, Locale.forLanguageTag("xh")),
				of(ISO, Locale.forLanguageTag("yo")),
				of(ISO, Locale.forLanguageTag("yrl")),
				of(ISO, Locale.forLanguageTag("yrl-CO")),
				of(ISO, Locale.forLanguageTag("yrl-VE")),
				of(ISO, Locale.forLanguageTag("yue")),
				of(JAPANESE, Locale.forLanguageTag("yue")),
				of(ISO, Locale.forLanguageTag("yue-Hans")),
				of(JAPANESE, Locale.forLanguageTag("yue-Hans")),
				of(ISO, Locale.forLanguageTag("zgh")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh")),
				of(ISO, Locale.forLanguageTag("zh")),
				of(JAPANESE, Locale.forLanguageTag("zh")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh-Hant")),
				of(ISO, Locale.forLanguageTag("zh-Hant")),
				of(JAPANESE, Locale.forLanguageTag("zh-Hant")),
				of(MINGUO, Locale.forLanguageTag("zh-Hant")),
				of(ISO, Locale.forLanguageTag("zh-Hant-HK")),
				of(ISO, Locale.forLanguageTag("zu")),
				});
		DATE_TIME_MEDIUM_PATTERNS.put("{0}, {1}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("vi")),
				});
		DATE_TIME_MEDIUM_PATTERNS.put("{1}⹁ {0}", new PatternCoordinates[] {
				of(JAPANESE, Locale.forLanguageTag("ff-Adlm")),
				});
		DATE_TIME_MEDIUM_PATTERNS.put("{1}،‏ {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fa")),
				});
		DATE_TIME_MEDIUM_PATTERNS.put("{0} {1}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ee")),
				});
		DATE_TIME_MEDIUM_PATTERNS.put("{1} - {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("wo")),
				});
		DATE_TIME_MEDIUM_PATTERNS.put("{1}، {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ar")),
				of(ISO, Locale.forLanguageTag("ug")),
				});
		DATE_TIME_SHORT_PATTERNS.put("{1}, {0}", new PatternCoordinates[] {
				of(THAI_BUDDHIST, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("be-TARASK")),
				of(ISO, Locale.forLanguageTag("bg")),
				of(ISO, Locale.forLanguageTag("brx")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("ceb")),
				of(ISO, Locale.forLanguageTag("chr")),
				of(ISO, Locale.forLanguageTag("cv")),
				of(ISO, Locale.forLanguageTag("de")),
				of(ISO, Locale.forLanguageTag("doi")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("en")),
				of(ISO, Locale.forLanguageTag("en-AU")),
				of(ISO, Locale.forLanguageTag("en-CA")),
				of(ISO, Locale.forLanguageTag("en-GB")),
				of(ISO, Locale.forLanguageTag("en-IN")),
				of(ISO, Locale.forLanguageTag("es")),
				of(ISO, Locale.forLanguageTag("es-419")),
				of(ISO, Locale.forLanguageTag("es-CO")),
				of(ISO, Locale.forLanguageTag("es-MX")),
				of(ISO, Locale.forLanguageTag("es-US")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("fil")),
				of(MINGUO, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("fo")),
				of(ISO, Locale.forLanguageTag("fr-ML")),
				of(ISO, Locale.forLanguageTag("frr")),
				of(ISO, Locale.forLanguageTag("gl")),
				of(ISO, Locale.forLanguageTag("ha")),
				of(ISO, Locale.forLanguageTag("he")),
				of(ISO, Locale.forLanguageTag("hi")),
				of(ISO, Locale.forLanguageTag("hy")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("ig")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("is")),
				of(JAPANESE, Locale.forLanguageTag("is")),
				of(MINGUO, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("it")),
				of(ISO, Locale.forLanguageTag("jv")),
				of(ISO, Locale.forLanguageTag("ka")),
				of(ISO, Locale.forLanguageTag("kab")),
				of(ISO, Locale.forLanguageTag("kea")),
				of(ISO, Locale.forLanguageTag("kk")),
				of(ISO, Locale.forLanguageTag("km")),
				of(ISO, Locale.forLanguageTag("ks")),
				of(ISO, Locale.forLanguageTag("ks-Deva")),
				of(ISO, Locale.forLanguageTag("lo")),
				of(ISO, Locale.forLanguageTag("mai")),
				of(ISO, Locale.forLanguageTag("mk")),
				of(ISO, Locale.forLanguageTag("mni")),
				of(ISO, Locale.forLanguageTag("mr")),
				of(ISO, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("nds")),
				of(ISO, Locale.forLanguageTag("ne")),
				of(ISO, Locale.forLanguageTag("nn")),
				of(ISO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("oc")),
				of(ISO, Locale.forLanguageTag("oc-ES")),
				of(ISO, Locale.forLanguageTag("or")),
				of(ISO, Locale.forLanguageTag("os")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pl")),
				of(ISO, Locale.forLanguageTag("pt-PT")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("ru")),
				of(ISO, Locale.forLanguageTag("sa")),
				of(ISO, Locale.forLanguageTag("sc")),
				of(ISO, Locale.forLanguageTag("sd-Deva")),
				of(ISO, Locale.forLanguageTag("sl")),
				of(ISO, Locale.forLanguageTag("sq")),
				of(ISO, Locale.forLanguageTag("su")),
				of(ISO, Locale.forLanguageTag("ta")),
				of(ISO, Locale.forLanguageTag("tt")),
				of(ISO, Locale.forLanguageTag("uk")),
				of(ISO, Locale.forLanguageTag("uz")),
				});
		DATE_TIME_SHORT_PATTERNS.put("{1} {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("as")),
				of(ISO, Locale.forLanguageTag("ast")),
				of(MINGUO, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("az")),
				of(ISO, Locale.forLanguageTag("bn")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("bs")),
				of(ISO, Locale.forLanguageTag("bs-Cyrl")),
				of(ISO, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("ccp")),
				of(ISO, Locale.forLanguageTag("ckb")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("cs")),
				of(JAPANESE, Locale.forLanguageTag("cs")),
				of(MINGUO, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("cy")),
				of(ISO, Locale.forLanguageTag("da")),
				of(ISO, Locale.forLanguageTag("dsb")),
				of(ISO, Locale.forLanguageTag("dz")),
				of(ISO, Locale.forLanguageTag("en-MV")),
				of(ISO, Locale.forLanguageTag("eo")),
				of(ISO, Locale.forLanguageTag("et")),
				of(ISO, Locale.forLanguageTag("eu")),
				of(ISO, Locale.forLanguageTag("ff-Adlm")),
				of(JAPANESE, Locale.forLanguageTag("ff-Adlm")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fi")),
				of(ISO, Locale.forLanguageTag("fi")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("fr")),
				of(JAPANESE, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("fr-CA")),
				of(ISO, Locale.forLanguageTag("fy")),
				of(JAPANESE, Locale.forLanguageTag("fy")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("gd")),
				of(MINGUO, Locale.forLanguageTag("gd")),
				of(ISO, Locale.forLanguageTag("gu")),
				of(ISO, Locale.forLanguageTag("haw")),
				of(ISO, Locale.forLanguageTag("hi-Latn")),
				of(ISO, Locale.forLanguageTag("hr")),
				of(JAPANESE, Locale.forLanguageTag("hr")),
				of(ISO, Locale.forLanguageTag("hsb")),
				of(ISO, Locale.forLanguageTag("hu")),
				of(ISO, Locale.forLanguageTag("ia")),
				of(ISO, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("ii")),
				of(ISO, Locale.forLanguageTag("ja")),
				of(JAPANESE, Locale.forLanguageTag("ja")),
				of(ISO, Locale.forLanguageTag("jgo")),
				of(ISO, Locale.forLanguageTag("kgp")),
				of(ISO, Locale.forLanguageTag("kkj")),
				of(ISO, Locale.forLanguageTag("kl")),
				of(ISO, Locale.forLanguageTag("kn")),
				of(ISO, Locale.forLanguageTag("ko")),
				of(ISO, Locale.forLanguageTag("kok")),
				of(ISO, Locale.forLanguageTag("ky")),
				of(ISO, Locale.forLanguageTag("lb")),
				of(ISO, Locale.forLanguageTag("lrc")),
				of(ISO, Locale.forLanguageTag("lt")),
				of(ISO, Locale.forLanguageTag("lv")),
				of(ISO, Locale.forLanguageTag("mg")),
				of(ISO, Locale.forLanguageTag("mgo")),
				of(ISO, Locale.forLanguageTag("mi")),
				of(ISO, Locale.forLanguageTag("ml")),
				of(ISO, Locale.forLanguageTag("mn")),
				of(JAPANESE, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("mt")),
				of(ISO, Locale.forLanguageTag("my")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("nl")),
				of(JAPANESE, Locale.forLanguageTag("nl")),
				of(MINGUO, Locale.forLanguageTag("nl")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("no")),
				of(JAPANESE, Locale.forLanguageTag("no")),
				of(MINGUO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("om")),
				of(ISO, Locale.forLanguageTag("pcm")),
				of(ISO, Locale.forLanguageTag("ps")),
				of(ISO, Locale.forLanguageTag("pt")),
				of(ISO, Locale.forLanguageTag("qu")),
				of(ISO, Locale.forLanguageTag("rm")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("")),
				of(HIJRAH_UMALQURA, Locale.forLanguageTag("")),
				of(JAPANESE, Locale.forLanguageTag("")),
				of(MINGUO, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("rw")),
				of(ISO, Locale.forLanguageTag("sah")),
				of(ISO, Locale.forLanguageTag("sat")),
				of(ISO, Locale.forLanguageTag("sd")),
				of(ISO, Locale.forLanguageTag("se")),
				of(ISO, Locale.forLanguageTag("si")),
				of(ISO, Locale.forLanguageTag("sk")),
				of(ISO, Locale.forLanguageTag("smn")),
				of(ISO, Locale.forLanguageTag("sn")),
				of(ISO, Locale.forLanguageTag("so")),
				of(ISO, Locale.forLanguageTag("sr")),
				of(ISO, Locale.forLanguageTag("sr-Latn")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sv")),
				of(JAPANESE, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sw")),
				of(ISO, Locale.forLanguageTag("sw-KE")),
				of(ISO, Locale.forLanguageTag("te")),
				of(ISO, Locale.forLanguageTag("tg")),
				of(ISO, Locale.forLanguageTag("th")),
				of(JAPANESE, Locale.forLanguageTag("th")),
				of(ISO, Locale.forLanguageTag("ti")),
				of(ISO, Locale.forLanguageTag("tk")),
				of(ISO, Locale.forLanguageTag("to")),
				of(ISO, Locale.forLanguageTag("tr")),
				of(ISO, Locale.forLanguageTag("ur")),
				of(ISO, Locale.forLanguageTag("uz-Cyrl")),
				of(ISO, Locale.forLanguageTag("xh")),
				of(ISO, Locale.forLanguageTag("yi")),
				of(ISO, Locale.forLanguageTag("yo")),
				of(ISO, Locale.forLanguageTag("yrl")),
				of(ISO, Locale.forLanguageTag("yrl-CO")),
				of(ISO, Locale.forLanguageTag("yrl-VE")),
				of(ISO, Locale.forLanguageTag("yue")),
				of(JAPANESE, Locale.forLanguageTag("yue")),
				of(ISO, Locale.forLanguageTag("yue-Hans")),
				of(JAPANESE, Locale.forLanguageTag("yue-Hans")),
				of(ISO, Locale.forLanguageTag("zgh")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh")),
				of(ISO, Locale.forLanguageTag("zh")),
				of(JAPANESE, Locale.forLanguageTag("zh")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("zh-Hant")),
				of(ISO, Locale.forLanguageTag("zh-Hant")),
				of(JAPANESE, Locale.forLanguageTag("zh-Hant")),
				of(MINGUO, Locale.forLanguageTag("zh-Hant")),
				of(ISO, Locale.forLanguageTag("zh-Hant-HK")),
				of(ISO, Locale.forLanguageTag("zu")),
				});
		DATE_TIME_SHORT_PATTERNS.put("{0}, {1}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("vi")),
				});
		DATE_TIME_SHORT_PATTERNS.put("{1}،‏ {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fa")),
				});
		DATE_TIME_SHORT_PATTERNS.put("{0} {1}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ee")),
				});
		DATE_TIME_SHORT_PATTERNS.put("{1} - {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("wo")),
				});
		DATE_TIME_SHORT_PATTERNS.put("{1}، {0}", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ar")),
				of(ISO, Locale.forLanguageTag("ug")),
				});
		TIME_FULL_PATTERNS.put("H:mm:ss zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ar-IL")),
				of(ISO, Locale.forLanguageTag("dsb")),
				of(ISO, Locale.forLanguageTag("en-IL")),
				of(ISO, Locale.forLanguageTag("he")),
				of(ISO, Locale.forLanguageTag("hsb")),
				of(ISO, Locale.forLanguageTag("hu")),
				of(ISO, Locale.forLanguageTag("sk")),
				of(ISO, Locale.forLanguageTag("tt")),
				});
		TIME_FULL_PATTERNS.put("ah:mm:ss [zzzz]", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yue")),
				of(ISO, Locale.forLanguageTag("zh-Hant-HK")),
				});
		TIME_FULL_PATTERNS.put("H ໂມງ m ນາທີ ss ວິນາທີ zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("lo")),
				});
		TIME_FULL_PATTERNS.put("zzzz HH:mm:ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("my")),
				of(ISO, Locale.forLanguageTag("yue-Hans")),
				of(ISO, Locale.forLanguageTag("zh")),
				});
		TIME_FULL_PATTERNS.put("'kl'. HH:mm:ss zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nn")),
				});
		TIME_FULL_PATTERNS.put("h:mm:ss a zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("ar")),
				of(ISO, Locale.forLanguageTag("bgc")),
				of(ISO, Locale.forLanguageTag("bho")),
				of(ISO, Locale.forLanguageTag("bn")),
				of(ISO, Locale.forLanguageTag("bo-IN")),
				of(ISO, Locale.forLanguageTag("ccp")),
				of(ISO, Locale.forLanguageTag("chr")),
				of(ISO, Locale.forLanguageTag("ckb")),
				of(ISO, Locale.forLanguageTag("doi")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-GH")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-GM")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-LR")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-MR")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-SL")),
				of(ISO, Locale.forLanguageTag("hi")),
				of(ISO, Locale.forLanguageTag("km")),
				of(ISO, Locale.forLanguageTag("kok")),
				of(ISO, Locale.forLanguageTag("ks")),
				of(ISO, Locale.forLanguageTag("lrc-IQ")),
				of(ISO, Locale.forLanguageTag("mai")),
				of(ISO, Locale.forLanguageTag("ml")),
				of(ISO, Locale.forLanguageTag("mni")),
				of(ISO, Locale.forLanguageTag("mr")),
				of(ISO, Locale.forLanguageTag("ne-IN")),
				of(ISO, Locale.forLanguageTag("or")),
				of(ISO, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pa-Arab")),
				of(ISO, Locale.forLanguageTag("ps-PK")),
				of(ISO, Locale.forLanguageTag("raj")),
				of(ISO, Locale.forLanguageTag("sa")),
				of(ISO, Locale.forLanguageTag("sat")),
				of(ISO, Locale.forLanguageTag("sd")),
				of(ISO, Locale.forLanguageTag("sd-Deva")),
				of(ISO, Locale.forLanguageTag("te")),
				of(ISO, Locale.forLanguageTag("ti")),
				of(ISO, Locale.forLanguageTag("ur")),
				of(ISO, Locale.forLanguageTag("vai")),
				});
		TIME_FULL_PATTERNS.put("H.mm.ss zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("en-FI")),
				of(ISO, Locale.forLanguageTag("fi")),
				of(ISO, Locale.forLanguageTag("smn")),
				of(ISO, Locale.forLanguageTag("su")),
				});
		TIME_FULL_PATTERNS.put("H 'h' mm 'min' ss 's' zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fr-BE")),
				});
		TIME_FULL_PATTERNS.put("H นาฬิกา mm นาที ss วินาที zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("th")),
				});
		TIME_FULL_PATTERNS.put("HH.mm.ss zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("da")),
				of(ISO, Locale.forLanguageTag("en-DK")),
				of(ISO, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("kl")),
				of(ISO, Locale.forLanguageTag("ms-ID")),
				of(ISO, Locale.forLanguageTag("si")),
				});
		TIME_FULL_PATTERNS.put("'Klock' H.mm:ss (zzzz)", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nds")),
				});
		TIME_FULL_PATTERNS.put("H:mm:ss (zzzz)", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("es")),
				of(ISO, Locale.forLanguageTag("fa")),
				of(ISO, Locale.forLanguageTag("oc-ES")),
				of(ISO, Locale.forLanguageTag("ps")),
				of(ISO, Locale.forLanguageTag("uz")),
				of(ISO, Locale.forLanguageTag("uz-Arab")),
				});
		TIME_FULL_PATTERNS.put("HH:mm:ss zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af")),
				of(ISO, Locale.forLanguageTag("agq")),
				of(ISO, Locale.forLanguageTag("ar-KM")),
				of(ISO, Locale.forLanguageTag("ar-MA")),
				of(ISO, Locale.forLanguageTag("asa")),
				of(ISO, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("az")),
				of(ISO, Locale.forLanguageTag("az-Cyrl")),
				of(ISO, Locale.forLanguageTag("bas")),
				of(ISO, Locale.forLanguageTag("bez")),
				of(ISO, Locale.forLanguageTag("bm")),
				of(ISO, Locale.forLanguageTag("bo")),
				of(ISO, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("bs")),
				of(ISO, Locale.forLanguageTag("bs-Cyrl")),
				of(ISO, Locale.forLanguageTag("cgg")),
				of(ISO, Locale.forLanguageTag("ckb-IR")),
				of(ISO, Locale.forLanguageTag("cv")),
				of(ISO, Locale.forLanguageTag("cy")),
				of(ISO, Locale.forLanguageTag("dav")),
				of(ISO, Locale.forLanguageTag("de")),
				of(ISO, Locale.forLanguageTag("dje")),
				of(ISO, Locale.forLanguageTag("dua")),
				of(ISO, Locale.forLanguageTag("dyo")),
				of(ISO, Locale.forLanguageTag("ebu")),
				of(ISO, Locale.forLanguageTag("ee-TG")),
				of(ISO, Locale.forLanguageTag("en-150")),
				of(ISO, Locale.forLanguageTag("en-AI")),
				of(ISO, Locale.forLanguageTag("en-BI")),
				of(ISO, Locale.forLanguageTag("en-BW")),
				of(ISO, Locale.forLanguageTag("en-BZ")),
				of(ISO, Locale.forLanguageTag("en-CC")),
				of(ISO, Locale.forLanguageTag("en-CK")),
				of(ISO, Locale.forLanguageTag("en-CM")),
				of(ISO, Locale.forLanguageTag("en-CX")),
				of(ISO, Locale.forLanguageTag("en-DG")),
				of(ISO, Locale.forLanguageTag("en-FK")),
				of(ISO, Locale.forLanguageTag("en-GB")),
				of(ISO, Locale.forLanguageTag("en-GG")),
				of(ISO, Locale.forLanguageTag("en-GI")),
				of(ISO, Locale.forLanguageTag("en-IE")),
				of(ISO, Locale.forLanguageTag("en-IM")),
				of(ISO, Locale.forLanguageTag("en-IO")),
				of(ISO, Locale.forLanguageTag("en-JE")),
				of(ISO, Locale.forLanguageTag("en-KE")),
				of(ISO, Locale.forLanguageTag("en-MG")),
				of(ISO, Locale.forLanguageTag("en-MS")),
				of(ISO, Locale.forLanguageTag("en-MT")),
				of(ISO, Locale.forLanguageTag("en-MU")),
				of(ISO, Locale.forLanguageTag("en-MV")),
				of(ISO, Locale.forLanguageTag("en-NF")),
				of(ISO, Locale.forLanguageTag("en-NG")),
				of(ISO, Locale.forLanguageTag("en-NR")),
				of(ISO, Locale.forLanguageTag("en-NU")),
				of(ISO, Locale.forLanguageTag("en-PN")),
				of(ISO, Locale.forLanguageTag("en-RW")),
				of(ISO, Locale.forLanguageTag("en-SC")),
				of(ISO, Locale.forLanguageTag("en-SH")),
				of(ISO, Locale.forLanguageTag("en-SX")),
				of(ISO, Locale.forLanguageTag("en-TK")),
				of(ISO, Locale.forLanguageTag("en-TV")),
				of(ISO, Locale.forLanguageTag("en-TZ")),
				of(ISO, Locale.forLanguageTag("en-UG")),
				of(ISO, Locale.forLanguageTag("en-ZA")),
				of(ISO, Locale.forLanguageTag("en-ZW")),
				of(ISO, Locale.forLanguageTag("es-419")),
				of(ISO, Locale.forLanguageTag("es-MX")),
				of(ISO, Locale.forLanguageTag("et")),
				of(ISO, Locale.forLanguageTag("ewo")),
				of(ISO, Locale.forLanguageTag("ff")),
				of(ISO, Locale.forLanguageTag("ff-Adlm")),
				of(ISO, Locale.forLanguageTag("fo")),
				of(ISO, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("frr")),
				of(ISO, Locale.forLanguageTag("fur")),
				of(ISO, Locale.forLanguageTag("fy")),
				of(ISO, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("gd")),
				of(ISO, Locale.forLanguageTag("gl")),
				of(ISO, Locale.forLanguageTag("gsw")),
				of(ISO, Locale.forLanguageTag("guz")),
				of(ISO, Locale.forLanguageTag("gv")),
				of(ISO, Locale.forLanguageTag("ha")),
				of(ISO, Locale.forLanguageTag("hy")),
				of(ISO, Locale.forLanguageTag("ia")),
				of(ISO, Locale.forLanguageTag("ig")),
				of(ISO, Locale.forLanguageTag("ii")),
				of(ISO, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("it")),
				of(ISO, Locale.forLanguageTag("jgo")),
				of(ISO, Locale.forLanguageTag("jmc")),
				of(ISO, Locale.forLanguageTag("jv")),
				of(ISO, Locale.forLanguageTag("ka")),
				of(ISO, Locale.forLanguageTag("kam")),
				of(ISO, Locale.forLanguageTag("kde")),
				of(ISO, Locale.forLanguageTag("kea")),
				of(ISO, Locale.forLanguageTag("kgp")),
				of(ISO, Locale.forLanguageTag("khq")),
				of(ISO, Locale.forLanguageTag("ki")),
				of(ISO, Locale.forLanguageTag("kk")),
				of(ISO, Locale.forLanguageTag("kln")),
				of(ISO, Locale.forLanguageTag("ksb")),
				of(ISO, Locale.forLanguageTag("ksf")),
				of(ISO, Locale.forLanguageTag("ksh")),
				of(ISO, Locale.forLanguageTag("kw")),
				of(ISO, Locale.forLanguageTag("ky")),
				of(ISO, Locale.forLanguageTag("lag")),
				of(ISO, Locale.forLanguageTag("lb")),
				of(ISO, Locale.forLanguageTag("lg")),
				of(ISO, Locale.forLanguageTag("ln")),
				of(ISO, Locale.forLanguageTag("lrc")),
				of(ISO, Locale.forLanguageTag("lt")),
				of(ISO, Locale.forLanguageTag("lu")),
				of(ISO, Locale.forLanguageTag("luo")),
				of(ISO, Locale.forLanguageTag("luy")),
				of(ISO, Locale.forLanguageTag("lv")),
				of(ISO, Locale.forLanguageTag("mas")),
				of(ISO, Locale.forLanguageTag("mer")),
				of(ISO, Locale.forLanguageTag("mfe")),
				of(ISO, Locale.forLanguageTag("mg")),
				of(ISO, Locale.forLanguageTag("mgh")),
				of(ISO, Locale.forLanguageTag("mgo")),
				of(ISO, Locale.forLanguageTag("mk")),
				of(ISO, Locale.forLanguageTag("mt")),
				of(ISO, Locale.forLanguageTag("mua")),
				of(ISO, Locale.forLanguageTag("nd")),
				of(ISO, Locale.forLanguageTag("ne")),
				of(ISO, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("nmg")),
				of(ISO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("nyn")),
				of(ISO, Locale.forLanguageTag("oc")),
				of(ISO, Locale.forLanguageTag("om-KE")),
				of(ISO, Locale.forLanguageTag("os")),
				of(ISO, Locale.forLanguageTag("pcm")),
				of(ISO, Locale.forLanguageTag("pl")),
				of(ISO, Locale.forLanguageTag("pt")),
				of(ISO, Locale.forLanguageTag("pt-PT")),
				of(ISO, Locale.forLanguageTag("qu")),
				of(ISO, Locale.forLanguageTag("rm")),
				of(ISO, Locale.forLanguageTag("rn")),
				of(ISO, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("rof")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("")),
				of(HIJRAH_UMALQURA, Locale.forLanguageTag("")),
				of(JAPANESE, Locale.forLanguageTag("")),
				of(MINGUO, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("ru")),
				of(ISO, Locale.forLanguageTag("rw")),
				of(ISO, Locale.forLanguageTag("rwk")),
				of(ISO, Locale.forLanguageTag("sah")),
				of(ISO, Locale.forLanguageTag("saq")),
				of(ISO, Locale.forLanguageTag("sbp")),
				of(ISO, Locale.forLanguageTag("sc")),
				of(ISO, Locale.forLanguageTag("se")),
				of(ISO, Locale.forLanguageTag("seh")),
				of(ISO, Locale.forLanguageTag("ses")),
				of(ISO, Locale.forLanguageTag("sg")),
				of(ISO, Locale.forLanguageTag("sl")),
				of(ISO, Locale.forLanguageTag("sn")),
				of(ISO, Locale.forLanguageTag("so-KE")),
				of(ISO, Locale.forLanguageTag("sq-MK")),
				of(ISO, Locale.forLanguageTag("sq-XK")),
				of(ISO, Locale.forLanguageTag("sr")),
				of(ISO, Locale.forLanguageTag("sr-Latn")),
				of(ISO, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sw")),
				of(ISO, Locale.forLanguageTag("sw-KE")),
				of(ISO, Locale.forLanguageTag("ta-LK")),
				of(ISO, Locale.forLanguageTag("teo")),
				of(ISO, Locale.forLanguageTag("tg")),
				of(ISO, Locale.forLanguageTag("tk")),
				of(ISO, Locale.forLanguageTag("tr")),
				of(ISO, Locale.forLanguageTag("twq")),
				of(ISO, Locale.forLanguageTag("ug")),
				of(ISO, Locale.forLanguageTag("uk")),
				of(ISO, Locale.forLanguageTag("vi")),
				of(ISO, Locale.forLanguageTag("vun")),
				of(ISO, Locale.forLanguageTag("wo")),
				of(ISO, Locale.forLanguageTag("xh")),
				of(ISO, Locale.forLanguageTag("xog")),
				of(ISO, Locale.forLanguageTag("yav")),
				of(ISO, Locale.forLanguageTag("yi")),
				of(ISO, Locale.forLanguageTag("yo")),
				of(ISO, Locale.forLanguageTag("yrl")),
				of(ISO, Locale.forLanguageTag("zgh")),
				of(ISO, Locale.forLanguageTag("zu")),
				});
		TIME_FULL_PATTERNS.put("H-'a' 'horo' 'kaj' m:ss zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("eo")),
				});
		TIME_FULL_PATTERNS.put("HH.mm:ss 'h' zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fr-CH")),
				});
		TIME_FULL_PATTERNS.put("a h시 m분 s초 zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ko")),
				});
		TIME_FULL_PATTERNS.put("H:mm:ss, zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("cs")),
				});
		TIME_FULL_PATTERNS.put("zzzz h:mm:ss a", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nus")),
				});
		TIME_FULL_PATTERNS.put("h:mm:ss a zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af-NA")),
				of(ISO, Locale.forLanguageTag("ak")),
				of(ISO, Locale.forLanguageTag("bem")),
				of(ISO, Locale.forLanguageTag("ceb")),
				of(ISO, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("en")),
				of(ISO, Locale.forLanguageTag("en-AU")),
				of(ISO, Locale.forLanguageTag("en-CA")),
				of(ISO, Locale.forLanguageTag("en-IN")),
				of(ISO, Locale.forLanguageTag("es-CO")),
				of(ISO, Locale.forLanguageTag("es-DO")),
				of(ISO, Locale.forLanguageTag("es-PA")),
				of(ISO, Locale.forLanguageTag("es-PH")),
				of(ISO, Locale.forLanguageTag("es-PR")),
				of(ISO, Locale.forLanguageTag("es-US")),
				of(ISO, Locale.forLanguageTag("es-VE")),
				of(ISO, Locale.forLanguageTag("ff-Latn-GH")),
				of(ISO, Locale.forLanguageTag("ff-Latn-GM")),
				of(ISO, Locale.forLanguageTag("ff-Latn-LR")),
				of(ISO, Locale.forLanguageTag("ff-Latn-MR")),
				of(ISO, Locale.forLanguageTag("ff-Latn-SL")),
				of(ISO, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("fr-DJ")),
				of(ISO, Locale.forLanguageTag("fr-DZ")),
				of(ISO, Locale.forLanguageTag("fr-MR")),
				of(ISO, Locale.forLanguageTag("fr-SY")),
				of(ISO, Locale.forLanguageTag("fr-TD")),
				of(ISO, Locale.forLanguageTag("fr-TN")),
				of(ISO, Locale.forLanguageTag("fr-VU")),
				of(ISO, Locale.forLanguageTag("ha-GH")),
				of(ISO, Locale.forLanguageTag("haw")),
				of(ISO, Locale.forLanguageTag("hi-Latn")),
				of(ISO, Locale.forLanguageTag("kab")),
				of(ISO, Locale.forLanguageTag("lkt")),
				of(ISO, Locale.forLanguageTag("mi")),
				of(ISO, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("naq")),
				of(ISO, Locale.forLanguageTag("om")),
				of(ISO, Locale.forLanguageTag("pt-MO")),
				of(ISO, Locale.forLanguageTag("so")),
				of(ISO, Locale.forLanguageTag("to")),
				of(ISO, Locale.forLanguageTag("tr-CY")),
				of(ISO, Locale.forLanguageTag("vai-Latn")),
				of(ISO, Locale.forLanguageTag("yrl-CO")),
				of(ISO, Locale.forLanguageTag("yrl-VE")),
				});
		TIME_FULL_PATTERNS.put("a h.mm.ss zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("as")),
				});
		TIME_FULL_PATTERNS.put("ཆུ་ཚོད་ h སྐར་མ་ mm:ss a zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("dz")),
				});
		TIME_FULL_PATTERNS.put("HH:mm:ss (zzzz)", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("eu")),
				of(ISO, Locale.forLanguageTag("hr")),
				of(ISO, Locale.forLanguageTag("mn")),
				of(ISO, Locale.forLanguageTag("uz-Cyrl")),
				});
		TIME_FULL_PATTERNS.put("a 'ga' h:mm:ss zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ee")),
				});
		TIME_FULL_PATTERNS.put("zzzz ah:mm:ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("zh-Hans-HK")),
				of(ISO, Locale.forLanguageTag("zh-Hans-MO")),
				of(ISO, Locale.forLanguageTag("zh-Hans-SG")),
				});
		TIME_FULL_PATTERNS.put("a h:mm:ss zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("brx")),
				of(ISO, Locale.forLanguageTag("ks-Deva")),
				of(ISO, Locale.forLanguageTag("ta")),
				});
		TIME_FULL_PATTERNS.put("HH:mm:ss, zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("be-TARASK")),
				});
		TIME_FULL_PATTERNS.put("h:mm:ss a, zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("sq")),
				});
		TIME_FULL_PATTERNS.put("H:mm:ss 'ч'. zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bg")),
				});
		TIME_FULL_PATTERNS.put("Bh:mm:ss [zzzz]", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("zh-Hant")),
				});
		TIME_FULL_PATTERNS.put("hh:mm:ss a zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("gu")),
				of(ISO, Locale.forLanguageTag("kn")),
				});
		TIME_FULL_PATTERNS.put("HH 'h' mm 'min' ss 's' zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fr-CA")),
				});
		TIME_FULL_PATTERNS.put("H時mm分ss秒 zzzz", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ja")),
				});
		TIME_LONG_PATTERNS.put("HH:mm:ss z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af")),
				of(ISO, Locale.forLanguageTag("agq")),
				of(ISO, Locale.forLanguageTag("ar-KM")),
				of(ISO, Locale.forLanguageTag("ar-MA")),
				of(ISO, Locale.forLanguageTag("asa")),
				of(ISO, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("az")),
				of(ISO, Locale.forLanguageTag("az-Cyrl")),
				of(ISO, Locale.forLanguageTag("bas")),
				of(ISO, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("be-TARASK")),
				of(ISO, Locale.forLanguageTag("bez")),
				of(ISO, Locale.forLanguageTag("bm")),
				of(ISO, Locale.forLanguageTag("bo")),
				of(ISO, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("bs")),
				of(ISO, Locale.forLanguageTag("bs-Cyrl")),
				of(ISO, Locale.forLanguageTag("cgg")),
				of(ISO, Locale.forLanguageTag("ckb-IR")),
				of(ISO, Locale.forLanguageTag("cv")),
				of(ISO, Locale.forLanguageTag("cy")),
				of(ISO, Locale.forLanguageTag("dav")),
				of(ISO, Locale.forLanguageTag("de")),
				of(ISO, Locale.forLanguageTag("dje")),
				of(ISO, Locale.forLanguageTag("dua")),
				of(ISO, Locale.forLanguageTag("dyo")),
				of(ISO, Locale.forLanguageTag("ebu")),
				of(ISO, Locale.forLanguageTag("ee-TG")),
				of(ISO, Locale.forLanguageTag("en-150")),
				of(ISO, Locale.forLanguageTag("en-AI")),
				of(ISO, Locale.forLanguageTag("en-BI")),
				of(ISO, Locale.forLanguageTag("en-BW")),
				of(ISO, Locale.forLanguageTag("en-BZ")),
				of(ISO, Locale.forLanguageTag("en-CC")),
				of(ISO, Locale.forLanguageTag("en-CK")),
				of(ISO, Locale.forLanguageTag("en-CM")),
				of(ISO, Locale.forLanguageTag("en-CX")),
				of(ISO, Locale.forLanguageTag("en-DG")),
				of(ISO, Locale.forLanguageTag("en-FK")),
				of(ISO, Locale.forLanguageTag("en-GB")),
				of(ISO, Locale.forLanguageTag("en-GG")),
				of(ISO, Locale.forLanguageTag("en-GI")),
				of(ISO, Locale.forLanguageTag("en-IE")),
				of(ISO, Locale.forLanguageTag("en-IM")),
				of(ISO, Locale.forLanguageTag("en-IO")),
				of(ISO, Locale.forLanguageTag("en-JE")),
				of(ISO, Locale.forLanguageTag("en-KE")),
				of(ISO, Locale.forLanguageTag("en-MG")),
				of(ISO, Locale.forLanguageTag("en-MS")),
				of(ISO, Locale.forLanguageTag("en-MT")),
				of(ISO, Locale.forLanguageTag("en-MU")),
				of(ISO, Locale.forLanguageTag("en-MV")),
				of(ISO, Locale.forLanguageTag("en-NF")),
				of(ISO, Locale.forLanguageTag("en-NG")),
				of(ISO, Locale.forLanguageTag("en-NR")),
				of(ISO, Locale.forLanguageTag("en-NU")),
				of(ISO, Locale.forLanguageTag("en-PN")),
				of(ISO, Locale.forLanguageTag("en-RW")),
				of(ISO, Locale.forLanguageTag("en-SC")),
				of(ISO, Locale.forLanguageTag("en-SH")),
				of(ISO, Locale.forLanguageTag("en-SX")),
				of(ISO, Locale.forLanguageTag("en-TK")),
				of(ISO, Locale.forLanguageTag("en-TV")),
				of(ISO, Locale.forLanguageTag("en-TZ")),
				of(ISO, Locale.forLanguageTag("en-UG")),
				of(ISO, Locale.forLanguageTag("en-ZA")),
				of(ISO, Locale.forLanguageTag("en-ZW")),
				of(ISO, Locale.forLanguageTag("eo")),
				of(ISO, Locale.forLanguageTag("es-419")),
				of(ISO, Locale.forLanguageTag("es-MX")),
				of(ISO, Locale.forLanguageTag("et")),
				of(ISO, Locale.forLanguageTag("ewo")),
				of(ISO, Locale.forLanguageTag("ff")),
				of(ISO, Locale.forLanguageTag("ff-Adlm")),
				of(ISO, Locale.forLanguageTag("fo")),
				of(ISO, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("frr")),
				of(ISO, Locale.forLanguageTag("fur")),
				of(ISO, Locale.forLanguageTag("fy")),
				of(ISO, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("gd")),
				of(ISO, Locale.forLanguageTag("gl")),
				of(ISO, Locale.forLanguageTag("gsw")),
				of(ISO, Locale.forLanguageTag("guz")),
				of(ISO, Locale.forLanguageTag("gv")),
				of(ISO, Locale.forLanguageTag("ha")),
				of(ISO, Locale.forLanguageTag("hr")),
				of(ISO, Locale.forLanguageTag("hy")),
				of(ISO, Locale.forLanguageTag("ia")),
				of(ISO, Locale.forLanguageTag("ig")),
				of(ISO, Locale.forLanguageTag("ii")),
				of(ISO, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("it")),
				of(ISO, Locale.forLanguageTag("jgo")),
				of(ISO, Locale.forLanguageTag("jmc")),
				of(ISO, Locale.forLanguageTag("jv")),
				of(ISO, Locale.forLanguageTag("ka")),
				of(ISO, Locale.forLanguageTag("kam")),
				of(ISO, Locale.forLanguageTag("kde")),
				of(ISO, Locale.forLanguageTag("kea")),
				of(ISO, Locale.forLanguageTag("kgp")),
				of(ISO, Locale.forLanguageTag("khq")),
				of(ISO, Locale.forLanguageTag("ki")),
				of(ISO, Locale.forLanguageTag("kk")),
				of(ISO, Locale.forLanguageTag("kln")),
				of(ISO, Locale.forLanguageTag("ksb")),
				of(ISO, Locale.forLanguageTag("ksf")),
				of(ISO, Locale.forLanguageTag("ksh")),
				of(ISO, Locale.forLanguageTag("kw")),
				of(ISO, Locale.forLanguageTag("ky")),
				of(ISO, Locale.forLanguageTag("lag")),
				of(ISO, Locale.forLanguageTag("lb")),
				of(ISO, Locale.forLanguageTag("lg")),
				of(ISO, Locale.forLanguageTag("ln")),
				of(ISO, Locale.forLanguageTag("lrc")),
				of(ISO, Locale.forLanguageTag("lt")),
				of(ISO, Locale.forLanguageTag("lu")),
				of(ISO, Locale.forLanguageTag("luo")),
				of(ISO, Locale.forLanguageTag("luy")),
				of(ISO, Locale.forLanguageTag("lv")),
				of(ISO, Locale.forLanguageTag("mas")),
				of(ISO, Locale.forLanguageTag("mer")),
				of(ISO, Locale.forLanguageTag("mfe")),
				of(ISO, Locale.forLanguageTag("mg")),
				of(ISO, Locale.forLanguageTag("mgh")),
				of(ISO, Locale.forLanguageTag("mgo")),
				of(ISO, Locale.forLanguageTag("mk")),
				of(ISO, Locale.forLanguageTag("mt")),
				of(ISO, Locale.forLanguageTag("mua")),
				of(ISO, Locale.forLanguageTag("nd")),
				of(ISO, Locale.forLanguageTag("ne")),
				of(ISO, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("nmg")),
				of(ISO, Locale.forLanguageTag("nn")),
				of(ISO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("nyn")),
				of(ISO, Locale.forLanguageTag("om-KE")),
				of(ISO, Locale.forLanguageTag("os")),
				of(ISO, Locale.forLanguageTag("pl")),
				of(ISO, Locale.forLanguageTag("pt")),
				of(ISO, Locale.forLanguageTag("pt-PT")),
				of(ISO, Locale.forLanguageTag("qu")),
				of(ISO, Locale.forLanguageTag("rm")),
				of(ISO, Locale.forLanguageTag("rn")),
				of(ISO, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("rof")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("")),
				of(HIJRAH_UMALQURA, Locale.forLanguageTag("")),
				of(JAPANESE, Locale.forLanguageTag("")),
				of(MINGUO, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("ru")),
				of(ISO, Locale.forLanguageTag("rw")),
				of(ISO, Locale.forLanguageTag("rwk")),
				of(ISO, Locale.forLanguageTag("sah")),
				of(ISO, Locale.forLanguageTag("saq")),
				of(ISO, Locale.forLanguageTag("sbp")),
				of(ISO, Locale.forLanguageTag("sc")),
				of(ISO, Locale.forLanguageTag("se")),
				of(ISO, Locale.forLanguageTag("seh")),
				of(ISO, Locale.forLanguageTag("ses")),
				of(ISO, Locale.forLanguageTag("sg")),
				of(ISO, Locale.forLanguageTag("sl")),
				of(ISO, Locale.forLanguageTag("sn")),
				of(ISO, Locale.forLanguageTag("so-KE")),
				of(ISO, Locale.forLanguageTag("sq-MK")),
				of(ISO, Locale.forLanguageTag("sq-XK")),
				of(ISO, Locale.forLanguageTag("sr")),
				of(ISO, Locale.forLanguageTag("sr-Latn")),
				of(ISO, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sw")),
				of(ISO, Locale.forLanguageTag("sw-KE")),
				of(ISO, Locale.forLanguageTag("ta-LK")),
				of(ISO, Locale.forLanguageTag("teo")),
				of(ISO, Locale.forLanguageTag("tg")),
				of(ISO, Locale.forLanguageTag("tk")),
				of(ISO, Locale.forLanguageTag("tr")),
				of(ISO, Locale.forLanguageTag("twq")),
				of(ISO, Locale.forLanguageTag("ug")),
				of(ISO, Locale.forLanguageTag("uk")),
				of(ISO, Locale.forLanguageTag("vi")),
				of(ISO, Locale.forLanguageTag("vun")),
				of(ISO, Locale.forLanguageTag("wo")),
				of(ISO, Locale.forLanguageTag("xh")),
				of(ISO, Locale.forLanguageTag("xog")),
				of(ISO, Locale.forLanguageTag("yav")),
				of(ISO, Locale.forLanguageTag("yi")),
				of(ISO, Locale.forLanguageTag("yrl")),
				of(ISO, Locale.forLanguageTag("zgh")),
				of(ISO, Locale.forLanguageTag("zu")),
				});
		TIME_LONG_PATTERNS.put("H ໂມງ m ນາທີ ss ວິນາທີ z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("lo")),
				});
		TIME_LONG_PATTERNS.put("h:mm:ss a, z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("sq")),
				});
		TIME_LONG_PATTERNS.put("HH:mm:ss (z)", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("eu")),
				of(ISO, Locale.forLanguageTag("mn")),
				of(ISO, Locale.forLanguageTag("uz-Cyrl")),
				});
		TIME_LONG_PATTERNS.put("a 'ga' h:mm:ss z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ee")),
				});
		TIME_LONG_PATTERNS.put("H:mm:ss z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ar-IL")),
				of(ISO, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("dsb")),
				of(ISO, Locale.forLanguageTag("en-IL")),
				of(ISO, Locale.forLanguageTag("es")),
				of(ISO, Locale.forLanguageTag("he")),
				of(ISO, Locale.forLanguageTag("hsb")),
				of(ISO, Locale.forLanguageTag("hu")),
				of(ISO, Locale.forLanguageTag("ja")),
				of(ISO, Locale.forLanguageTag("oc-ES")),
				of(ISO, Locale.forLanguageTag("pcm")),
				of(ISO, Locale.forLanguageTag("sk")),
				of(ISO, Locale.forLanguageTag("tt")),
				of(ISO, Locale.forLanguageTag("yo")),
				});
		TIME_LONG_PATTERNS.put("H:mm:ss 'ч'. z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bg")),
				});
		TIME_LONG_PATTERNS.put("a h:mm:ss z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("brx")),
				of(ISO, Locale.forLanguageTag("ks-Deva")),
				of(ISO, Locale.forLanguageTag("ta")),
				});
		TIME_LONG_PATTERNS.put("H.mm.ss z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("en-FI")),
				of(ISO, Locale.forLanguageTag("fi")),
				of(ISO, Locale.forLanguageTag("smn")),
				of(ISO, Locale.forLanguageTag("su")),
				});
		TIME_LONG_PATTERNS.put("h:mm:ss a z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("ar")),
				of(ISO, Locale.forLanguageTag("bgc")),
				of(ISO, Locale.forLanguageTag("bho")),
				of(ISO, Locale.forLanguageTag("bn")),
				of(ISO, Locale.forLanguageTag("bo-IN")),
				of(ISO, Locale.forLanguageTag("ccp")),
				of(ISO, Locale.forLanguageTag("chr")),
				of(ISO, Locale.forLanguageTag("ckb")),
				of(ISO, Locale.forLanguageTag("doi")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-GH")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-GM")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-LR")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-MR")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-SL")),
				of(ISO, Locale.forLanguageTag("hi")),
				of(ISO, Locale.forLanguageTag("km")),
				of(ISO, Locale.forLanguageTag("kok")),
				of(ISO, Locale.forLanguageTag("ks")),
				of(ISO, Locale.forLanguageTag("lrc-IQ")),
				of(ISO, Locale.forLanguageTag("mai")),
				of(ISO, Locale.forLanguageTag("ml")),
				of(ISO, Locale.forLanguageTag("mni")),
				of(ISO, Locale.forLanguageTag("mr")),
				of(ISO, Locale.forLanguageTag("ne-IN")),
				of(ISO, Locale.forLanguageTag("or")),
				of(ISO, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pa-Arab")),
				of(ISO, Locale.forLanguageTag("ps-PK")),
				of(ISO, Locale.forLanguageTag("raj")),
				of(ISO, Locale.forLanguageTag("sa")),
				of(ISO, Locale.forLanguageTag("sat")),
				of(ISO, Locale.forLanguageTag("sd")),
				of(ISO, Locale.forLanguageTag("sd-Deva")),
				of(ISO, Locale.forLanguageTag("te")),
				of(ISO, Locale.forLanguageTag("ti")),
				of(ISO, Locale.forLanguageTag("ur")),
				of(ISO, Locale.forLanguageTag("vai")),
				});
		TIME_LONG_PATTERNS.put("a h.mm.ss z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("as")),
				});
		TIME_LONG_PATTERNS.put("hh:mm:ss a z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("gu")),
				of(ISO, Locale.forLanguageTag("kn")),
				});
		TIME_LONG_PATTERNS.put("z ah:mm:ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("zh-Hans-HK")),
				of(ISO, Locale.forLanguageTag("zh-Hans-MO")),
				of(ISO, Locale.forLanguageTag("zh-Hans-SG")),
				});
		TIME_LONG_PATTERNS.put("Bh:mm:ss [z]", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("zh-Hant")),
				});
		TIME_LONG_PATTERNS.put("'Klock' H.mm:ss (z)", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nds")),
				});
		TIME_LONG_PATTERNS.put("z HH:mm:ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("my")),
				of(ISO, Locale.forLanguageTag("yue-Hans")),
				of(ISO, Locale.forLanguageTag("zh")),
				});
		TIME_LONG_PATTERNS.put("HH 'h' mm 'min' ss 's' z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fr-CA")),
				});
		TIME_LONG_PATTERNS.put("ah:mm:ss [z]", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yue")),
				of(ISO, Locale.forLanguageTag("zh-Hant-HK")),
				});
		TIME_LONG_PATTERNS.put("H นาฬิกา mm นาที ss วินาที z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("th")),
				});
		TIME_LONG_PATTERNS.put("a h시 m분 s초 z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ko")),
				});
		TIME_LONG_PATTERNS.put("HH.mm.ss z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("da")),
				of(ISO, Locale.forLanguageTag("en-DK")),
				of(ISO, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("kl")),
				of(ISO, Locale.forLanguageTag("ms-ID")),
				of(ISO, Locale.forLanguageTag("si")),
				});
		TIME_LONG_PATTERNS.put("h:mm:ss a z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af-NA")),
				of(ISO, Locale.forLanguageTag("ak")),
				of(ISO, Locale.forLanguageTag("bem")),
				of(ISO, Locale.forLanguageTag("ceb")),
				of(ISO, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("en")),
				of(ISO, Locale.forLanguageTag("en-AU")),
				of(ISO, Locale.forLanguageTag("en-CA")),
				of(ISO, Locale.forLanguageTag("en-IN")),
				of(ISO, Locale.forLanguageTag("es-CO")),
				of(ISO, Locale.forLanguageTag("es-DO")),
				of(ISO, Locale.forLanguageTag("es-PA")),
				of(ISO, Locale.forLanguageTag("es-PH")),
				of(ISO, Locale.forLanguageTag("es-PR")),
				of(ISO, Locale.forLanguageTag("es-US")),
				of(ISO, Locale.forLanguageTag("es-VE")),
				of(ISO, Locale.forLanguageTag("ff-Latn-GH")),
				of(ISO, Locale.forLanguageTag("ff-Latn-GM")),
				of(ISO, Locale.forLanguageTag("ff-Latn-LR")),
				of(ISO, Locale.forLanguageTag("ff-Latn-MR")),
				of(ISO, Locale.forLanguageTag("ff-Latn-SL")),
				of(ISO, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("fr-DJ")),
				of(ISO, Locale.forLanguageTag("fr-DZ")),
				of(ISO, Locale.forLanguageTag("fr-MR")),
				of(ISO, Locale.forLanguageTag("fr-SY")),
				of(ISO, Locale.forLanguageTag("fr-TD")),
				of(ISO, Locale.forLanguageTag("fr-TN")),
				of(ISO, Locale.forLanguageTag("fr-VU")),
				of(ISO, Locale.forLanguageTag("ha-GH")),
				of(ISO, Locale.forLanguageTag("haw")),
				of(ISO, Locale.forLanguageTag("hi-Latn")),
				of(ISO, Locale.forLanguageTag("kab")),
				of(ISO, Locale.forLanguageTag("lkt")),
				of(ISO, Locale.forLanguageTag("mi")),
				of(ISO, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("naq")),
				of(ISO, Locale.forLanguageTag("om")),
				of(ISO, Locale.forLanguageTag("pt-MO")),
				of(ISO, Locale.forLanguageTag("so")),
				of(ISO, Locale.forLanguageTag("to")),
				of(ISO, Locale.forLanguageTag("tr-CY")),
				of(ISO, Locale.forLanguageTag("vai-Latn")),
				of(ISO, Locale.forLanguageTag("yrl-CO")),
				of(ISO, Locale.forLanguageTag("yrl-VE")),
				});
		TIME_LONG_PATTERNS.put("ཆུ་ཚོད་ h སྐར་མ་ mm:ss a z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("dz")),
				});
		TIME_LONG_PATTERNS.put("H'h'mm:ss z", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("oc")),
				});
		TIME_LONG_PATTERNS.put("z h:mm:ss a", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nus")),
				});
		TIME_LONG_PATTERNS.put("H:mm:ss (z)", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fa")),
				of(ISO, Locale.forLanguageTag("ps")),
				of(ISO, Locale.forLanguageTag("uz")),
				of(ISO, Locale.forLanguageTag("uz-Arab")),
				});
		TIME_MEDIUM_PATTERNS.put("HH:mm:ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af")),
				of(ISO, Locale.forLanguageTag("agq")),
				of(ISO, Locale.forLanguageTag("ar-KM")),
				of(ISO, Locale.forLanguageTag("ar-MA")),
				of(ISO, Locale.forLanguageTag("asa")),
				of(ISO, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("az")),
				of(ISO, Locale.forLanguageTag("az-Cyrl")),
				of(ISO, Locale.forLanguageTag("bas")),
				of(ISO, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("be-TARASK")),
				of(ISO, Locale.forLanguageTag("bez")),
				of(ISO, Locale.forLanguageTag("bm")),
				of(ISO, Locale.forLanguageTag("bo")),
				of(ISO, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("bs")),
				of(ISO, Locale.forLanguageTag("bs-Cyrl")),
				of(ISO, Locale.forLanguageTag("cgg")),
				of(ISO, Locale.forLanguageTag("ckb-IR")),
				of(ISO, Locale.forLanguageTag("cv")),
				of(ISO, Locale.forLanguageTag("cy")),
				of(ISO, Locale.forLanguageTag("dav")),
				of(ISO, Locale.forLanguageTag("de")),
				of(ISO, Locale.forLanguageTag("dje")),
				of(ISO, Locale.forLanguageTag("dua")),
				of(ISO, Locale.forLanguageTag("dyo")),
				of(ISO, Locale.forLanguageTag("ebu")),
				of(ISO, Locale.forLanguageTag("ee-TG")),
				of(ISO, Locale.forLanguageTag("en-150")),
				of(ISO, Locale.forLanguageTag("en-AI")),
				of(ISO, Locale.forLanguageTag("en-BI")),
				of(ISO, Locale.forLanguageTag("en-BW")),
				of(ISO, Locale.forLanguageTag("en-BZ")),
				of(ISO, Locale.forLanguageTag("en-CC")),
				of(ISO, Locale.forLanguageTag("en-CK")),
				of(ISO, Locale.forLanguageTag("en-CM")),
				of(ISO, Locale.forLanguageTag("en-CX")),
				of(ISO, Locale.forLanguageTag("en-DG")),
				of(ISO, Locale.forLanguageTag("en-FK")),
				of(ISO, Locale.forLanguageTag("en-GB")),
				of(ISO, Locale.forLanguageTag("en-GG")),
				of(ISO, Locale.forLanguageTag("en-GI")),
				of(ISO, Locale.forLanguageTag("en-IE")),
				of(ISO, Locale.forLanguageTag("en-IM")),
				of(ISO, Locale.forLanguageTag("en-IO")),
				of(ISO, Locale.forLanguageTag("en-JE")),
				of(ISO, Locale.forLanguageTag("en-KE")),
				of(ISO, Locale.forLanguageTag("en-MG")),
				of(ISO, Locale.forLanguageTag("en-MS")),
				of(ISO, Locale.forLanguageTag("en-MT")),
				of(ISO, Locale.forLanguageTag("en-MU")),
				of(ISO, Locale.forLanguageTag("en-MV")),
				of(ISO, Locale.forLanguageTag("en-NF")),
				of(ISO, Locale.forLanguageTag("en-NG")),
				of(ISO, Locale.forLanguageTag("en-NR")),
				of(ISO, Locale.forLanguageTag("en-NU")),
				of(ISO, Locale.forLanguageTag("en-PN")),
				of(ISO, Locale.forLanguageTag("en-RW")),
				of(ISO, Locale.forLanguageTag("en-SC")),
				of(ISO, Locale.forLanguageTag("en-SH")),
				of(ISO, Locale.forLanguageTag("en-SX")),
				of(ISO, Locale.forLanguageTag("en-TK")),
				of(ISO, Locale.forLanguageTag("en-TV")),
				of(ISO, Locale.forLanguageTag("en-TZ")),
				of(ISO, Locale.forLanguageTag("en-UG")),
				of(ISO, Locale.forLanguageTag("en-ZA")),
				of(ISO, Locale.forLanguageTag("en-ZW")),
				of(ISO, Locale.forLanguageTag("eo")),
				of(ISO, Locale.forLanguageTag("es-419")),
				of(ISO, Locale.forLanguageTag("es-MX")),
				of(ISO, Locale.forLanguageTag("et")),
				of(ISO, Locale.forLanguageTag("eu")),
				of(ISO, Locale.forLanguageTag("ewo")),
				of(ISO, Locale.forLanguageTag("ff")),
				of(ISO, Locale.forLanguageTag("ff-Adlm")),
				of(ISO, Locale.forLanguageTag("fo")),
				of(ISO, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("frr")),
				of(ISO, Locale.forLanguageTag("fur")),
				of(ISO, Locale.forLanguageTag("fy")),
				of(ISO, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("gd")),
				of(ISO, Locale.forLanguageTag("gl")),
				of(ISO, Locale.forLanguageTag("gsw")),
				of(ISO, Locale.forLanguageTag("guz")),
				of(ISO, Locale.forLanguageTag("gv")),
				of(ISO, Locale.forLanguageTag("ha")),
				of(ISO, Locale.forLanguageTag("hr")),
				of(ISO, Locale.forLanguageTag("hy")),
				of(ISO, Locale.forLanguageTag("ia")),
				of(ISO, Locale.forLanguageTag("ig")),
				of(ISO, Locale.forLanguageTag("ii")),
				of(ISO, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("it")),
				of(ISO, Locale.forLanguageTag("jgo")),
				of(ISO, Locale.forLanguageTag("jmc")),
				of(ISO, Locale.forLanguageTag("jv")),
				of(ISO, Locale.forLanguageTag("ka")),
				of(ISO, Locale.forLanguageTag("kam")),
				of(ISO, Locale.forLanguageTag("kde")),
				of(ISO, Locale.forLanguageTag("kea")),
				of(ISO, Locale.forLanguageTag("kgp")),
				of(ISO, Locale.forLanguageTag("khq")),
				of(ISO, Locale.forLanguageTag("ki")),
				of(ISO, Locale.forLanguageTag("kk")),
				of(ISO, Locale.forLanguageTag("kkj")),
				of(ISO, Locale.forLanguageTag("kln")),
				of(ISO, Locale.forLanguageTag("ksb")),
				of(ISO, Locale.forLanguageTag("ksf")),
				of(ISO, Locale.forLanguageTag("ksh")),
				of(ISO, Locale.forLanguageTag("kw")),
				of(ISO, Locale.forLanguageTag("ky")),
				of(ISO, Locale.forLanguageTag("lag")),
				of(ISO, Locale.forLanguageTag("lb")),
				of(ISO, Locale.forLanguageTag("lg")),
				of(ISO, Locale.forLanguageTag("ln")),
				of(ISO, Locale.forLanguageTag("lrc")),
				of(ISO, Locale.forLanguageTag("lt")),
				of(ISO, Locale.forLanguageTag("lu")),
				of(ISO, Locale.forLanguageTag("luo")),
				of(ISO, Locale.forLanguageTag("luy")),
				of(ISO, Locale.forLanguageTag("lv")),
				of(ISO, Locale.forLanguageTag("mas")),
				of(ISO, Locale.forLanguageTag("mer")),
				of(ISO, Locale.forLanguageTag("mfe")),
				of(ISO, Locale.forLanguageTag("mg")),
				of(ISO, Locale.forLanguageTag("mgh")),
				of(ISO, Locale.forLanguageTag("mgo")),
				of(ISO, Locale.forLanguageTag("mk")),
				of(ISO, Locale.forLanguageTag("mn")),
				of(ISO, Locale.forLanguageTag("mt")),
				of(ISO, Locale.forLanguageTag("mua")),
				of(ISO, Locale.forLanguageTag("nd")),
				of(ISO, Locale.forLanguageTag("ne")),
				of(ISO, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("nmg")),
				of(ISO, Locale.forLanguageTag("nn")),
				of(ISO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("nyn")),
				of(ISO, Locale.forLanguageTag("om-KE")),
				of(ISO, Locale.forLanguageTag("os")),
				of(ISO, Locale.forLanguageTag("pcm")),
				of(ISO, Locale.forLanguageTag("pl")),
				of(ISO, Locale.forLanguageTag("pt")),
				of(ISO, Locale.forLanguageTag("pt-PT")),
				of(ISO, Locale.forLanguageTag("qu")),
				of(ISO, Locale.forLanguageTag("rm")),
				of(ISO, Locale.forLanguageTag("rn")),
				of(ISO, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("rof")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("")),
				of(HIJRAH_UMALQURA, Locale.forLanguageTag("")),
				of(JAPANESE, Locale.forLanguageTag("")),
				of(MINGUO, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("ru")),
				of(ISO, Locale.forLanguageTag("rw")),
				of(ISO, Locale.forLanguageTag("rwk")),
				of(ISO, Locale.forLanguageTag("sah")),
				of(ISO, Locale.forLanguageTag("saq")),
				of(ISO, Locale.forLanguageTag("sbp")),
				of(ISO, Locale.forLanguageTag("sc")),
				of(ISO, Locale.forLanguageTag("se")),
				of(ISO, Locale.forLanguageTag("seh")),
				of(ISO, Locale.forLanguageTag("ses")),
				of(ISO, Locale.forLanguageTag("sg")),
				of(ISO, Locale.forLanguageTag("sl")),
				of(ISO, Locale.forLanguageTag("sn")),
				of(ISO, Locale.forLanguageTag("so-KE")),
				of(ISO, Locale.forLanguageTag("sq-MK")),
				of(ISO, Locale.forLanguageTag("sq-XK")),
				of(ISO, Locale.forLanguageTag("sr")),
				of(ISO, Locale.forLanguageTag("sr-Latn")),
				of(ISO, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sw")),
				of(ISO, Locale.forLanguageTag("sw-KE")),
				of(ISO, Locale.forLanguageTag("ta-LK")),
				of(ISO, Locale.forLanguageTag("teo")),
				of(ISO, Locale.forLanguageTag("tg")),
				of(ISO, Locale.forLanguageTag("th")),
				of(ISO, Locale.forLanguageTag("tk")),
				of(ISO, Locale.forLanguageTag("tr")),
				of(ISO, Locale.forLanguageTag("twq")),
				of(ISO, Locale.forLanguageTag("ug")),
				of(ISO, Locale.forLanguageTag("uk")),
				of(ISO, Locale.forLanguageTag("uz")),
				of(ISO, Locale.forLanguageTag("uz-Cyrl")),
				of(ISO, Locale.forLanguageTag("vi")),
				of(ISO, Locale.forLanguageTag("vun")),
				of(ISO, Locale.forLanguageTag("wo")),
				of(ISO, Locale.forLanguageTag("xh")),
				of(ISO, Locale.forLanguageTag("xog")),
				of(ISO, Locale.forLanguageTag("yav")),
				of(ISO, Locale.forLanguageTag("yi")),
				of(ISO, Locale.forLanguageTag("yrl")),
				of(ISO, Locale.forLanguageTag("yue-Hans")),
				of(ISO, Locale.forLanguageTag("zgh")),
				of(ISO, Locale.forLanguageTag("zh")),
				of(ISO, Locale.forLanguageTag("zu")),
				});
		TIME_MEDIUM_PATTERNS.put("ah:mm:ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yue")),
				of(ISO, Locale.forLanguageTag("zh-Hans-HK")),
				of(ISO, Locale.forLanguageTag("zh-Hans-MO")),
				of(ISO, Locale.forLanguageTag("zh-Hans-SG")),
				of(ISO, Locale.forLanguageTag("zh-Hant-HK")),
				});
		TIME_MEDIUM_PATTERNS.put("H:mm:ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ar-IL")),
				of(ISO, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("dsb")),
				of(ISO, Locale.forLanguageTag("en-IL")),
				of(ISO, Locale.forLanguageTag("es")),
				of(ISO, Locale.forLanguageTag("fa")),
				of(ISO, Locale.forLanguageTag("he")),
				of(ISO, Locale.forLanguageTag("hsb")),
				of(ISO, Locale.forLanguageTag("hu")),
				of(ISO, Locale.forLanguageTag("ja")),
				of(ISO, Locale.forLanguageTag("lo")),
				of(ISO, Locale.forLanguageTag("my")),
				of(ISO, Locale.forLanguageTag("oc-ES")),
				of(ISO, Locale.forLanguageTag("ps")),
				of(ISO, Locale.forLanguageTag("sk")),
				of(ISO, Locale.forLanguageTag("tt")),
				of(ISO, Locale.forLanguageTag("uz-Arab")),
				});
		TIME_MEDIUM_PATTERNS.put("a h.mm.ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("as")),
				});
		TIME_MEDIUM_PATTERNS.put("HH.mm.ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("da")),
				of(ISO, Locale.forLanguageTag("en-DK")),
				of(ISO, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("kl")),
				of(ISO, Locale.forLanguageTag("ms-ID")),
				of(ISO, Locale.forLanguageTag("si")),
				});
		TIME_MEDIUM_PATTERNS.put("H:m:s", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yo")),
				});
		TIME_MEDIUM_PATTERNS.put("Bh:mm:ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("zh-Hant")),
				});
		TIME_MEDIUM_PATTERNS.put("H'h'mm:ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("oc")),
				});
		TIME_MEDIUM_PATTERNS.put("h:mm:ss a", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("ar")),
				of(ISO, Locale.forLanguageTag("bgc")),
				of(ISO, Locale.forLanguageTag("bho")),
				of(ISO, Locale.forLanguageTag("bn")),
				of(ISO, Locale.forLanguageTag("bo-IN")),
				of(ISO, Locale.forLanguageTag("ccp")),
				of(ISO, Locale.forLanguageTag("chr")),
				of(ISO, Locale.forLanguageTag("ckb")),
				of(ISO, Locale.forLanguageTag("doi")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-GH")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-GM")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-LR")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-MR")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-SL")),
				of(ISO, Locale.forLanguageTag("hi")),
				of(ISO, Locale.forLanguageTag("km")),
				of(ISO, Locale.forLanguageTag("kok")),
				of(ISO, Locale.forLanguageTag("ks")),
				of(ISO, Locale.forLanguageTag("lrc-IQ")),
				of(ISO, Locale.forLanguageTag("mai")),
				of(ISO, Locale.forLanguageTag("ml")),
				of(ISO, Locale.forLanguageTag("mni")),
				of(ISO, Locale.forLanguageTag("mr")),
				of(ISO, Locale.forLanguageTag("ne-IN")),
				of(ISO, Locale.forLanguageTag("or")),
				of(ISO, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pa-Arab")),
				of(ISO, Locale.forLanguageTag("ps-PK")),
				of(ISO, Locale.forLanguageTag("raj")),
				of(ISO, Locale.forLanguageTag("sa")),
				of(ISO, Locale.forLanguageTag("sat")),
				of(ISO, Locale.forLanguageTag("sd")),
				of(ISO, Locale.forLanguageTag("sd-Deva")),
				of(ISO, Locale.forLanguageTag("te")),
				of(ISO, Locale.forLanguageTag("ti")),
				of(ISO, Locale.forLanguageTag("ur")),
				of(ISO, Locale.forLanguageTag("vai")),
				});
		TIME_MEDIUM_PATTERNS.put("a h:mm:ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("brx")),
				of(ISO, Locale.forLanguageTag("ko")),
				of(ISO, Locale.forLanguageTag("ks-Deva")),
				of(ISO, Locale.forLanguageTag("ta")),
				});
		TIME_MEDIUM_PATTERNS.put("'Klock' H.mm:ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nds")),
				});
		TIME_MEDIUM_PATTERNS.put("hh:mm:ss a", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("gu")),
				of(ISO, Locale.forLanguageTag("kn")),
				});
		TIME_MEDIUM_PATTERNS.put("a 'ga' h:mm:ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ee")),
				});
		TIME_MEDIUM_PATTERNS.put("h:mm:ss a", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af-NA")),
				of(ISO, Locale.forLanguageTag("ak")),
				of(ISO, Locale.forLanguageTag("bem")),
				of(ISO, Locale.forLanguageTag("ceb")),
				of(ISO, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("en")),
				of(ISO, Locale.forLanguageTag("en-AU")),
				of(ISO, Locale.forLanguageTag("en-CA")),
				of(ISO, Locale.forLanguageTag("en-IN")),
				of(ISO, Locale.forLanguageTag("es-CO")),
				of(ISO, Locale.forLanguageTag("es-DO")),
				of(ISO, Locale.forLanguageTag("es-PA")),
				of(ISO, Locale.forLanguageTag("es-PH")),
				of(ISO, Locale.forLanguageTag("es-PR")),
				of(ISO, Locale.forLanguageTag("es-US")),
				of(ISO, Locale.forLanguageTag("es-VE")),
				of(ISO, Locale.forLanguageTag("ff-Latn-GH")),
				of(ISO, Locale.forLanguageTag("ff-Latn-GM")),
				of(ISO, Locale.forLanguageTag("ff-Latn-LR")),
				of(ISO, Locale.forLanguageTag("ff-Latn-MR")),
				of(ISO, Locale.forLanguageTag("ff-Latn-SL")),
				of(ISO, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("fr-DJ")),
				of(ISO, Locale.forLanguageTag("fr-DZ")),
				of(ISO, Locale.forLanguageTag("fr-MR")),
				of(ISO, Locale.forLanguageTag("fr-SY")),
				of(ISO, Locale.forLanguageTag("fr-TD")),
				of(ISO, Locale.forLanguageTag("fr-TN")),
				of(ISO, Locale.forLanguageTag("fr-VU")),
				of(ISO, Locale.forLanguageTag("ha-GH")),
				of(ISO, Locale.forLanguageTag("haw")),
				of(ISO, Locale.forLanguageTag("hi-Latn")),
				of(ISO, Locale.forLanguageTag("kab")),
				of(ISO, Locale.forLanguageTag("lkt")),
				of(ISO, Locale.forLanguageTag("mi")),
				of(ISO, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("naq")),
				of(ISO, Locale.forLanguageTag("nus")),
				of(ISO, Locale.forLanguageTag("om")),
				of(ISO, Locale.forLanguageTag("pt-MO")),
				of(ISO, Locale.forLanguageTag("so")),
				of(ISO, Locale.forLanguageTag("sq")),
				of(ISO, Locale.forLanguageTag("to")),
				of(ISO, Locale.forLanguageTag("tr-CY")),
				of(ISO, Locale.forLanguageTag("vai-Latn")),
				of(ISO, Locale.forLanguageTag("yrl-CO")),
				of(ISO, Locale.forLanguageTag("yrl-VE")),
				});
		TIME_MEDIUM_PATTERNS.put("H.mm.ss", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("en-FI")),
				of(ISO, Locale.forLanguageTag("fi")),
				of(ISO, Locale.forLanguageTag("smn")),
				of(ISO, Locale.forLanguageTag("su")),
				});
		TIME_MEDIUM_PATTERNS.put("H:mm:ss 'ч'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bg")),
				});
		TIME_MEDIUM_PATTERNS.put("ཆུ་ཚོད་h:mm:ss a", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("dz")),
				});
		TIME_MEDIUM_PATTERNS.put("HH 'h' mm 'min' ss 's'", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fr-CA")),
				});
		TIME_SHORT_PATTERNS.put("HH:mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af")),
				of(ISO, Locale.forLanguageTag("agq")),
				of(ISO, Locale.forLanguageTag("ar-KM")),
				of(ISO, Locale.forLanguageTag("ar-MA")),
				of(ISO, Locale.forLanguageTag("asa")),
				of(ISO, Locale.forLanguageTag("ast")),
				of(ISO, Locale.forLanguageTag("az")),
				of(ISO, Locale.forLanguageTag("az-Cyrl")),
				of(ISO, Locale.forLanguageTag("bas")),
				of(ISO, Locale.forLanguageTag("be")),
				of(ISO, Locale.forLanguageTag("be-TARASK")),
				of(ISO, Locale.forLanguageTag("bez")),
				of(ISO, Locale.forLanguageTag("bm")),
				of(ISO, Locale.forLanguageTag("bo")),
				of(ISO, Locale.forLanguageTag("br")),
				of(ISO, Locale.forLanguageTag("bs")),
				of(ISO, Locale.forLanguageTag("bs-Cyrl")),
				of(ISO, Locale.forLanguageTag("cgg")),
				of(ISO, Locale.forLanguageTag("ckb-IR")),
				of(ISO, Locale.forLanguageTag("cv")),
				of(ISO, Locale.forLanguageTag("cy")),
				of(ISO, Locale.forLanguageTag("dav")),
				of(ISO, Locale.forLanguageTag("de")),
				of(ISO, Locale.forLanguageTag("dje")),
				of(ISO, Locale.forLanguageTag("dua")),
				of(ISO, Locale.forLanguageTag("dyo")),
				of(ISO, Locale.forLanguageTag("ebu")),
				of(ISO, Locale.forLanguageTag("ee-TG")),
				of(ISO, Locale.forLanguageTag("en-150")),
				of(ISO, Locale.forLanguageTag("en-AI")),
				of(ISO, Locale.forLanguageTag("en-BI")),
				of(ISO, Locale.forLanguageTag("en-BW")),
				of(ISO, Locale.forLanguageTag("en-BZ")),
				of(ISO, Locale.forLanguageTag("en-CC")),
				of(ISO, Locale.forLanguageTag("en-CK")),
				of(ISO, Locale.forLanguageTag("en-CM")),
				of(ISO, Locale.forLanguageTag("en-CX")),
				of(ISO, Locale.forLanguageTag("en-DG")),
				of(ISO, Locale.forLanguageTag("en-FK")),
				of(ISO, Locale.forLanguageTag("en-GB")),
				of(ISO, Locale.forLanguageTag("en-GG")),
				of(ISO, Locale.forLanguageTag("en-GI")),
				of(ISO, Locale.forLanguageTag("en-IE")),
				of(ISO, Locale.forLanguageTag("en-IM")),
				of(ISO, Locale.forLanguageTag("en-IO")),
				of(ISO, Locale.forLanguageTag("en-JE")),
				of(ISO, Locale.forLanguageTag("en-KE")),
				of(ISO, Locale.forLanguageTag("en-MG")),
				of(ISO, Locale.forLanguageTag("en-MS")),
				of(ISO, Locale.forLanguageTag("en-MT")),
				of(ISO, Locale.forLanguageTag("en-MU")),
				of(ISO, Locale.forLanguageTag("en-MV")),
				of(ISO, Locale.forLanguageTag("en-NF")),
				of(ISO, Locale.forLanguageTag("en-NG")),
				of(ISO, Locale.forLanguageTag("en-NR")),
				of(ISO, Locale.forLanguageTag("en-NU")),
				of(ISO, Locale.forLanguageTag("en-PN")),
				of(ISO, Locale.forLanguageTag("en-RW")),
				of(ISO, Locale.forLanguageTag("en-SC")),
				of(ISO, Locale.forLanguageTag("en-SH")),
				of(ISO, Locale.forLanguageTag("en-SX")),
				of(ISO, Locale.forLanguageTag("en-TK")),
				of(ISO, Locale.forLanguageTag("en-TV")),
				of(ISO, Locale.forLanguageTag("en-TZ")),
				of(ISO, Locale.forLanguageTag("en-UG")),
				of(ISO, Locale.forLanguageTag("en-ZA")),
				of(ISO, Locale.forLanguageTag("en-ZW")),
				of(ISO, Locale.forLanguageTag("eo")),
				of(ISO, Locale.forLanguageTag("es-419")),
				of(ISO, Locale.forLanguageTag("es-MX")),
				of(ISO, Locale.forLanguageTag("et")),
				of(ISO, Locale.forLanguageTag("eu")),
				of(ISO, Locale.forLanguageTag("ewo")),
				of(ISO, Locale.forLanguageTag("ff")),
				of(ISO, Locale.forLanguageTag("ff-Adlm")),
				of(ISO, Locale.forLanguageTag("fo")),
				of(ISO, Locale.forLanguageTag("fr")),
				of(ISO, Locale.forLanguageTag("frr")),
				of(ISO, Locale.forLanguageTag("fur")),
				of(ISO, Locale.forLanguageTag("fy")),
				of(ISO, Locale.forLanguageTag("ga")),
				of(ISO, Locale.forLanguageTag("gd")),
				of(ISO, Locale.forLanguageTag("gl")),
				of(ISO, Locale.forLanguageTag("gsw")),
				of(ISO, Locale.forLanguageTag("guz")),
				of(ISO, Locale.forLanguageTag("gv")),
				of(ISO, Locale.forLanguageTag("ha")),
				of(ISO, Locale.forLanguageTag("hr")),
				of(ISO, Locale.forLanguageTag("hy")),
				of(ISO, Locale.forLanguageTag("ia")),
				of(ISO, Locale.forLanguageTag("ig")),
				of(ISO, Locale.forLanguageTag("ii")),
				of(ISO, Locale.forLanguageTag("is")),
				of(ISO, Locale.forLanguageTag("it")),
				of(ISO, Locale.forLanguageTag("jgo")),
				of(ISO, Locale.forLanguageTag("jmc")),
				of(ISO, Locale.forLanguageTag("jv")),
				of(ISO, Locale.forLanguageTag("ka")),
				of(ISO, Locale.forLanguageTag("kam")),
				of(ISO, Locale.forLanguageTag("kde")),
				of(ISO, Locale.forLanguageTag("kea")),
				of(ISO, Locale.forLanguageTag("kgp")),
				of(ISO, Locale.forLanguageTag("khq")),
				of(ISO, Locale.forLanguageTag("ki")),
				of(ISO, Locale.forLanguageTag("kk")),
				of(ISO, Locale.forLanguageTag("kkj")),
				of(ISO, Locale.forLanguageTag("kln")),
				of(ISO, Locale.forLanguageTag("ksb")),
				of(ISO, Locale.forLanguageTag("ksf")),
				of(ISO, Locale.forLanguageTag("ksh")),
				of(ISO, Locale.forLanguageTag("kw")),
				of(ISO, Locale.forLanguageTag("ky")),
				of(ISO, Locale.forLanguageTag("lag")),
				of(ISO, Locale.forLanguageTag("lb")),
				of(ISO, Locale.forLanguageTag("lg")),
				of(ISO, Locale.forLanguageTag("ln")),
				of(ISO, Locale.forLanguageTag("lrc")),
				of(ISO, Locale.forLanguageTag("lt")),
				of(ISO, Locale.forLanguageTag("lu")),
				of(ISO, Locale.forLanguageTag("luo")),
				of(ISO, Locale.forLanguageTag("luy")),
				of(ISO, Locale.forLanguageTag("lv")),
				of(ISO, Locale.forLanguageTag("mas")),
				of(ISO, Locale.forLanguageTag("mer")),
				of(ISO, Locale.forLanguageTag("mfe")),
				of(ISO, Locale.forLanguageTag("mg")),
				of(ISO, Locale.forLanguageTag("mgh")),
				of(ISO, Locale.forLanguageTag("mgo")),
				of(ISO, Locale.forLanguageTag("mk")),
				of(ISO, Locale.forLanguageTag("mn")),
				of(ISO, Locale.forLanguageTag("mt")),
				of(ISO, Locale.forLanguageTag("mua")),
				of(ISO, Locale.forLanguageTag("nd")),
				of(ISO, Locale.forLanguageTag("ne")),
				of(ISO, Locale.forLanguageTag("nl")),
				of(ISO, Locale.forLanguageTag("nmg")),
				of(ISO, Locale.forLanguageTag("nn")),
				of(ISO, Locale.forLanguageTag("no")),
				of(ISO, Locale.forLanguageTag("nyn")),
				of(ISO, Locale.forLanguageTag("om-KE")),
				of(ISO, Locale.forLanguageTag("os")),
				of(ISO, Locale.forLanguageTag("pcm")),
				of(ISO, Locale.forLanguageTag("pl")),
				of(ISO, Locale.forLanguageTag("pt")),
				of(ISO, Locale.forLanguageTag("pt-PT")),
				of(ISO, Locale.forLanguageTag("qu")),
				of(ISO, Locale.forLanguageTag("rm")),
				of(ISO, Locale.forLanguageTag("rn")),
				of(ISO, Locale.forLanguageTag("ro")),
				of(ISO, Locale.forLanguageTag("rof")),
				of(THAI_BUDDHIST, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("")),
				of(HIJRAH_UMALQURA, Locale.forLanguageTag("")),
				of(JAPANESE, Locale.forLanguageTag("")),
				of(MINGUO, Locale.forLanguageTag("")),
				of(ISO, Locale.forLanguageTag("ru")),
				of(ISO, Locale.forLanguageTag("rw")),
				of(ISO, Locale.forLanguageTag("rwk")),
				of(ISO, Locale.forLanguageTag("sah")),
				of(ISO, Locale.forLanguageTag("saq")),
				of(ISO, Locale.forLanguageTag("sbp")),
				of(ISO, Locale.forLanguageTag("sc")),
				of(ISO, Locale.forLanguageTag("se")),
				of(ISO, Locale.forLanguageTag("seh")),
				of(ISO, Locale.forLanguageTag("ses")),
				of(ISO, Locale.forLanguageTag("sg")),
				of(ISO, Locale.forLanguageTag("sl")),
				of(ISO, Locale.forLanguageTag("sn")),
				of(ISO, Locale.forLanguageTag("so-KE")),
				of(ISO, Locale.forLanguageTag("sq-MK")),
				of(ISO, Locale.forLanguageTag("sq-XK")),
				of(ISO, Locale.forLanguageTag("sr")),
				of(ISO, Locale.forLanguageTag("sr-Latn")),
				of(ISO, Locale.forLanguageTag("sv")),
				of(ISO, Locale.forLanguageTag("sw")),
				of(ISO, Locale.forLanguageTag("sw-KE")),
				of(ISO, Locale.forLanguageTag("ta-LK")),
				of(ISO, Locale.forLanguageTag("teo")),
				of(ISO, Locale.forLanguageTag("tg")),
				of(ISO, Locale.forLanguageTag("th")),
				of(ISO, Locale.forLanguageTag("tk")),
				of(ISO, Locale.forLanguageTag("tr")),
				of(ISO, Locale.forLanguageTag("twq")),
				of(ISO, Locale.forLanguageTag("ug")),
				of(ISO, Locale.forLanguageTag("uk")),
				of(ISO, Locale.forLanguageTag("uz")),
				of(ISO, Locale.forLanguageTag("uz-Cyrl")),
				of(ISO, Locale.forLanguageTag("vi")),
				of(ISO, Locale.forLanguageTag("vun")),
				of(ISO, Locale.forLanguageTag("wo")),
				of(ISO, Locale.forLanguageTag("xh")),
				of(ISO, Locale.forLanguageTag("xog")),
				of(ISO, Locale.forLanguageTag("yav")),
				of(ISO, Locale.forLanguageTag("yi")),
				of(ISO, Locale.forLanguageTag("yrl")),
				of(ISO, Locale.forLanguageTag("yue-Hans")),
				of(ISO, Locale.forLanguageTag("zgh")),
				of(ISO, Locale.forLanguageTag("zh")),
				of(ISO, Locale.forLanguageTag("zu")),
				});
		TIME_SHORT_PATTERNS.put("h:mm a", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("af-NA")),
				of(ISO, Locale.forLanguageTag("ak")),
				of(ISO, Locale.forLanguageTag("bem")),
				of(ISO, Locale.forLanguageTag("ceb")),
				of(ISO, Locale.forLanguageTag("el")),
				of(ISO, Locale.forLanguageTag("en")),
				of(ISO, Locale.forLanguageTag("en-AU")),
				of(ISO, Locale.forLanguageTag("en-CA")),
				of(ISO, Locale.forLanguageTag("en-IN")),
				of(ISO, Locale.forLanguageTag("es-CO")),
				of(ISO, Locale.forLanguageTag("es-DO")),
				of(ISO, Locale.forLanguageTag("es-PA")),
				of(ISO, Locale.forLanguageTag("es-PH")),
				of(ISO, Locale.forLanguageTag("es-PR")),
				of(ISO, Locale.forLanguageTag("es-US")),
				of(ISO, Locale.forLanguageTag("es-VE")),
				of(ISO, Locale.forLanguageTag("ff-Latn-GH")),
				of(ISO, Locale.forLanguageTag("ff-Latn-GM")),
				of(ISO, Locale.forLanguageTag("ff-Latn-LR")),
				of(ISO, Locale.forLanguageTag("ff-Latn-MR")),
				of(ISO, Locale.forLanguageTag("ff-Latn-SL")),
				of(ISO, Locale.forLanguageTag("fil")),
				of(ISO, Locale.forLanguageTag("fr-DJ")),
				of(ISO, Locale.forLanguageTag("fr-DZ")),
				of(ISO, Locale.forLanguageTag("fr-MR")),
				of(ISO, Locale.forLanguageTag("fr-SY")),
				of(ISO, Locale.forLanguageTag("fr-TD")),
				of(ISO, Locale.forLanguageTag("fr-TN")),
				of(ISO, Locale.forLanguageTag("fr-VU")),
				of(ISO, Locale.forLanguageTag("ha-GH")),
				of(ISO, Locale.forLanguageTag("haw")),
				of(ISO, Locale.forLanguageTag("hi-Latn")),
				of(ISO, Locale.forLanguageTag("kab")),
				of(ISO, Locale.forLanguageTag("lkt")),
				of(ISO, Locale.forLanguageTag("mi")),
				of(ISO, Locale.forLanguageTag("ms")),
				of(ISO, Locale.forLanguageTag("naq")),
				of(ISO, Locale.forLanguageTag("nus")),
				of(ISO, Locale.forLanguageTag("om")),
				of(ISO, Locale.forLanguageTag("pt-MO")),
				of(ISO, Locale.forLanguageTag("so")),
				of(ISO, Locale.forLanguageTag("sq")),
				of(ISO, Locale.forLanguageTag("to")),
				of(ISO, Locale.forLanguageTag("tr-CY")),
				of(ISO, Locale.forLanguageTag("vai-Latn")),
				of(ISO, Locale.forLanguageTag("yrl-CO")),
				of(ISO, Locale.forLanguageTag("yrl-VE")),
				});
		TIME_SHORT_PATTERNS.put("'Kl'. H.mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("nds")),
				});
		TIME_SHORT_PATTERNS.put("Bh:mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("zh-Hant")),
				});
		TIME_SHORT_PATTERNS.put("H.mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("en-FI")),
				of(ISO, Locale.forLanguageTag("fi")),
				of(ISO, Locale.forLanguageTag("smn")),
				of(ISO, Locale.forLanguageTag("su")),
				});
		TIME_SHORT_PATTERNS.put("a नि h:mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("brx")),
				});
		TIME_SHORT_PATTERNS.put("a h:mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ko")),
				of(ISO, Locale.forLanguageTag("ks-Deva")),
				of(ISO, Locale.forLanguageTag("ta")),
				});
		TIME_SHORT_PATTERNS.put("H'h'mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("oc")),
				});
		TIME_SHORT_PATTERNS.put("HH 'h' mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("fr-CA")),
				});
		TIME_SHORT_PATTERNS.put("h:mm a", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("am")),
				of(ISO, Locale.forLanguageTag("ar")),
				of(ISO, Locale.forLanguageTag("bgc")),
				of(ISO, Locale.forLanguageTag("bho")),
				of(ISO, Locale.forLanguageTag("bn")),
				of(ISO, Locale.forLanguageTag("bo-IN")),
				of(ISO, Locale.forLanguageTag("ccp")),
				of(ISO, Locale.forLanguageTag("chr")),
				of(ISO, Locale.forLanguageTag("ckb")),
				of(ISO, Locale.forLanguageTag("doi")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-GH")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-GM")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-LR")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-MR")),
				of(ISO, Locale.forLanguageTag("ff-Adlm-SL")),
				of(ISO, Locale.forLanguageTag("hi")),
				of(ISO, Locale.forLanguageTag("km")),
				of(ISO, Locale.forLanguageTag("kok")),
				of(ISO, Locale.forLanguageTag("ks")),
				of(ISO, Locale.forLanguageTag("lrc-IQ")),
				of(ISO, Locale.forLanguageTag("mai")),
				of(ISO, Locale.forLanguageTag("ml")),
				of(ISO, Locale.forLanguageTag("mni")),
				of(ISO, Locale.forLanguageTag("mr")),
				of(ISO, Locale.forLanguageTag("ne-IN")),
				of(ISO, Locale.forLanguageTag("or")),
				of(ISO, Locale.forLanguageTag("pa")),
				of(ISO, Locale.forLanguageTag("pa-Arab")),
				of(ISO, Locale.forLanguageTag("ps-PK")),
				of(ISO, Locale.forLanguageTag("raj")),
				of(ISO, Locale.forLanguageTag("sa")),
				of(ISO, Locale.forLanguageTag("sat")),
				of(ISO, Locale.forLanguageTag("sd")),
				of(ISO, Locale.forLanguageTag("sd-Deva")),
				of(ISO, Locale.forLanguageTag("te")),
				of(ISO, Locale.forLanguageTag("ti")),
				of(ISO, Locale.forLanguageTag("ur")),
				of(ISO, Locale.forLanguageTag("vai")),
				});
		TIME_SHORT_PATTERNS.put("H:mm 'hodź'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("hsb")),
				});
		TIME_SHORT_PATTERNS.put("H:mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ar-IL")),
				of(ISO, Locale.forLanguageTag("ca")),
				of(ISO, Locale.forLanguageTag("cs")),
				of(ISO, Locale.forLanguageTag("dsb")),
				of(ISO, Locale.forLanguageTag("en-IL")),
				of(ISO, Locale.forLanguageTag("es")),
				of(ISO, Locale.forLanguageTag("fa")),
				of(ISO, Locale.forLanguageTag("he")),
				of(ISO, Locale.forLanguageTag("hu")),
				of(ISO, Locale.forLanguageTag("ja")),
				of(ISO, Locale.forLanguageTag("lo")),
				of(ISO, Locale.forLanguageTag("my")),
				of(ISO, Locale.forLanguageTag("oc-ES")),
				of(ISO, Locale.forLanguageTag("ps")),
				of(ISO, Locale.forLanguageTag("sk")),
				of(ISO, Locale.forLanguageTag("tt")),
				of(ISO, Locale.forLanguageTag("uz-Arab")),
				});
		TIME_SHORT_PATTERNS.put("ah:mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yue")),
				of(ISO, Locale.forLanguageTag("zh-Hans-HK")),
				of(ISO, Locale.forLanguageTag("zh-Hans-MO")),
				of(ISO, Locale.forLanguageTag("zh-Hans-SG")),
				of(ISO, Locale.forLanguageTag("zh-Hant-HK")),
				});
		TIME_SHORT_PATTERNS.put("a 'ga' h:mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("ee")),
				});
		TIME_SHORT_PATTERNS.put("HH.mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("da")),
				of(ISO, Locale.forLanguageTag("en-DK")),
				of(ISO, Locale.forLanguageTag("id")),
				of(ISO, Locale.forLanguageTag("kl")),
				of(ISO, Locale.forLanguageTag("ms-ID")),
				of(ISO, Locale.forLanguageTag("si")),
				});
		TIME_SHORT_PATTERNS.put("ཆུ་ཚོད་ h སྐར་མ་ mm a", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("dz")),
				});
		TIME_SHORT_PATTERNS.put("H:mm 'ч'.", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("bg")),
				});
		TIME_SHORT_PATTERNS.put("H:m", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("yo")),
				});
		TIME_SHORT_PATTERNS.put("a h.mm", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("as")),
				});
		TIME_SHORT_PATTERNS.put("hh:mm a", new PatternCoordinates[] {
				of(ISO, Locale.forLanguageTag("gu")),
				of(ISO, Locale.forLanguageTag("kn")),
				});
	}
}
