/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.accessor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jsefa.common.accessor.AbstractObjectAccessorProvider;
import org.jsefa.common.accessor.ObjectAccessor;
import org.jsefa.common.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionBasedObjectAccessorProvider
extends AbstractObjectAccessorProvider {
    @Override
    protected ObjectAccessor create(Class<?> objectType) {
        return new ReflectionBasedObjectAccessor(objectType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReflectionBasedObjectAccessor
    implements ObjectAccessor {
        private final Map<String, Field> fields;
        private final Constructor<?> constructor;

        private ReflectionBasedObjectAccessor(Class<?> objectType) {
            this.constructor = ReflectionUtil.getDefaultConstructor(objectType);
            this.constructor.setAccessible(true);
            this.fields = new HashMap<String, Field>();
            for (Field field : ReflectionUtil.getAllFields(objectType)) {
                field.setAccessible(true);
                this.fields.put(field.getName(), field);
            }
        }

        @Override
        public Object createObject() {
            try {
                return this.constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setValue(Object object, String fieldName, Object value) {
            Field field = this.fields.get(fieldName);
            try {
                field.set(object, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object getValue(Object object, String fieldName) {
            Field field = this.fields.get(fieldName);
            try {
                return field.get(object);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

