/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.jsefa.common.annotation.AnnotationDataProvider;
import org.jsefa.common.annotation.AnnotationException;
import org.jsefa.common.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedFieldsProvider {
    public static List<Field> getSortedAnnotatedFields(Class<?> objectType, Class<? extends Annotation> ... annotationClasses) {
        ArrayList<Field> sortedFields = new ArrayList<Field>();
        for (Class<?> theClass : ReflectionUtil.getTypesInReverseOrder(objectType)) {
            List<Field> flrFields = AnnotatedFieldsProvider.getDeclaredFields(theClass, annotationClasses);
            TreeMap<Integer, Field> fieldMap = new TreeMap<Integer, Field>();
            for (Field field : flrFields) {
                Integer pos = (Integer)AnnotationDataProvider.get(field, "pos", annotationClasses);
                if (pos == null || pos < 0) continue;
                if (fieldMap.get(pos) != null) {
                    throw new AnnotationException("There are more than one field in " + objectType.getName() + " annotated with the same pos " + pos);
                }
                fieldMap.put(pos, field);
            }
            for (Field field : fieldMap.values()) {
                sortedFields.add(field);
            }
            for (Field field : flrFields) {
                if (sortedFields.contains(field)) continue;
                sortedFields.add(field);
            }
        }
        return sortedFields;
    }

    public static List<Field> getAnnotatedFields(Class<?> objectType, Class<? extends Annotation> ... annotationClasses) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> theClass : ReflectionUtil.getTypesInReverseOrder(objectType)) {
            fields.addAll(AnnotatedFieldsProvider.getDeclaredFields(theClass, annotationClasses));
        }
        return fields;
    }

    private static List<Field> getDeclaredFields(Class<?> objectType, Class<? extends Annotation> ... annotationClasses) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : objectType.getDeclaredFields()) {
            for (Class<? extends Annotation> annotationClass : annotationClasses) {
                if (!field.isAnnotationPresent(annotationClass)) continue;
                result.add(field);
            }
        }
        return result;
    }

    private AnnotatedFieldsProvider() {
    }
}

