/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jsefa.common.annotation.NoClass;
import org.jsefa.common.annotation.NoConverterType;
import org.jsefa.common.annotation.NoValidatorType;
import org.jsefa.common.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationDataProvider {
    private static final List<?> NULL_OBJECTS = Arrays.asList("", NoConverterType.class, NoValidatorType.class, NoClass.class);

    public static <T> T get(Annotation annotation, String annotationParameterName) {
        Object[] resultArray;
        Object result = ReflectionUtil.callMethod(annotation, annotationParameterName);
        if (NULL_OBJECTS.contains(result)) {
            return null;
        }
        if (Object[].class.isAssignableFrom(result.getClass()) && (resultArray = (Object[])result).length == 0) {
            return null;
        }
        return result;
    }

    public static <T> T get(AnnotatedElement annotatedElement, String annotationParameterName, Class<? extends Annotation> ... annotationClasses) {
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            if (!AnnotationDataProvider.hasParameter(annotationClass, annotationParameterName) || !annotatedElement.isAnnotationPresent(annotationClass)) continue;
            return AnnotationDataProvider.get(annotatedElement.getAnnotation(annotationClass), annotationParameterName);
        }
        return null;
    }

    public static boolean hasParameter(Class<? extends Annotation> annotationClass, String annotationParameterName) {
        Method method = ReflectionUtil.getMethod(annotationClass, annotationParameterName, new Class[0]);
        return method != null;
    }

    private AnnotationDataProvider() {
    }
}

