/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.jsefa.common.accessor.ObjectAccessorProvider;
import org.jsefa.common.annotation.AnnotationDataProvider;
import org.jsefa.common.annotation.AnnotationException;
import org.jsefa.common.annotation.ValidatorFactory;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.provider.SimpleTypeConverterProvider;
import org.jsefa.common.mapping.SimpleTypeMapping;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.mapping.TypeMappingException;
import org.jsefa.common.mapping.TypeMappingRegistry;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.common.validator.provider.ValidatorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeMappingFactory<N, R extends TypeMappingRegistry<N>> {
    private final SimpleTypeConverterProvider simpleTypeConverterProvider;
    private final ValidatorProvider validatorProvider;
    private final ObjectAccessorProvider objectAccessorProvider;
    private final R typeMappingRegistry;
    private final ValidatorFactory validatorFactory;

    public TypeMappingFactory(R typeMappingRegistry, SimpleTypeConverterProvider simpleTypeConverterProvider, ValidatorProvider validatorProvider, ObjectAccessorProvider objectAccessorProvider) {
        this.typeMappingRegistry = typeMappingRegistry;
        this.simpleTypeConverterProvider = simpleTypeConverterProvider;
        this.validatorProvider = validatorProvider;
        this.objectAccessorProvider = objectAccessorProvider;
        this.validatorFactory = new ValidatorFactory(validatorProvider, objectAccessorProvider);
    }

    public abstract N createIfAbsent(Class<?> var1);

    public final R getTypeMappingRegistry() {
        return this.typeMappingRegistry;
    }

    protected final boolean prepareToCreate(Class<?> objectType, N dataTypeName) {
        if (((TypeMappingRegistry)this.typeMappingRegistry).get(dataTypeName) != null) {
            return false;
        }
        ((TypeMappingRegistry)this.typeMappingRegistry).register(new TypeMappingPlaceholder(objectType, dataTypeName));
        return true;
    }

    protected final ObjectAccessorProvider getObjectAccessorProvider() {
        return this.objectAccessorProvider;
    }

    protected final SimpleTypeConverterProvider getSimpleTypeConverterProvider() {
        return this.simpleTypeConverterProvider;
    }

    protected final ValidatorProvider getValidatorProvider() {
        return this.validatorProvider;
    }

    protected final SimpleTypeConverter createSimpleTypeConverter(Class<?> objectType, Field field, Annotation annotation) {
        String[] format = null;
        SimpleTypeConverter itemTypeConverter = null;
        if (annotation != null) {
            format = (String[])AnnotationDataProvider.get(annotation, "format");
            if (this.hasCollectionType(objectType)) {
                Annotation itemAnnotation = (Annotation)AnnotationDataProvider.get(annotation, "listItem");
                N itemDataTypeName = this.getAnnotatedDataTypeName(itemAnnotation, field.getDeclaringClass());
                if (itemDataTypeName != null) {
                    this.assertTypeMappingIsSimple(itemDataTypeName);
                    this.assertNoCollectionType(((TypeMappingRegistry)this.getTypeMappingRegistry()).get(itemDataTypeName).getObjectType());
                    itemTypeConverter = ((SimpleTypeMapping)((TypeMappingRegistry)this.getTypeMappingRegistry()).get(itemDataTypeName)).getSimpleTypeConverter();
                } else {
                    Class<?> itemObjectType = this.getCollectionItemType(itemAnnotation, field, true);
                    this.assertHasSimpleType(itemObjectType);
                    this.assertNoCollectionType(itemObjectType);
                    itemTypeConverter = this.createSimpleTypeConverter(itemObjectType, null, itemAnnotation);
                }
            }
            if (AnnotationDataProvider.get(annotation, "converterType") != null) {
                Class converterType = (Class)AnnotationDataProvider.get(annotation, "converterType");
                return this.getSimpleTypeConverterProvider().getForConverterType(converterType, objectType, format, itemTypeConverter);
            }
        }
        if (this.getSimpleTypeConverterProvider().hasConverterFor(objectType)) {
            return this.getSimpleTypeConverterProvider().getForObjectType(objectType, format, itemTypeConverter);
        }
        throw new TypeMappingException("Could not create a simple type converter for " + objectType);
    }

    protected final Class<?> getCollectionItemType(Annotation annotation, Field field, boolean fromFieldDeclarationAllowed) {
        Class<?> objectType = (Class<?>)AnnotationDataProvider.get(annotation, "objectType");
        if (objectType == null && fromFieldDeclarationAllowed) {
            objectType = ReflectionUtil.getActualTypeParameter(field, 0);
        }
        return objectType;
    }

    protected final Class<?> getMapValueType(Annotation annotation, Field field, boolean fromFieldDeclarationAllowed) {
        Class<?> objectType = (Class<?>)AnnotationDataProvider.get(annotation, "objectType");
        if (objectType == null && fromFieldDeclarationAllowed) {
            objectType = ReflectionUtil.getActualTypeParameter(field, 1);
        }
        return objectType;
    }

    protected final Class<?> getMapKeyType(Annotation annotation, Field field) {
        Class<?> objectType = (Class<?>)AnnotationDataProvider.get(annotation, "objectType");
        if (objectType == null) {
            objectType = ReflectionUtil.getActualTypeParameter(field, 0);
        }
        return objectType;
    }

    protected abstract N getAnnotatedDataTypeName(Annotation var1, Class<?> var2);

    protected final ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    protected final boolean hasSimpleType(Class<?> objectType) {
        return this.getSimpleTypeConverterProvider().hasConverterFor(objectType);
    }

    protected final boolean hasCollectionType(Class<?> objectType) {
        return Collection.class.isAssignableFrom(objectType);
    }

    protected final boolean hasMapType(Class<?> objectType) {
        return Map.class.isAssignableFrom(objectType);
    }

    protected final void assertTypeMappingExists(N dataTypeName) {
        if (((TypeMappingRegistry)this.getTypeMappingRegistry()).get(dataTypeName) == null) {
            throw new AnnotationException("No type mapping registered for data type name " + dataTypeName);
        }
    }

    protected final void assertTypeMappingIsSimple(N dataTypeName) {
        this.assertTypeMappingExists(dataTypeName);
        if (!(((TypeMappingRegistry)this.getTypeMappingRegistry()).get(dataTypeName) instanceof SimpleTypeMapping)) {
            throw new AnnotationException("The dataTypeName " + dataTypeName + " does not denote a simple type mapping");
        }
    }

    protected final void assertNoCollectionType(Class<?> objectType) {
        if (this.hasCollectionType(objectType)) {
            throw new AnnotationException("No collections allowed here!");
        }
    }

    protected final void assertHasSimpleType(Class<?> objectType) {
        if (!this.hasSimpleType(objectType)) {
            throw new AnnotationException("Only simple types are allowed here!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class TypeMappingPlaceholder
    extends TypeMapping<N> {
        protected TypeMappingPlaceholder(Class<?> objectType, N dataTypeName) {
            super(objectType, dataTypeName);
        }
    }
}

