/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.config;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jsefa.common.config.InitialConfigurationException;
import org.jsefa.common.util.OnDemandObjectProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InitialConfiguration {
    private static final ConcurrentMap<String, Object> MAP = new ConcurrentHashMap<String, Object>();

    public static <T> T get(String parameter, OnDemandObjectProvider defaultValueProvider) {
        Object previousValue = MAP.get(parameter);
        if (previousValue != null) {
            return (T)previousValue;
        }
        Object defaultValue = defaultValueProvider.get();
        previousValue = MAP.putIfAbsent(parameter, defaultValue);
        if (previousValue != null) {
            return (T)previousValue;
        }
        return defaultValue;
    }

    public static <T> T get(String parameter, Object defaultValue) {
        Object previousValue = MAP.putIfAbsent(parameter, defaultValue);
        if (previousValue != null) {
            return (T)previousValue;
        }
        return (T)defaultValue;
    }

    public static void set(String parameter, Object value) {
        Object other = MAP.putIfAbsent(parameter, value);
        if (other != null && !other.equals(value)) {
            throw new InitialConfigurationException("The configuration parameter " + parameter + " is already bound to " + value);
        }
    }

    private InitialConfiguration() {
    }
}

