/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.converter;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jsefa.common.converter.EnumConstant;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.SimpleTypeConverterConfiguration;
import org.jsefa.common.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumConverter
implements SimpleTypeConverter {
    private final Class<? extends Enum> enumType;
    private final Map<String, String> nameToAliasMap;
    private final Map<String, String> aliasToNameMap;

    public static EnumConverter create(SimpleTypeConverterConfiguration configuration) {
        Class enumType = configuration.getObjectType();
        HashMap<String, String> nameToAliasMap = new HashMap<String, String>();
        for (Field field : ReflectionUtil.getAllFields(enumType)) {
            if (!field.isAnnotationPresent(EnumConstant.class)) continue;
            nameToAliasMap.put(field.getName(), field.getAnnotation(EnumConstant.class).value());
        }
        if (configuration.getFormat() != null) {
            for (String mapping : configuration.getFormat()) {
                String[] tokens = mapping.split("=");
                nameToAliasMap.put(tokens[0], tokens[1]);
            }
        }
        return new EnumConverter(enumType, nameToAliasMap);
    }

    private EnumConverter(Class<? extends Enum<?>> enumType, Map<String, String> nameToAliasMap) {
        this.enumType = enumType;
        this.nameToAliasMap = nameToAliasMap;
        this.aliasToNameMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.nameToAliasMap.entrySet()) {
            this.aliasToNameMap.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public Enum fromString(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        String name = this.aliasToNameMap.get(value);
        if (name != null) {
            return Enum.valueOf(this.enumType, name);
        }
        return Enum.valueOf(this.enumType, value);
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        String name = ((Enum)value).name();
        String alias = this.nameToAliasMap.get(name);
        if (alias != null) {
            return alias;
        }
        return name;
    }
}

