/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.converter;

import org.jsefa.common.converter.ConversionException;
import org.jsefa.common.converter.SimpleTypeConverter;

public final class LongConverter
implements SimpleTypeConverter {
    private static final LongConverter INSTANCE = new LongConverter();

    public static LongConverter create() {
        return INSTANCE;
    }

    private LongConverter() {
    }

    public Long fromString(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            if (value.charAt(0) == '+') {
                return this.fromString(value.substring(1));
            }
            throw new ConversionException("Wrong Long format: " + value);
        }
    }

    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

