/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.lowlevel.filter;

import org.jsefa.common.lowlevel.filter.FilterResult;
import org.jsefa.common.lowlevel.filter.LineFilter;

public final class HeaderAndFooterFilter
implements LineFilter {
    private final int headerSize;
    private final boolean filterLastLine;
    private final boolean storeFailedLines;

    public HeaderAndFooterFilter(int headerSize, boolean hasFooter, boolean storeFailedLines) {
        this.headerSize = headerSize;
        this.filterLastLine = hasFooter;
        this.storeFailedLines = storeFailedLines;
    }

    public FilterResult filter(String line, int lineNumber, boolean truncated, boolean lastLine) {
        if (!(lineNumber <= this.headerSize || this.filterLastLine && lastLine)) {
            return FilterResult.PASSED;
        }
        if (this.storeFailedLines) {
            return FilterResult.FAILED_BUT_STORE;
        }
        return FilterResult.FAILED;
    }
}

