/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.lowlevel.io;

import java.io.IOException;
import java.io.Reader;
import org.jsefa.common.lowlevel.InputPosition;
import org.jsefa.common.lowlevel.io.LineSegment;

public class LineSegmentReader {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int DEFAULT_MIN_BUFFER_FILLING = 1024;
    private static final int DEFAULT_BUFFER_ENLARGEMENT = 1024;
    private Reader reader;
    private char[] buffer;
    private int bufferEnlargement;
    private int minBufferFilling;
    private int noCharsInBuffer;
    private int nextCharIndex;
    private int lineIndex;
    private int columnIndex;
    private boolean skipLF = false;
    private Marker marker = null;

    public LineSegmentReader(Reader reader) {
        this(reader, 8192, 1024, 1024);
    }

    public LineSegmentReader(Reader reader, int bufferSize, int minBufferFilling, int bufferEnlargement) {
        this.reader = reader;
        this.buffer = new char[bufferSize];
        this.minBufferFilling = minBufferFilling;
        this.bufferEnlargement = bufferEnlargement;
        this.nextCharIndex = 0;
        this.noCharsInBuffer = 0;
    }

    public LineSegment read() throws IOException {
        return this.read(-1, -1);
    }

    public LineSegment read(int limit) throws IOException {
        return this.read(-1, limit);
    }

    public LineSegment read(int specialTerminator, int limit) throws IOException {
        int index;
        int columnNumber = this.columnIndex + 1;
        StringBuilder contentBuilder = null;
        do {
            String content;
            if (this.nextCharIndex >= this.noCharsInBuffer && !this.fill()) {
                if (contentBuilder != null && contentBuilder.length() > 0) {
                    return new LineSegment(contentBuilder.toString(), this.lineIndex + 1, columnNumber, LineSegment.Terminator.EOS);
                }
                return null;
            }
            if (this.skipLF && this.buffer[this.nextCharIndex] == '\n') {
                ++this.nextCharIndex;
                this.skipLF = false;
            }
            boolean eolFound = false;
            boolean specialCharFound = false;
            int maxIndex = this.noCharsInBuffer - 1;
            if (limit > 0) {
                maxIndex = Math.min(this.noCharsInBuffer - 1, this.nextCharIndex + limit);
                if (contentBuilder != null) {
                    maxIndex -= contentBuilder.length();
                }
            }
            for (index = this.nextCharIndex; index <= maxIndex; ++index) {
                char nextChar = this.buffer[index];
                if (nextChar == '\r' || nextChar == '\n') {
                    if (nextChar == '\r') {
                        this.skipLF = true;
                    }
                    eolFound = true;
                    break;
                }
                if (nextChar != specialTerminator) continue;
                specialCharFound = true;
                break;
            }
            int length = index - this.nextCharIndex;
            if (eolFound || specialCharFound) {
                content = new String(this.buffer, this.nextCharIndex, length);
                if (contentBuilder != null) {
                    contentBuilder.append(content);
                    content = contentBuilder.toString();
                }
                this.nextCharIndex += length + 1;
                if (eolFound) {
                    this.columnIndex = 0;
                    return new LineSegment(content, ++this.lineIndex, columnNumber, LineSegment.Terminator.LINE_BREAK);
                }
                this.columnIndex += length + 1;
                return new LineSegment(content, this.lineIndex + 1, columnNumber, LineSegment.Terminator.SPECIAL_CHARACTER);
            }
            if (limit > 0) {
                int charLeft = contentBuilder == null ? limit : limit - contentBuilder.length();
                length = Math.min(charLeft, length);
            }
            content = new String(this.buffer, this.nextCharIndex, length);
            if (contentBuilder == null) {
                contentBuilder = new StringBuilder();
            }
            contentBuilder.append(content);
            this.columnIndex += length;
            this.nextCharIndex += length;
        } while (contentBuilder.length() != limit || index >= this.noCharsInBuffer);
        return new LineSegment(contentBuilder.toString(), this.lineIndex + 1, columnNumber, LineSegment.Terminator.NONE);
    }

    public void skipLine() throws IOException {
        char nextChar;
        block0: while (true) {
            if (this.nextCharIndex >= this.noCharsInBuffer && !this.fill()) {
                return;
            }
            if (this.skipLF && this.buffer[this.nextCharIndex] == '\n') {
                ++this.nextCharIndex;
                this.skipLF = false;
            }
            do {
                if (this.nextCharIndex >= this.noCharsInBuffer) continue block0;
            } while ((nextChar = this.buffer[this.nextCharIndex++]) != '\r' && nextChar != '\n');
            break;
        }
        if (nextChar == '\r') {
            this.skipLF = true;
        }
        this.columnIndex = 0;
        ++this.lineIndex;
    }

    public InputPosition getInputPosition() {
        return new InputPosition(this.lineIndex + 1, this.columnIndex + 1);
    }

    public void mark() {
        this.marker = new Marker(this.nextCharIndex, this.skipLF, this.lineIndex, this.columnIndex);
    }

    public void reset(boolean removeMarker) {
        if (this.marker != null) {
            this.nextCharIndex = this.marker.nextCharIndex;
            this.skipLF = this.marker.skipLF;
            this.lineIndex = this.marker.lineIndex;
            this.columnIndex = this.marker.columnIndex;
            if (removeMarker) {
                this.removeMarker();
            }
        }
    }

    public void removeMarker() {
        this.marker = null;
    }

    public void close() throws IOException {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.buffer = null;
    }

    private boolean fill() throws IOException {
        int destIndex;
        if (this.marker == null) {
            destIndex = 0;
        } else {
            destIndex = this.nextCharIndex - this.marker.nextCharIndex;
            if (this.marker.nextCharIndex >= this.minBufferFilling) {
                System.arraycopy(this.buffer, this.marker.nextCharIndex, this.buffer, 0, destIndex);
                this.marker.nextCharIndex = 0;
            } else {
                char[] newBuffer = new char[this.buffer.length + this.bufferEnlargement];
                System.arraycopy(this.buffer, this.marker.nextCharIndex, newBuffer, 0, destIndex);
                this.buffer = newBuffer;
                this.marker.nextCharIndex = 0;
            }
            this.nextCharIndex = destIndex;
            this.noCharsInBuffer = destIndex;
        }
        int noReadChars = 0;
        while ((noReadChars = this.reader.read(this.buffer, destIndex, this.buffer.length - destIndex)) == 0) {
        }
        if (noReadChars > 0) {
            this.noCharsInBuffer = destIndex + noReadChars;
            this.nextCharIndex = destIndex;
            return true;
        }
        return false;
    }

    private static final class Marker {
        int nextCharIndex;
        boolean skipLF;
        int lineIndex;
        int columnIndex;

        Marker(int nextCharIndex, boolean skipLF, int lineIndex, int columnIndex) {
            this.nextCharIndex = nextCharIndex;
            this.skipLF = skipLF;
            this.lineIndex = lineIndex;
            this.columnIndex = columnIndex;
        }
    }
}

