/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.mapping;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jsefa.common.mapping.TypeMappingRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HierarchicalTypeMappingRegistry<T>
extends TypeMappingRegistry<T> {
    private final ConcurrentMap<T, Collection<T>> subtypeRelation = new ConcurrentHashMap<T, Collection<T>>();

    public HierarchicalTypeMappingRegistry() {
    }

    protected HierarchicalTypeMappingRegistry(HierarchicalTypeMappingRegistry<T> other) {
        super(other);
        for (Object superDataTypeName : other.subtypeRelation.keySet()) {
            for (T subDataTypeName : super.getSubDataTypeNames(superDataTypeName)) {
                this.registerSubtypeRelation(superDataTypeName, subDataTypeName);
            }
        }
    }

    public final void registerSubtypeRelation(T superDataTypeName, T subDataTypeName) {
        HashSet<T> subDataTypeNames = (HashSet<T>)this.subtypeRelation.get(superDataTypeName);
        if (subDataTypeNames == null) {
            subDataTypeNames = new HashSet<T>();
            this.subtypeRelation.put(superDataTypeName, subDataTypeNames);
        }
        subDataTypeNames.add(subDataTypeName);
    }

    public final Collection<T> getDataTypeNameTreeElements(T rootDataTypeName) {
        HashSet<T> result = new HashSet<T>();
        result.add(rootDataTypeName);
        for (T subDataTypeName : this.getSubDataTypeNames(rootDataTypeName)) {
            result.addAll(this.getDataTypeNameTreeElements(subDataTypeName));
        }
        return result;
    }

    private Collection<T> getSubDataTypeNames(T dataTypeName) {
        HashSet result = (HashSet)this.subtypeRelation.get(dataTypeName);
        if (result == null) {
            result = new HashSet();
        }
        return result;
    }
}

