/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jsefa.IOFactoryException;
import org.jsefa.common.accessor.ObjectAccessor;
import org.jsefa.common.mapping.NodeDescriptor;
import org.jsefa.common.mapping.NodeMapping;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListTypeMapping<N, D extends NodeDescriptor<?>, M extends NodeMapping<N, D>>
extends TypeMapping<N> {
    private final Collection<M> nodeMappings;
    private final Map<D, M> nodeMappingsByNodeDescriptor;
    private final Map<Class<?>, M> nodeMappingsByObjectType;
    private final ObjectAccessor objectAccessor;

    public ListTypeMapping(Class<?> objectType, N dataTypeName, Collection<M> nodeMappings, ObjectAccessor objectAccessor) {
        super(objectType, dataTypeName);
        this.nodeMappings = new ArrayList<M>(nodeMappings);
        this.nodeMappingsByNodeDescriptor = this.createNodeMappingsByNodeDescriptorMap(nodeMappings);
        this.nodeMappingsByObjectType = this.createNodeMappingsByObjectTypeMap(nodeMappings);
        this.objectAccessor = objectAccessor;
    }

    public final Collection<M> getNodeMappings() {
        return Collections.unmodifiableCollection(this.nodeMappings);
    }

    public <T extends M> T getNodeMapping(D nodeDescriptor) {
        return (T)((NodeMapping)this.nodeMappingsByNodeDescriptor.get(nodeDescriptor));
    }

    public <T extends M> T getNodeMapping(Class<?> objectType) {
        return (T)((NodeMapping)ReflectionUtil.getNearest(objectType, this.nodeMappingsByObjectType));
    }

    public final ObjectAccessor getObjectAccessor() {
        return this.objectAccessor;
    }

    protected Map<D, M> createNodeMappingsByNodeDescriptorMap(Collection<M> nodeMappings) {
        HashMap result = new HashMap();
        for (NodeMapping nodeMapping : nodeMappings) {
            if (result.put(nodeMapping.getNodeDescriptor(), nodeMapping) == null) continue;
            throw new IOFactoryException("The node descriptor is ambiguous: " + nodeMapping.getNodeDescriptor());
        }
        return result;
    }

    private Map<Class<?>, M> createNodeMappingsByObjectTypeMap(Collection<M> nodeMappings) {
        HashMap result = new HashMap();
        for (NodeMapping nodeMapping : nodeMappings) {
            result.put(nodeMapping.getObjectType(), nodeMapping);
        }
        return result;
    }
}

