/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    public static Constructor<?> getDefaultConstructor(Class<?> objectType) {
        try {
            return objectType.getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createInstance(Class<T> objectType) {
        try {
            return objectType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<Field> getAllFields(Class<?> objectType) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> currentObjectType = objectType; currentObjectType != null; currentObjectType = currentObjectType.getSuperclass()) {
            for (Field field : currentObjectType.getDeclaredFields()) {
                fields.add(field);
            }
        }
        return fields;
    }

    public static List<Class<?>> getTypesInReverseOrder(Class<?> objectType) {
        if (objectType.isInterface() || objectType.isPrimitive()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        Class<?> type = objectType;
        while (!type.equals(Object.class)) {
            result.add(type);
            type = type.getSuperclass();
        }
        Collections.reverse(result);
        return result;
    }

    public static Method getMethod(Class<?> objectType, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = objectType.getDeclaredMethod(methodName, parameterTypes);
            if (method == null) {
                method = objectType.getMethod(methodName, parameterTypes);
            }
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T callMethod(Object object, String methodName) {
        try {
            Method method = ReflectionUtil.getMethod(object.getClass(), methodName, new Class[0]);
            return ReflectionUtil.callMethod(object, method, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T callMethod(Object object, Method method, Object ... parameters) {
        try {
            method.setAccessible(true);
            return (T)method.invoke(object, parameters);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getActualTypeParameter(Field field, int index) {
        Type typeArg;
        ParameterizedType parameterizedType;
        Type[] typeArgs;
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType && index < (typeArgs = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length && (typeArg = typeArgs[index]) instanceof Class) {
            return (Class)typeArg;
        }
        return null;
    }

    public static <T> T getNearest(Class<?> objectType, Map<Class<?>, T> map) {
        T value = map.get(objectType);
        if (value == null) {
            LinkedList types = new LinkedList();
            Class type = objectType;
            while (value == null) {
                Class<?> superType = type.getSuperclass();
                if (superType != null && superType != Object.class) {
                    types.add(superType);
                }
                for (Class<?> anInterface : type.getInterfaces()) {
                    types.add(anInterface);
                }
                if (types.isEmpty()) break;
                type = (Class)types.removeFirst();
                value = map.get(type);
            }
        }
        return value;
    }

    public static boolean hasClass(String clazz) {
        try {
            return Class.forName(clazz) != null;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    public static Class<?> getClass(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }

    private ReflectionUtil() {
    }
}

