/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator;

import java.util.regex.Pattern;
import org.jsefa.common.converter.IntegerConverter;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.StringConverter;
import org.jsefa.common.validator.ValidatorConfiguration;
import org.jsefa.common.validator.ValidatorCreationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstraintsAccessor {
    private final ValidatorConfiguration config;
    private final SimpleTypeConverter converter;

    static ConstraintsAccessor create(ValidatorConfiguration config) {
        return new ConstraintsAccessor(config, StringConverter.create());
    }

    static ConstraintsAccessor create(ValidatorConfiguration config, SimpleTypeConverter converter) {
        return new ConstraintsAccessor(config, converter);
    }

    ConstraintsAccessor(ValidatorConfiguration config, SimpleTypeConverter converter) {
        this.config = config;
        this.converter = converter;
    }

    <T> T get(String name, boolean required) {
        String value = this.getString(name, required);
        if (value != null && value.length() > 0) {
            return (T)this.converter.fromString(value);
        }
        return null;
    }

    String getString(String name, boolean required) {
        String value = this.config.getConstraints().get(name);
        if (value == null && required) {
            throw new ValidatorCreationException("No value for constraint " + name + " given");
        }
        return value;
    }

    Integer getInteger(String name, boolean required) {
        return IntegerConverter.create().fromString(this.getString(name, required));
    }

    Pattern getPattern(String name, boolean required) {
        String patternString = this.getString(name, required);
        if (patternString == null) {
            return null;
        }
        try {
            return Pattern.compile(patternString);
        }
        catch (Exception e) {
            throw new ValidatorCreationException("Wrong value for constraint " + name + " given: " + patternString);
        }
    }
}

