/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jsefa.ObjectPathElement;
import org.jsefa.common.validator.ConstraintsAccessor;
import org.jsefa.common.validator.ValidationError;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.ValidatorConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapValidator
implements Validator {
    private final Integer minEntries;
    private final Integer maxEntries;
    private static final String MIN = "min";
    private static final String MAX = "max";

    public static MapValidator create(ValidatorConfiguration configuration) {
        return new MapValidator(configuration);
    }

    private MapValidator(ValidatorConfiguration configuration) {
        ConstraintsAccessor constraints = ConstraintsAccessor.create(configuration);
        this.minEntries = constraints.getInteger(MIN, false);
        this.maxEntries = constraints.getInteger(MAX, false);
    }

    @Override
    public ValidationResult validate(Object value) {
        Map map = (Map)value;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validateMinEntries(map, errors);
        this.validateMaxEntries(map, errors);
        return ValidationResult.create(errors);
    }

    private void validateMinEntries(Map<?, ?> map, Collection<ValidationError> errors) {
        int entryCount = map.size();
        if (this.minEntries != null && entryCount < this.minEntries) {
            String errorText = "The map must have at least " + this.minEntries + " entries, but has " + entryCount + " entries only";
            errors.add(ValidationError.create("WRONG_QUANTITY", errorText, new ObjectPathElement[0]));
        }
    }

    private void validateMaxEntries(Map<?, ?> map, Collection<ValidationError> errors) {
        int entryCount = map.size();
        if (this.maxEntries != null && entryCount > this.maxEntries) {
            String errorText = "The number of map entries must not exceed " + this.maxEntries + ", but is " + entryCount;
            errors.add(ValidationError.create("WRONG_QUANTITY", errorText, new ObjectPathElement[0]));
        }
    }
}

