/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jsefa.ObjectPathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationError {
    private final String errorCode;
    private final String errorText;
    private final List<ObjectPathElement> relativeObjectPath;

    public static ValidationError create(String errorCode, String errorText, ObjectPathElement ... relativeObjectPathElements) {
        ArrayList<ObjectPathElement> relativeObjectPath = new ArrayList<ObjectPathElement>();
        for (ObjectPathElement objectPathElement : relativeObjectPathElements) {
            relativeObjectPath.add(objectPathElement);
        }
        return new ValidationError(errorCode, errorText, relativeObjectPath);
    }

    private ValidationError(String errorCode, String errorText, List<ObjectPathElement> relativeObjectPath) {
        this.errorCode = errorCode;
        this.errorText = errorText;
        this.relativeObjectPath = relativeObjectPath;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public List<ObjectPathElement> getRelativeObjectPath() {
        return Collections.unmodifiableList(this.relativeObjectPath);
    }
}

