/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator.traversal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.common.validator.ValidationError;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.traversal.TraversingValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TraversingCollectionValueValidator
extends TraversingValidator {
    private final Map<Class<?>, Validator> validatorsByObjectType;

    TraversingCollectionValueValidator(Map<Class<?>, Validator> validatorsByObjectType) {
        this.validatorsByObjectType = this.checkTriviality(validatorsByObjectType.values()) ? Collections.EMPTY_MAP : new HashMap(validatorsByObjectType);
    }

    @Override
    public ValidationResult validate(Object object) {
        if (this.isTrivial()) {
            return ValidationResult.VALID;
        }
        if (object == null) {
            return ValidationResult.VALID;
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Object item : (Collection)object) {
            Validator itemValidator = this.getItemValidator(this.getNormalizedObjectType(item));
            if (itemValidator == null) continue;
            errors.addAll(itemValidator.validate(item).getErrors());
        }
        return ValidationResult.create(errors);
    }

    private Validator getItemValidator(Class<?> objectType) {
        return ReflectionUtil.getNearest(objectType, this.validatorsByObjectType);
    }

    private Class<?> getNormalizedObjectType(Object value) {
        Class<Object> objectType = value.getClass();
        if (Collection.class.isAssignableFrom(objectType)) {
            objectType = Collection.class;
        } else if (Map.class.isAssignableFrom(objectType)) {
            objectType = Map.class;
        }
        return objectType;
    }
}

