/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator.traversal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.common.validator.ValidationError;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.traversal.TraversingValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TraversingMapValueValidator
extends TraversingValidator {
    private Validator keyValidator;
    private Map<Class<?>, Validator> valueValidatorsByObjectType;

    TraversingMapValueValidator(Validator keyValidator, Map<Class<?>, Validator> valueValidatorsByObjectType) {
        if (this.checkTriviality(keyValidator, valueValidatorsByObjectType)) {
            return;
        }
        this.keyValidator = keyValidator;
        this.valueValidatorsByObjectType = new HashMap(valueValidatorsByObjectType);
    }

    @Override
    public ValidationResult validate(Object object) {
        if (this.isTrivial()) {
            return ValidationResult.VALID;
        }
        if (object == null) {
            return ValidationResult.VALID;
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Map.Entry entry : ((Map)object).entrySet()) {
            Validator valueValidator;
            if (this.keyValidator != null) {
                errors.addAll(this.keyValidator.validate(entry.getKey()).getErrors());
            }
            if ((valueValidator = this.getValueValidator(this.getNormalizedObjectType(entry.getValue()))) == null) continue;
            errors.addAll(valueValidator.validate(entry.getValue()).getErrors());
        }
        return ValidationResult.create(errors);
    }

    private Validator getValueValidator(Class<?> objectType) {
        return ReflectionUtil.getNearest(objectType, this.valueValidatorsByObjectType);
    }

    private Class<?> getNormalizedObjectType(Object value) {
        Class<Object> objectType = value.getClass();
        if (Collection.class.isAssignableFrom(objectType)) {
            objectType = Collection.class;
        } else if (Map.class.isAssignableFrom(objectType)) {
            objectType = Map.class;
        }
        return objectType;
    }

    private boolean checkTriviality(Validator keyValidator, Map<?, Validator> valueValidators) {
        ArrayList<Validator> allValidators = new ArrayList<Validator>(valueValidators.values());
        if (keyValidator != null) {
            allValidators.add(keyValidator);
        }
        return this.checkTriviality(allValidators);
    }
}

