/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.common.validator.traversal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jsefa.common.accessor.ObjectAccessorProvider;
import org.jsefa.common.mapping.ComplexTypeMapping;
import org.jsefa.common.mapping.FieldDescriptor;
import org.jsefa.common.mapping.ListTypeMapping;
import org.jsefa.common.mapping.MapTypeMapping;
import org.jsefa.common.mapping.NodeMapping;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.mapping.TypeMappingRegistry;
import org.jsefa.common.validator.ValidationError;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.traversal.TraversingCollectionValueValidator;
import org.jsefa.common.validator.traversal.TraversingComplexValueValidator;
import org.jsefa.common.validator.traversal.TraversingMapValueValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraversingValidatorFactory<N> {
    private TypeMappingRegistry<N> typeMappingRegistry;
    private ObjectAccessorProvider objectAccessorProvider;
    private ConcurrentMap<N, TraversingComplexValueValidator> traversingComplexValueValidators;

    public TraversingValidatorFactory(TypeMappingRegistry<N> typeMappingRegistry, ObjectAccessorProvider objectAccessorProvider) {
        this.typeMappingRegistry = typeMappingRegistry;
        this.objectAccessorProvider = objectAccessorProvider;
        this.traversingComplexValueValidators = new ConcurrentHashMap<N, TraversingComplexValueValidator>();
    }

    public Validator create(N dataTypeName, Validator rootValidator) {
        return this.combine(this.create(this.typeMappingRegistry.get(dataTypeName)), rootValidator);
    }

    private Validator create(TypeMapping<N> mapping) {
        if (mapping instanceof ComplexTypeMapping) {
            return this.createForComplexType((ComplexTypeMapping)mapping);
        }
        if (mapping instanceof ListTypeMapping) {
            return this.createForListType((ListTypeMapping)mapping);
        }
        if (mapping instanceof MapTypeMapping) {
            return this.createForMapType((MapTypeMapping)mapping);
        }
        return null;
    }

    private Validator createForComplexType(ComplexTypeMapping<N, ?, ?> mapping) {
        Validator validator = (Validator)this.traversingComplexValueValidators.get(mapping.getDataTypeName());
        if (validator != null) {
            return validator;
        }
        TraversingComplexValueValidator result = new TraversingComplexValueValidator();
        this.traversingComplexValueValidators.put(mapping.getDataTypeName(), result);
        HashMap<FieldDescriptor, Validator> validatorsByFieldDescriptor = new HashMap<FieldDescriptor, Validator>();
        for (NodeMapping nodeMapping : mapping.getNodeMappings()) {
            Validator fieldValidator;
            if (nodeMapping.isIndirectMapping() || validatorsByFieldDescriptor.get(nodeMapping.getFieldDescriptor()) != null || (fieldValidator = this.combine(nodeMapping.getValidator(), this.create(this.typeMappingRegistry.get(nodeMapping.getDataTypeName())))) == null) continue;
            validatorsByFieldDescriptor.put(nodeMapping.getFieldDescriptor(), fieldValidator);
        }
        result.init(mapping.getValidator(), validatorsByFieldDescriptor, this.objectAccessorProvider.get(mapping.getObjectType()));
        return result;
    }

    private Validator createForListType(ListTypeMapping<N, ?, ?> mapping) {
        HashMap validatorsByObjectType = new HashMap();
        for (NodeMapping nodeMapping : mapping.getNodeMappings()) {
            Validator itemValidator;
            if (validatorsByObjectType.get(nodeMapping.getObjectType()) != null || (itemValidator = this.combine(nodeMapping.getValidator(), this.create(this.typeMappingRegistry.get(nodeMapping.getDataTypeName())))) == null) continue;
            validatorsByObjectType.put(nodeMapping.getObjectType(), itemValidator);
        }
        return new TraversingCollectionValueValidator(validatorsByObjectType);
    }

    private Validator createForMapType(MapTypeMapping<N, ?, ?, ?> mapping) {
        HashMap valueValidatorsByObjectType = new HashMap();
        for (NodeMapping nodeMapping : mapping.getValueNodeMappings()) {
            Validator valueValidator;
            if (valueValidatorsByObjectType.get(nodeMapping.getObjectType()) != null || (valueValidator = this.combine(nodeMapping.getValidator(), this.create(this.typeMappingRegistry.get(nodeMapping.getDataTypeName())))) == null) continue;
            valueValidatorsByObjectType.put(nodeMapping.getObjectType(), valueValidator);
        }
        Object keyNodeMapping = mapping.getKeyNodeMapping();
        Validator keyValidator = this.combine(((NodeMapping)keyNodeMapping).getValidator(), this.create(this.typeMappingRegistry.get(((NodeMapping)keyNodeMapping).getDataTypeName())));
        return new TraversingMapValueValidator(keyValidator, valueValidatorsByObjectType);
    }

    private Validator combine(Validator validatorA, Validator validatorB) {
        if (validatorA == null) {
            return validatorB;
        }
        if (validatorB == null) {
            return validatorA;
        }
        return new AndValidator(validatorA, validatorB);
    }

    private static final class AndValidator
    implements Validator {
        private Validator validatorA;
        private Validator validatorB;

        AndValidator(Validator validatorA, Validator validatorB) {
            this.validatorA = validatorA;
            this.validatorB = validatorB;
        }

        public ValidationResult validate(Object value) {
            ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
            errors.addAll(this.validatorA.validate(value).getErrors());
            errors.addAll(this.validatorB.validate(value).getErrors());
            return ValidationResult.create(errors);
        }
    }
}

