/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.csv;

import java.lang.reflect.Method;
import org.jsefa.IOFactory;
import org.jsefa.IOFactoryException;
import org.jsefa.common.config.InitialConfiguration;
import org.jsefa.common.util.ReflectionUtil;
import org.jsefa.csv.CsvDeserializer;
import org.jsefa.csv.CsvIOFactoryImpl;
import org.jsefa.csv.CsvSerializer;
import org.jsefa.csv.annotation.CsvEntryPointFactory;
import org.jsefa.csv.annotation.CsvTypeMappingFactory;
import org.jsefa.csv.config.CsvConfiguration;
import org.jsefa.rbf.mapping.RbfTypeMappingRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsvIOFactory
implements IOFactory {
    public static CsvIOFactory createFactory(CsvConfiguration config) {
        Class factoryClass = (Class)InitialConfiguration.get("jsefa:csv:ioFactoryClass", CsvIOFactoryImpl.class);
        Method createMethod = ReflectionUtil.getMethod(factoryClass, "createFactory", CsvConfiguration.class);
        if (createMethod == null) {
            throw new IOFactoryException("Failed to create a CsvIOFactory. The factory " + factoryClass + " does not contain the required static createFactory method.");
        }
        try {
            return (CsvIOFactory)ReflectionUtil.callMethod(null, createMethod, config);
        }
        catch (Exception e) {
            throw new IOFactoryException("Failed to create a CsvIOFactory", e);
        }
    }

    public static CsvIOFactory createFactory(Class<?> ... objectTypes) {
        return CsvIOFactory.createFactory(new CsvConfiguration(), objectTypes);
    }

    public static CsvIOFactory createFactory(CsvConfiguration config, Class<?> ... objectTypes) {
        CsvConfiguration newConfig = config.createCopy();
        try {
            CsvTypeMappingFactory typeMappingFactory = new CsvTypeMappingFactory((RbfTypeMappingRegistry)newConfig.getTypeMappingRegistry(), newConfig.getSimpleTypeConverterProvider(), newConfig.getValidatorProvider(), newConfig.getObjectAccessorProvider(), newConfig.getDefaultQuoteMode(), newConfig.getDefaultNoValueString());
            newConfig.getEntryPoints().addAll(CsvEntryPointFactory.createEntryPoints(typeMappingFactory, objectTypes));
            return CsvIOFactory.createFactory(newConfig);
        }
        catch (IOFactoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOFactoryException("Failed to create an CsvIOFactory", e);
        }
    }

    @Override
    public abstract CsvSerializer createSerializer();

    @Override
    public abstract CsvDeserializer createDeserializer();
}

