/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.csv.config;

import org.jsefa.common.config.InitialConfiguration;
import org.jsefa.csv.lowlevel.config.CsvLowLevelConfiguration;
import org.jsefa.csv.lowlevel.config.EscapeMode;
import org.jsefa.csv.lowlevel.config.QuoteMode;
import org.jsefa.rbf.config.RbfConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsvConfiguration
extends RbfConfiguration<CsvLowLevelConfiguration> {
    private QuoteMode defaultQuoteMode;
    private String defaultNoValueString;

    public CsvConfiguration() {
    }

    private CsvConfiguration(CsvConfiguration other) {
        super(other);
        this.setDefaultQuoteMode(other.getDefaultQuoteMode());
        this.setDefaultNoValueString(other.getDefaultNoValueString());
    }

    public CsvConfiguration createCopy() {
        return new CsvConfiguration(this);
    }

    public QuoteMode getDefaultQuoteMode() {
        if (this.defaultQuoteMode == null) {
            this.defaultQuoteMode = (QuoteMode)((Object)InitialConfiguration.get("jsefa:csv:defaultQuoteMode", (Object)Defaults.DEFAULT_QUOTE_MODE));
        }
        return this.defaultQuoteMode;
    }

    public String getDefaultNoValueString() {
        if (this.defaultNoValueString == null) {
            this.defaultNoValueString = (String)InitialConfiguration.get("jsefa:csv:defaultNoValueString", "");
        }
        return this.defaultNoValueString;
    }

    public void setDefaultQuoteMode(QuoteMode defaultQuoteMode) {
        this.defaultQuoteMode = defaultQuoteMode.equals((Object)QuoteMode.DEFAULT) ? (QuoteMode)((Object)InitialConfiguration.get("jsefa:csv:defaultQuoteMode", (Object)Defaults.DEFAULT_QUOTE_MODE)) : defaultQuoteMode;
    }

    public void setDefaultNoValueString(String defaultNoValueString) {
        this.defaultNoValueString = defaultNoValueString.equals("DEFAULT_STRING") ? (String)InitialConfiguration.get("jsefa:csv:defaultNoValueString", "") : defaultNoValueString;
    }

    public char getFieldDelimiter() {
        return ((CsvLowLevelConfiguration)this.getLowLevelConfiguration()).getFieldDelimiter();
    }

    public char getQuoteCharacter() {
        return ((CsvLowLevelConfiguration)this.getLowLevelConfiguration()).getQuoteCharacter();
    }

    public EscapeMode getQuoteCharacterEscapeMode() {
        return ((CsvLowLevelConfiguration)this.getLowLevelConfiguration()).getQuoteCharacterEscapeMode();
    }

    public boolean getUseDelimiterAfterLastField() {
        return ((CsvLowLevelConfiguration)this.getLowLevelConfiguration()).getUseDelimiterAfterLastField();
    }

    public String getLineBreak() {
        return ((CsvLowLevelConfiguration)this.getLowLevelConfiguration()).getLineBreak();
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        ((CsvLowLevelConfiguration)this.getLowLevelConfiguration()).setFieldDelimiter(fieldDelimiter);
    }

    public void setQuoteCharacter(char quoteCharacter) {
        ((CsvLowLevelConfiguration)this.getLowLevelConfiguration()).setQuoteCharacter(quoteCharacter);
    }

    public void setUseDelimiterAfterLastField(boolean useDelimiterAfterLastField) {
        ((CsvLowLevelConfiguration)this.getLowLevelConfiguration()).setUseDelimiterAfterLastField(useDelimiterAfterLastField);
    }

    public void setQuoteCharacterEscapeMode(EscapeMode quoteCharacterEscapeMode) {
        ((CsvLowLevelConfiguration)this.getLowLevelConfiguration()).setQuoteCharacterEscapeMode(quoteCharacterEscapeMode);
    }

    public void setLineBreak(String lineBreak) {
        ((CsvLowLevelConfiguration)this.getLowLevelConfiguration()).setLineBreak(lineBreak);
    }

    @Override
    protected CsvLowLevelConfiguration createDefaultLowLevelConfiguration() {
        return new CsvLowLevelConfiguration();
    }

    public static interface Defaults {
        public static final QuoteMode DEFAULT_QUOTE_MODE = QuoteMode.ON_DEMAND;
        public static final String DEFAULT_NO_VALUE_STRING = "";
    }
}

